/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.dialog;

import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.StandardDirectoryValidator;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingPathWidget;
import com.hello2morrow.sonargraph.ui.swt.dialog.StandardDialog;
import de.schlichtherle.truezip.file.TFile;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public abstract class OutputDirectorySelectionDialog
extends StandardDialog {
    private TFile m_outputDirectory;
    private ValidatingPathWidget m_directoryWidget;

    public OutputDirectorySelectionDialog(Shell shell, String title) {
        super(shell, title);
    }

    @Override
    protected final int getNumberOfColumns() {
        return 3;
    }

    @Override
    protected final Point getPreferredSize() {
        return new Point(500, 250);
    }

    protected abstract String createPreferenceKey();

    @Override
    protected final void applyData() {
        IEclipsePreferences settings = this.getPreferences("com.hello2morrow.sonargraph.ui.swt");
        assert (settings != null) : "settings must not be null";
        TFile defaultDirectory = this.getDefaultDirectory();
        String outputDirectoryPath = settings.get(this.createPreferenceKey(), defaultDirectory.getAbsolutePath());
        this.m_outputDirectory = new TFile(outputDirectoryPath).getNormalizedAbsoluteFile();
        this.m_directoryWidget.setPath(this.m_outputDirectory.getAbsolutePath());
        this.inputChanged();
    }

    protected abstract TFile getDefaultDirectory();

    @Override
    protected final IEclipsePreferences saveData() {
        IEclipsePreferences preferences = this.getPreferences("com.hello2morrow.sonargraph.ui.swt");
        if (this.m_outputDirectory != null) {
            preferences.put(this.createPreferenceKey(), this.m_outputDirectory.getNormalizedAbsolutePath());
        }
        return preferences;
    }

    @Override
    protected final void fillDialogArea(Composite composite) {
        Label directoryLabel = new Label(composite, 0);
        directoryLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        directoryLabel.setText("Output Directory:");
        this.m_directoryWidget = new ValidatingPathWidget(composite, new ValidatingPathWidget.IConsumer(){

            @Override
            public void setPath(TFile input, boolean inputModified) {
                if (inputModified) {
                    OutputDirectorySelectionDialog.this.m_outputDirectory = input;
                    OutputDirectorySelectionDialog.this.inputChanged();
                }
            }
        }, (IPathValidator)new StandardDirectoryValidator(StandardDirectoryValidator.Permission.READ_WRITE), 1, this.m_outputDirectory, false);
        this.m_directoryWidget.setLayoutData(new GridData(4, 0x1000000, true, false, 2, 1));
    }

    protected final void inputChanged() {
        this.getButton(0).setEnabled(this.hasValidData());
    }

    public final TFile getOutputDirectory() {
        return this.m_outputDirectory;
    }

    @Override
    public final boolean hasValidData() {
        return this.m_outputDirectory != null && this.m_outputDirectory.isDirectory() && !this.m_outputDirectory.isArchive() && this.m_outputDirectory.canWrite();
    }
}

