/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.workbench;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.CommandException;
import com.hello2morrow.sonargraph.core.command.common.CommandResultConsumer;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class WaitForCommandCompletion {
    private static final Logger LOGGER = LoggerFactory.getLogger(WaitForCommandCompletion.class);
    private final Display m_display;
    private final Command m_command;
    private final IWorkerContext m_workerContext;
    private Boolean m_commandFinished;
    private CommandException m_exception;

    WaitForCommandCompletion(Display display, Command command, IWorkerContext workerContext) {
        assert (display != null) : "Parameter 'display' of method 'WaitForCommandCompletion' must not be null";
        assert (command != null) : "Parameter 'command' of method 'WaitForCommandCompletion' must not be null";
        assert (workerContext != null) : "Parameter 'workerContext' of method 'WaitForCommandCompletion' must not be null";
        this.m_display = display;
        this.m_command = command;
        this.m_workerContext = workerContext;
    }

    CommandException getCommandExecutionException() {
        return this.m_exception;
    }

    void run() {
        assert (this.m_commandFinished == null) : "Parameter 'm_commandFinished' of method 'run' must be null";
        this.m_commandFinished = Boolean.FALSE;
        this.m_command.run(this.m_workerContext, new CommandResultConsumer(){

            public void consume(CommandException exception) {
                super.consume(exception);
                LOGGER.debug("Consuming: {}", (Object)WaitForCommandCompletion.this.m_command.getId());
                WaitForCommandCompletion.this.m_commandFinished = Boolean.TRUE;
                WaitForCommandCompletion.this.m_exception = exception;
            }
        });
        while (true) {
            if (!this.m_display.isDisposed()) {
                if (this.m_display.readAndDispatch()) {
                    continue;
                }
            }
            try {
                if (LOGGER.isDebugEnabled()) {
                    Thread.sleep(250L);
                    LOGGER.debug("Still alive ...");
                } else {
                    Thread.sleep(25L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.m_commandFinished.equals(Boolean.FALSE)) break;
        }
    }
}

