/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.workbench;

import com.hello2morrow.sonargraph.api.IParserDependencyType;
import com.hello2morrow.sonargraph.core.model.programming.CoreParserDependencyType;
import com.hello2morrow.sonargraph.core.model.representation.FocusMode;
import com.hello2morrow.sonargraph.core.model.representation.FocusProperties;
import com.hello2morrow.sonargraph.foundation.utilities.ByteBitFieldUtil;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ComboWithImages;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.DrawableSlaveView;
import com.hello2morrow.sonargraph.ui.swt.dialog.StandardDialog;
import java.util.Arrays;
import java.util.EnumSet;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class FocusDialog
extends StandardDialog
implements SelectionListener,
ICheckStateListener {
    private final FocusProperties m_focusProperties;
    private DrawableSlaveView.FocusSelectionType m_selectionType;
    private Button m_selected;
    private Button m_unselected;
    private Button m_none;
    private Button m_transitive;
    private Button m_onlyInternal;
    private Button m_selectAll;
    private Button m_deselectAll;
    private CheckboxTableViewer m_dependenciesTable;
    private ComboWithImages m_focusModeCombo;
    private byte m_state;

    public FocusDialog(Shell shell, FocusProperties previousFocusProperties, EnumSet<FocusDialogProperty> dialogProperties) {
        super(shell, "Focus");
        assert (dialogProperties != null) : "Parameter 'dialogProperties' of method 'FocusDialog' must not be null";
        this.m_selectionType = DrawableSlaveView.FocusSelectionType.SELECTED;
        this.m_focusProperties = previousFocusProperties != null ? new FocusProperties(previousFocusProperties) : new FocusProperties();
        this.setIsSelectionEmpty(dialogProperties.contains((Object)FocusDialogProperty.IS_SELECTION_EMPTY));
        this.setSupportsDependencyTypes(dialogProperties.contains((Object)FocusDialogProperty.SUPPORTS_DEPENDENCY_TYPES));
        this.setSupportsTransitive(dialogProperties.contains((Object)FocusDialogProperty.SUPPORTS_TRANSITIVE));
        this.setSupportsOnlyInternal(dialogProperties.contains((Object)FocusDialogProperty.SUPPORTS_ONLY_INTERNAL));
        this.setSupportsSelectionType(dialogProperties.contains((Object)FocusDialogProperty.SUPPORTS_SELECTION_TYPE));
    }

    public FocusDialog(Shell shell, EnumSet<FocusDialogProperty> dialogProperties) {
        this(shell, null, dialogProperties);
    }

    @Override
    protected GridLayout createGridLayout() {
        GridLayout gridLayout = new GridLayout(this.getNumberOfColumns(), false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginBottom = 2;
        gridLayout.marginTop = 2;
        gridLayout.marginLeft = 2;
        gridLayout.marginRight = 2;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        return gridLayout;
    }

    private GridLayout createGroupLayout(int numberOfColumns) {
        GridLayout gridLayout = new GridLayout(numberOfColumns, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginBottom = 2;
        gridLayout.marginTop = 2;
        gridLayout.marginLeft = 2;
        gridLayout.marginRight = 2;
        gridLayout.horizontalSpacing = 3;
        gridLayout.verticalSpacing = 3;
        return gridLayout;
    }

    @Override
    protected final void fillDialogArea(Composite composite) {
        super.fillDialogArea(composite);
        if (this.supportsSelectionType()) {
            Group selectionGroup = new Group(composite, 4);
            selectionGroup.setLayout((Layout)this.createGroupLayout(3));
            selectionGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            this.m_selected = new Button((Composite)selectionGroup, 16);
            this.m_selected.setText("Selected");
            this.m_selected.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 1, 1));
            this.m_selected.addSelectionListener((SelectionListener)this);
            this.m_selected.setData((Object)DrawableSlaveView.FocusSelectionType.SELECTED);
            this.m_selected.setEnabled(!this.isSelectionEmpty());
            this.m_unselected = new Button((Composite)selectionGroup, 16);
            this.m_unselected.setText("Unselected");
            this.m_unselected.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 1, 1));
            this.m_unselected.addSelectionListener((SelectionListener)this);
            this.m_unselected.setData((Object)DrawableSlaveView.FocusSelectionType.UNSELECTED);
            this.m_unselected.setEnabled(!this.isSelectionEmpty());
            this.m_none = new Button((Composite)selectionGroup, 16);
            this.m_none.setText("None");
            this.m_none.setLayoutData((Object)new GridData(1, 0x1000000, true, false, 1, 1));
            this.m_none.addSelectionListener((SelectionListener)this);
            this.m_none.setData((Object)DrawableSlaveView.FocusSelectionType.NONE);
            this.m_none.setEnabled(this.supportsDependencyTypes());
        }
        Group propertiesGroup = new Group(composite, 4);
        propertiesGroup.setLayout((Layout)this.createGroupLayout(3));
        propertiesGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.m_focusModeCombo = new ComboWithImages((Composite)propertiesGroup, 120, "Select focus mode", new ComboWithImages.ILabelProvider(){

            @Override
            public String getText(Object item) {
                if (!($assertionsDisabled || item != null && item instanceof FocusMode)) {
                    throw new AssertionError((Object)("Unexpected class in method 'getText': " + String.valueOf(item)));
                }
                return ((FocusMode)item).getPresentationName();
            }

            @Override
            public Image getImage(Object item) {
                if (!($assertionsDisabled || item != null && item instanceof FocusMode)) {
                    throw new AssertionError((Object)("Unexpected class in method 'getImage': " + String.valueOf(item)));
                }
                return UiResourceManager.getInstance().getImage(((FocusMode)item).getStandardName());
            }
        });
        this.m_focusModeCombo.setLayoutData(new GridData(1, 0x1000000, false, false, 1, 1));
        this.m_focusModeCombo.setItems(Arrays.asList(FocusMode.values()), this.m_focusProperties.getFocusMode());
        this.m_focusModeCombo.setSelectionListener(new ComboWithImages.IItemSelectionListener(){

            @Override
            public void itemSelected(ComboWithImages source, Object item) {
                if (!($assertionsDisabled || item != null && item instanceof FocusMode)) {
                    throw new AssertionError((Object)("Unexpected class in method 'itemSelected': " + String.valueOf(item)));
                }
                FocusDialog.this.m_focusProperties.setFocusMode((FocusMode)item);
            }
        });
        this.m_focusModeCombo.setEnabled(!this.isSelectionEmpty());
        if (this.supportsTransitive()) {
            this.m_transitive = new Button((Composite)propertiesGroup, 32);
            this.m_transitive.setText("Transitive");
            this.m_transitive.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 1, 1));
            this.m_transitive.addSelectionListener((SelectionListener)this);
            this.m_transitive.setEnabled(!this.isSelectionEmpty());
            this.m_transitive.setSelection(this.m_focusProperties.transitive());
        }
        if (this.supportsOnlyInternal()) {
            this.m_onlyInternal = new Button((Composite)propertiesGroup, 32);
            this.m_onlyInternal.setText("Only Internal");
            this.m_onlyInternal.setLayoutData((Object)new GridData(1, 0x1000000, true, false, 1, 1));
            this.m_onlyInternal.addSelectionListener((SelectionListener)this);
            this.m_onlyInternal.setEnabled(!this.isSelectionEmpty());
            this.m_onlyInternal.setSelection(this.m_focusProperties.onlyInternal());
        }
        if (this.supportsDependencyTypes()) {
            Group dependenciesGroup = new Group(composite, 4);
            dependenciesGroup.setLayout((Layout)this.createGroupLayout(3));
            dependenciesGroup.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
            this.m_dependenciesTable = CheckboxTableViewer.newCheckList((Composite)dependenciesGroup, (int)0);
            this.m_dependenciesTable.getTable().setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
            this.m_dependenciesTable.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.m_dependenciesTable.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    if (!($assertionsDisabled || element != null && element instanceof CoreParserDependencyType)) {
                        throw new AssertionError((Object)("Unexpected class in method 'getText': " + String.valueOf(element)));
                    }
                    CoreParserDependencyType parserDependencyType = (CoreParserDependencyType)element;
                    return parserDependencyType.getPresentationName();
                }

                public Image getImage(Object element) {
                    if (!$assertionsDisabled && element == null) {
                        throw new AssertionError((Object)"Parameter 'element' of method 'getImage' must not be null");
                    }
                    return UiResourceManager.getInstance().getImage("CoreDependencyType");
                }
            });
            this.m_dependenciesTable.setInput((Object)CoreParserDependencyType.values());
            this.m_dependenciesTable.addCheckStateListener((ICheckStateListener)this);
            for (IParserDependencyType dependencyType : this.m_focusProperties.getParserDependencyTypesForEdges()) {
                this.m_dependenciesTable.setChecked((Object)dependencyType, true);
            }
            this.m_selectAll = new Button((Composite)dependenciesGroup, 8);
            this.m_selectAll.setText("Select All");
            this.m_selectAll.setLayoutData((Object)new GridData(0x1000008, 1, true, false, 2, 1));
            this.m_selectAll.addSelectionListener((SelectionListener)this);
            this.m_deselectAll = new Button((Composite)dependenciesGroup, 8);
            this.m_deselectAll.setText("Deselect All");
            this.m_deselectAll.setLayoutData((Object)new GridData(0x1000008, 1, false, false, 1, 1));
            this.m_deselectAll.addSelectionListener((SelectionListener)this);
        }
        if (this.supportsSelectionType()) {
            this.m_selected.setSelection(!this.isSelectionEmpty());
            this.m_none.setSelection(this.isSelectionEmpty());
        }
    }

    public final void widgetSelected(SelectionEvent event) {
        assert (event != null) : "Parameter 'event' of method 'widgetSelected' must not be null";
        Object object = event.getSource();
        assert (object != null && object instanceof Button) : "Unexpected class in method 'widgetSelected': " + String.valueOf(object);
        Button source = (Button)object;
        if (this.supportsSelectionType() && (source == this.m_selected || source == this.m_unselected || source == this.m_none)) {
            Button selectionButton = source;
            Object data = selectionButton.getData();
            assert (data != null && data instanceof DrawableSlaveView.FocusSelectionType) : "Unexpected class in method 'widgetSelected': " + String.valueOf(data);
            if (source.getSelection()) {
                this.m_selectionType = (DrawableSlaveView.FocusSelectionType)((Object)data);
                this.m_focusModeCombo.setEnabled(source != this.m_none);
                if (this.supportsTransitive()) {
                    this.m_transitive.setEnabled(source != this.m_none);
                }
                if (this.supportsOnlyInternal()) {
                    this.m_onlyInternal.setEnabled(source != this.m_none);
                }
            }
        } else if (source == this.m_transitive) {
            this.m_focusProperties.setTransitive(source.getSelection());
        } else if (source == this.m_onlyInternal) {
            this.m_focusProperties.setOnlyInternal(source.getSelection());
        } else if (source == this.m_selectAll || source == this.m_deselectAll) {
            boolean check = source == this.m_selectAll;
            CoreParserDependencyType[] coreParserDependencyTypeArray = CoreParserDependencyType.values();
            int n = coreParserDependencyTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                CoreParserDependencyType dependencyType = coreParserDependencyTypeArray[n2];
                this.m_dependenciesTable.setChecked((Object)dependencyType, check);
                if (check) {
                    this.m_focusProperties.addParserDependencyType(dependencyType);
                } else {
                    this.m_focusProperties.removeParserDependencyType(dependencyType);
                }
                ++n2;
            }
            boolean okEnabeld = source == this.m_selectAll;
            this.getButton(0).setEnabled(okEnabeld);
        }
    }

    public final void checkStateChanged(CheckStateChangedEvent event) {
        assert (event != null) : "Parameter 'event' of method 'checkStateChanged' must not be null";
        Object element = event.getElement();
        assert (element != null && element instanceof CoreParserDependencyType) : "Unexpected class in method 'checkStateChanged': " + String.valueOf(element);
        CoreParserDependencyType parserDependencyType = (CoreParserDependencyType)element;
        if (event.getChecked()) {
            this.m_focusProperties.addParserDependencyType(parserDependencyType);
        } else {
            this.m_focusProperties.removeParserDependencyType(parserDependencyType);
        }
        this.getButton(0).setEnabled(!this.m_focusProperties.getParserDependencyTypesForEdges().isEmpty());
    }

    public final DrawableSlaveView.FocusSelectionType getSelectionType() {
        return this.m_selectionType;
    }

    @Override
    protected final int getNumberOfColumns() {
        return 1;
    }

    @Override
    protected final Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(true);
        }
        return control;
    }

    public final FocusProperties getFocusProperties() {
        return this.m_focusProperties;
    }

    public final void widgetDefaultSelected(SelectionEvent e) {
    }

    private final void setIsSelectionEmpty(boolean isSelectionEmpty) {
        this.m_state = isSelectionEmpty ? ByteBitFieldUtil.enableFlag((byte)this.m_state, (byte)((byte)(1 << FocusDialogProperty.IS_SELECTION_EMPTY.ordinal()))) : ByteBitFieldUtil.disableFlag((byte)this.m_state, (byte)((byte)(1 << FocusDialogProperty.IS_SELECTION_EMPTY.ordinal())));
    }

    private final boolean isSelectionEmpty() {
        return ByteBitFieldUtil.isFlagEnabled((byte)this.m_state, (byte)((byte)(1 << FocusDialogProperty.IS_SELECTION_EMPTY.ordinal())));
    }

    private final void setSupportsDependencyTypes(boolean supportsDependencyTypes) {
        this.m_state = supportsDependencyTypes ? ByteBitFieldUtil.enableFlag((byte)this.m_state, (byte)((byte)(1 << FocusDialogProperty.SUPPORTS_DEPENDENCY_TYPES.ordinal()))) : ByteBitFieldUtil.disableFlag((byte)this.m_state, (byte)((byte)(1 << FocusDialogProperty.SUPPORTS_DEPENDENCY_TYPES.ordinal())));
    }

    private final boolean supportsDependencyTypes() {
        return ByteBitFieldUtil.isFlagEnabled((byte)this.m_state, (byte)((byte)(1 << FocusDialogProperty.SUPPORTS_DEPENDENCY_TYPES.ordinal())));
    }

    private final void setSupportsTransitive(boolean supportsTransitive) {
        this.m_state = supportsTransitive ? ByteBitFieldUtil.enableFlag((byte)this.m_state, (byte)((byte)(1 << FocusDialogProperty.SUPPORTS_TRANSITIVE.ordinal()))) : ByteBitFieldUtil.disableFlag((byte)this.m_state, (byte)((byte)(1 << FocusDialogProperty.SUPPORTS_TRANSITIVE.ordinal())));
    }

    private final boolean supportsTransitive() {
        return ByteBitFieldUtil.isFlagEnabled((byte)this.m_state, (byte)((byte)(1 << FocusDialogProperty.SUPPORTS_TRANSITIVE.ordinal())));
    }

    private final void setSupportsOnlyInternal(boolean supportsOnlyInternal) {
        this.m_state = supportsOnlyInternal ? ByteBitFieldUtil.enableFlag((byte)this.m_state, (byte)((byte)(1 << FocusDialogProperty.SUPPORTS_ONLY_INTERNAL.ordinal()))) : ByteBitFieldUtil.disableFlag((byte)this.m_state, (byte)((byte)(1 << FocusDialogProperty.SUPPORTS_ONLY_INTERNAL.ordinal())));
    }

    private final boolean supportsOnlyInternal() {
        return ByteBitFieldUtil.isFlagEnabled((byte)this.m_state, (byte)((byte)(1 << FocusDialogProperty.SUPPORTS_ONLY_INTERNAL.ordinal())));
    }

    private final void setSupportsSelectionType(boolean supportsSelectionType) {
        this.m_state = supportsSelectionType ? ByteBitFieldUtil.enableFlag((byte)this.m_state, (byte)((byte)(1 << FocusDialogProperty.SUPPORTS_SELECTION_TYPE.ordinal()))) : ByteBitFieldUtil.disableFlag((byte)this.m_state, (byte)((byte)(1 << FocusDialogProperty.SUPPORTS_SELECTION_TYPE.ordinal())));
    }

    private final boolean supportsSelectionType() {
        return ByteBitFieldUtil.isFlagEnabled((byte)this.m_state, (byte)((byte)(1 << FocusDialogProperty.SUPPORTS_SELECTION_TYPE.ordinal())));
    }

    @Override
    protected final boolean useCalculatedSizeAsMinimumSize() {
        return true;
    }

    public static enum FocusDialogProperty {
        IS_SELECTION_EMPTY,
        SUPPORTS_DEPENDENCY_TYPES,
        SUPPORTS_TRANSITIVE,
        SUPPORTS_ONLY_INTERNAL,
        SUPPORTS_SELECTION_TYPE;

    }
}

