/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.workbench;

import com.hello2morrow.sonargraph.core.model.analysis.IMetricValue;
import com.hello2morrow.sonargraph.core.model.element.Dependency;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.representation.RepresentationDependency;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.view.IContextMenuContributor;
import com.hello2morrow.sonargraph.ui.swt.base.view.IContextMenuInteractionListener;
import com.hello2morrow.sonargraph.ui.swt.base.view.IMenuGroup;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.SonargraphWizardAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.WizardRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.CommandExecutionSelectionAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ContextMenuContributionInfo;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ContextMenuContributionInfoComparator;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.OpenWizardSelectionAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ShowInViewMenuEntryModelComparator;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ShowInViewNodeVisitor;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ShowInViewSelectionAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import com.hello2morrow.sonargraph.ui.swt.common.ShowInView;
import com.hello2morrow.sonargraph.ui.swt.common.ShowInViewNode;
import com.hello2morrow.sonargraph.ui.swt.common.ShowInViewNodeWithOptionProvider;
import com.hello2morrow.sonargraph.ui.swt.common.SupportsShowInView;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.core.commands.Command;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledItem;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ContextMenuCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContextMenuCreator.class);

    ContextMenuCreator() {
    }

    private void addSeparator(Menu menu) {
        assert (menu != null) : "Parameter 'menu' of method 'addSeparator' must not be null";
        if (menu.getItemCount() > 0 && menu.getItem(menu.getItemCount() - 1).getStyle() != 2) {
            new MenuItem(menu, 2);
        }
    }

    private void createActionsFromContextMenuContributionsInfo(Menu menu, IContextMenuInteractionListener listener, ECommandService commandService, EHandlerService handlerService, Collection<ContextMenuContributionInfo> infoList, IWorkbenchView workbenchView, List<Element> currentSelection) {
        assert (menu != null) : "Parameter 'menu' of method 'createActionsFromContextMenuContributionsInfo' must not be null";
        assert (listener != null) : "Parameter 'listener' of method 'createActionsFromContextMenuContributionsInfo' must not be null";
        assert (commandService != null) : "Parameter 'commandService' of method 'createActionsFromContextMenuContributionsInfo' must not be null";
        assert (handlerService != null) : "Parameter 'handlerService' of method 'createActionsFromContextMenuContributionsInfo' must not be null";
        assert (infoList != null) : "Parameter 'infoList' of method 'createActionsFromContextMenuContributionsInfo' must not be null";
        assert (workbenchView != null) : "Parameter 'workbenchView' of method 'createActionsFromContextMenuContributionsInfo' must not be null";
        assert (currentSelection != null) : "Parameter 'currentSelection' of method 'createActionsFromContextMenuContributionsInfo' must not be null";
        IMenuGroup currentMenuGroup = null;
        for (ContextMenuContributionInfo nextInfo : infoList) {
            IContextMenuContributor nextContributor = nextInfo.getContributor();
            IMenuGroup nextMenuGroup = nextContributor.getMenuGroup();
            if ((nextMenuGroup != null && !nextMenuGroup.createSubMenu() && currentMenuGroup != nextMenuGroup || nextContributor.addSeparatorBefore()) && menu.getItemCount() > 0) {
                this.addSeparator(menu);
            }
            MenuItem nextMenuItem = new MenuItem(menu, 8);
            nextMenuItem.setText(nextContributor.getLabel(workbenchView, currentSelection, nextInfo.getLabel()));
            String nextImageResourceName = nextInfo.getImageResourceName();
            if (nextImageResourceName != null) {
                nextMenuItem.setImage(UiResourceManager.getInstance().getImage(nextImageResourceName));
            }
            nextMenuItem.addSelectionListener((SelectionListener)new CommandExecutionSelectionAdapter(listener, commandService, handlerService, nextInfo.getCommandId()));
            if (nextContributor.addSeparatorAfter()) {
                this.addSeparator(menu);
            }
            currentMenuGroup = nextMenuGroup;
        }
    }

    private void addCommandContributionItems(Menu menu, IContextMenuInteractionListener listener, IWorkbenchView workbenchView, List<Element> currentSelection) {
        ContextMenuContributionInfoComparator comparator;
        assert (menu != null) : "Parameter 'menu' of method 'addCommandContributionItems' must not be null";
        assert (listener != null) : "Parameter 'listener' of method 'addCommandContributionItems' must not be null";
        assert (workbenchView != null) : "Parameter 'workbenchView' of method 'addCommandContributionItems' must not be null";
        assert (currentSelection != null) : "Parameter 'currentSelection' of method 'addCommandContributionItems' must not be null";
        IEclipseContext eclipseContext = workbenchView.getEclipseContext();
        ECommandService commandService = (ECommandService)eclipseContext.get(ECommandService.class);
        EHandlerService handlerService = (EHandlerService)eclipseContext.get(EHandlerService.class);
        ArrayList<ContextMenuContributionInfo> firstContributionInfo = new ArrayList<ContextMenuContributionInfo>();
        ArrayList<ContextMenuContributionInfo> contributionInfo = new ArrayList<ContextMenuContributionInfo>();
        ArrayList<ContextMenuContributionInfo> lastContributionInfo = new ArrayList<ContextMenuContributionInfo>();
        THashMap invisibleGroupedMenuEntries = new THashMap();
        THashMap groupedMenuEntries = new THashMap();
        boolean atLeastOneEntryAdded = false;
        for (ContextMenuContributionInfo nextInfo : WorkbenchRegistry.getInstance().getContextMenuContributionInfo()) {
            Command nextCommand = commandService.getCommand(nextInfo.getCommandId());
            IContextMenuContributor nextContributor = nextInfo.getContributor();
            if (nextCommand == null || !nextCommand.isEnabled() || !nextCommand.isHandled() || nextCommand.getHandler() == null || !nextCommand.getHandler().isEnabled() || !nextContributor.showInContextMenu(workbenchView, currentSelection)) continue;
            IMenuGroup menuGroup = nextContributor.getMenuGroup();
            if (menuGroup != null && menuGroup != IContextMenuContributor.SpecialMenuGroup.FIRST && menuGroup != IContextMenuContributor.SpecialMenuGroup.LAST) {
                if (menuGroup.createSubMenu()) {
                    menuEntries = (ArrayList<ContextMenuContributionInfo>)groupedMenuEntries.get(menuGroup);
                    if (menuEntries == null) {
                        menuEntries = new ArrayList<ContextMenuContributionInfo>();
                        groupedMenuEntries.put(menuGroup, menuEntries);
                    }
                    menuEntries.add(nextInfo);
                } else {
                    menuEntries = (List)invisibleGroupedMenuEntries.get(menuGroup);
                    if (menuEntries == null) {
                        menuEntries = new ArrayList();
                        invisibleGroupedMenuEntries.put(menuGroup, menuEntries);
                    }
                    menuEntries.add(nextInfo);
                }
            } else if (menuGroup == IContextMenuContributor.SpecialMenuGroup.FIRST) {
                firstContributionInfo.add(nextInfo);
            } else if (menuGroup == IContextMenuContributor.SpecialMenuGroup.LAST) {
                lastContributionInfo.add(nextInfo);
            } else {
                contributionInfo.add(nextInfo);
            }
            atLeastOneEntryAdded = true;
        }
        if (atLeastOneEntryAdded) {
            EModelService modelService = (EModelService)eclipseContext.get(EModelService.class);
            MApplication application = (MApplication)eclipseContext.get(MApplication.class);
            List mainMenuIds = modelService.findElements((MUIElement)application, null, MHandledItem.class, null, 32);
            THashMap commandIdToIndex = new THashMap();
            int index = 0;
            for (MHandledItem nextMainMenuId : mainMenuIds) {
                MCommand nextCommandId = nextMainMenuId.getCommand();
                if (nextCommandId != null) {
                    commandIdToIndex.put(nextCommandId.getElementId(), index);
                    ++index;
                    continue;
                }
                LOGGER.warn("No command found for: " + nextMainMenuId.getElementId());
            }
            comparator = new ContextMenuContributionInfoComparator((Map<String, Integer>)commandIdToIndex);
        } else {
            comparator = null;
        }
        if (!firstContributionInfo.isEmpty()) {
            assert (comparator != null) : "'comparator' of method 'addCommandContributionItems' must not be null";
            firstContributionInfo.sort(comparator);
            this.createActionsFromContextMenuContributionsInfo(menu, listener, commandService, handlerService, firstContributionInfo, workbenchView, currentSelection);
        }
        if (!contributionInfo.isEmpty()) {
            assert (comparator != null) : "'comparator' of method 'addCommandContributionItems' must not be null";
            contributionInfo.sort(comparator);
            this.createActionsFromContextMenuContributionsInfo(menu, listener, commandService, handlerService, contributionInfo, workbenchView, currentSelection);
        }
        if (!invisibleGroupedMenuEntries.isEmpty()) {
            assert (comparator != null) : "'comparator' of method 'addCommandContributionItems' must not be null";
            for (Map.Entry nextEntry : invisibleGroupedMenuEntries.entrySet()) {
                List nextMenuContributionInfo = (List)nextEntry.getValue();
                nextMenuContributionInfo.sort(comparator);
                this.createActionsFromContextMenuContributionsInfo(menu, listener, commandService, handlerService, nextMenuContributionInfo, workbenchView, currentSelection);
            }
        }
        if (!groupedMenuEntries.isEmpty()) {
            assert (comparator != null) : "'comparator' of method 'addCommandContributionItems' must not be null";
            for (Map.Entry entry : groupedMenuEntries.entrySet()) {
                IMenuGroup nextMenuGroup = (IMenuGroup)entry.getKey();
                List nextMenuContributionInfo = (List)entry.getValue();
                nextMenuContributionInfo.sort(comparator);
                MenuItem nextSubMenuItem = new MenuItem(menu, 64);
                nextSubMenuItem.setText(nextMenuGroup.getText());
                String nextImageResourceName = nextMenuGroup.getImageResourceName();
                if (nextImageResourceName != null) {
                    nextSubMenuItem.setImage(UiResourceManager.getInstance().getImage(nextImageResourceName));
                }
                Menu nextSubMenu = new Menu(menu);
                nextSubMenuItem.setMenu(nextSubMenu);
                this.createActionsFromContextMenuContributionsInfo(nextSubMenu, listener, commandService, handlerService, nextMenuContributionInfo, workbenchView, currentSelection);
            }
        }
        if (!lastContributionInfo.isEmpty()) {
            assert (comparator != null) : "'comparator' of method 'addCommandContributionItems' must not be null";
            lastContributionInfo.sort(comparator);
            this.createActionsFromContextMenuContributionsInfo(menu, listener, commandService, handlerService, lastContributionInfo, workbenchView, currentSelection);
        }
    }

    private void addSeparator(Menu menu, SonargraphWizardAdapter.Category category, String bundleId, SonargraphWizardAdapter nextToAdd) {
        assert (menu != null) : "Parameter 'menu' of method 'addSeparator' must not be null";
        assert (nextToAdd != null) : "Parameter 'nextToAdd' of method 'addSeparator' must not be null";
        boolean addSeparator = false;
        if (category != null && nextToAdd.getCategory() != category) {
            addSeparator = true;
        }
        if (!addSeparator && bundleId != null && !nextToAdd.getBundleId().equals(bundleId)) {
            addSeparator = true;
        }
        if (addSeparator) {
            this.addSeparator(menu);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addWizards(Menu menu, IContextMenuInteractionListener listener, IWorkbenchView workbenchView, List<Element> selected) {
        block15: {
            SonargraphWizardAdapter.Category nextCategory;
            assert (menu != null) : "Parameter 'menu' of method 'addWizards' must not be null";
            assert (listener != null) : "'listener' of method 'addWizards' must not be null";
            assert (workbenchView != null) : "Parameter 'workbenchView' of method 'addWizards' must not be null";
            assert (selected != null) : "Parameter 'selected' of method 'addWizards' must not be null";
            ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
            LinkedHashMap<SonargraphWizardAdapter.Category, ArrayList<SonargraphWizardAdapter>> categoryToWizardAdapter = new LinkedHashMap<SonargraphWizardAdapter.Category, ArrayList<SonargraphWizardAdapter>>();
            for (SonargraphWizardAdapter sonargraphWizardAdapter : WizardRegistry.getInstance().getWizardAdapters()) {
                if (!sonargraphWizardAdapter.isAvailable() || !sonargraphWizardAdapter.isEnabled(provider, selected) || !sonargraphWizardAdapter.showInContextMenu(provider, workbenchView, selected)) continue;
                nextCategory = sonargraphWizardAdapter.getCategory();
                ArrayList<SonargraphWizardAdapter> wizardAdapters = (ArrayList<SonargraphWizardAdapter>)categoryToWizardAdapter.get((Object)nextCategory);
                if (wizardAdapters == null) {
                    wizardAdapters = new ArrayList<SonargraphWizardAdapter>();
                    categoryToWizardAdapter.put(nextCategory, wizardAdapters);
                }
                wizardAdapters.add(sonargraphWizardAdapter);
            }
            if (categoryToWizardAdapter.isEmpty()) break block15;
            this.addSeparator(menu);
            if (categoryToWizardAdapter.size() > 1) {
                for (Map.Entry entry : categoryToWizardAdapter.entrySet()) {
                    nextCategory = (SonargraphWizardAdapter.Category)((Object)entry.getKey());
                    List nextWizardAdapters = (List)entry.getValue();
                    assert (!nextWizardAdapters.isEmpty()) : "'nextWizardAdapters' must not be empty";
                    MenuItem subMenuItem = new MenuItem(menu, 64);
                    subMenuItem.setText(nextCategory.getPresentationName());
                    subMenuItem.setImage(UiResourceManager.getInstance().getImage(nextCategory.getImageResource()));
                    Menu subMenu = new Menu(menu);
                    subMenuItem.setMenu(subMenu);
                    String currentBundleId = null;
                    SonargraphWizardAdapter.Category currentCategory = null;
                    for (SonargraphWizardAdapter nextWizardAdapter : nextWizardAdapters) {
                        this.addSeparator(subMenu, currentCategory, currentBundleId, nextWizardAdapter);
                        MenuItem nextSubMenuMenuItem = new MenuItem(subMenu, 8);
                        nextSubMenuMenuItem.setText(nextWizardAdapter.getName() + "...");
                        String imageResource = nextWizardAdapter.getImageResource();
                        if (imageResource != null) {
                            nextSubMenuMenuItem.setImage(UiResourceManager.getInstance().getImage(imageResource));
                        }
                        nextSubMenuMenuItem.addSelectionListener((SelectionListener)new OpenWizardSelectionAdapter(listener, nextWizardAdapter, provider, selected));
                        currentBundleId = nextWizardAdapter.getBundleId();
                        currentCategory = nextWizardAdapter.getCategory();
                    }
                }
            } else {
                Object var7_11 = null;
                String currentBundleId = null;
                for (Map.Entry nextEntry : categoryToWizardAdapter.entrySet()) {
                    for (SonargraphWizardAdapter nextWizardAdapter : (List)nextEntry.getValue()) {
                        void var7_12;
                        this.addSeparator(menu, (SonargraphWizardAdapter.Category)var7_12, currentBundleId, nextWizardAdapter);
                        MenuItem nextWizardMenuItem = new MenuItem(menu, 8);
                        nextWizardMenuItem.setText(nextWizardAdapter.getName() + "...");
                        String imageResource = nextWizardAdapter.getImageResource();
                        if (imageResource != null) {
                            nextWizardMenuItem.setImage(UiResourceManager.getInstance().getImage(imageResource));
                        }
                        nextWizardMenuItem.addSelectionListener((SelectionListener)new OpenWizardSelectionAdapter(listener, nextWizardAdapter, provider, selected));
                        SonargraphWizardAdapter.Category category = nextWizardAdapter.getCategory();
                        currentBundleId = nextWizardAdapter.getBundleId();
                    }
                }
            }
        }
    }

    private void addNavigationEntries(Menu menu, IContextMenuInteractionListener listener, Set<IViewId> viewIds, IWorkbenchView workbenchView, List<Element> selectedElements) {
        assert (menu != null) : "Parameter 'menu' of method 'addNavigationEntries' must not be null";
        assert (viewIds != null && !viewIds.isEmpty()) : "Parameter 'viewIds' of method 'addNavigationEntries' must not be empty";
        assert (workbenchView != null) : "Parameter 'workbenchView' of method 'addNavigationEntries' must not be null";
        assert (selectedElements != null && !selectedElements.isEmpty()) : "Parameter 'selectedElements' of method 'addNavigationEntries' must not be empty";
        assert (listener != null) : "Parameter 'listener' of method 'addNavigationEntries' must not be null";
        boolean separatorAdded = false;
        TreeMap sortedMenuEntries = new TreeMap(new ShowInViewMenuEntryModelComparator());
        for (IViewId iViewId : viewIds) {
            SupportsShowInView nextSupportsShowInView = iViewId.getSupportsShowInView(workbenchView.getViewId());
            if (nextSupportsShowInView == null || iViewId == workbenchView.getViewId() && !nextSupportsShowInView.supportsShowInSelf()) continue;
            String secondaryIdForReuse = workbenchView.getViewId() == iViewId ? workbenchView.getSecondaryId() : null;
            ShowInView showInView = nextSupportsShowInView.supportsShowInViewFor(selectedElements, workbenchView.getAdditionalShowInViewOptions(), secondaryIdForReuse);
            if (showInView == null) continue;
            if (!separatorAdded) {
                this.addSeparator(menu);
                separatorAdded = true;
            }
            THashMap depthToMenu = new THashMap();
            depthToMenu.put(0, menu);
            for (ShowInViewNode rootMenuNode : showInView.getRootNodes()) {
                ShowInViewNodeVisitor creator = new ShowInViewNodeVisitor((Map)depthToMenu, listener, workbenchView, iViewId, secondaryIdForReuse, sortedMenuEntries){
                    private final /* synthetic */ Map val$depthToMenu;
                    private final /* synthetic */ IContextMenuInteractionListener val$listener;
                    private final /* synthetic */ IWorkbenchView val$workbenchView;
                    private final /* synthetic */ IViewId val$nextViewId;
                    private final /* synthetic */ String val$secondaryIdForReuse;
                    private final /* synthetic */ SortedMap val$sortedMenuEntries;
                    {
                        this.val$depthToMenu = map;
                        this.val$listener = iContextMenuInteractionListener;
                        this.val$workbenchView = iWorkbenchView;
                        this.val$nextViewId = iViewId;
                        this.val$secondaryIdForReuse = string;
                        this.val$sortedMenuEntries = sortedMap;
                    }

                    @Override
                    public boolean visit(ShowInViewNode showInViewNode) {
                        if (!$assertionsDisabled && showInViewNode == null) {
                            throw new AssertionError((Object)"Parameter 'showInViewNode' of method 'visit' must not be null");
                        }
                        int depth = showInViewNode.getDepth();
                        Menu menuForDepth = (Menu)this.val$depthToMenu.get(depth);
                        if (!$assertionsDisabled && menuForDepth == null) {
                            throw new AssertionError((Object)"'menuForDepth' of method 'visit' must not be null");
                        }
                        String text = showInViewNode.getName();
                        String imageName = showInViewNode.getImageResourceName();
                        if (showInViewNode.isLeaf()) {
                            ShowInViewSelectionAdapter nextSelectionAdapter = showInViewNode instanceof ShowInViewNodeWithOptionProvider ? new ShowInViewSelectionAdapter(this.val$listener, this.val$workbenchView, this.val$nextViewId, showInViewNode.getSecondaryId(), showInViewNode.getElements(), text, this.val$secondaryIdForReuse, showInViewNode.getOptions(), ((ShowInViewNodeWithOptionProvider)showInViewNode).getOptionProvider(), this.val$secondaryIdForReuse != null) : new ShowInViewSelectionAdapter(this.val$listener, this.val$workbenchView, this.val$nextViewId, showInViewNode.getSecondaryId(), showInViewNode.getOptions(), showInViewNode.getElements(), text, imageName, this.val$secondaryIdForReuse != null);
                            if (depth == 0) {
                                this.val$sortedMenuEntries.put(showInViewNode, nextSelectionAdapter);
                            } else {
                                MenuItem menuItem = new MenuItem(menuForDepth, 8);
                                menuItem.setText(text);
                                if (imageName != null) {
                                    menuItem.setImage(UiResourceManager.getInstance().getImage(imageName));
                                }
                                menuItem.addSelectionListener((SelectionListener)nextSelectionAdapter);
                                if (showInViewNode.addSeparatorAfter()) {
                                    new MenuItem(menuForDepth, 2);
                                }
                            }
                        } else {
                            MenuItem subMenuItem = new MenuItem(menuForDepth, 64);
                            subMenuItem.setText(text);
                            if (imageName != null) {
                                subMenuItem.setImage(UiResourceManager.getInstance().getImage(imageName));
                            }
                            Menu subMenu = new Menu(menuForDepth);
                            subMenuItem.setMenu(subMenu);
                            this.val$depthToMenu.put(depth + 1, subMenu);
                            if (showInViewNode.addSeparatorAfter()) {
                                new MenuItem(menuForDepth, 2);
                            }
                        }
                        return this.visitChildrenOf(showInViewNode);
                    }
                };
                rootMenuNode.accept(creator);
            }
        }
        for (Map.Entry entry : sortedMenuEntries.entrySet()) {
            ShowInViewNode showInViewNode = (ShowInViewNode)((Object)entry.getKey());
            ShowInViewSelectionAdapter nextAdapter = (ShowInViewSelectionAdapter)entry.getValue();
            MenuItem nextMenuItem = new MenuItem(menu, 8);
            nextMenuItem.setText(nextAdapter.getText());
            String nextImageResourceName = nextAdapter.getImageResourcename();
            if (nextImageResourceName != null) {
                nextMenuItem.setImage(UiResourceManager.getInstance().getImage(nextImageResourceName));
            }
            nextMenuItem.addSelectionListener((SelectionListener)nextAdapter);
            if (!showInViewNode.addSeparatorAfter()) continue;
            new MenuItem(menu, 2);
        }
    }

    private void addNavigationEntries(Menu menu, IContextMenuInteractionListener listener, IWorkbenchView workbenchView, List<Element> selectedElements) {
        assert (menu != null) : "Parameter 'menu' of method 'addNavigationEntries' must not be null";
        assert (listener != null) : "Parameter 'listener' of method 'addNavigationEntries' must not be null";
        assert (workbenchView != null) : "Parameter 'workbenchView' of method 'addNavigationEntries' must not be null";
        assert (selectedElements != null) : "Parameter 'selectedElements' of method 'addNavigationEntries' must not be null";
        if (selectedElements.isEmpty()) {
            return;
        }
        Set<IViewId> viewIds = WorkbenchRegistry.getInstance().getAvailableViewIds();
        if (viewIds.isEmpty()) {
            return;
        }
        this.addNavigationEntries(menu, listener, viewIds, workbenchView, selectedElements);
        for (Element nextSelectedElement : selectedElements) {
            if (!(nextSelectedElement instanceof IMetricValue)) continue;
            NamedElement nextAssociatedElement = ((IMetricValue)nextSelectedElement).getAssociatedElement();
            this.addNavigationEntries(menu, listener, viewIds, workbenchView, Collections.singletonList(nextAssociatedElement));
        }
        if (selectedElements.size() > 1) {
            return;
        }
        NamedElement from = null;
        NamedElement to = null;
        Element selectedElement = selectedElements.get(0);
        if (selectedElement instanceof Issue) {
            selectedElement = ((Issue)selectedElement).getAffectedElement();
        }
        if (selectedElement instanceof Dependency) {
            Dependency dependency = (Dependency)selectedElement;
            from = dependency.getUnderlyingFrom();
            to = dependency.getUnderlyingTo();
        } else if (selectedElement instanceof RepresentationDependency) {
            RepresentationDependency representationDependency = (RepresentationDependency)selectedElement;
            from = representationDependency.getFromEndPoint();
            to = representationDependency.getToEndPoint();
        }
        if (from != null) {
            assert (to != null) : "'to' of method 'menuAboutToShow' must not be null";
            String fromSubMenuName = "From '" + from.getPresentationName(true) + "'";
            String toSubMenuName = "To '" + to.getPresentationName(true) + "'";
            MenuItem fromSubMenuItem = new MenuItem(menu, 64);
            fromSubMenuItem.setText(fromSubMenuName);
            fromSubMenuItem.setImage(UiResourceManager.getInstance().getImage(from.getImageResourceName()));
            Menu fromSubMenu = new Menu(menu);
            fromSubMenuItem.setMenu(fromSubMenu);
            MenuItem toSubMenuItem = new MenuItem(menu, 64);
            toSubMenuItem.setText(toSubMenuName);
            toSubMenuItem.setImage(UiResourceManager.getInstance().getImage(to.getImageResourceName()));
            Menu toSubMenu = new Menu(menu);
            toSubMenuItem.setMenu(toSubMenu);
            this.addNavigationEntries(fromSubMenu, listener, viewIds, workbenchView, Collections.singletonList(from));
            this.addNavigationEntries(toSubMenu, listener, viewIds, workbenchView, Collections.singletonList(to));
            if (fromSubMenu.getItems().length == 0) {
                fromSubMenuItem.dispose();
                fromSubMenu.dispose();
            }
            if (toSubMenu.getItems().length == 0) {
                toSubMenuItem.dispose();
                toSubMenu.dispose();
            }
        }
    }

    void populate(Menu menu, IContextMenuInteractionListener listener, IWorkbenchView workbenchView, List<Element> currentSelection) {
        MenuItem lastItem;
        assert (menu != null) : "Parameter 'menu' of method 'populate' must not be null";
        assert (listener != null) : "Parameter 'listener' of method 'populate' must not be null";
        assert (workbenchView != null) : "Parameter 'workbenchView' of method 'populate' must not be null";
        assert (currentSelection != null) : "Parameter 'currentSelection' of method 'populate' must not be null";
        this.addCommandContributionItems(menu, listener, workbenchView, currentSelection);
        this.addWizards(menu, listener, workbenchView, currentSelection);
        this.addNavigationEntries(menu, listener, workbenchView, currentSelection);
        MenuItem[] items = menu.getItems();
        if (items != null && items.length > 0 && (lastItem = items[items.length - 1]).getStyle() == 2) {
            lastItem.dispose();
        }
    }
}

