/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.draw2d;

import com.hello2morrow.draw2d.Dimension;
import com.hello2morrow.draw2d.Figure;
import com.hello2morrow.draw2d.Graphics;
import com.hello2morrow.draw2d.IFigure;
import com.hello2morrow.draw2d.Layer;
import com.hello2morrow.draw2d.LayoutManager;
import com.hello2morrow.draw2d.Rectangle;
import com.hello2morrow.draw2d.ScalableLayeredPane;
import com.hello2morrow.draw2d.StackLayout;
import com.hello2morrow.sonargraph.ui.swt.base.draw2d.DrawableViewLayout;
import com.hello2morrow.sonargraph.ui.swt.base.draw2d.IDrawableNode;
import com.hello2morrow.sonargraph.ui.swt.base.draw2d.ISizeProvider;
import com.hello2morrow.sonargraph.ui.swt.base.draw2d.ZoomManager;
import org.eclipse.swt.widgets.Control;

public final class DrawableViewContentFigure
extends ScalableLayeredPane {
    public static final float MAX_ZOOM = 2.0f;
    public static final float MAX_AUTOZOOM = 1.3f;
    public static final float MIN_AUTOZOOM = 0.6f;
    public static final float MIN_ZOOM = 0.2f;
    private final Layer m_bottomLayer;
    private final Layer m_edgesLayer;
    private final Layer m_nodesLayer;
    private final Layer m_topLayer;
    private final Control m_displayingControl;
    private ZoomManager m_zoomManager;
    private boolean m_notifyChildren = true;

    DrawableViewContentFigure(DrawableViewLayout layout, Control displayingControl) {
        assert (layout != null) : "Parameter 'layout' of method 'DrawableViewRootFigure' must not be null";
        assert (displayingControl != null) : "Parameter 'displayingControl' of method 'DrawableViewRootFigure' must not be null";
        this.m_displayingControl = displayingControl;
        this.setLayoutManager(new StackLayout());
        this.m_bottomLayer = new Layer();
        super.add(this.m_bottomLayer, null, -1);
        this.m_edgesLayer = new Layer();
        super.add(this.m_edgesLayer, null, -1);
        this.m_nodesLayer = new Layer();
        super.add(this.m_nodesLayer, null, -1);
        this.m_topLayer = new Layer();
        super.add(this.m_topLayer, null, -1);
        this.setLayout(layout);
    }

    @Override
    public void setScale(double newZoom) {
        this.m_notifyChildren = this.getScale() != newZoom;
        super.setScale(newZoom);
    }

    @Override
    public void setBounds(Rectangle rect) {
        boolean translate;
        assert (rect != null) : "Parameter 'rect' of method 'setBounds' must not be null";
        int x = this.bounds.x;
        int y = this.bounds.y;
        boolean resize = rect.width != this.bounds.width || rect.height != this.bounds.height;
        boolean bl = translate = rect.x != x || rect.y != y;
        if ((resize || translate) && this.isVisible() && this.m_notifyChildren) {
            this.erase();
        }
        if (translate) {
            int dx = rect.x - x;
            int dy = rect.y - y;
            this.primTranslate(dx, dy);
        }
        this.bounds.width = rect.width;
        this.bounds.height = rect.height;
        if ((translate || resize) && this.m_notifyChildren) {
            if (resize) {
                this.invalidate();
            }
            this.fireFigureMoved();
            this.repaint();
        }
        this.m_notifyChildren = false;
    }

    void setLayout(final DrawableViewLayout layout) {
        assert (layout != null) : "Parameter 'layout' of method 'setLayout' must not be null";
        LayoutManager layoutManager = this.m_nodesLayer.getLayoutManager();
        if (layoutManager != null) {
            assert (layout != layoutManager) : "Layout already set: " + String.valueOf(layout);
            assert (layoutManager instanceof DrawableViewLayout) : "Unexpected class in method 'setLayout': " + String.valueOf(layoutManager);
            ((DrawableViewLayout)layoutManager).clear();
        }
        this.m_zoomManager = new ZoomManager(new ISizeProvider(){

            @Override
            public Dimension getNeededSize() {
                return layout.getNeededSize();
            }

            @Override
            public Dimension getAvailableSize() {
                org.eclipse.swt.graphics.Rectangle bounds = DrawableViewContentFigure.this.m_displayingControl.getBounds();
                return new Dimension(bounds.width, bounds.height);
            }
        }, this, 0.2f, 2.0);
        this.m_nodesLayer.setLayoutManager(layout);
        layout.connect(this.m_displayingControl, this.m_bottomLayer, this.m_edgesLayer, this.m_nodesLayer, this.m_topLayer);
    }

    DrawableViewLayout getNodesLayerLayout() {
        return (DrawableViewLayout)this.getNodesLayer().getLayoutManager();
    }

    void dispose() {
        this.getNodesLayerLayout().dispose();
    }

    @Override
    protected void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
    }

    void zoomIn() {
        this.m_zoomManager.zoomIn();
    }

    void zoomOut() {
        this.m_zoomManager.zoomOut();
    }

    void home() {
        this.getNodesLayerLayout().home();
    }

    void fitToView() {
        this.m_zoomManager.fitToView(ZoomManager.FitMode.VERTICAL);
    }

    double getZoomLevel() {
        return this.m_zoomManager.getScale();
    }

    @Override
    public void add(IFigure figure, Object constraint, int index) {
        assert (figure != null) : "Parameter 'figure' of method 'add' must not be null";
        assert (constraint != null) : "Parameter 'constraint' of method 'add' must not be null";
        assert (constraint instanceof Layer) : "Parameter 'constraint' of method 'add' must be of class 'Layer': " + constraint.getClass().getSimpleName();
        Layer toLayer = (Layer)constraint;
        assert (this.getChildren().contains(toLayer)) : "Not an owned layer: " + String.valueOf(toLayer);
        toLayer.add(figure, null, index);
    }

    @Override
    public void remove(IFigure figure) {
        assert (figure != null) : "Parameter 'figure' of method 'remove' must not be null";
        assert (figure != this.m_bottomLayer) : "Layer can not be removed";
        assert (figure != this.m_edgesLayer) : "Layer can not be removed";
        assert (figure != this.m_nodesLayer) : "Layer can not be removed";
        assert (figure != this.m_topLayer) : "Layer can not be removed";
        IFigure parent = figure.getParent();
        assert (parent != null) : "'parent' of method 'remove' must not be null";
        ((Layer)parent).remove(figure);
    }

    void clear() {
        this.m_bottomLayer.removeAll();
        this.m_edgesLayer.removeAll();
        this.m_nodesLayer.removeAll();
        this.m_topLayer.removeAll();
        this.getNodesLayerLayout().clear();
    }

    Layer getBottomLayer() {
        return this.m_bottomLayer;
    }

    Layer getEdgesLayer() {
        return this.m_edgesLayer;
    }

    Layer getNodesLayer() {
        return this.m_nodesLayer;
    }

    Layer getTopLayer() {
        return this.m_topLayer;
    }

    void addFigure(Figure figure, Layer layer) {
        this.add((IFigure)figure, layer);
    }

    <T extends IDrawableNode.IDrawableEdge<?>> void addEdge(T edgeFigure) {
        this.add(edgeFigure, this.getEdgesLayer(), 0);
    }

    <T extends IDrawableNode> void addNode(T graphNodeFigure) {
        this.add(graphNodeFigure, this.getNodesLayer());
    }

    void setMinScale(double minScale) {
        this.m_zoomManager.setMinScale(minScale);
    }

    void setScaleStep(double scaleStep) {
        this.m_zoomManager.setScaleStep(scaleStep);
    }

    void calculateSize() {
        Dimension nodesLayerDimension = this.m_nodesLayer.getLayoutManager().getPreferredSize(this.m_nodesLayer, -1, -1);
        this.setPreferredSize(nodesLayerDimension);
    }
}

