/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.draw2d;

import com.hello2morrow.draw2d.BorderLayout;
import com.hello2morrow.draw2d.Figure;
import com.hello2morrow.draw2d.IFigure;
import com.hello2morrow.draw2d.Label;
import com.hello2morrow.sonargraph.core.model.representation.NameMode;
import com.hello2morrow.sonargraph.core.model.representation.RepresentationNode;
import com.hello2morrow.sonargraph.foundation.utilities.ByteBitFieldUtil;
import com.hello2morrow.sonargraph.ui.swt.base.draw2d.DrawableNodeLabel;
import com.hello2morrow.sonargraph.ui.swt.base.draw2d.IDrawableFigure;
import com.hello2morrow.sonargraph.ui.swt.base.draw2d.IDrawableNode;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DrawableNode
extends Figure
implements IDrawableNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(DrawableNode.class);
    protected static final int SPACING = 4;
    private final RepresentationNode m_node;
    private final IDrawableFigure.IDrawableFigureListener m_figureListener;
    private final DrawableNodeLabel m_label;
    private final NameMode m_nameMode;
    private Set<IDrawableNode.IDrawableEdge<? extends IDrawableNode>> m_edges;
    private Map<String, Object> m_data;
    private byte m_state;

    public DrawableNode(IDrawableFigure.IDrawableFigureListener listener, RepresentationNode node, Image image, NameMode nameMode) {
        assert (listener != null) : "Parameter 'listener' of method 'DrawableNode' must not be null";
        assert (node != null) : "Parameter 'node' of method 'DrawableNode' must not be null";
        assert (image != null) : "Parameter 'image' of method 'DrawableNode' must not be null";
        assert (nameMode != null) : "Parameter 'nameMode' of method 'DrawableNode' must not be null";
        this.m_figureListener = listener;
        this.m_node = node;
        this.m_nameMode = nameMode;
        BorderLayout layout = new BorderLayout();
        this.setLayoutManager(layout);
        this.m_label = new DrawableNodeLabel(this.getTextForNode(), image);
        this.m_label.setForegroundColor(this.getForgroundColorForNode());
        this.add((IFigure)this.m_label, BorderLayout.CENTER);
    }

    protected abstract Color getForgroundColorForNode();

    protected final DrawableNodeLabel getLabel() {
        return this.m_label;
    }

    @Override
    public final void setIsHighlighted(boolean isHighlighted) {
        this.m_state = isHighlighted ? ByteBitFieldUtil.enableFlag((byte)this.m_state, (byte)((byte)(1 << NodeState.HIGHLIGHTED_DIRECT.ordinal()))) : ByteBitFieldUtil.disableFlag((byte)this.m_state, (byte)((byte)(1 << NodeState.HIGHLIGHTED_DIRECT.ordinal())));
        this.invalidate();
    }

    public final boolean isHighlighted() {
        return ByteBitFieldUtil.isFlagEnabled((byte)this.m_state, (byte)((byte)(1 << NodeState.HIGHLIGHTED_DIRECT.ordinal())));
    }

    @Override
    public final void setIsHighlightedIndirectly(boolean isHighlighted) {
        this.m_state = isHighlighted ? ByteBitFieldUtil.enableFlag((byte)this.m_state, (byte)((byte)(1 << NodeState.HIGHLIGHTED_INDIRECT.ordinal()))) : ByteBitFieldUtil.disableFlag((byte)this.m_state, (byte)((byte)(1 << NodeState.HIGHLIGHTED_INDIRECT.ordinal())));
        this.invalidate();
    }

    public final boolean isHighlightedIndirectly() {
        return ByteBitFieldUtil.isFlagEnabled((byte)this.m_state, (byte)((byte)(1 << NodeState.HIGHLIGHTED_INDIRECT.ordinal())));
    }

    @Override
    public final void setIsHighlightedMixed(boolean isHighlighted) {
        this.m_state = isHighlighted ? ByteBitFieldUtil.enableFlag((byte)this.m_state, (byte)((byte)(1 << NodeState.HIGHLIGHTED_MIXED.ordinal()))) : ByteBitFieldUtil.disableFlag((byte)this.m_state, (byte)((byte)(1 << NodeState.HIGHLIGHTED_MIXED.ordinal())));
        this.invalidate();
    }

    public final boolean isHighlightedMixed() {
        return ByteBitFieldUtil.isFlagEnabled((byte)this.m_state, (byte)((byte)(1 << NodeState.HIGHLIGHTED_MIXED.ordinal())));
    }

    @Override
    public final void setSelected(boolean isSelected) {
        this.m_state = isSelected ? ByteBitFieldUtil.enableFlag((byte)this.m_state, (byte)((byte)(1 << NodeState.SELECTED.ordinal()))) : ByteBitFieldUtil.disableFlag((byte)this.m_state, (byte)((byte)(1 << NodeState.SELECTED.ordinal())));
        this.invalidate();
    }

    @Override
    public final boolean isSelected() {
        return ByteBitFieldUtil.isFlagEnabled((byte)this.m_state, (byte)((byte)(1 << NodeState.SELECTED.ordinal())));
    }

    @Override
    public final Object getData(String key) {
        assert (key != null) : "Parameter 'key' of method 'getData' must not be null";
        return this.m_data != null ? this.m_data.get(key) : null;
    }

    @Override
    public final void setData(String key, Object data) {
        assert (key != null) : "Parameter 'key' of method 'setData' must not be null";
        assert (data != null) : "Parameter 'data' of method 'setData' must not be null";
        if (this.m_data == null) {
            this.m_data = new LinkedHashMap<String, Object>(4);
        }
        this.m_data.put(key, data);
    }

    public final RepresentationNode getRepresentationElement() {
        return this.m_node;
    }

    public final boolean hasEdges() {
        return this.m_edges != null && !this.m_edges.isEmpty();
    }

    private final void unlinkEdge(IDrawableNode.IDrawableEdge<? extends IDrawableNode> edgeFigure) {
        assert (this.hasEdges()) : "No edges: " + String.valueOf(this);
        assert (edgeFigure != null) : "Parameter 'edgeFigure' of method 'unlinkEdge' must not be null";
        boolean success = this.m_edges.remove(edgeFigure);
        assert (success) : "Edge not found: " + String.valueOf(edgeFigure);
        if (this.m_edges.isEmpty()) {
            this.m_edges = null;
        }
    }

    public final Collection<IDrawableNode.IDrawableEdge<? extends IDrawableNode>> removeEdges() {
        if (this.hasEdges()) {
            for (IDrawableNode.IDrawableEdge<? extends IDrawableNode> nextEdge : this.m_edges) {
                if (nextEdge.getFrom() == this && nextEdge.getTo() == this) continue;
                if (nextEdge.getFrom() == this) {
                    ((DrawableNode)nextEdge.getTo()).unlinkEdge(nextEdge);
                    continue;
                }
                ((DrawableNode)nextEdge.getFrom()).unlinkEdge(nextEdge);
            }
            Set<IDrawableNode.IDrawableEdge<? extends IDrawableNode>> edges = this.m_edges;
            this.m_edges = null;
            this.invalidate();
            return edges;
        }
        return Collections.emptyList();
    }

    private final void linkEdge(IDrawableNode.IDrawableEdge<? extends IDrawableNode> edge) {
        assert (edge != null) : "Parameter 'edge' of method 'linkEdge' must not be null";
        if (this.m_edges == null) {
            this.m_edges = new LinkedHashSet<IDrawableNode.IDrawableEdge<? extends IDrawableNode>>(5);
        }
        boolean notPresent = this.m_edges.add(edge);
        assert (notPresent) : "Edge already added: " + String.valueOf(edge);
    }

    public final void addEdge(IDrawableNode.IDrawableEdge<? extends IDrawableNode> edgeFigure) {
        assert (edgeFigure != null) : "Parameter 'edgeFigure' of method 'addEdge' must not be null";
        this.linkEdge(edgeFigure);
        if (edgeFigure.getFrom() != this || edgeFigure.getTo() != this) {
            if (edgeFigure.getFrom() == this) {
                ((DrawableNode)edgeFigure.getTo()).linkEdge(edgeFigure);
            } else if (edgeFigure.getTo() == this) {
                ((DrawableNode)edgeFigure.getFrom()).linkEdge(edgeFigure);
            } else assert (false) : "Edge does not contain 'this': " + String.valueOf(this) + " (" + String.valueOf(edgeFigure) + ")";
        }
        this.invalidate();
    }

    @Override
    public final Set<IDrawableNode.IDrawableEdge<? extends IDrawableNode>> getEdges() {
        if (!this.hasEdges()) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.m_edges);
    }

    public final boolean hasOutgoingEdges() {
        if (this.hasEdges()) {
            for (IDrawableNode.IDrawableEdge<? extends IDrawableNode> nextEdge : this.m_edges) {
                if (!nextEdge.getFrom().equals(this)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public final Set<IDrawableNode.IDrawableEdge<? extends IDrawableNode>> getOutgoingEdges() {
        if (!this.hasOutgoingEdges()) {
            return Collections.emptySet();
        }
        LinkedHashSet<IDrawableNode.IDrawableEdge<? extends IDrawableNode>> result = new LinkedHashSet<IDrawableNode.IDrawableEdge<? extends IDrawableNode>>();
        for (IDrawableNode.IDrawableEdge<? extends IDrawableNode> nextEdge : this.m_edges) {
            if (!nextEdge.getFrom().equals(this)) continue;
            result.add(nextEdge);
        }
        return result;
    }

    public final boolean hasIncomingEdges() {
        if (this.hasEdges()) {
            for (IDrawableNode.IDrawableEdge<? extends IDrawableNode> nextEdge : this.m_edges) {
                if (!nextEdge.getTo().equals(this)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public final Set<IDrawableNode.IDrawableEdge<? extends IDrawableNode>> getIncomingEdges() {
        if (!this.hasIncomingEdges()) {
            return Collections.emptySet();
        }
        LinkedHashSet<IDrawableNode.IDrawableEdge<? extends IDrawableNode>> result = new LinkedHashSet<IDrawableNode.IDrawableEdge<? extends IDrawableNode>>();
        for (IDrawableNode.IDrawableEdge<? extends IDrawableNode> nextEdge : this.m_edges) {
            if (!nextEdge.getTo().equals(this)) continue;
            result.add(nextEdge);
        }
        return result;
    }

    @Override
    public final IDrawableFigure.IDrawableFigureListener getListener() {
        return this.m_figureListener;
    }

    @Override
    public final void enableToolTip(boolean enable) {
        if (enable) {
            Label label = new Label(this.createTooltip());
            this.setToolTip(label);
        } else {
            this.setToolTip(null);
        }
    }

    @Override
    public final void setImage(Image image) {
        assert (image != null) : "Parameter 'image' of method 'setImage' must not be null";
        this.m_label.setImage(image);
        this.invalidate();
    }

    protected final Image getImage() {
        return this.m_label.getImage();
    }

    @Override
    public final String getTextForNode() {
        Object text = this.m_node.getTextForNode(this.m_nameMode);
        if (LOGGER.isDebugEnabled()) {
            if (this.m_node.isOriginalInputAncestor()) {
                text = (String)text + " (OA)";
            }
            if (this.m_node.isOriginalInputRelated()) {
                text = (String)text + " (O)";
            }
            if (this.m_node.isMainNode()) {
                text = (String)text + " (M)";
            }
            if (this.m_node.isAdditionalNode()) {
                text = (String)text + " (A)";
            }
            if (this.m_node.isOriginalInputDescendant()) {
                text = (String)text + " (OD)";
            }
        }
        return text;
    }

    public String toString() {
        return this.m_node.toString();
    }

    private static enum NodeState {
        HIGHLIGHTED_DIRECT,
        HIGHLIGHTED_INDIRECT,
        HIGHLIGHTED_MIXED,
        SELECTED;

    }
}

