/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.draw;

import com.hello2morrow.draw2d.Dimension;
import com.hello2morrow.draw2d.Graphics;
import com.hello2morrow.draw2d.GridLayout;
import com.hello2morrow.draw2d.IFigure;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawModifier;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DrawUtilities {
    public static final String FONT_NAME = "Arial";
    public static final int FONT_HEIGHT = UiResourceManager.getInstance().getDefaultSystemFontHeight();
    public static final UiResourceManager.FontId FONT_ID = new UiResourceManager.FontId("Arial", FONT_HEIGHT, 0);
    public static final UiResourceManager.FontId BOLD_FONT_ID = new UiResourceManager.FontId("Arial", FONT_HEIGHT, 1);
    public static final int IMAGE_HEIGHT_AND_WIDTH = 16;
    public static final int HALF_IMAGE_HEIGHT_AND_WIDTH = 8;
    public static final Dimension IMAGE_DIMENSION = new Dimension(16, 16);
    public static final Dimension EXPAND_COLLAPSE_FIGURE_DIMENSION = new Dimension(16, 16);
    public static final int CONTENT_STEPS_NO_CONTENT = -1;
    private static final Logger LOGGER = LoggerFactory.getLogger(DrawUtilities.class);

    private DrawUtilities() {
    }

    public static void checkImageDimension(Image image, String info) {
        assert (image != null) : "Parameter 'image' of method 'checkImageDimension' must not be null";
        Rectangle imageBounds = image.getBounds();
        if (16 < imageBounds.width || 16 < imageBounds.height) {
            LOGGER.warn("'" + String.valueOf(imageBounds) + "' bigger than allowed 16x16" + (String)(info != null && !info.isEmpty() ? " (" + info + ")" : ""));
        }
    }

    public static void drawBoundingBox(Graphics graphics, IFigure figure) {
        assert (graphics != null) : "Parameter 'graphics' of method 'drawBoundingBox' must not be null";
        assert (figure != null) : "Parameter 'figure' of method 'drawBoundingBox' must not be null";
        Color initialColor = graphics.getForegroundColor();
        graphics.setForegroundColor(UiResourceManager.getInstance().getColor(UiResourceManager.BLACK));
        graphics.drawRectangle(figure.getBounds().getResized(-1, -1));
        graphics.setForegroundColor(initialColor);
    }

    public static DrawModifier getModifier(MouseEvent event) {
        assert (event != null) : "Parameter 'event' of method 'getModifier' must not be null";
        if ((event.stateMask & SWT.MOD1) != 0) {
            return DrawModifier.PRIMARY;
        }
        if ((event.stateMask & 0x20000) != 0) {
            return DrawModifier.SHIFT;
        }
        return DrawModifier.NONE;
    }

    public static DrawModifier getModifier(com.hello2morrow.draw2d.MouseEvent event) {
        assert (event != null) : "Parameter 'event' of method 'getModifier' must not be null";
        if ((event.getState() & SWT.MOD1) != 0) {
            return DrawModifier.PRIMARY;
        }
        if ((event.getState() & 0x20000) != 0) {
            return DrawModifier.SHIFT;
        }
        return DrawModifier.NONE;
    }

    private static <T extends IFigure> void collectFigures(Class<T> figureClassToCollect, List<IFigure> current, List<T> collector, Predicate<IFigure> include) {
        assert (figureClassToCollect != null) : "Parameter 'figureClass' of method 'collectFigures' must not be null";
        assert (current != null) : "Parameter 'current' of method 'collectFigures' must not be null";
        assert (collector != null) : "Parameter 'collector' of method 'collectFigures' must not be null";
        assert (include != null) : "Parameter 'include' of method 'collectFigures' must not be null";
        for (IFigure next : current) {
            if (!include.test(next)) continue;
            if (figureClassToCollect.isAssignableFrom(next.getClass())) {
                collector.add(next);
            }
            DrawUtilities.collectFigures(figureClassToCollect, next.getChildren(), collector, include);
        }
    }

    public static <T extends IFigure> T findSelfOrParent(Class<T> figureClassToFind, IFigure figure) {
        assert (figureClassToFind != null) : "Parameter 'figureClassToFind' of method 'findSelfOrParent' must not be null";
        assert (figure != null) : "Parameter 'figure' of method 'findSelfOrParent' must not be null";
        IFigure current = figure;
        while (current != null) {
            if (figureClassToFind.isAssignableFrom(current.getClass())) {
                return (T)current;
            }
            current = current.getParent();
        }
        return null;
    }

    public static <T extends IFigure> List<T> findParents(Class<T> parentClassToFind, IFigure figure) {
        assert (parentClassToFind != null) : "Parameter 'parentClassToFind' of method 'findParents' must not be null";
        assert (figure != null) : "Parameter 'figure' of method 'findParents' must not be null";
        ArrayList<IFigure> parents = new ArrayList<IFigure>();
        IFigure current = figure.getParent();
        while (current != null) {
            if (parentClassToFind.isAssignableFrom(current.getClass())) {
                parents.add(current);
            }
            current = current.getParent();
        }
        return parents;
    }

    public static <T extends IFigure> List<T> findChildFigures(Class<T> figureClassToFind, IFigure parentFigure, Predicate<IFigure> include) {
        assert (figureClassToFind != null) : "Parameter 'figureClassToFind' of method 'findChildFigures' must not be null";
        assert (parentFigure != null) : "Parameter 'parentFigure' of method 'findChildFigures' must not be null";
        assert (include != null) : "Parameter 'include' of method 'findChildFigures' must not be null";
        ArrayList collector = new ArrayList(2);
        DrawUtilities.collectFigures(figureClassToFind, parentFigure.getChildren(), collector, include);
        return collector;
    }

    public static <T extends IFigure> List<T> findChildFigures(Class<T> figureClassToFind, IFigure parentFigure) {
        assert (figureClassToFind != null) : "Parameter 'figureClassToFind' of method 'findChildFigures' must not be null";
        assert (parentFigure != null) : "Parameter 'parentFigure' of method 'findChildFigures' must not be null";
        return DrawUtilities.findChildFigures(figureClassToFind, parentFigure, f -> true);
    }

    public static GridLayout createGridLayout(int columns, int horizontalMargin, int verticalMargin, int horizontalSpacing, int verticalSpacing, boolean makeColumnsEqualWidth) {
        GridLayout layout = new GridLayout(columns, makeColumnsEqualWidth);
        layout.marginWidth = horizontalMargin;
        layout.marginHeight = verticalMargin;
        layout.horizontalSpacing = horizontalSpacing;
        layout.verticalSpacing = verticalSpacing;
        return layout;
    }

    public static GridLayout createGridLayout(int columns) {
        return DrawUtilities.createGridLayout(columns, 0, 0, 0, 0, false);
    }

    public static GridLayout createGridLayout() {
        return DrawUtilities.createGridLayout(1, 0, 0, 0, 0, false);
    }
}

