/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.draw;

import com.hello2morrow.draw2d.AbstractLayout;
import com.hello2morrow.draw2d.Dimension;
import com.hello2morrow.draw2d.IFigure;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawCache;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawConnectionFigure;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawNodeFigure;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawScalableContentFigure;
import java.util.List;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Scrollable;

public abstract class DrawNodeAndConnectionFigureCanvasLayout<N, C>
extends AbstractLayout {
    protected static final double DEFAULT_SCALE_STEP = (double)0.1f;
    protected static final double SCALE_MAX = Double.MAX_VALUE;
    protected static final double NO_SCALE = 1.0;
    private final SizeAndScale m_sizeAndScale;
    private Scrollable m_drawArea;
    private DrawScalableContentFigure<N, C> m_contentFigure;
    private boolean m_needsLayout;
    private boolean m_needsPreferredSizeCalculation;
    private DrawCache m_cache;

    protected DrawNodeAndConnectionFigureCanvasLayout(double minScale, double scaleStep) {
        this.m_sizeAndScale = new SizeAndScale(minScale, scaleStep);
    }

    protected DrawNodeAndConnectionFigureCanvasLayout() {
        this(1.0, 0.1f);
    }

    protected final SizeAndScale getSizeAndScale() {
        return this.m_sizeAndScale;
    }

    final void connect(Scrollable drawArea, DrawScalableContentFigure<N, C> contentFigure) {
        assert (drawArea != null) : "Parameter 'drawArea' of method 'connect' must not be null";
        assert (contentFigure != null) : "Parameter 'contentFigure' of method 'connect' must not be null";
        this.m_drawArea = drawArea;
        this.m_contentFigure = contentFigure;
        this.m_contentFigure.connectLayoutManager(this);
    }

    final void setNeedsLayout() {
        if (!this.m_needsLayout) {
            this.m_needsLayout = true;
            this.m_needsPreferredSizeCalculation = true;
            this.invalidate();
        }
    }

    protected abstract void calculateSizeAndScale(List<DrawNodeFigure<N>> var1, List<DrawConnectionFigure<C>> var2, SizeAndScale var3, DrawCache var4);

    protected abstract void layout(List<DrawNodeFigure<N>> var1, List<DrawConnectionFigure<C>> var2, DrawCache var3);

    @Override
    protected final Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        if (!this.m_needsPreferredSizeCalculation) {
            assert (this.m_sizeAndScale != null) : "'m_sizeAndScale' of method 'calculatePreferredSize' must not be null";
            return this.m_sizeAndScale.getSize();
        }
        StrictPair<List<DrawNodeFigure<N>>, List<DrawConnectionFigure<C>>> figures = this.m_contentFigure.getNodeAndConnectionFigures();
        if (((List)figures.getFirst()).isEmpty()) {
            this.m_sizeAndScale.setSize(new Dimension());
            return this.m_sizeAndScale.getSize();
        }
        Rectangle clientArea = this.m_drawArea.getClientArea();
        this.m_sizeAndScale.setAvailableSize(new Dimension(clientArea.width, clientArea.height));
        this.m_cache = new DrawCache();
        this.calculateSizeAndScale((List)figures.getFirst(), (List)figures.getSecond(), this.m_sizeAndScale, this.m_cache);
        this.m_needsPreferredSizeCalculation = false;
        this.m_contentFigure.setScale(this.m_sizeAndScale.getScale());
        Dimension newSize = this.m_sizeAndScale.getSize();
        this.m_contentFigure.setPreferredSize(newSize);
        return newSize;
    }

    @Override
    public final void layout(IFigure container) {
        assert (container != null) : "Parameter 'container' of method 'layout' must not be null";
        if (!this.m_needsLayout) {
            this.m_cache = null;
            return;
        }
        StrictPair<List<DrawNodeFigure<N>>, List<DrawConnectionFigure<C>>> figures = this.m_contentFigure.getNodeAndConnectionFigures();
        if (((List)figures.getFirst()).isEmpty()) {
            this.m_cache = null;
            return;
        }
        assert (!this.m_needsPreferredSizeCalculation) : "Preferred size not calculated";
        this.layout((List)figures.getFirst(), (List)figures.getSecond(), this.m_cache);
        this.m_needsLayout = false;
        this.m_cache = null;
    }

    protected boolean needsLayoutOnZoom() {
        return false;
    }

    protected boolean needsLayoutOnResize() {
        return false;
    }

    final void forceUpdate() {
        this.setNeedsLayout();
        this.getPreferredSize(this.m_contentFigure.getFigureToLayout(), -1, -1);
        this.layout(this.m_contentFigure.getFigureToLayout());
    }

    final boolean isResetZoomPossible() {
        return this.m_contentFigure.getScale() != 1.0;
    }

    final void resetZoom() {
        this.m_contentFigure.setScale(1.0);
        this.m_sizeAndScale.setScale(1.0);
    }

    final boolean zoomInPossible() {
        double newScale = Math.min(this.m_contentFigure.getScale() + this.m_sizeAndScale.getScaleStep(), Double.MAX_VALUE);
        return newScale > this.m_contentFigure.getScale();
    }

    final void zoomIn() {
        double newScale = Math.min(this.m_contentFigure.getScale() + this.m_sizeAndScale.getScaleStep(), Double.MAX_VALUE);
        this.m_contentFigure.setScale(newScale);
        this.m_sizeAndScale.setScale(newScale);
        if (this.needsLayoutOnZoom()) {
            this.forceUpdate();
        }
    }

    final boolean zoomOutPossible() {
        double newScale = Math.max(this.m_contentFigure.getScale() - this.m_sizeAndScale.getScaleStep(), this.m_sizeAndScale.getMinScale());
        return newScale < this.m_contentFigure.getScale();
    }

    final void zoomOut() {
        double newScale = Math.max(this.m_contentFigure.getScale() - this.m_sizeAndScale.getScaleStep(), this.m_sizeAndScale.getMinScale());
        this.m_contentFigure.setScale(newScale);
        this.m_sizeAndScale.setScale(newScale);
        if (this.needsLayoutOnZoom()) {
            this.forceUpdate();
        }
    }

    final boolean drawAreaResized() {
        if (this.needsLayoutOnResize()) {
            this.forceUpdate();
            return true;
        }
        return false;
    }

    final void setScale(double scale) {
        this.m_contentFigure.setScale(scale);
        this.m_sizeAndScale.setScale(scale);
        if (this.needsLayoutOnZoom()) {
            this.forceUpdate();
        }
    }

    final double getScale() {
        return this.m_sizeAndScale.getScale();
    }

    protected final double getMinScale() {
        return this.m_sizeAndScale.getMinScale();
    }

    public int getFullWidth() {
        return this.getSizeAndScale().getSize().width();
    }

    public static final class SizeAndScale {
        private final double m_minScale;
        private final double m_scaleStep;
        private Dimension m_size = new Dimension();
        private double m_scale = 1.0;
        private Dimension m_availableSize;

        SizeAndScale(double minScale, double scaleStep) {
            this.m_minScale = minScale;
            this.m_scaleStep = scaleStep;
        }

        public void setSize(Dimension size) {
            assert (size != null) : "Parameter 'size' of method 'setSize' must not be null";
            assert (size.width >= 0 && size.height() >= 0) : "Invalid size: " + String.valueOf(size);
            this.m_size = size;
        }

        public Dimension getSize() {
            return new Dimension(this.m_size);
        }

        public void setScale(double scale) {
            assert (scale >= this.m_minScale && scale <= Double.MAX_VALUE) : "Invalid scale: " + scale;
            this.m_scale = scale;
        }

        public double getMinScale() {
            return this.m_minScale;
        }

        public double getScaleStep() {
            return this.m_scaleStep;
        }

        public double getScale() {
            return this.m_scale;
        }

        void setAvailableSize(Dimension size) {
            assert (size != null) : "Parameter 'size' of method 'setAvailableSize' must not be null";
            this.m_availableSize = size;
        }

        public Dimension getAvailableSize() {
            assert (this.m_availableSize != null) : "'m_availableSize' of method 'getAvailableSize' must not be null";
            return this.m_availableSize;
        }

        public String toString() {
            return "SizeAndScale [m_availableSize=" + String.valueOf(this.m_availableSize) + ", m_size=" + String.valueOf(this.m_size) + ", m_scale=" + this.m_scale + "]";
        }
    }
}

