/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.commandhandler;

import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.representation.INodeAndEdgeRepresentationProvider;
import com.hello2morrow.sonargraph.core.model.representation.NodeAndEdgeRepresentation;
import com.hello2morrow.sonargraph.core.model.representation.RepresentationNode;
import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.FocusBasedHandlerWithMenuEntry;
import com.hello2morrow.sonargraph.ui.swt.base.draw2d.DrawableWidget;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.view.RcpUtility;
import com.hello2morrow.sonargraph.ui.swt.base.view.WorkbenchViewSelection;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.DrawableSlaveView;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchState;
import jakarta.inject.Named;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;

public abstract class RemoveFromFocusHandler
extends FocusBasedHandlerWithMenuEntry {
    private List<RepresentationNode> getElementsToRemoveFromFocus(Set<NamedElement> currentMainNodes, List<Element> selectedElements) {
        if (WorkbenchRegistry.getInstance().hasState(WorkbenchState.SOFTWARE_SYSTEM_OPENED)) {
            return ((INodeAndEdgeRepresentationProvider)WorkbenchRegistry.getInstance().getProvider().getSoftwareSystem().getExtension(INodeAndEdgeRepresentationProvider.class)).isRemoveFromFocusPossible(currentMainNodes, selectedElements);
        }
        return Collections.emptyList();
    }

    @Override
    protected final boolean internalCanExecute(IEclipseContext eclipseContext, MMenuItem menuItem, WorkbenchViewSelection selection) {
        assert (selection != null) : "Parameter 'selection' of method 'internalCanExecute' must not be null";
        IWorkbenchView workbenchView = selection.getWorkbenchView();
        if (workbenchView instanceof DrawableSlaveView && workbenchView.getViewId() == this.getSupportedViewId()) {
            DrawableSlaveView view = (DrawableSlaveView)workbenchView;
            DrawableWidget drawableWidget = view.getDrawableWidget();
            assert (drawableWidget != null) : "Parameter 'drawableWidget' of method 'internalCanExecute' must not be null";
            NodeAndEdgeRepresentation underlyingRepresentation = drawableWidget.getUnderlyingRepresentation();
            return !this.getElementsToRemoveFromFocus(underlyingRepresentation.getMainNodes(), selection.getElements()).isEmpty();
        }
        return false;
    }

    @Execute
    public final void execute(@Named(value="org.eclipse.ui.selection") WorkbenchViewSelection selection, MPart part) {
        assert (selection != null && !selection.isEmpty()) : "Parameter 'selection' of method 'execute' must not be empty";
        DrawableSlaveView view = RcpUtility.getWorkbenchView(part, DrawableSlaveView.class);
        assert (view != null) : "'view' of method 'execute' must not be null";
        view.removeFromFocus(selection.getElements());
    }
}

