/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.commandhandler;

import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.representation.INodeAndEdgeRepresentationProvider;
import com.hello2morrow.sonargraph.core.model.representation.RepresentationNode;
import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.FocusBasedHandlerWithMenuEntry;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.view.RcpUtility;
import com.hello2morrow.sonargraph.ui.swt.base.view.WorkbenchViewSelection;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.DrawableSlaveView;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchState;
import jakarta.inject.Named;
import java.util.Collections;
import java.util.List;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;

public abstract class ExtendFocusHandler
extends FocusBasedHandlerWithMenuEntry {
    private List<RepresentationNode> getElementsToExtendFocus(List<Element> selectedElements) {
        if (WorkbenchRegistry.getInstance().hasState(WorkbenchState.SOFTWARE_SYSTEM_OPENED)) {
            return ((INodeAndEdgeRepresentationProvider)WorkbenchRegistry.getInstance().getProvider().getSoftwareSystem().getExtension(INodeAndEdgeRepresentationProvider.class)).isExtendFocusPossible(selectedElements);
        }
        return Collections.emptyList();
    }

    @Override
    protected final boolean internalCanExecute(IEclipseContext eclipseContext, MMenuItem menuItem, WorkbenchViewSelection selection) {
        assert (selection != null) : "Parameter 'selection' of method 'internalCanExecute' must not be null";
        IWorkbenchView workbenchView = selection.getWorkbenchView();
        if (workbenchView instanceof DrawableSlaveView && workbenchView.getViewId() == this.getSupportedViewId()) {
            return !this.getElementsToExtendFocus(selection.getElements()).isEmpty();
        }
        return false;
    }

    @Execute
    public final void execute(@Named(value="org.eclipse.ui.selection") WorkbenchViewSelection selection, MPart part) {
        assert (selection != null && !selection.isEmpty()) : "Parameter 'selection' of method 'execute' must not be empty";
        DrawableSlaveView view = RcpUtility.getWorkbenchView(part, DrawableSlaveView.class);
        assert (view != null) : "'view' of method 'execute' must not be null";
        view.extendFocus(selection.getElements(), this.onlyVisible());
    }

    protected abstract boolean onlyVisible();
}

