/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base;

import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.foundation.utilities.Platform;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public abstract class ValidatingWidget
extends Composite {
    private ControlDecoration m_decoration;
    private boolean m_isValid = false;

    public ValidatingWidget(Composite parent) {
        super(parent, 0);
        assert (parent != null) : "Parameter 'parent' of method 'ValidatingPathWidget' must not be null";
    }

    public boolean isValid() {
        return this.m_isValid;
    }

    protected final String getDecorationDescriptionText(ValidationResult result) {
        assert (result != null) : "Parameter 'result' of method 'getDecorationTooltip' must not be null";
        return result.toFormattedString();
    }

    protected final void finishUpdateDecoration() {
        Shell shell;
        if (Platform.isMac() && (shell = this.getShell()) != null && !shell.isDisposed()) {
            shell.setBounds(shell.getBounds());
            shell.layout(true, true);
        }
    }

    protected void updateDecoration(Control control, ValidationResult result) {
        String decorationDescriptionText = this.getDecorationDescriptionText(result);
        this.m_isValid = result.isSuccess();
        if (decorationDescriptionText != null) {
            if (control != null) {
                if (this.m_decoration == null) {
                    this.m_decoration = new ControlDecoration(control, 16512);
                }
                if (result.isSuccess()) {
                    this.m_decoration.setImage(UiResourceManager.getInstance().getImage("WarningMarker"));
                } else {
                    this.m_decoration.setImage(UiResourceManager.getInstance().getImage("ErrorMarker"));
                }
                this.m_decoration.setDescriptionText(decorationDescriptionText);
                this.m_decoration.show();
            }
        } else {
            this.clearDecoration(control);
        }
        this.finishUpdateDecoration();
    }

    protected final void clearDecoration(Control control) {
        if (control != null && this.m_decoration != null) {
            this.m_decoration.setDescriptionText("");
            this.m_decoration.hide();
        }
    }
}

