/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base;

import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PreferencesUtility {
    private static final Logger LOGGER = LoggerFactory.getLogger(PreferencesUtility.class);

    private PreferencesUtility() {
    }

    public static final IEclipsePreferences getPreferences(String id) {
        assert (id != null && id.length() > 0) : "Parameter 'id' of method 'getPreferences' must not be empty";
        return InstanceScope.INSTANCE.getNode(id);
    }

    public static final IEclipsePreferences getPreferences(String bundleId, String id) {
        assert (bundleId != null && bundleId.length() > 0) : "Parameter 'bundleId' of method 'getPreferences' must not be empty";
        assert (id != null && id.length() > 0) : "Parameter 'id' of method 'getPreferences' must not be empty";
        return InstanceScope.INSTANCE.getNode(bundleId + "." + id);
    }

    public static final IEclipsePreferences getPreferences(String bundleId, IDialogId dialogId) {
        assert (bundleId != null && bundleId.length() > 0) : "Parameter 'bundleId' of method 'getPreferences' must not be empty";
        assert (dialogId != null) : "Parameter 'dialogId' of method 'getDialogSettings' must not be null";
        return PreferencesUtility.getPreferences(bundleId, StringUtility.firstCharacterCase((String)dialogId.getStandardName(), (boolean)true));
    }

    public static void save(IEclipsePreferences preferences) {
        assert (preferences != null) : "Parameter 'preferences' of method 'save' must not be null";
        try {
            preferences.flush();
        }
        catch (Exception e) {
            LOGGER.warn("Unable to save preferences", (Throwable)e);
        }
    }

    public static void put(String baseKey, List<String> values, IEclipsePreferences preferences) {
        assert (baseKey != null && baseKey.length() > 0) : "Parameter 'baseKey' of method 'put' must not be empty";
        assert (values != null) : "Parameter 'values' of method 'put' must not be null";
        assert (preferences != null) : "Parameter 'preferences' of method 'put' must not be null";
        int i = 0;
        while (i < values.size()) {
            preferences.put(baseKey + "_" + i, values.get(i));
            ++i;
        }
    }

    public static List<String> get(String baseKey, IEclipsePreferences preferences) {
        assert (baseKey != null && baseKey.length() > 0) : "Parameter 'baseKey' of method 'get' must not be empty";
        assert (preferences != null) : "Parameter 'preferences' of method 'get' must not be null";
        ArrayList<String> values = new ArrayList<String>();
        int i = 0;
        String nextValue = null;
        do {
            if ((nextValue = preferences.get(baseKey + "_" + i, null)) == null) continue;
            values.add(nextValue);
            ++i;
        } while (nextValue != null);
        return values;
    }
}

