/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public final class DecoratingImageDescriptor
extends CompositeImageDescriptor {
    private final ImageDescriptor m_imageDescriptor;
    private ImageDescriptor m_imageDescriptorBackground;
    private ImageDescriptor m_markerUpperLeft;
    private ImageDescriptor m_markerUpperRight;
    private ImageDescriptor m_markerLowerRight;
    private ImageDescriptor m_markerLowerLeft;

    DecoratingImageDescriptor(ImageDescriptor imageDescriptor) {
        assert (imageDescriptor != null) : "'imageDescriptor' must not be null";
        this.m_imageDescriptor = imageDescriptor;
    }

    void setBackground(ImageDescriptor imageDescriptor) {
        assert (imageDescriptor != null) : "Parameter 'imageDescriptor' of method 'setBackground' must not be null";
        this.m_imageDescriptorBackground = imageDescriptor;
    }

    void addMarker(ImageDescriptor marker, Corner corner) {
        assert (marker != null) : "'corner' must not be null";
        switch (corner) {
            case UPPER_LEFT: {
                this.m_markerUpperLeft = marker;
                break;
            }
            case UPPER_RIGHT: {
                this.m_markerUpperRight = marker;
                break;
            }
            case LOWER_RIGHT: {
                this.m_markerLowerRight = marker;
                break;
            }
            case LOWER_LEFT: {
                this.m_markerLowerLeft = marker;
                break;
            }
            default: {
                assert (false) : "Unhandled 'corner': " + String.valueOf((Object)corner);
                break;
            }
        }
    }

    protected void drawCompositeImage(int width, int height) {
        int markerHeight;
        assert (height >= 0) : "'height' must not be negative";
        if (this.m_imageDescriptorBackground != null) {
            this.drawImage(this.m_imageDescriptorBackground.getImageData(), 0, 0);
        }
        this.drawImage(this.m_imageDescriptor.getImageData(), 0, 0);
        if (this.m_markerUpperLeft != null) {
            this.drawImage(this.m_markerUpperLeft.getImageData(), 0, 0);
        }
        if (this.m_markerUpperRight != null) {
            int markerWidth = this.m_markerUpperRight.getImageData().width;
            this.drawImage(this.m_markerUpperRight.getImageData(), width - markerWidth, 0);
        }
        if (this.m_markerLowerRight != null) {
            markerHeight = this.m_markerLowerRight.getImageData().height;
            int markerWidth = this.m_markerLowerRight.getImageData().width;
            this.drawImage(this.m_markerLowerRight.getImageData(), width - markerWidth, height - markerHeight);
        }
        if (this.m_markerLowerLeft != null) {
            markerHeight = this.m_markerLowerLeft.getImageData().height;
            this.drawImage(this.m_markerLowerLeft.getImageData(), 0, height - markerHeight);
        }
    }

    protected Point getSize() {
        ImageData image = this.m_imageDescriptor.getImageData();
        return new Point(image.width, image.height);
    }

    public static enum Corner {
        UPPER_LEFT,
        UPPER_RIGHT,
        LOWER_LEFT,
        LOWER_RIGHT;

    }
}

