/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.draw2d;

import com.hello2morrow.draw2d.EventDispatcher;
import com.hello2morrow.draw2d.Figure;
import com.hello2morrow.draw2d.FocusEvent;
import com.hello2morrow.draw2d.FocusTraverseManager;
import com.hello2morrow.draw2d.IFigure;
import com.hello2morrow.draw2d.KeyEvent;
import com.hello2morrow.draw2d.MouseEvent;
import com.hello2morrow.draw2d.ToolTipHelper;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;

public class SWTEventDispatcher
extends EventDispatcher {
    protected static final int ANY_BUTTON = SWT.BUTTON_MASK;
    private boolean figureTraverse = true;
    private boolean captured;
    private IFigure root;
    private IFigure mouseTarget;
    private IFigure cursorTarget;
    private IFigure focusOwner;
    private IFigure hoverSource;
    private MouseEvent currentEvent;
    private Cursor cursor;
    protected Control control;
    private ToolTipHelper toolTipHelper;
    private FocusTraverseManager focusManager = new FocusTraverseManager();

    @Override
    public void dispatchFocusGained(org.eclipse.swt.events.FocusEvent e) {
        IFigure currentFocusOwner = this.getFocusTraverseManager().getCurrentFocusOwner();
        if (currentFocusOwner == null) {
            currentFocusOwner = this.getFocusTraverseManager().getNextFocusableFigure(this.root, this.focusOwner);
        }
        this.setFocus(currentFocusOwner);
    }

    @Override
    public void dispatchFocusLost(org.eclipse.swt.events.FocusEvent e) {
        this.setFocus(null);
    }

    @Override
    public void dispatchKeyPressed(org.eclipse.swt.events.KeyEvent e) {
        if (this.focusOwner != null) {
            KeyEvent event = new KeyEvent((EventDispatcher)this, this.focusOwner, e);
            this.focusOwner.handleKeyPressed(event);
        }
    }

    @Override
    public void dispatchKeyReleased(org.eclipse.swt.events.KeyEvent e) {
        if (this.focusOwner != null) {
            KeyEvent event = new KeyEvent((EventDispatcher)this, this.focusOwner, e);
            this.focusOwner.handleKeyReleased(event);
        }
    }

    @Override
    public void dispatchKeyTraversed(TraverseEvent e) {
        if (!this.figureTraverse) {
            return;
        }
        IFigure nextFigure = null;
        if (e.detail == 16) {
            nextFigure = this.getFocusTraverseManager().getNextFocusableFigure(this.root, this.focusOwner);
        } else if (e.detail == 8) {
            nextFigure = this.getFocusTraverseManager().getPreviousFocusableFigure(this.root, this.focusOwner);
        }
        if (nextFigure != null) {
            e.doit = false;
            this.setFocus(nextFigure);
        }
    }

    @Override
    public void dispatchMouseHover(org.eclipse.swt.events.MouseEvent me) {
        this.receive(me);
        if (this.mouseTarget != null) {
            this.mouseTarget.handleMouseHover(this.currentEvent);
        }
        if (this.hoverSource != null) {
            this.toolTipHelper = this.getToolTipHelper();
            IFigure tip = this.hoverSource.getToolTip();
            Control control = (Control)me.getSource();
            Point absolute = control.toDisplay(new Point(me.x, me.y));
            this.toolTipHelper.displayToolTipNear(this.hoverSource, tip, absolute.x, absolute.y);
        }
    }

    @Override
    public void dispatchMouseDoubleClicked(org.eclipse.swt.events.MouseEvent me) {
        this.receive(me);
        if (this.mouseTarget != null) {
            this.mouseTarget.handleMouseDoubleClicked(this.currentEvent);
        }
    }

    @Override
    public void dispatchMouseEntered(org.eclipse.swt.events.MouseEvent me) {
        this.receive(me);
    }

    @Override
    public void dispatchMouseExited(org.eclipse.swt.events.MouseEvent me) {
        this.setHoverSource(null, me);
        if (this.mouseTarget != null) {
            this.currentEvent = new MouseEvent((EventDispatcher)this, this.mouseTarget, me);
            this.mouseTarget.handleMouseExited(this.currentEvent);
            this.releaseCapture();
            this.mouseTarget = null;
        }
    }

    @Override
    public void dispatchMousePressed(org.eclipse.swt.events.MouseEvent me) {
        this.receive(me);
        if (this.mouseTarget != null) {
            this.mouseTarget.handleMousePressed(this.currentEvent);
            if (this.currentEvent.isConsumed()) {
                this.setCapture(this.mouseTarget);
            }
        }
    }

    @Override
    public void dispatchMouseMoved(org.eclipse.swt.events.MouseEvent me) {
        this.receive(me);
        if (this.mouseTarget != null) {
            if ((me.stateMask & SWT.BUTTON_MASK) != 0) {
                this.mouseTarget.handleMouseDragged(this.currentEvent);
            } else {
                this.mouseTarget.handleMouseMoved(this.currentEvent);
            }
        }
    }

    @Override
    public void dispatchMouseReleased(org.eclipse.swt.events.MouseEvent me) {
        this.receive(me);
        if (this.mouseTarget != null) {
            this.mouseTarget.handleMouseReleased(this.currentEvent);
        }
        this.releaseCapture();
        this.receive(me);
    }

    @Override
    protected EventDispatcher.AccessibilityDispatcher getAccessibilityDispatcher() {
        return null;
    }

    protected MouseEvent getCurrentEvent() {
        return this.currentEvent;
    }

    private IFigure getCurrentToolTip() {
        if (this.hoverSource != null) {
            return this.hoverSource.getToolTip();
        }
        return null;
    }

    protected IFigure getCursorTarget() {
        return this.cursorTarget;
    }

    protected ToolTipHelper getToolTipHelper() {
        if (this.toolTipHelper == null) {
            this.toolTipHelper = new ToolTipHelper(this.control);
        }
        return this.toolTipHelper;
    }

    protected final FocusTraverseManager getFocusTraverseManager() {
        if (this.focusManager == null) {
            this.focusManager = new FocusTraverseManager();
        }
        return this.focusManager;
    }

    @Override
    public IFigure getFocusOwner() {
        return this.focusOwner;
    }

    protected IFigure getMouseTarget() {
        return this.mouseTarget;
    }

    protected IFigure getRoot() {
        return this.root;
    }

    @Override
    public boolean isCaptured() {
        return this.captured;
    }

    private void receive(org.eclipse.swt.events.MouseEvent me) {
        this.currentEvent = null;
        this.updateFigureUnderCursor(me);
        if (this.captured) {
            if (this.mouseTarget != null) {
                this.currentEvent = new MouseEvent((EventDispatcher)this, this.mouseTarget, me);
            }
        } else {
            IFigure f = this.root.findMouseEventTargetAt(me.x, me.y);
            if (f == this.mouseTarget) {
                if (this.mouseTarget != null) {
                    this.currentEvent = new MouseEvent((EventDispatcher)this, this.mouseTarget, me);
                }
                return;
            }
            if (this.mouseTarget != null) {
                this.currentEvent = new MouseEvent((EventDispatcher)this, this.mouseTarget, me);
                this.mouseTarget.handleMouseExited(this.currentEvent);
            }
            this.setMouseTarget(f);
            if (this.mouseTarget != null) {
                this.currentEvent = new MouseEvent((EventDispatcher)this, this.mouseTarget, me);
                this.mouseTarget.handleMouseEntered(this.currentEvent);
            }
        }
    }

    @Override
    protected void releaseCapture() {
        this.captured = false;
    }

    @Override
    public void requestFocus(IFigure fig) {
        this.setFocus(fig);
    }

    @Override
    public void requestRemoveFocus(IFigure fig) {
        if (this.getFocusOwner() == fig) {
            this.setFocus(null);
        }
        if (this.mouseTarget == fig) {
            this.mouseTarget = null;
        }
        if (this.cursorTarget == fig) {
            this.cursorTarget = null;
        }
        if (this.hoverSource == fig) {
            this.hoverSource = null;
        }
        this.getFocusTraverseManager().setCurrentFocusOwner(null);
    }

    @Override
    protected void setCapture(IFigure figure) {
        this.captured = true;
        this.mouseTarget = figure;
    }

    @Override
    public void setControl(Control c) {
        if (c == this.control) {
            return;
        }
        if (this.control != null && !this.control.isDisposed()) {
            throw new RuntimeException("Can not set control again once it has been set");
        }
        if (c != null) {
            c.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (SWTEventDispatcher.this.toolTipHelper != null) {
                        SWTEventDispatcher.this.toolTipHelper.dispose();
                    }
                }
            });
        }
        this.control = c;
    }

    protected void setCursor(Cursor c) {
        if (c == null && this.cursor == null) {
            return;
        }
        if (c != this.cursor || !c.equals((Object)this.cursor)) {
            this.cursor = c;
            if (this.control != null && !this.control.isDisposed()) {
                this.control.setCursor(c);
            }
        }
    }

    public void setEnableKeyTraversal(boolean traverse) {
        this.figureTraverse = traverse;
    }

    protected void setFigureUnderCursor(IFigure f) {
        if (this.cursorTarget == f) {
            return;
        }
        this.cursorTarget = f;
        this.updateCursor();
    }

    protected void setFocus(IFigure fig) {
        if (fig == this.focusOwner) {
            return;
        }
        FocusEvent fe = new FocusEvent(this.focusOwner, fig);
        IFigure oldOwner = this.focusOwner;
        this.focusOwner = fig;
        if (oldOwner != null) {
            oldOwner.handleFocusLost(fe);
        }
        if (fig != null) {
            this.getFocusTraverseManager().setCurrentFocusOwner(fig);
        }
        if (this.focusOwner != null) {
            this.focusOwner.handleFocusGained(fe);
        }
    }

    protected void setHoverSource(Figure figure, org.eclipse.swt.events.MouseEvent me) {
        this.hoverSource = figure;
        if (figure != null) {
            Control control = (Control)me.getSource();
            Point absolute = control.toDisplay(new Point(me.x, me.y));
            this.toolTipHelper = this.getToolTipHelper();
            this.toolTipHelper.updateToolTip(this.hoverSource, this.getCurrentToolTip(), absolute.x, absolute.y);
        } else if (this.toolTipHelper != null) {
            this.toolTipHelper.updateToolTip(this.hoverSource, this.getCurrentToolTip(), me.x, me.y);
        }
    }

    protected void setMouseTarget(IFigure figure) {
        this.mouseTarget = figure;
    }

    @Override
    public void setRoot(IFigure figure) {
        this.root = figure;
    }

    @Override
    protected void updateCursor() {
        Cursor newCursor = null;
        if (this.cursorTarget != null) {
            newCursor = this.cursorTarget.getCursor();
        }
        this.setCursor(newCursor);
    }

    protected void updateFigureUnderCursor(org.eclipse.swt.events.MouseEvent me) {
        if (!this.captured) {
            IFigure f = this.root.findFigureAt(me.x, me.y);
            this.setFigureUnderCursor(f);
            if (this.cursorTarget != this.hoverSource) {
                this.updateHoverSource(me);
            }
        }
    }

    protected void updateHoverSource(org.eclipse.swt.events.MouseEvent me) {
        if (this.cursorTarget != null) {
            boolean sourceFound = false;
            Figure source = (Figure)this.cursorTarget;
            while (!sourceFound && source.getParent() != null) {
                if (source.getToolTip() != null) {
                    sourceFound = true;
                    continue;
                }
                source = (Figure)source.getParent();
            }
            this.setHoverSource(source, me);
        } else {
            this.setHoverSource(null, me);
        }
    }

    protected class FigureAccessibilityDispatcher
    extends EventDispatcher.AccessibilityDispatcher {
        protected FigureAccessibilityDispatcher() {
        }

        public void getChildAtPoint(AccessibleControlEvent e) {
        }

        public void getChildCount(AccessibleControlEvent e) {
        }

        public void getChildren(AccessibleControlEvent e) {
        }

        public void getDefaultAction(AccessibleControlEvent e) {
        }

        public void getDescription(AccessibleEvent e) {
        }

        public void getFocus(AccessibleControlEvent e) {
        }

        public void getHelp(AccessibleEvent e) {
        }

        public void getKeyboardShortcut(AccessibleEvent e) {
        }

        public void getLocation(AccessibleControlEvent e) {
        }

        public void getName(AccessibleEvent e) {
        }

        public void getRole(AccessibleControlEvent e) {
        }

        public void getSelection(AccessibleControlEvent e) {
        }

        public void getState(AccessibleControlEvent e) {
        }

        public void getValue(AccessibleControlEvent e) {
        }
    }
}

