/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.draw2d;

import com.hello2morrow.draw2d.IFigure;
import com.hello2morrow.draw2d.Point;
import com.hello2morrow.draw2d.Rectangle;
import com.hello2morrow.draw2d.XYLayout;
import java.util.ListIterator;

public class FreeformLayout
extends XYLayout {
    private static final int FLAG__POSITIVE_COORDINATES = 1;
    private int flags;
    private Point origin = null;

    @Override
    public Point getOrigin(IFigure figure) {
        if (this.origin == null) {
            this.origin = new Point();
            if (this.isPositiveCoordinates()) {
                ListIterator children = figure.getChildren().listIterator();
                while (children.hasNext()) {
                    IFigure f = (IFigure)children.next();
                    Rectangle constraint = (Rectangle)this.getConstraint(f);
                    if (constraint == null) continue;
                    this.origin.x = Math.min(this.origin.x, constraint.x);
                    this.origin.y = Math.min(this.origin.y, constraint.y);
                }
                this.origin.negate();
            }
        }
        return this.origin;
    }

    public boolean isPositiveCoordinates() {
        return (this.flags & 1) != 0;
    }

    public void setPositiveCoordinates(boolean positiveCoordinates) {
        if (positiveCoordinates != this.isPositiveCoordinates()) {
            this.flags = positiveCoordinates ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
            this.invalidate();
        }
    }

    @Override
    public void invalidate() {
        this.origin = null;
        super.invalidate();
    }
}

