/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.draw2d;

import com.hello2morrow.draw2d.Dimension;
import com.hello2morrow.draw2d.IFigure;
import com.hello2morrow.draw2d.OrderedLayout;
import com.hello2morrow.draw2d.Rectangle;
import java.util.Iterator;
import java.util.List;

public class FlowLayout
extends OrderedLayout {
    public static final int ALIGN_LEFTTOP = 1;
    public static final int ALIGN_RIGHTBOTTOM = 2;
    protected WorkingData data = null;
    protected boolean fill;
    protected int majorAlignment = 1;
    protected int majorSpacing = 5;
    protected int minorSpacing = 5;

    public FlowLayout() {
        this.setStretchMinorAxis(false);
    }

    public FlowLayout(boolean isHorizontal) {
        this.setHorizontal(isHorizontal);
        this.setStretchMinorAxis(false);
    }

    @Override
    protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        int maxWidth;
        if (wHint > -1) {
            wHint = Math.max(0, wHint - container.getInsets().getWidth());
        }
        if (hHint > -1) {
            hHint = Math.max(0, hHint - container.getInsets().getHeight());
        }
        if (this.isHorizontal()) {
            maxWidth = wHint;
            hHint = -1;
        } else {
            maxWidth = hHint;
            wHint = -1;
        }
        if (maxWidth < 0) {
            maxWidth = Integer.MAX_VALUE;
        }
        Dimension prefSize = new Dimension();
        List children = container.getChildren();
        int width = 0;
        int height = 0;
        int i = 0;
        while (i < children.size()) {
            IFigure child = (IFigure)children.get(i);
            Dimension childSize = this.transposer.t(this.getChildSize(child, wHint, hHint));
            if (i == 0) {
                width = childSize.width;
                height = childSize.height;
            } else if (width + childSize.width + this.getMinorSpacing() > maxWidth) {
                prefSize.height += height + this.getMajorSpacing();
                prefSize.width = Math.max(prefSize.width, width);
                width = childSize.width;
                height = childSize.height;
            } else {
                width += childSize.width + this.getMinorSpacing();
                height = Math.max(height, childSize.height);
            }
            ++i;
        }
        prefSize.height += height;
        prefSize.width = Math.max(prefSize.width, width);
        prefSize = this.transposer.t(prefSize);
        prefSize.width += container.getInsets().getWidth();
        prefSize.height += container.getInsets().getHeight();
        prefSize.union(this.getBorderPreferredSize(container));
        return prefSize;
    }

    protected Dimension getChildSize(IFigure child, int wHint, int hHint) {
        return child.getPreferredSize(wHint, hHint);
    }

    @Override
    protected int getDefaultOrientation() {
        return 64;
    }

    public int getMajorAlignment() {
        return this.majorAlignment;
    }

    public int getMajorSpacing() {
        return this.majorSpacing;
    }

    public int getMinorSpacing() {
        return this.minorSpacing;
    }

    protected void initRow() {
        this.data.rowX = 0;
        this.data.rowHeight = 0;
        this.data.rowWidth = 0;
        this.data.rowCount = 0;
    }

    protected void initVariables(IFigure parent) {
        this.data.row = new IFigure[parent.getChildren().size()];
        this.data.bounds = new Rectangle[this.data.row.length];
        this.data.maxWidth = this.data.area.width;
    }

    @Override
    protected boolean isSensitiveHorizontally(IFigure parent) {
        return this.isHorizontal();
    }

    @Override
    protected boolean isSensitiveVertically(IFigure parent) {
        return !this.isHorizontal();
    }

    @Override
    public boolean isStretchMinorAxis() {
        return this.fill;
    }

    @Override
    public void layout(IFigure parent) {
        this.data = new WorkingData();
        Rectangle relativeArea = parent.getClientArea();
        this.data.area = this.transposer.t(relativeArea);
        Iterator iterator = parent.getChildren().iterator();
        int wHint = -1;
        int hHint = -1;
        if (this.isHorizontal()) {
            wHint = parent.getClientArea().width;
        } else {
            hHint = parent.getClientArea().height;
        }
        this.initVariables(parent);
        this.initRow();
        while (iterator.hasNext()) {
            IFigure f = (IFigure)iterator.next();
            Dimension pref = this.transposer.t(this.getChildSize(f, wHint, hHint));
            Rectangle r = new Rectangle(0, 0, pref.width, pref.height);
            if (this.data.rowCount > 0 && this.data.rowWidth + pref.width > this.data.maxWidth) {
                this.layoutRow(parent);
            }
            r.x = this.data.rowX;
            r.y = this.data.rowY;
            int dx = r.width + this.getMinorSpacing();
            this.data.rowX += dx;
            this.data.rowWidth += dx;
            this.data.rowHeight = Math.max(this.data.rowHeight, r.height);
            this.data.row[this.data.rowCount] = f;
            this.data.bounds[this.data.rowCount] = r;
            ++this.data.rowCount;
        }
        if (this.data.rowCount != 0) {
            this.layoutRow(parent);
        }
        this.data = null;
    }

    protected void layoutRow(IFigure parent) {
        int majorAdjustment = 0;
        int minorAdjustment = 0;
        int correctMajorAlignment = this.getMajorAlignment();
        int correctMinorAlignment = this.getMinorAlignment();
        majorAdjustment = this.data.area.width - this.data.rowWidth + this.getMinorSpacing();
        switch (correctMajorAlignment) {
            case 1: {
                majorAdjustment = 0;
                break;
            }
            case 0: {
                majorAdjustment /= 2;
                break;
            }
        }
        int j = 0;
        while (j < this.data.rowCount) {
            if (this.isStretchMinorAxis()) {
                this.data.bounds[j].height = this.data.rowHeight;
            } else {
                minorAdjustment = this.data.rowHeight - this.data.bounds[j].height;
                switch (correctMinorAlignment) {
                    case 1: {
                        minorAdjustment = 0;
                        break;
                    }
                    case 0: {
                        minorAdjustment /= 2;
                        break;
                    }
                }
                this.data.bounds[j].y += minorAdjustment;
            }
            this.data.bounds[j].x += majorAdjustment;
            this.setBoundsOfChild(parent, this.data.row[j], this.transposer.t(this.data.bounds[j]));
            ++j;
        }
        this.data.rowY += this.getMajorSpacing() + this.data.rowHeight;
        this.initRow();
    }

    protected void setBoundsOfChild(IFigure parent, IFigure child, Rectangle bounds) {
        parent.getClientArea(Rectangle.SINGLETON);
        bounds.translate(Rectangle.SINGLETON.x, Rectangle.SINGLETON.y);
        child.setBounds(bounds);
    }

    public void setMajorAlignment(int align) {
        this.majorAlignment = align;
    }

    public void setMajorSpacing(int n) {
        this.majorSpacing = n;
    }

    public void setMinorSpacing(int n) {
        this.minorSpacing = n;
    }

    @Override
    public void setStretchMinorAxis(boolean value) {
        this.fill = value;
    }

    protected class WorkingData {
        public Rectangle[] bounds;
        public Rectangle area;
        public IFigure[] row;
        public int rowHeight;
        public int rowWidth;
        public int rowCount;
        public int rowX;
        public int rowY;
        public int maxWidth;

        protected WorkingData() {
        }
    }
}

