/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.draw2d;

import com.hello2morrow.draw2d.AbstractConnectionAnchor;
import com.hello2morrow.draw2d.IFigure;
import com.hello2morrow.draw2d.Point;
import com.hello2morrow.draw2d.Rectangle;

public class EllipseAnchor
extends AbstractConnectionAnchor {
    public EllipseAnchor() {
    }

    public EllipseAnchor(IFigure owner) {
        super(owner);
    }

    @Override
    public Point getLocation(Point reference) {
        Rectangle r = Rectangle.SINGLETON;
        r.setBounds(this.getOwner().getBounds());
        r.translate(-1, -1);
        r.resize(1, 1);
        this.getOwner().translateToAbsolute(r);
        Point ref = r.getCenter().negate().translate(reference);
        if (ref.x == 0) {
            return new Point(reference.x, ref.y > 0 ? r.bottom() : r.y);
        }
        if (ref.y == 0) {
            return new Point(ref.x > 0 ? r.right() : r.x, reference.y);
        }
        float dx = ref.x > 0 ? 0.5f : -0.5f;
        float dy = ref.y > 0 ? 0.5f : -0.5f;
        float k = (float)(ref.y * r.width) / (float)(ref.x * r.height);
        k *= k;
        return r.getCenter().translate((int)((double)((float)r.width * dx) / Math.sqrt(1.0f + k)), (int)((double)((float)r.height * dy) / Math.sqrt(1.0f + 1.0f / k)));
    }

    public boolean equals(Object o) {
        if (o instanceof EllipseAnchor) {
            EllipseAnchor other = (EllipseAnchor)o;
            return other.getOwner() == this.getOwner();
        }
        return false;
    }

    public int hashCode() {
        if (this.getOwner() != null) {
            return this.getOwner().hashCode();
        }
        return super.hashCode();
    }
}

