/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.workspaceview;

import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.model.filter.Filter;
import com.hello2morrow.sonargraph.core.model.filter.Pattern;
import com.hello2morrow.sonargraph.core.model.filter.PatternType;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.NameAndDescriptionWizardPage;
import com.hello2morrow.sonargraph.ui.standalone.workspaceview.WorkspacePatternWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.NonLazySonargraphWizard;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.SonargraphWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;

public abstract class FilterPatternWizard
extends NonLazySonargraphWizard {
    private final PatternType m_type;
    private final Filter m_filterToBeEdited;
    private final Pattern m_patternToBeEdited;
    private NameAndDescriptionWizardPage m_page;

    private static String getInfo(PatternType type) {
        assert (type != null) : "Parameter 'type' of method 'getInfo' must not be null";
        return type.getPresentationName();
    }

    private static String getInfo(Pattern pattern) {
        assert (pattern != null) : "Parameter 'pattern' of method 'getInfo' must not be null";
        return pattern.getType().getPresentationName();
    }

    public FilterPatternWizard(PatternType type, Filter filter) {
        super("New " + FilterPatternWizard.getInfo(type) + " Pattern");
        assert (type != null) : "Parameter 'type' of method 'FilterPatternWizard' must not be null";
        assert (filter != null) : "Parameter 'filter' of method 'WorkspacePatternWizard' must not be null";
        this.m_type = type;
        this.m_filterToBeEdited = filter;
        this.m_patternToBeEdited = null;
    }

    public FilterPatternWizard(Pattern pattern) {
        super("Edit " + FilterPatternWizard.getInfo(pattern) + " Pattern");
        assert (pattern != null) : "Parameter 'pattern' of method 'WorkspacePatternWizard' must not be null";
        this.m_type = pattern.getType();
        this.m_patternToBeEdited = pattern;
        this.m_filterToBeEdited = (Filter)pattern.getParent(Filter.class, new Class[0]);
        assert (this.m_filterToBeEdited != null) : "Parameter 'm_filterToBeEdited' of method 'WorkspacePatternWizard' must not be null";
    }

    protected final Filter getFilterToBeEdited() {
        return this.m_filterToBeEdited;
    }

    protected final Pattern getPatternToBeEdited() {
        return this.m_patternToBeEdited;
    }

    protected final PatternType getType() {
        return this.m_type;
    }

    protected abstract ITextValidator getPatternValidator();

    public final void addPages() {
        assert (WorkbenchRegistry.getInstance().getProvider().hasSoftwareSystem()) : "No system available";
        this.m_page = new WorkspacePatternWizardPage("PAGE_1", (this.getPatternToBeEdited() == null ? "New " : "Edit ") + FilterPatternWizard.getInfo(this.m_type) + " Pattern", "Pattern:", this.getPatternValidator(), this.getPatternToBeEdited() != null ? this.getPatternToBeEdited().getName() : null);
        this.addPage((SonargraphWizardPage)this.m_page);
    }

    protected final String getPattern() {
        return this.m_page.getElementName();
    }
}

