/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.wizards;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.system.resolution.CreateOrEditPatternBasedCycleIgnoreFilterCommand;
import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.NameValidator;
import com.hello2morrow.sonargraph.core.model.resolution.CycleGroupKind;
import com.hello2morrow.sonargraph.core.model.resolution.IgnoreDefinition;
import com.hello2morrow.sonargraph.core.model.resolution.PatternBasedCycleIgnoreFilter;
import com.hello2morrow.sonargraph.core.model.resolution.PatternBasedCycleIgnoreFilterData;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.ui.standalone.wizards.NameAndDescriptionAndCycleKindWizardPage;
import com.hello2morrow.sonargraph.ui.standalone.wizards.PatternWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.NonLazySonargraphWizard;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.SonargraphWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import java.util.ArrayList;

public final class CycleIgnoreWizard
extends NonLazySonargraphWizard {
    private final PatternBasedCycleIgnoreFilter m_filter;
    private NameAndDescriptionAndCycleKindWizardPage m_nameAndDescriptionAndCycleKindPage;
    private PatternWizardPage m_patternPage;

    public CycleIgnoreWizard(ISoftwareSystemProvider provider, PatternBasedCycleIgnoreFilter filter) {
        super("Ignore Cycle Groups Based On Patterns");
        this.m_filter = filter;
    }

    public void addPages() {
        ArrayList<PatternBasedCycleIgnoreFilterData.Pattern> excludes;
        ArrayList<PatternBasedCycleIgnoreFilterData.Pattern> includes;
        String name = "";
        String description = "";
        CycleGroupKind kind = CycleGroupKind.COMPONENT_CYCLES;
        if (this.m_filter != null) {
            PatternBasedCycleIgnoreFilterData data = this.m_filter.getFilterData();
            name = data.getName();
            description = data.getDescription();
            kind = data.getKind();
            includes = new ArrayList(data.getIncludePatterns());
            excludes = new ArrayList(data.getExcludePatterns());
        } else {
            includes = new ArrayList<PatternBasedCycleIgnoreFilterData.Pattern>();
            excludes = new ArrayList<PatternBasedCycleIgnoreFilterData.Pattern>();
        }
        this.m_nameAndDescriptionAndCycleKindPage = new NameAndDescriptionAndCycleKindWizardPage("PAGE_1", "Specify a name, description and cycle kind for the new cycle filter", "Filter Name:", (ITextValidator)new NameValidator(), name, description, kind);
        this.addPage((SonargraphWizardPage)this.m_nameAndDescriptionAndCycleKindPage);
        this.m_patternPage = new PatternWizardPage("PAGE_2", this.m_nameAndDescriptionAndCycleKindPage, includes, excludes);
        this.addPage((SonargraphWizardPage)this.m_patternPage);
    }

    public boolean performFinish() {
        if (this.canFinish()) {
            CreateOrEditPatternBasedCycleIgnoreFilterCommand cmd = new CreateOrEditPatternBasedCycleIgnoreFilterCommand(WorkbenchRegistry.getInstance().getProvider(), (CreateOrEditPatternBasedCycleIgnoreFilterCommand.IInteraction)new Interaction());
            UserInterfaceAdapter.getInstance().run((Command)cmd);
            return true;
        }
        return false;
    }

    private class Interaction
    implements CreateOrEditPatternBasedCycleIgnoreFilterCommand.IInteraction {
        private Interaction() {
        }

        public boolean collectData(PatternBasedCycleIgnoreFilterData data) {
            data.setName(CycleIgnoreWizard.this.m_nameAndDescriptionAndCycleKindPage.getElementName());
            data.setDescription(CycleIgnoreWizard.this.m_nameAndDescriptionAndCycleKindPage.getElementDescription());
            data.setKind(CycleIgnoreWizard.this.m_nameAndDescriptionAndCycleKindPage.getCycleGroupKind());
            CycleIgnoreWizard.this.m_patternPage.getIncludePatterns().forEach(p -> data.addIncludePattern(p));
            CycleIgnoreWizard.this.m_patternPage.getExcludePatterns().forEach(p -> data.addExcludePattern(p.getPattern()));
            if (CycleIgnoreWizard.this.m_filter != null) {
                data.setIgnoreDefinition((IgnoreDefinition)CycleIgnoreWizard.this.m_filter.getParent(IgnoreDefinition.class, new Class[0]));
            }
            return true;
        }

        public void process(OperationResult result) {
            if (result.isFailure()) {
                UserInterfaceAdapter.getInstance().process(result);
            }
        }
    }
}

