/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.virtualmodelview;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.SetModelCommand;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SonargraphCommand;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.INavigationState;
import com.hello2morrow.sonargraph.core.model.event.ModifiableFileCreatedEvent;
import com.hello2morrow.sonargraph.core.model.event.ModifiableFileDeletedEvent;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.event.MultipleModifiableFileModifiedEvent;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemClosedEvent;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemModifiedEvent;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemOpenedEvent;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemProviderEvent;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.ModifiableModel;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.VirtualModel;
import com.hello2morrow.sonargraph.foundation.event.EventHandler;
import com.hello2morrow.sonargraph.foundation.event.EventManager;
import com.hello2morrow.sonargraph.foundation.file.IPathType;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.ui.standalone.virtualmodelview.ModifiableModelWizard;
import com.hello2morrow.sonargraph.ui.swt.base.CompositeContributionButton;
import com.hello2morrow.sonargraph.ui.swt.base.ISonargraphUIContribution;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.SonargraphWizard;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.SonargraphWizardAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ComboWithImages;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.common.ViewNavigationManager;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.Collection;
import java.util.List;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public final class VirtualModelSelectorWidget
implements ISonargraphUIContribution {
    private ComboWithImages m_combo;
    private CompositeContributionButton m_createModelButton;

    @PostConstruct
    public void createWidget(IEclipseContext eclipseContext, ECommandService commandService, final EHandlerService handlerService, Composite parent) {
        assert (eclipseContext != null) : "Parameter 'eclipseContext' of method 'createWidget' must not be null";
        assert (commandService != null) : "Parameter 'commandService' of method 'createWidget' must not be null";
        assert (handlerService != null) : "Parameter 'handlerService' of method 'createWidget' must not be null";
        assert (parent != null) : "Parameter 'parent' of method 'createWidget' must not be null";
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.marginTop = 0;
        gridLayout.marginBottom = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 2;
        gridLayout.verticalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        this.m_combo = new ComboWithImages(composite, 220, "Select Model", new ComboWithImages.ILabelProvider(){

            public String getToolTipText(Object item) {
                if (!($assertionsDisabled || item != null && item instanceof VirtualModel)) {
                    throw new AssertionError((Object)("Unexpected class in method 'getToolTipText': " + String.valueOf(item)));
                }
                VirtualModel model = (VirtualModel)item;
                if (model instanceof ModifiableModel) {
                    ModifiableModel modifiableModel = (ModifiableModel)model;
                    return modifiableModel.getAbsolutePath();
                }
                return model.getName();
            }

            public String getText(Object item) {
                ModifiableModel modifiableModel;
                if (!($assertionsDisabled || item != null && item instanceof VirtualModel)) {
                    throw new AssertionError((Object)("Unexpected class in method 'getText': " + String.valueOf(item)));
                }
                VirtualModel model = (VirtualModel)item;
                Object text = model.getShortName();
                if (model instanceof ModifiableModel && (modifiableModel = (ModifiableModel)model).needsSave()) {
                    text = (String)text + " (*)";
                }
                return text;
            }

            public Image getImage(Object item) {
                if (!($assertionsDisabled || item != null && item instanceof VirtualModel)) {
                    throw new AssertionError((Object)("Unexpected class in method 'getImage': " + String.valueOf(item)));
                }
                VirtualModel model = (VirtualModel)item;
                return UiResourceManager.getInstance().getImage((Element)model);
            }
        });
        this.m_combo.setLayoutData((Object)new GridData(4, 2, true, false));
        this.m_combo.setSelectionListener(new ComboWithImages.IItemSelectionListener(){

            public void itemSelected(ComboWithImages source, Object item) {
                if (!($assertionsDisabled || item != null && item instanceof VirtualModel)) {
                    throw new AssertionError((Object)("Unexpected class in method 'itemSelected': " + String.valueOf(item)));
                }
                final VirtualModel model = (VirtualModel)item;
                SetModelCommand cmd = new SetModelCommand(WorkbenchRegistry.getInstance().getProvider(), new SetModelCommand.ISetModelInteraction(){

                    public boolean collect(SetModelCommand.SetModelData data) {
                        data.setModel(model);
                        return true;
                    }

                    public INavigationState getNavigationState() {
                        return ViewNavigationManager.getInstance().getCurrentNavigationState();
                    }

                    public void processSetModelResult(OperationResult result) {
                        UserInterfaceAdapter.getInstance().process(result);
                    }
                });
                UserInterfaceAdapter.getInstance().run((Command)cmd);
            }
        });
        this.m_createModelButton = new CompositeContributionButton(composite, UiResourceManager.getInstance().getImage("New"));
        this.m_createModelButton.setEnabled(false);
        this.m_createModelButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.m_createModelButton.setToolTipText("Create and set model");
        this.m_createModelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!$assertionsDisabled && handlerService == null) {
                    throw new AssertionError((Object)"Parameter 'handlerService' of method 'execute' must not be null");
                }
                ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
                if (!$assertionsDisabled && !provider.hasSoftwareSystem()) {
                    throw new AssertionError((Object)"No system available");
                }
                ModifiableModelWizard wizard = new ModifiableModelWizard(provider.getSoftwareSystem().getCurrentModel());
                SonargraphWizardAdapter.createWizardDialog((Shell)WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), (SonargraphWizard)wizard).open();
            }
        });
        this.m_combo.setEnabled(false);
        this.connectEvents();
    }

    private void connectEvents() {
        EventManager.getInstance().attach((EventHandler)new EventHandler<SoftwareSystemOpenedEvent>(SoftwareSystemOpenedEvent.class, (Object)this){

            public void handleEvent(SoftwareSystemOpenedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"'event' must not be null");
                }
                if (WorkbenchRegistry.isRunning()) {
                    VirtualModelSelectorWidget.this.updateAvailableModels((SoftwareSystemProviderEvent)event);
                    SoftwareSystem softwareSystem = event.getProvider().getSoftwareSystem();
                    List availableModels = softwareSystem.getAvailableVirtualModels();
                    VirtualModel selected = softwareSystem.getCurrentModel();
                    if (!$assertionsDisabled && (VirtualModelSelectorWidget.this.m_combo == null || VirtualModelSelectorWidget.this.m_combo.isDisposed())) {
                        throw new AssertionError((Object)"'m_combo' of method 'handleEvent' must not be null and must not be disposed");
                    }
                    VirtualModelSelectorWidget.this.m_combo.setItems((Collection)availableModels, (Object)selected);
                    VirtualModelSelectorWidget.this.m_combo.setEnabled(SonargraphCommand.isAvailable((ICommandId)CoreCommandId.SET_MODEL, (SoftwareSystem)softwareSystem));
                    VirtualModelSelectorWidget.this.m_createModelButton.setEnabled(SonargraphCommand.isAvailable((ICommandId)CoreCommandId.CREATE_MODIFIABLE_MODEL, (SoftwareSystem)softwareSystem));
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<SoftwareSystemModifiedEvent>(SoftwareSystemModifiedEvent.class, (Object)this){

            public void handleEvent(SoftwareSystemModifiedEvent event) {
                SoftwareSystem softwareSystem;
                ISoftwareSystemProvider provider;
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"'event' must not be null");
                }
                if (WorkbenchRegistry.isRunning() && (provider = event.getProvider()).hasSoftwareSystem() && (softwareSystem = provider.getSoftwareSystem()).isValid() && (event.getModification().contains(Modification.VIRTUAL_MODEL_CHANGED) || event.getModification().contains(Modification.AVAILABLE_VIRTUAL_MODELS_MODIFIED) || event.getModification().contains(Modification.VIRTUAL_MODEL_MODIFIED))) {
                    VirtualModelSelectorWidget.this.updateAvailableModels((SoftwareSystemProviderEvent)event);
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<SoftwareSystemClosedEvent>(SoftwareSystemClosedEvent.class, (Object)this){

            public void handleEvent(SoftwareSystemClosedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"'event' must not be null");
                }
                if (WorkbenchRegistry.isRunning()) {
                    VirtualModelSelectorWidget.this.clearCombo();
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<MultipleModifiableFileModifiedEvent>(MultipleModifiableFileModifiedEvent.class, (Object)this){

            public void handleEvent(MultipleModifiableFileModifiedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"'event' must not be null");
                }
                if (WorkbenchRegistry.isRunning() && event.containsPathOfType(new IPathType[]{CoreFileType.MODEL})) {
                    VirtualModelSelectorWidget.this.updateAvailableModels((SoftwareSystemProviderEvent)event);
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<ModifiableFileDeletedEvent>(ModifiableFileDeletedEvent.class, (Object)this){

            public void handleEvent(ModifiableFileDeletedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'handleEvent' must not be null");
                }
                if (WorkbenchRegistry.isRunning() && event.containsPathOfType(new IPathType[]{CoreFileType.MODEL})) {
                    VirtualModelSelectorWidget.this.updateAvailableModels((SoftwareSystemProviderEvent)event);
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<ModifiableFileCreatedEvent>(ModifiableFileCreatedEvent.class, (Object)this){

            public void handleEvent(ModifiableFileCreatedEvent event) {
                if (WorkbenchRegistry.isRunning() && event.containsPathOfType(new IPathType[]{CoreFileType.MODEL})) {
                    VirtualModelSelectorWidget.this.updateAvailableModels((SoftwareSystemProviderEvent)event);
                }
            }
        });
    }

    @PreDestroy
    public void dispose() {
        EventManager.getInstance().detach(SoftwareSystemOpenedEvent.class, (Object)this);
        EventManager.getInstance().detach(SoftwareSystemModifiedEvent.class, (Object)this);
        EventManager.getInstance().detach(SoftwareSystemClosedEvent.class, (Object)this);
        EventManager.getInstance().detach(MultipleModifiableFileModifiedEvent.class, (Object)this);
        EventManager.getInstance().detach(ModifiableFileCreatedEvent.class, (Object)this);
        EventManager.getInstance().detach(ModifiableFileDeletedEvent.class, (Object)this);
    }

    private void clearCombo() {
        if (this.m_combo != null && !this.m_combo.isDisposed()) {
            this.m_combo.setEnabled(false);
            this.m_combo.removeItems();
        }
        if (this.m_createModelButton != null && !this.m_createModelButton.isDisposed()) {
            this.m_createModelButton.setEnabled(false);
        }
    }

    private void updateAvailableModels(SoftwareSystemProviderEvent event) {
        ISoftwareSystemProvider provider = event.getProvider();
        if (provider.hasSoftwareSystem()) {
            if (this.m_combo != null && !this.m_combo.isDisposed()) {
                SoftwareSystem softwareSystem = event.getProvider().getSoftwareSystem();
                List availableModels = softwareSystem.getAvailableVirtualModels();
                VirtualModel selected = softwareSystem.getCurrentModel();
                this.m_combo.setItems((Collection)availableModels, (Object)selected);
                this.m_combo.setEnabled(SonargraphCommand.isAvailable((ICommandId)CoreCommandId.SET_MODEL, (SoftwareSystem)softwareSystem));
                this.m_createModelButton.setEnabled(SonargraphCommand.isAvailable((ICommandId)CoreCommandId.CREATE_MODIFIABLE_MODEL, (SoftwareSystem)softwareSystem));
            }
        } else {
            this.clearCombo();
        }
    }
}

