/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.virtualmodelview;

import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.VirtualModels;
import com.hello2morrow.sonargraph.core.model.system.VirtualModel;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.NameAndDescriptionWizardPage;
import com.hello2morrow.sonargraph.ui.standalone.base.swt.NamedElementViewContentAndLabelProvider;
import com.hello2morrow.sonargraph.ui.standalone.base.workbench.CoreDialogId;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import java.util.Collections;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public final class CreateModifiableModelWizardPage
extends NameAndDescriptionWizardPage
implements ISelectionChangedListener {
    private final VirtualModels m_virtualModels;
    private VirtualModel m_basedOn;
    private CLabel m_model;
    private boolean m_set = true;

    public CreateModifiableModelWizardPage(ITextValidator nameValidator, VirtualModels virtualModels, VirtualModel basedOn) {
        super("CreateModel", "Create Model", "Name", nameValidator, "", "");
        assert (virtualModels != null) : "Parameter 'virtualModels' of method 'CreateModifiableModelWizardPage' must not be null";
        assert (basedOn != null) : "Parameter 'basedOn' of method 'CreateModifiableModelWizardPage' must not be null";
        this.m_virtualModels = virtualModels;
        this.m_basedOn = basedOn;
    }

    protected IDialogId getDialogId() {
        return CoreDialogId.CREATE_MODIFIABLE_MODEL;
    }

    public final void selectionChanged(SelectionChangedEvent event) {
        assert (event != null) : "Parameter 'event' of method 'selectionChanged' must not be null";
        StructuredSelection selection = (StructuredSelection)event.getSelection();
        Object selectedElement = selection.getFirstElement();
        if (selectedElement != null) {
            assert (selectedElement instanceof VirtualModel) : "Unexpected class in method 'selectionChanged': " + String.valueOf(selectedElement);
            this.m_basedOn = (VirtualModel)selectedElement;
            this.m_model.setText(this.m_basedOn.getName());
            this.m_model.setImage(UiResourceManager.getInstance().getImage((Element)this.m_basedOn));
        } else {
            this.m_basedOn = null;
            this.m_model.setText("<<no model selected>>");
            this.m_model.setImage(null);
        }
        this.m_model.getParent().layout(true);
        this.m_model.layout(true);
    }

    @Override
    protected void updatePageCompletion(boolean hasValidData) {
        if (hasValidData) {
            if (this.m_basedOn == null) {
                this.setMessage("A model needs to be selected.", 3);
            } else {
                this.setMessage("");
            }
        }
        super.updatePageCompletion(hasValidData && this.m_basedOn != null);
    }

    @Override
    protected void addWidgetsToDialogAreaAfter(Composite composite) {
        assert (composite != null) : "Parameter 'composite' of method 'addWidgetsToDialogAreaAfter' must not be null";
        Label label = new Label(composite, 0);
        label.setText("Model based on: ");
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 1, 1));
        this.m_model = new CLabel(composite, 0);
        this.m_model.setText(this.m_basedOn.getName());
        this.m_model.setImage(UiResourceManager.getInstance().getImage((Element)this.m_basedOn));
        this.m_model.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        TreeViewer modelView = new TreeViewer(composite, 4);
        modelView.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        NamedElementViewContentAndLabelProvider contentAndLabelProvider = new NamedElementViewContentAndLabelProvider(Collections.singletonList(NamedElement.class), Collections.singletonList(VirtualModel.class));
        modelView.setContentProvider((IContentProvider)contentAndLabelProvider);
        modelView.setLabelProvider((IBaseLabelProvider)contentAndLabelProvider);
        modelView.setInput((Object)this.m_virtualModels);
        modelView.expandAll();
        modelView.setSelection((ISelection)new StructuredSelection((Object)this.m_basedOn));
        modelView.addSelectionChangedListener((ISelectionChangedListener)this);
        Composite checkBoxComposite = new Composite(composite, 0);
        checkBoxComposite.setLayout((Layout)new FillLayout());
        checkBoxComposite.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, false, 3, 1));
        final Button setAsCurrentModel = new Button(checkBoxComposite, 32);
        setAsCurrentModel.setText("Set as current model");
        setAsCurrentModel.setSelection(this.m_set);
        setAsCurrentModel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CreateModifiableModelWizardPage.this.m_set = setAsCurrentModel.getSelection();
            }
        });
        super.addWidgetsToDialogAreaAfter(composite);
    }

    VirtualModel getBasedOn() {
        return this.m_basedOn;
    }

    boolean setModel() {
        return this.m_set;
    }
}

