/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.update;

import com.hello2morrow.sonargraph.foundation.utilities.ExceptionUtility;
import com.hello2morrow.sonargraph.foundation.utilities.Platform;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.dialog.StandardDialog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.e4.ui.workbench.IWorkbench;
import org.eclipse.equinox.p2.operations.ProvisioningJob;
import org.eclipse.equinox.p2.operations.UpdateOperation;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class UpdateExecutionDialog
extends StandardDialog
implements IJobChangeListener,
IProgressMonitor {
    private static final String NO_UPDATE_WITHIN_ECLIPSE = "Updates cannot run from within Eclipse!";
    private static final String DOWNLOAD_INFO = "Downloading the newest version of Sonargraph. This can take a while!";
    private static final String BUTTON_CLOSE = "Close";
    private static final String BUTTON_RESTART = "Restart";
    private static final Logger LOGGER = LoggerFactory.getLogger(UpdateExecutionDialog.class);
    private final IWorkbench m_workbench;
    private final UpdateOperation m_updateOperation;
    private Composite m_placeHolder;
    private ProgressBar m_progressBar;
    private StyledText m_info;
    private Button m_button;
    private boolean m_restart;

    private static final String collect(IStatus status) {
        assert (status != null) : "Parameter 'status' of method 'collect' must not be null";
        StringBuilder builder = new StringBuilder();
        builder.append(status.toString()).append(".");
        Throwable thowable = status.getException();
        if (thowable != null) {
            builder.append(" With exception:\n");
            builder.append(ExceptionUtility.collectAll((Throwable)thowable));
        }
        return builder.toString();
    }

    UpdateExecutionDialog(Shell shell, IWorkbench workbench, UpdateOperation updateOperation) {
        super(shell, "Update", 32816);
        assert (shell != null) : "Parameter 'shell' of method 'UpdateExecutionDialog' must not be null";
        assert (workbench != null) : "Parameter 'workbench' of method 'UpdateExecutionDialog' must not be null";
        assert (updateOperation != null) : "Parameter 'updateOperation' of method 'UpdateExecutionDialog' must not be null";
        this.m_workbench = workbench;
        this.m_updateOperation = updateOperation;
        this.setBlockOnOpen(false);
    }

    protected Point getMinimumSize() {
        return new Point(450, 200);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        assert (parent != null) : "Parameter 'parent' of method 'createButtonsForButtonBar' must not be null";
        this.m_button = this.createButton(parent, 0, BUTTON_CLOSE, true);
        this.m_button.setEnabled(false);
    }

    protected void fillDialogArea(Composite composite) {
        assert (composite != null) : "Parameter 'composite' of method 'fillDialogArea' must not be null";
        this.m_info = new StyledText(composite, 72);
        this.m_info.setBackground(UiResourceManager.getInstance().getBackgroundColor());
        this.m_info.setText("Downloading the newest version of Sonargraph. This can take a while!\n\n\n\n");
        this.m_info.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_placeHolder = new Composite(composite, 0);
        this.m_placeHolder.setLayout((Layout)new FillLayout());
        this.m_progressBar = new ProgressBar(this.m_placeHolder, 2);
        this.m_placeHolder.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    protected void okPressed() {
        if (this.m_restart) {
            this.m_workbench.restart();
        }
        super.okPressed();
    }

    private void displayFinishedProgressBar() {
        this.m_progressBar.dispose();
        this.m_progressBar = new ProgressBar(this.m_placeHolder, 65536);
        this.m_progressBar.setMinimum(0);
        this.m_progressBar.setMaximum(100);
        this.m_progressBar.setSelection(100);
        this.m_placeHolder.layout(true);
    }

    private void working(String info) {
        assert (info != null && info.length() > 0) : "Parameter 'info' of method 'working' must not be empty";
        this.m_info.setText("Downloading the newest version of Sonargraph. This can take a while!\n\n" + info);
    }

    private void provisioningJobDone(String failureInfo) {
        this.displayFinishedProgressBar();
        if (failureInfo == null) {
            Object infoText = "Download successful! Click 'Restart'!";
            if (Platform.isMac()) {
                infoText = (String)infoText + "\n\nNOTE: Restart might not work on older mac operating systems. In that case you have to restart manually after shutting down!";
            }
            this.m_info.setText((String)infoText);
            this.m_button.setText(BUTTON_RESTART);
            this.m_restart = true;
            LOGGER.info("Update successful");
        } else {
            String firstPart = "Download failed! Consider downloading the latest Sonargraph version manually!\n\nIt can be downloaded here: ";
            String downloadUrl = "www.hello2morrow.com";
            this.m_info.setText("Download failed! Consider downloading the latest Sonargraph version manually!\n\nIt can be downloaded here: www.hello2morrow.com!");
            StyleRange linkStyleRange = new StyleRange("Download failed! Consider downloading the latest Sonargraph version manually!\n\nIt can be downloaded here: ".length(), "www.hello2morrow.com".toString().length(), null, null);
            linkStyleRange.underline = true;
            linkStyleRange.underlineStyle = 4;
            linkStyleRange.data = "www.hello2morrow.com";
            this.m_info.setStyleRange(linkStyleRange);
            this.m_info.addListener(3, event -> {
                int offset = this.m_info.getOffsetAtPoint(new Point(event.x, event.y));
                if (offset != -1) {
                    StyleRange style = null;
                    try {
                        style = this.m_info.getStyleRangeAtOffset(offset);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    if (style != null && style.underline && style.underlineStyle == 4) {
                        Program.launch((String)"https://www.hello2morrow.com/products/downloads");
                    }
                }
            });
            this.m_button.setText(BUTTON_CLOSE);
            this.m_restart = false;
            LOGGER.warn("Update failed: " + failureInfo);
        }
        this.m_button.setEnabled(true);
    }

    public int open() {
        super.open();
        Shell shell = this.getShell();
        assert (shell != null) : "'shell' of method 'open' must not be null";
        assert (!shell.isDisposed());
        Display display = shell.getDisplay();
        assert (display != null) : "'display' of method 'open' must not be null";
        assert (!display.isDisposed());
        ProvisioningJob provisioningJob = this.m_updateOperation.getProvisioningJob((IProgressMonitor)this);
        if (provisioningJob != null) {
            provisioningJob.addJobChangeListener((IJobChangeListener)this);
            provisioningJob.schedule();
            LOGGER.info("Provisioning job scheduled");
        } else {
            this.displayFinishedProgressBar();
            this.m_info.setText(NO_UPDATE_WITHIN_ECLIPSE);
            this.m_restart = false;
            this.m_button.setText(BUTTON_CLOSE);
            this.m_button.setEnabled(true);
            LOGGER.info(NO_UPDATE_WITHIN_ECLIPSE);
        }
        while (!shell.isDisposed()) {
            try {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            catch (Throwable e) {
                LOGGER.error("Catched exception", e);
                assert (false) : ExceptionUtility.collectAll((Throwable)e);
            }
        }
        if (!display.isDisposed()) {
            display.update();
        }
        return 0;
    }

    private boolean isDisposed() {
        return this.m_info.isDisposed() || this.m_placeHolder.isDisposed() || this.m_progressBar.isDisposed() || this.m_button.isDisposed();
    }

    public void done(final IJobChangeEvent event) {
        assert (event != null) : "Parameter 'event' of method 'done' must not be null";
        UserInterfaceAdapter.getInstance().displayUiElementAsync(new Runnable(){

            @Override
            public void run() {
                if (!UpdateExecutionDialog.this.isDisposed()) {
                    UpdateExecutionDialog.this.provisioningJobDone(event.getResult().isOK() ? null : UpdateExecutionDialog.collect(event.getResult()));
                }
            }
        });
    }

    public void aboutToRun(IJobChangeEvent event) {
    }

    public void awake(IJobChangeEvent event) {
    }

    public void running(IJobChangeEvent event) {
    }

    public void scheduled(IJobChangeEvent event) {
    }

    public void sleeping(IJobChangeEvent event) {
    }

    public void beginTask(final String name, int totalWork) {
        if (name != null && !name.isEmpty()) {
            UserInterfaceAdapter.getInstance().displayUiElementAsync(new Runnable(){

                @Override
                public void run() {
                    if (!UpdateExecutionDialog.this.isDisposed()) {
                        UpdateExecutionDialog.this.working(name);
                    }
                }
            });
        }
    }

    public void done() {
    }

    public void internalWorked(double work) {
    }

    public boolean isCanceled() {
        return false;
    }

    public void setCanceled(boolean value) {
    }

    public void setTaskName(String name) {
    }

    public void subTask(final String name) {
        if (name != null && !name.isEmpty()) {
            UserInterfaceAdapter.getInstance().displayUiElementAsync(new Runnable(){

                @Override
                public void run() {
                    if (!UpdateExecutionDialog.this.isDisposed()) {
                        UpdateExecutionDialog.this.working(name);
                    }
                }
            });
        }
    }

    public void worked(int work) {
    }
}

