/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.treemap;

import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.model.treemap.TreeMapProperties;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.NameAndDescriptionWizardPage;
import com.hello2morrow.sonargraph.ui.standalone.base.workbench.CoreDialogId;
import com.hello2morrow.sonargraph.ui.standalone.treemap.TreeMapConfigurationComposite;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

final class TreeMapWizardPage
extends NameAndDescriptionWizardPage {
    private final TreeMapProperties m_originalProperties;
    private final TreeMapProperties m_properties;
    private final Mode m_mode;

    TreeMapWizardPage(ITextValidator nameValidator, TreeMapProperties properties, Mode mode) {
        super(CoreDialogId.TREE_MAP_PROPERTIES.getStandardName(), mode != null ? mode.getTitle() : "Treemap", "Name", nameValidator, properties == null ? "" : properties.getName(), properties == null ? "" : properties.getDescription());
        assert (properties != null) : "Parameter 'properties' of method 'TreeMapWizardPage' must not be null";
        assert (mode != null) : "Parameter 'mode' of method 'TreeMapWizardPage' must not be null";
        this.m_originalProperties = new TreeMapProperties(properties);
        this.m_properties = properties;
        this.m_mode = mode;
        switch (this.m_mode) {
            case CREATE: {
                this.setDescription("Specify a name and an optional description. Configure the treemap generation.");
                break;
            }
            case EDIT: {
                this.setDescription("Edit name, description and the treemap generation configuration.");
                break;
            }
            default: {
                assert (false) : "Unhandled mode: " + String.valueOf((Object)this.m_mode);
                break;
            }
        }
    }

    protected IDialogId getDialogId() {
        return CoreDialogId.TREE_MAP_PROPERTIES;
    }

    @Override
    protected void addWidgetsToDialogAreaAfter(Composite composite) {
        assert (composite != null) : "Parameter 'composite' of method 'addWidgetsToDialogAreaAfter' must not be null";
        TreeMapConfigurationComposite leafElementComposite = new TreeMapConfigurationComposite(composite, this.m_properties, new TreeMapConfigurationComposite.IListener(){

            @Override
            public void modified() {
                TreeMapWizardPage.this.validate();
            }
        });
        leafElementComposite.setLayoutData(new GridData(4, 4, true, true, 3, 1));
    }

    @Override
    protected void updatePageCompletion(boolean hasValidData) {
        boolean propertiesAreValid = this.m_properties.isValid().isSuccess();
        super.updatePageCompletion(hasValidData && propertiesAreValid);
    }

    @Override
    protected void elementNameModified(String name) {
        this.m_properties.setName(name == null ? "" : name);
    }

    @Override
    protected void descriptionModified(String description) {
        this.m_properties.setDescription(description == null ? "" : description);
    }

    public boolean isPageComplete() {
        switch (this.m_mode) {
            case CREATE: {
                return super.isPageComplete();
            }
            case EDIT: {
                return super.isPageComplete() && !this.m_properties.equals((Object)this.m_originalProperties);
            }
        }
        assert (false) : "Unhandled mode: " + String.valueOf((Object)this.m_mode);
        return false;
    }

    TreeMapProperties getProperties() {
        return this.m_properties;
    }

    static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode CREATE = new Mode("New Treemap");
        public static final /* enum */ Mode EDIT = new Mode("Edit Treemap");
        private final String m_title;
        private static final /* synthetic */ Mode[] ENUM$VALUES;

        static {
            ENUM$VALUES = new Mode[]{CREATE, EDIT};
        }

        private Mode(String title) {
            assert (title != null && title.length() > 0) : "Parameter 'title' of method 'Mode' must not be empty";
            this.m_title = title;
        }

        public String getTitle() {
            return this.m_title;
        }

        public static Mode[] values() {
            Mode[] modeArray = ENUM$VALUES;
            int n = modeArray.length;
            Mode[] modeArray2 = new Mode[n];
            System.arraycopy(ENUM$VALUES, 0, modeArray2, 0, n);
            return modeArray2;
        }

        public static Mode valueOf(String string) {
            return Enum.valueOf(Mode.class, string);
        }
    }
}

