/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.treemap;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.system.treemap.LoadTreeMapCommand;
import com.hello2morrow.sonargraph.core.foundation.common.treemap.TreeMapNode;
import com.hello2morrow.sonargraph.core.model.context.IContext;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemProviderEvent;
import com.hello2morrow.sonargraph.core.model.event.TreeMapLoadedEvent;
import com.hello2morrow.sonargraph.core.model.event.TreeMapModifiedEvent;
import com.hello2morrow.sonargraph.core.model.event.TreeMapUnloadedEvent;
import com.hello2morrow.sonargraph.core.model.programming.NamespaceFragment;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.treemap.ILeafInfoProvider;
import com.hello2morrow.sonargraph.core.model.treemap.ISizeInfoProvider;
import com.hello2morrow.sonargraph.core.model.treemap.ITreeMapProvider;
import com.hello2morrow.sonargraph.core.model.treemap.TreeMapFile;
import com.hello2morrow.sonargraph.core.model.treemap.TreeMapNodeData;
import com.hello2morrow.sonargraph.core.model.treemap.TreeMapRepresentation;
import com.hello2morrow.sonargraph.core.model.treemap.TreeMapType;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.common.RunnableWithResult;
import com.hello2morrow.sonargraph.foundation.event.EventHandler;
import com.hello2morrow.sonargraph.foundation.event.EventManager;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.ui.standalone.base.swt.FocusableToolTip;
import com.hello2morrow.sonargraph.ui.standalone.treemap.CanvasImageData;
import com.hello2morrow.sonargraph.ui.standalone.treemap.CanvasImageData2D;
import com.hello2morrow.sonargraph.ui.standalone.treemap.CanvasImageData3D;
import com.hello2morrow.sonargraph.ui.standalone.treemap.CuboidCreator;
import com.hello2morrow.sonargraph.ui.standalone.treemap.Matrix;
import com.hello2morrow.sonargraph.ui.standalone.treemap.ModuleSelectionDialog;
import com.hello2morrow.sonargraph.ui.standalone.treemap.RectangleCreator;
import com.hello2morrow.sonargraph.ui.standalone.treemap.TreeMapNodeView;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.CommandHandler;
import com.hello2morrow.sonargraph.ui.swt.base.view.Gesture;
import com.hello2morrow.sonargraph.ui.swt.base.view.IViewWithAutoResize;
import com.hello2morrow.sonargraph.ui.swt.base.view.IViewWithZoom;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ImageExtension;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchSlaveView;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileOutputStream;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TreeMapView
extends WorkbenchSlaveView
implements IViewWithZoom,
IViewWithAutoResize,
FocusableToolTip.IToolTipProvider,
CanvasImageData2D.IInfoProvider2D,
CanvasImageData3D.IInfoProvider3D {
    private static final Logger LOGGER = LoggerFactory.getLogger(TreeMapView.class);
    private static final double SCALE_STEP_2D = 0.05;
    private static final double FOV_STEP_3D = 0.01;
    private static final int ROTATION_STEP_3D = 10;
    private static final int ROTATION_X_DEFAULT_3D = 20;
    private static final int ROTATION_Y_DEFAULT_3D = 0;
    private static final boolean AUTO_RESIZE_DEFAULT = true;
    private final Set<TreeMapNodeView> m_selectedNodeViews = new THashSet();
    private Map<TreeMapNode<NamedElement, TreeMapNodeData>, TreeMapNodeView> m_nodeToNodeView;
    private List<? extends TreeMapNodeView> m_nodeViews = Collections.emptyList();
    private TreeMapFile m_file;
    private TreeMapRepresentation m_treeMap;
    private FocusableToolTip m_focusableToolTip;
    private Canvas m_canvas;
    private Point m_inContentMove;
    private Point m_inContentRotate;
    private Point m_currentTranslation = new Point(0, 0);
    private boolean m_inGesture;
    private boolean m_selectionFromTreeMapInfoView;
    private boolean m_colorUpdateOnlyIfPossible;
    private CanvasImageData m_canvasImageData;
    private Image m_image;
    private boolean m_autoResize = true;
    private double m_scale2d = 1.0;
    private int m_modelWorldOffsetZ3D;
    private Matrix m_centerModelMatrix3d;
    private Matrix m_moveModelMatrix3d;
    private double m_fovRadians3d = 1.0;
    private int m_modelHeight3D;
    private int m_modelWorldDepth3d;
    private int m_rotateUpDown3d = 20;
    private int m_rotateLeftRight3d = 0;

    public IViewId getViewId() {
        return ViewId.TREE_MAP_VIEW;
    }

    public List<Element> getSelectedElements() {
        return this.m_treeMap != null && this.m_treeMap.isValid() ? Collections.singletonList(this.m_treeMap) : Collections.emptyList();
    }

    protected boolean supportsSleep() {
        return false;
    }

    private void disposeImage() {
        if (this.m_image != null) {
            this.m_image.dispose();
            this.m_image = null;
        }
    }

    private void close() {
        this.disposeImage();
        this.resetPartName();
        this.hideView();
    }

    public List<Control> getControlsForInteraction() {
        return Arrays.asList(this.m_canvas);
    }

    private void createModel() {
        assert (this.m_treeMap != null) : "'m_treeMap' of method 'createModel' must not be null";
        long start = System.currentTimeMillis();
        LOGGER.trace("Create model");
        TreeMapNodeView select = null;
        TreeMapNode rootNode = this.m_treeMap.getTreeMapNode();
        switch (this.m_treeMap.getType()) {
            case THREE_DIMENSIONAL: {
                CuboidCreator cuboidCreator = new CuboidCreator();
                rootNode.accept((TreeMapNode.IVisitor)cuboidCreator);
                int width = rootNode.getWidth();
                int depth = rootNode.getHeight();
                this.m_modelWorldOffsetZ3D = depth * 5;
                this.m_modelHeight3D = cuboidCreator.getHeight();
                double halfDepth = (double)depth / 2.0;
                this.m_centerModelMatrix3d = Matrix.createTranslationMatrix((double)width / -2.0, (double)this.m_modelHeight3D / -2.0, -halfDepth);
                this.m_moveModelMatrix3d = Matrix.createTranslationMatrix(0.0, 0.0, halfDepth + (double)this.m_modelWorldOffsetZ3D);
                this.m_modelWorldDepth3d = depth;
                this.m_nodeViews = cuboidCreator.getCuboids();
                select = cuboidCreator.getRoot();
                break;
            }
            case TWO_DIMENSIONAL: {
                RectangleCreator rectangleCreator = new RectangleCreator();
                rootNode.getChildren().forEach(c -> c.accept((TreeMapNode.IVisitor)rectangleCreator));
                rootNode.accept((TreeMapNode.IVisitor)rectangleCreator);
                this.m_nodeViews = rectangleCreator.getRectangles();
                select = rectangleCreator.getRoot();
                break;
            }
            default: {
                assert (false) : "Unhandled tree map type: " + String.valueOf(this.m_treeMap.getType());
                break;
            }
        }
        if (select != null) {
            select.setIsSelected(true);
            this.m_selectedNodeViews.add(select);
        }
        LOGGER.trace("Create model - done [" + (System.currentTimeMillis() - start) + " ms]");
    }

    private void finishContentMove() {
        if (this.m_inContentMove != null) {
            LOGGER.trace("Finish content move (current translation): " + String.valueOf(this.m_currentTranslation));
            this.m_inContentMove = null;
            this.disposeImage();
            this.m_canvas.redraw();
            Shell shell = this.getShell();
            if (shell != null) {
                shell.setCursor(null);
            }
            WorkbenchRegistry.getInstance().refreshUIElements();
        }
    }

    private void finishContentRotate() {
        if (this.m_inContentRotate != null) {
            LOGGER.trace("Finish content rotate (current translation): " + String.valueOf(this.m_currentTranslation));
            this.m_inContentRotate = null;
            this.disposeImage();
            this.m_canvas.redraw();
            Shell shell = this.getShell();
            if (shell != null) {
                shell.setCursor(null);
            }
            WorkbenchRegistry.getInstance().refreshUIElements();
        }
    }

    public void finishedGesture() {
        this.m_inGesture = false;
        this.finishContentMove();
        this.finishContentRotate();
    }

    private void createImage() {
        assert (this.m_treeMap != null) : "'m_treeMap' of method 'createImage' must not be null";
        assert (this.m_image == null) : "'m_image' of method 'createImage' must be null";
        assert (this.m_nodeViews != null && !this.m_nodeViews.isEmpty()) : "'m_nodeViews' of method 'createImage' must not be empty";
        Point size = this.m_canvas.getSize();
        boolean is3D = this.is3D();
        if (this.m_canvasImageData == null || this.m_canvasImageData.needsReCreation(size, is3D)) {
            this.m_canvasImageData = is3D ? new CanvasImageData3D(this, size) : new CanvasImageData2D(this, size);
            this.m_colorUpdateOnlyIfPossible = false;
        } else if (!this.m_colorUpdateOnlyIfPossible) {
            LOGGER.debug("Re-initialize canvas image data");
            this.m_canvasImageData.reInitialize();
        }
        if (this.m_colorUpdateOnlyIfPossible) {
            this.m_canvasImageData.updateColors(this.m_selectionFromTreeMapInfoView);
            this.m_colorUpdateOnlyIfPossible = false;
        } else {
            this.m_canvasImageData.createImageData(this.getShell().getMonitor().getBounds(), (TreeMapNode<NamedElement, TreeMapNodeData>)this.m_treeMap.getTreeMapNode(), this.m_nodeViews, this.m_currentTranslation, this.m_autoResize, this.m_selectionFromTreeMapInfoView);
        }
        this.m_image = new Image((Device)this.m_canvas.getDisplay(), this.m_canvasImageData.getImageData());
    }

    protected void createViewContent(Composite viewContentArea) {
        assert (viewContentArea != null) : "Parameter 'viewContentArea' of method 'createViewContent' must not be null";
        this.m_canvas = new Canvas(viewContentArea, 0x140000);
        this.m_canvas.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'mouseMove' must not be null");
                }
                if (TreeMapView.this.m_inGesture && Gesture.shiftKeyPressed((int)event.stateMask) && !Gesture.primaryModifierKeyPressed((int)event.stateMask) && !Gesture.ctrlKeyPressed((int)event.stateMask)) {
                    if (TreeMapView.this.m_inContentMove == null) {
                        TreeMapView.this.m_autoResize = false;
                        TreeMapView.this.m_inContentMove = new Point(event.x, event.y);
                        Shell shell = TreeMapView.this.getShell();
                        if (shell != null) {
                            shell.setCursor(UiResourceManager.getInstance().getCursor(UiResourceManager.CursorId.OPEN_HAND));
                        }
                    } else {
                        Point delta = new Point(event.x - TreeMapView.this.m_inContentMove.x, event.y - TreeMapView.this.m_inContentMove.y);
                        if (Math.abs(delta.x) >= 2 || Math.abs(delta.y) >= 2) {
                            TreeMapView.this.m_currentTranslation = new Point(TreeMapView.this.m_currentTranslation.x + delta.x, TreeMapView.this.m_currentTranslation.y + delta.y);
                            TreeMapView.this.m_inContentMove = new Point(event.x, event.y);
                            TreeMapView.this.disposeImage();
                            TreeMapView.this.m_canvas.redraw();
                        }
                    }
                } else if (TreeMapView.this.m_inGesture && Gesture.shiftKeyPressed((int)event.stateMask) && Gesture.primaryModifierKeyPressed((int)event.stateMask) && !Gesture.ctrlKeyPressed((int)event.stateMask)) {
                    if (TreeMapView.this.m_inContentRotate == null) {
                        TreeMapView.this.m_autoResize = false;
                        TreeMapView.this.m_inContentRotate = new Point(event.x, event.y);
                        Shell shell = TreeMapView.this.getShell();
                        if (shell != null) {
                            shell.setCursor(UiResourceManager.getInstance().getCursor(UiResourceManager.CursorId.ROTATE));
                        }
                    } else {
                        Point delta = new Point(event.x - TreeMapView.this.m_inContentRotate.x, event.y - TreeMapView.this.m_inContentRotate.y);
                        int absDeltaX = Math.abs(delta.x);
                        int absDeltaY = Math.abs(delta.y);
                        if (absDeltaX >= 2 || absDeltaY >= 2) {
                            TreeMapView.this.m_inContentRotate = new Point(event.x, event.y);
                            if (absDeltaX > absDeltaY) {
                                if (delta.x > 0) {
                                    if (TreeMapView.this.isRotateRightPossible()) {
                                        TreeMapView.this.rotateRight();
                                    }
                                } else if (TreeMapView.this.isRotateLeftPossible()) {
                                    TreeMapView.this.rotateLeft();
                                }
                            } else if (delta.y > 0) {
                                if (TreeMapView.this.isRotateUpPossible()) {
                                    TreeMapView.this.rotateUp();
                                }
                            } else if (TreeMapView.this.isRotateDownPossible()) {
                                TreeMapView.this.rotateDown();
                            }
                        }
                    }
                } else {
                    TreeMapView.this.finishContentMove();
                    TreeMapView.this.finishContentRotate();
                }
            }
        });
        this.m_canvas.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                TreeMapView.this.disposeImage();
                TreeMapView.this.m_canvas.redraw();
            }
        });
        this.m_canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'paintControl' must not be null");
                }
                if (!$assertionsDisabled && TreeMapView.this.m_canvas == null) {
                    throw new AssertionError((Object)"'m_canvas' of method 'paintControl' must not be null");
                }
                long start = System.currentTimeMillis();
                LOGGER.debug("Paint");
                if (TreeMapView.this.m_image != null) {
                    LOGGER.debug("Draw image");
                    event.gc.drawImage(TreeMapView.this.m_image, 0, 0);
                } else if (TreeMapView.this.m_treeMap != null && TreeMapView.this.m_treeMap.isValid()) {
                    LOGGER.debug("Create image");
                    TreeMapView.this.createImage();
                    if (!$assertionsDisabled && TreeMapView.this.m_image == null) {
                        throw new AssertionError((Object)"'m_image' of method 'paintControl' must not be null");
                    }
                    LOGGER.debug("Draw image");
                    event.gc.drawImage(TreeMapView.this.m_image, 0, 0);
                }
                LOGGER.debug("Paint - done [" + (System.currentTimeMillis() - start) + " ms]");
            }
        });
        this.m_focusableToolTip = new FocusableToolTip((Control)this.m_canvas, this, 1500);
        EventManager.getInstance().attach((EventHandler)new EventHandler<TreeMapLoadedEvent>(TreeMapLoadedEvent.class, (Object)this){

            public void handleEvent(TreeMapLoadedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'handleEvent' must not be null");
                }
                if (TreeMapView.this.canHandleEvent((SoftwareSystemProviderEvent)event) && event.getFile() == TreeMapView.this.m_file) {
                    TreeMapView.this.m_treeMap = (TreeMapRepresentation)TreeMapView.this.m_file.getUniqueExistingChild(TreeMapRepresentation.class);
                    TreeMapView.this.disposeImage();
                    TreeMapView.this.createModel();
                    TreeMapView.this.m_canvas.redraw();
                    WorkbenchRegistry.getInstance().refreshUIElements();
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<TreeMapModifiedEvent>(TreeMapModifiedEvent.class, (Object)this){

            public void handleEvent(TreeMapModifiedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'handleEvent' must not be null");
                }
                if (TreeMapView.this.canHandleEvent((SoftwareSystemProviderEvent)event) && event.getFile() == TreeMapView.this.m_file) {
                    TreeMapView.this.m_treeMap = (TreeMapRepresentation)TreeMapView.this.m_file.getUniqueExistingChild(TreeMapRepresentation.class);
                    if (event.leafInfoOnly()) {
                        TreeMapView.this.m_colorUpdateOnlyIfPossible = true;
                        TreeMapView.this.disposeImage();
                    } else {
                        TreeMapView.this.setTitleTooltip(TreeMapView.this.m_file.getIdentifyingPath());
                        WorkbenchRegistry.getInstance().updatePartNameForModifiableFileState(TreeMapView.this.getPart(), TreeMapView.this.m_file.getShortName());
                        TreeMapView.this.disposeImage();
                        TreeMapView.this.createModel();
                    }
                    TreeMapView.this.m_canvas.redraw();
                    WorkbenchRegistry.getInstance().refreshUIElements();
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<TreeMapUnloadedEvent>(TreeMapUnloadedEvent.class, (Object)this){

            public void handleEvent(TreeMapUnloadedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'handleEvent' must not be null");
                }
                if (TreeMapView.this.canHandleEvent((SoftwareSystemProviderEvent)event) && event.getFile() == TreeMapView.this.m_file) {
                    TreeMapView.this.close();
                    WorkbenchRegistry.getInstance().refreshUIElements();
                }
            }
        });
    }

    protected void destroyViewContent() {
        ITreeMapProvider provider;
        if (this.m_focusableToolTip != null) {
            this.m_focusableToolTip.closeTooltip();
            this.m_focusableToolTip = null;
        }
        EventManager.getInstance().detach(TreeMapLoadedEvent.class, (Object)this);
        EventManager.getInstance().detach(TreeMapUnloadedEvent.class, (Object)this);
        EventManager.getInstance().detach(TreeMapModifiedEvent.class, (Object)this);
        SoftwareSystem softwareSystem = this.getSoftwareSystem();
        if (softwareSystem != null && this.m_file != null && (provider = (ITreeMapProvider)softwareSystem.getExtension(ITreeMapProvider.class)).hasBeenLoaded(this.m_file)) {
            provider.unload(this.m_file);
        }
        this.m_file = null;
        this.disposeImage();
        super.destroyViewContent();
    }

    public void startGesture(Point location, int button, int stateMask) {
        Point pixelInfoLocation;
        assert (location != null) : "Parameter 'location' of method 'mouseDown' must not be null";
        this.m_inGesture = true;
        this.m_focusableToolTip.closeTooltip();
        if (button == 1 && this.m_canvasImageData != null && !this.m_canvas.isDisposed() && !Gesture.shiftKeyPressed((int)stateMask) && this.m_inContentMove == null && this.m_inContentRotate == null && (pixelInfoLocation = this.m_canvasImageData.getTreeMapNodeViewLocation(location)) != null) {
            TreeMapNodeView nodeView;
            boolean aggregate = (stateMask & SWT.MOD1) != 0;
            boolean repaint = false;
            if (!aggregate && !this.m_selectedNodeViews.isEmpty()) {
                repaint = true;
                this.m_selectedNodeViews.forEach(c -> c.setIsSelected(false));
                this.m_selectedNodeViews.clear();
            }
            if ((nodeView = this.m_canvasImageData.getTreeMapNodeView(pixelInfoLocation.x, pixelInfoLocation.y)) != null) {
                this.m_selectedNodeViews.add(nodeView);
                nodeView.setIsSelected(true);
                repaint = true;
            }
            if (repaint) {
                this.m_selectionFromTreeMapInfoView = false;
                this.m_colorUpdateOnlyIfPossible = true;
                this.disposeImage();
                this.m_canvas.redraw();
                ArrayList<Element> selectedNamedElements = new ArrayList<Element>(this.m_selectedNodeViews.size());
                for (TreeMapNodeView next : this.m_selectedNodeViews) {
                    selectedNamedElements.add((Element)next.getNode().getAssociatedElement());
                }
                this.getSelectionProviderAdapter().handleSelectionChanged(selectedNamedElements);
            }
        }
    }

    public boolean isAutoResizeEnabled() {
        return this.m_autoResize;
    }

    public void enableAutoResize(boolean enable) {
        if (this.m_autoResize != enable) {
            this.m_autoResize = enable;
            if (this.m_autoResize) {
                this.m_rotateUpDown3d = 20;
                this.m_rotateLeftRight3d = 0;
                this.m_currentTranslation = new Point(0, 0);
                this.disposeImage();
                this.m_canvas.redraw();
            }
            WorkbenchRegistry.getInstance().refreshUIElements();
        }
    }

    public boolean zoomInPossible() {
        if (this.m_treeMap != null && this.m_treeMap.isValid()) {
            if (TreeMapType.THREE_DIMENSIONAL.equals((Object)this.m_treeMap.getType())) {
                return this.m_fovRadians3d - 0.01 > 0.005;
            }
            return this.m_scale2d <= 1.95;
        }
        return false;
    }

    private boolean is3D() {
        return this.m_treeMap != null && this.m_treeMap.isValid() && TreeMapType.THREE_DIMENSIONAL.equals((Object)this.m_treeMap.getType());
    }

    public void zoomIn(Point location) {
        this.m_autoResize = false;
        if (this.is3D()) {
            this.m_fovRadians3d -= 0.01;
        } else {
            this.m_scale2d += 0.05;
        }
        this.disposeImage();
        this.m_canvas.redraw();
        WorkbenchRegistry.getInstance().refreshUIElements();
    }

    public boolean zoomOutPossible() {
        if (this.m_treeMap != null && this.m_treeMap.isValid()) {
            if (TreeMapType.THREE_DIMENSIONAL.equals((Object)this.m_treeMap.getType())) {
                return this.m_fovRadians3d + 0.01 < 1.6;
            }
            return this.m_scale2d >= 0.25;
        }
        return false;
    }

    public void zoomOut(Point location) {
        this.m_autoResize = false;
        if (this.is3D()) {
            this.m_fovRadians3d += 0.01;
        } else {
            this.m_scale2d -= 0.05;
        }
        this.disposeImage();
        this.m_canvas.redraw();
        WorkbenchRegistry.getInstance().refreshUIElements();
    }

    private void rotate(int offset) {
        assert (offset != 0) : "offset must not be '0'";
        this.m_autoResize = false;
        this.m_rotateLeftRight3d += offset;
        if (this.m_rotateLeftRight3d >= 360) {
            this.m_rotateLeftRight3d -= 360;
        } else if (this.m_rotateLeftRight3d < 0) {
            this.m_rotateLeftRight3d += 360;
        }
        this.disposeImage();
        this.m_canvas.redraw();
        WorkbenchRegistry.getInstance().refreshUIElements();
    }

    boolean isRotateLeftPossible() {
        return this.is3D();
    }

    boolean isRotateRightPossible() {
        return this.is3D();
    }

    void rotateLeft() {
        this.rotate(-10);
    }

    void rotateRight() {
        this.rotate(10);
    }

    boolean isRotateUpPossible() {
        return this.is3D() && this.m_rotateUpDown3d + 10 <= 90;
    }

    boolean isRotateDownPossible() {
        return this.is3D() && this.m_rotateUpDown3d - 10 >= 0;
    }

    void rotateDown() {
        this.m_autoResize = false;
        this.m_rotateUpDown3d -= 10;
        this.disposeImage();
        this.m_canvas.redraw();
        WorkbenchRegistry.getInstance().refreshUIElements();
    }

    void rotateUp() {
        this.m_autoResize = false;
        this.m_rotateUpDown3d += 10;
        this.disposeImage();
        this.m_canvas.redraw();
        WorkbenchRegistry.getInstance().refreshUIElements();
    }

    public void showInView(IContext context, List<Element> elements, List<IStandardEnumeration> options, boolean secondaryIdReused) {
        assert (elements != null) : "Parameter 'elements' of method 'showInView' must not be null";
        assert (elements.size() == 1) : "Exactly 1 element expected";
        assert (elements.get(0) instanceof TreeMapFile) : "Unexpected class in method 'showInView': " + String.valueOf(elements.get(0));
        this.m_file = (TreeMapFile)elements.get(0);
        assert (this.m_file != null) : "'m_file' of method 'showInView' must not be null";
        this.setTitleTooltip(this.m_file.getIdentifyingPath());
        WorkbenchRegistry.getInstance().updatePartNameForModifiableFileState(this.getPart(), this.m_file.getShortName());
    }

    public void finishShowInView(IViewId sourceViewId, List<Element> elements, List<IStandardEnumeration> options) {
        assert (this.m_file != null) : "'m_file' of method 'finishShowInView' must not be null";
        final SoftwareSystem softwareSystem = this.getSoftwareSystem();
        assert (softwareSystem != null) : "'softwareSystem' of method 'finishShowInView' must not be null";
        if (!((ITreeMapProvider)softwareSystem.getExtension(ITreeMapProvider.class)).hasBeenLoaded(this.m_file)) {
            if (CommandHandler.performCheck((CommandHandler.Check)CommandHandler.Check.LEVEL, (boolean)true)) {
                LoadTreeMapCommand command = new LoadTreeMapCommand(this.getSoftwareSystemProvider(), new LoadTreeMapCommand.ILoadTreeMapInteraction(){

                    public boolean collect(LoadTreeMapCommand.LoadTreeMapData data) {
                        if (!$assertionsDisabled && data == null) {
                            throw new AssertionError((Object)"Parameter 'data' of method 'collect' must not be null");
                        }
                        RunnableWithResult<List<Module>> runnable = new RunnableWithResult<List<Module>>(){

                            public void run() {
                                List modules = ((Workspace)softwareSystem.getUniqueExistingChild(Workspace.class)).getChildren(Module.class);
                                if (modules.size() == 1) {
                                    this.setResult(modules);
                                } else {
                                    ModuleSelectionDialog dialog = new ModuleSelectionDialog(WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), modules);
                                    if (dialog.open() == 0) {
                                        this.setResult(dialog.getModules());
                                    } else {
                                        this.setResult(null);
                                    }
                                }
                            }
                        };
                        UserInterfaceAdapter.getInstance().displayUiElementWithResult((RunnableWithResult)runnable);
                        List selectedModules = (List)runnable.getResult();
                        if (selectedModules != null && !selectedModules.isEmpty()) {
                            data.setFile(TreeMapView.this.m_file, selectedModules);
                            return true;
                        }
                        UserInterfaceAdapter.getInstance().displayUiElement(() -> TreeMapView.this.close());
                        return false;
                    }

                    public void processLoadTreeMapResult(OperationResult result) {
                        if (!$assertionsDisabled && result == null) {
                            throw new AssertionError((Object)"Parameter 'result' of method 'processLoadTreeMapResult' must not be null");
                        }
                        UserInterfaceAdapter.getInstance().process(result);
                        if (result.isFailure()) {
                            UserInterfaceAdapter.getInstance().displayUiElement(() -> TreeMapView.this.close());
                        }
                    }
                });
                UserInterfaceAdapter.getInstance().run((Command)command);
            } else {
                this.close();
            }
        }
    }

    @Override
    public String getToolTipText(Point location) {
        TreeMapNodeData data;
        TreeMapNode<NamedElement, TreeMapNodeData> node;
        TreeMapNodeView nodeView;
        Point pixelInfoLocation;
        assert (location != null) : "Parameter 'location' of method 'getToolTipText' must not be null";
        if (this.m_inContentMove == null && !this.m_inGesture && this.m_canvasImageData != null && (pixelInfoLocation = this.m_canvasImageData.getTreeMapNodeViewLocation(location)) != null && (nodeView = this.m_canvasImageData.getTreeMapNodeView(pixelInfoLocation.x, pixelInfoLocation.y)) != null && (node = nodeView.getNode()) != null && (data = (TreeMapNodeData)node.getAssociatedData()) != null) {
            ILeafInfoProvider heightInfoProvider;
            StringBuilder builder = new StringBuilder();
            NamedElement associatedElement = (NamedElement)node.getAssociatedElement();
            if (associatedElement != null) {
                builder.append(associatedElement.getPresentationKind()).append(": ").append(associatedElement.getShortName()).append("\n");
            } else {
                builder.append(node.getName()).append("\n");
            }
            ISizeInfoProvider sizeInfoProvider = data.getSizeInfoProvider();
            builder.append("\n<Size> ").append(sizeInfoProvider.getInformation()).append(": ").append(TreeMapNode.FORMAT.format(node.getSize()));
            ILeafInfoProvider colorInfoProvider = data.getLeafColorInfoProvider();
            if (colorInfoProvider != null) {
                builder.append("\n<Color> ").append(colorInfoProvider.getInformation());
            }
            if ((heightInfoProvider = data.getLeafHeightInfoProvider()) != null) {
                builder.append("\n<Height> ").append(heightInfoProvider.getInformation());
            }
            builder.append("\n");
            boolean topLevelFragmentSeen = false;
            for (TreeMapNode nextParent : node.getParents()) {
                NamedElement nextAssociatedElement = (NamedElement)nextParent.getAssociatedElement();
                if (nextAssociatedElement == null) continue;
                if (!(nextAssociatedElement instanceof NamespaceFragment) || !topLevelFragmentSeen) {
                    builder.append("\n<").append(nextAssociatedElement.getPresentationKind()).append("> ").append(nextParent.getName());
                }
                if (!(nextAssociatedElement instanceof NamespaceFragment)) continue;
                topLevelFragmentSeen = true;
            }
            return builder.toString();
        }
        return null;
    }

    public boolean supportsImageExport() {
        return this.m_file != null && this.m_treeMap != null && this.m_canvas != null && !this.m_canvas.isDisposed();
    }

    public String getInitialExportImageName() {
        return this.m_file != null ? FileUtility.getFileNameWithoutExtension((TFile)this.m_file.getFile()) : "";
    }

    public OperationResult exportToImage(TFile targetFile) {
        assert (targetFile != null) : "Parameter 'targetFile' of method 'exportImage' must not be null";
        OperationResult result = new OperationResult("Export image to '" + targetFile.getAbsolutePath() + "'");
        String targetFileExtension = FileUtility.getExtension((TFile)targetFile);
        int imageType = ImageExtension.getSwtImageType((String)targetFileExtension);
        Image image = null;
        GC gc = null;
        try {
            try {
                Throwable throwable = null;
                Object var8_10 = null;
                try (TFileOutputStream outputStream = new TFileOutputStream((File)targetFile);){
                    Point canvasSize = this.m_canvas.getSize();
                    image = new Image((Device)WorkbenchRegistry.getInstance().getDisplay(), canvasSize.x, canvasSize.y);
                    gc = new GC((Drawable)image);
                    gc.setAntialias(1);
                    this.m_canvas.print(gc);
                    ImageLoader imageLoader = new ImageLoader();
                    imageLoader.data = new ImageData[]{image.getImageData()};
                    imageLoader.save((OutputStream)outputStream, imageType);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_CREATE_FILE, e, "Failed to export image.", new Object[0]);
                if (gc != null) {
                    gc.dispose();
                }
                if (image != null) {
                    image.dispose();
                }
            }
        }
        finally {
            if (gc != null) {
                gc.dispose();
            }
            if (image != null) {
                image.dispose();
            }
        }
        return result;
    }

    TreeMapRepresentation getTreeMapRepresentation() {
        return this.m_treeMap != null && this.m_treeMap.isValid() ? this.m_treeMap : null;
    }

    void selectNodes(List<TreeMapNode<NamedElement, TreeMapNodeData>> nodes) {
        assert (nodes != null) : "Parameter 'nodes' of method 'applySelection' must not be null";
        if (nodes.isEmpty()) {
            if (!this.m_selectedNodeViews.isEmpty() && this.m_selectionFromTreeMapInfoView) {
                this.m_selectedNodeViews.forEach(v -> v.setIsSelected(false));
                this.m_selectedNodeViews.clear();
                this.disposeImage();
                this.m_canvas.redraw();
                WorkbenchRegistry.getInstance().refreshUIElements();
            }
        } else {
            this.m_selectedNodeViews.forEach(v -> v.setIsSelected(false));
            this.m_selectedNodeViews.clear();
            if (this.m_nodeToNodeView == null) {
                this.m_nodeToNodeView = new THashMap();
                this.m_nodeViews.forEach(v -> {
                    TreeMapNodeView treeMapNodeView = this.m_nodeToNodeView.put(v.getNode(), (TreeMapNodeView)v);
                });
            }
            for (TreeMapNode<NamedElement, TreeMapNodeData> nextNode : nodes) {
                TreeMapNodeView nextView = this.m_nodeToNodeView.get(nextNode);
                if (nextView == null) continue;
                nextView.setIsSelected(true);
                this.m_selectedNodeViews.add(nextView);
            }
            this.m_selectionFromTreeMapInfoView = true;
            this.m_colorUpdateOnlyIfPossible = true;
            this.disposeImage();
            this.m_canvas.redraw();
            WorkbenchRegistry.getInstance().refreshUIElements();
        }
    }

    @Override
    public double getScale2D() {
        return this.m_scale2d;
    }

    @Override
    public void setScale2D(double scale) {
        this.m_scale2d = scale;
    }

    @Override
    public int getModelWorldOffsetZ3D() {
        return this.m_modelWorldOffsetZ3D;
    }

    @Override
    public int getModelWorldDepth3d() {
        return this.m_modelWorldDepth3d;
    }

    @Override
    public int getModelHeight3D() {
        return this.m_modelHeight3D;
    }

    @Override
    public Matrix getMoveModelMatrix3d() {
        return this.m_moveModelMatrix3d;
    }

    @Override
    public int getRotateUpDown3d() {
        return this.m_rotateUpDown3d;
    }

    @Override
    public int getRotateLeftRight3d() {
        return this.m_rotateLeftRight3d;
    }

    @Override
    public Matrix getCenterModelMatrix3d() {
        return this.m_centerModelMatrix3d;
    }

    @Override
    public double getFovRadians3d() {
        return this.m_fovRadians3d;
    }

    @Override
    public void setFovRadians3d(double fov) {
        this.m_fovRadians3d = fov;
    }
}

