/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.treemap;

import com.hello2morrow.sonargraph.core.foundation.common.treemap.TreeMapNode;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IElementGroup;
import com.hello2morrow.sonargraph.core.model.element.IElementResolver;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemProviderEvent;
import com.hello2morrow.sonargraph.core.model.event.TreeMapModifiedEvent;
import com.hello2morrow.sonargraph.core.model.event.TreeMapUnloadedEvent;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.export.IExportProvider;
import com.hello2morrow.sonargraph.core.model.treemap.ITreeMapProvider;
import com.hello2morrow.sonargraph.core.model.treemap.LeafNodeColor;
import com.hello2morrow.sonargraph.core.model.treemap.TreeMapFile;
import com.hello2morrow.sonargraph.core.model.treemap.TreeMapNodeData;
import com.hello2morrow.sonargraph.core.model.treemap.TreeMapRepresentation;
import com.hello2morrow.sonargraph.core.model.treemap.TreeMapType;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.event.EventHandler;
import com.hello2morrow.sonargraph.foundation.event.EventManager;
import com.hello2morrow.sonargraph.foundation.export.ExportData;
import com.hello2morrow.sonargraph.foundation.propertyreader.BeanPropertyReader;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;
import com.hello2morrow.sonargraph.ui.standalone.treemap.TreeMapNodeBeanAdapter;
import com.hello2morrow.sonargraph.ui.standalone.treemap.TreeMapView;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.textsearch.ITextSearchHandler;
import com.hello2morrow.sonargraph.ui.swt.base.view.Search;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PagingPropertyTableViewer;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableViewer;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableViewerBasedTextSearchHandler;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchAuxiliaryView;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import com.hello2morrow.sonargraph.ui.swt.common.NavigationState;
import com.hello2morrow.sonargraph.ui.swt.common.ViewNavigationManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TreeMapInfoView
extends WorkbenchAuxiliaryView
implements ISelectionChangedListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(TreeMapInfoView.class);
    private static final String COLOR_PROPERTY_NAME = "colorValue";
    private PagingPropertyTableViewer<TreeMapNode<NamedElement, TreeMapNodeData>> m_infoView;
    private PropertyTableViewerBasedTextSearchHandler m_textSearchProvider;
    private TreeMapFile m_file;
    private TreeMapRepresentation m_treeMap;
    private Map<NamedElement, TreeMapNode<NamedElement, TreeMapNodeData>> m_namedElementToLeaf;

    public IViewId getViewId() {
        return ViewId.TREE_MAP_INFO_VIEW;
    }

    public Search supportsSearch() {
        return Search.FIND_TEXT;
    }

    protected boolean supportsSleep() {
        return false;
    }

    private void createDefaultViewer(Composite viewContentArea) {
        assert (viewContentArea != null) : "Parameter 'viewContentArea' of method 'createDefaultViewer' must not be null";
        if (this.m_infoView != null) {
            this.m_infoView.dispose();
        }
        this.m_infoView = new PagingPropertyTableViewer(viewContentArea, (BeanPropertyReader.BeanAdapter)new TreeMapNodeBeanAdapter(), null, false, PropertyTableViewer.SelectionType.MULTI_FULL_LINE, 1000, true);
        this.m_textSearchProvider = new PropertyTableViewerBasedTextSearchHandler(this.m_infoView, this.getViewId().getPresentationName());
    }

    protected void createViewContent(Composite viewContentArea) {
        assert (viewContentArea != null) : "Parameter 'viewContentArea' of method 'createViewContent' must not be null";
        this.createDefaultViewer(viewContentArea);
        EventManager.getInstance().attach((EventHandler)new EventHandler<TreeMapModifiedEvent>(TreeMapModifiedEvent.class, (Object)this){

            public void handleEvent(TreeMapModifiedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'handleEvent' must not be null");
                }
                if (event.getFile() == TreeMapInfoView.this.m_file) {
                    TreeMapInfoView.this.showTreeMap((TreeMapRepresentation)TreeMapInfoView.this.m_file.getUniqueExistingChild(TreeMapRepresentation.class));
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<TreeMapUnloadedEvent>(TreeMapUnloadedEvent.class, (Object)this){

            public void handleEvent(TreeMapUnloadedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'handleEvent' must not be null");
                }
                if (TreeMapInfoView.this.canHandleEvent((SoftwareSystemProviderEvent)event)) {
                    SoftwareSystem system = TreeMapInfoView.this.getSoftwareSystem();
                    if (system != null && !((ITreeMapProvider)system.getExtension(ITreeMapProvider.class)).hasLoadedTreeMaps()) {
                        TreeMapInfoView.this.hideView();
                    } else if (event.getFile() == TreeMapInfoView.this.m_file) {
                        TreeMapInfoView.this.showTreeMap(null);
                    }
                }
            }
        });
        this.initialize();
    }

    protected void destroyViewContent() {
        EventManager.getInstance().detach(TreeMapModifiedEvent.class, (Object)this);
        EventManager.getInstance().detach(TreeMapUnloadedEvent.class, (Object)this);
        super.destroyViewContent();
    }

    public List<Control> getControlsForInteraction() {
        return Collections.singletonList(this.m_infoView.getTableViewer().getTable());
    }

    protected ITextSearchHandler getTextSearchHandler() {
        return this.m_textSearchProvider;
    }

    protected boolean canConnect(WorkbenchView view, boolean force) {
        assert (view != null) : "Parameter 'view' of method 'canConnect' must not be null";
        return view.getViewId().equals(ViewId.TREE_MAP_VIEW) && ((TreeMapView)view).getTreeMapRepresentation() != null;
    }

    private void removeListeners() {
        this.m_infoView.getTableViewer().removeSelectionChangedListener((ISelectionChangedListener)this);
    }

    private void addListeners() {
        this.m_infoView.getTableViewer().addSelectionChangedListener((ISelectionChangedListener)this);
    }

    private void showTreeMap(TreeMapRepresentation treeMap) {
        assert (this.m_infoView != null) : "Parameter 'm_propertyTableViewer' of method 'showTreeMap' must not be null";
        this.removeListeners();
        if (treeMap == null) {
            LOGGER.debug("No treemap - recreate default viewer");
            this.createDefaultViewer(this.m_infoView.getParent());
            this.m_namedElementToLeaf = null;
            this.m_file = null;
        } else if (treeMap != this.m_treeMap) {
            LOGGER.debug("Different treemap - recreate viewer");
            Composite contentArea = this.m_infoView.getParent();
            String sortedBy = this.m_infoView.getSortProperty();
            Boolean ascendingSort = this.m_infoView.isAscendingSort();
            this.m_infoView.dispose();
            this.m_infoView = null;
            this.m_namedElementToLeaf = null;
            this.m_treeMap = null;
            this.m_file = null;
            String sortProperty = COLOR_PROPERTY_NAME;
            boolean ascending = false;
            if (treeMap.getType() == TreeMapType.THREE_DIMENSIONAL || sortedBy == null || !sortedBy.equals("height")) {
                sortProperty = sortedBy != null ? sortedBy : sortProperty;
                ascending = ascendingSort != null ? ascendingSort : ascending;
            }
            this.m_infoView = new PagingPropertyTableViewer(contentArea, (BeanPropertyReader.BeanAdapter)new TreeMapNodeBeanAdapter(), null, false, PropertyTableViewer.SelectionType.MULTI_FULL_LINE, 1000, true);
            this.m_infoView.addColumn(treeMap.getLeafElement(), "element", "element", "image", 50, PropertyTableViewer.ColumnType.TEXT);
            this.m_infoView.addColumn(treeMap.getColorAttribute() + " (Color)", COLOR_PROPERTY_NAME, COLOR_PROPERTY_NAME, null, 15, PropertyTableViewer.ColumnType.NUMBER);
            ArrayList<StrictPair> sortProperties = new ArrayList<StrictPair>();
            sortProperties.add(new StrictPair((Object)COLOR_PROPERTY_NAME, (Object)false));
            if (treeMap.getType() == TreeMapType.THREE_DIMENSIONAL) {
                this.m_infoView.addColumn(treeMap.getHeightAttribute() + " (Height)", "height", "height", null, 20, PropertyTableViewer.ColumnType.NUMBER);
                sortProperties.add(new StrictPair((Object)"height", (Object)false));
            }
            this.m_infoView.addColumn(treeMap.getSizeAttribute() + " (Size)", "size", "size", null, 15, PropertyTableViewer.ColumnType.NUMBER);
            sortProperties.add(new StrictPair((Object)"size", (Object)false));
            sortProperties.add(new StrictPair((Object)"element", (Object)true));
            this.m_infoView.setSortOrder(sortProperties);
            this.m_infoView.setCellColorProvider((PropertyTableViewer.ICellColorProvider)new PropertyTableViewer.ICellColorProvider<TreeMapNode<NamedElement, TreeMapNodeData>>(){

                public Color getCellColor(PropertyTableViewer<TreeMapNode<NamedElement, TreeMapNodeData>> viewer, TreeMapNode<NamedElement, TreeMapNodeData> object, String propertyName) {
                    if (!propertyName.equals(TreeMapInfoView.COLOR_PROPERTY_NAME)) {
                        return null;
                    }
                    LeafNodeColor leafColor = ((TreeMapNodeData)object.getAssociatedData()).getLeafColor();
                    return UiResourceManager.getInstance().getTreeMapLeafColor(leafColor);
                }

                public Color getForeground(PropertyTableViewer<TreeMapNode<NamedElement, TreeMapNodeData>> viewer, TreeMapNode<NamedElement, TreeMapNodeData> object, String propertyName) {
                    if (propertyName.equals(TreeMapInfoView.COLOR_PROPERTY_NAME)) {
                        LeafNodeColor leafColor = ((TreeMapNodeData)object.getAssociatedData()).getLeafColor();
                        return UiResourceManager.getInstance().getForegroundForTreeMapLeafColor(leafColor);
                    }
                    return null;
                }
            });
            this.recreateElementInteractor();
            this.setPartName("Info for '" + treeMap.getParent().getShortName() + "'");
            LOGGER.debug("Showing info for treemap {} " + treeMap.getName());
            LOGGER.debug("Element: {}", (Object)treeMap.getLeafElement());
            LOGGER.debug("Size: {}", (Object)treeMap.getSizeAttribute());
            LOGGER.debug("Height: {}", (Object)treeMap.getHeightAttribute());
            LOGGER.debug("Color: {}", (Object)treeMap.getColorAttribute());
            LOGGER.debug("Get leafs");
            this.m_namedElementToLeaf = treeMap.getNamedElementToLeaf();
            LOGGER.debug("Get leafs - done [leafs: " + this.m_namedElementToLeaf.size() + "]");
            this.m_infoView.showData(this.m_namedElementToLeaf.values());
            this.m_infoView.getParent().layout(true, true);
            this.m_textSearchProvider = new PropertyTableViewerBasedTextSearchHandler(this.m_infoView, this.getViewId().getPresentationName());
            this.initializeTextSearchData();
            this.m_treeMap = treeMap;
            this.m_file = (TreeMapFile)this.m_treeMap.getParent(TreeMapFile.class, ParentMode.FIRST_PARENT);
        } else {
            LOGGER.debug("Same treemap - refresh");
            this.m_infoView.refresh();
        }
        this.addListeners();
    }

    protected void connect(WorkbenchView view) {
        super.connect(view);
        assert (view != null && view instanceof TreeMapView) : "Unexpected class in method 'connect': " + String.valueOf(view);
        if (this.isActive()) {
            this.showTreeMap(((TreeMapView)view).getTreeMapRepresentation());
        }
    }

    protected void disconnect() {
        WorkbenchView connectedTo = this.getConnectedView();
        assert (connectedTo != null && connectedTo instanceof TreeMapView) : "Unexpected class in method 'disconnect': " + String.valueOf(connectedTo);
        this.showTreeMap(null);
        super.disconnect();
    }

    protected void handleSelection(WorkbenchView connectedView, List<Element> elements) {
        assert (connectedView != null) : "Parameter 'connectedView' of method 'handleSelection' must not be null";
        assert (elements != null) : "Parameter 'elements' of method 'handleSelection' must not be null";
        assert (connectedView != null && connectedView instanceof TreeMapView) : "Unexpected class in method 'handleSelection': " + String.valueOf(connectedView);
        if (this.m_treeMap != null && this.m_treeMap == ((TreeMapView)connectedView).getTreeMapRepresentation()) {
            assert (this.m_namedElementToLeaf != null) : "'m_namedElementToLeaf' of method 'handleSelection' must not be null";
            LOGGER.debug("Handle selection: " + String.valueOf(elements));
            ArrayList<TreeMapNode<NamedElement, TreeMapNodeData>> leafs = new ArrayList<TreeMapNode<NamedElement, TreeMapNodeData>>();
            for (Element next : elements) {
                TreeMapNode<NamedElement, TreeMapNodeData> nextNode;
                if (!(next instanceof NamedElement) || (nextNode = this.m_namedElementToLeaf.get(next)) == null) continue;
                leafs.add(nextNode);
            }
            this.removeListeners();
            if (!leafs.isEmpty()) {
                this.m_infoView.select(new ArrayList(leafs));
            } else {
                this.m_infoView.getTableViewer().setSelection(null);
            }
            this.addListeners();
        }
    }

    public void finishShowInView(IViewId sourceViewId, List<Element> elements, List<IStandardEnumeration> options) {
        Element element;
        assert (elements != null) : "Parameter 'elements' of method 'finishShowInView' must not be null";
        LOGGER.debug("Finish show in view: " + String.valueOf(elements));
        if (elements.size() == 1 && (element = elements.get(0)) instanceof TreeMapRepresentation) {
            this.showTreeMap((TreeMapRepresentation)element);
        }
    }

    public List<Element> getSelectedElements() {
        if (this.m_infoView != null && !this.m_infoView.isDisposed()) {
            List selections = this.m_infoView.getSelected();
            List<Element> selected = selections.stream().map(node -> (NamedElement)node.getAssociatedElement()).collect(Collectors.toList());
            return selected;
        }
        return Collections.emptyList();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        assert (event != null) : "Parameter 'event' of method 'selectionChanged' must not be null";
        this.removeListeners();
        List<Element> selectedElements = this.getSelectedElements();
        NavigationState state = ViewNavigationManager.getInstance().createNavigationState(this.getViewId(), this.getSecondaryId(), NavigationState.Type.CONTENT_SELECTED);
        this.addStateInfo(state);
        ViewNavigationManager.getInstance().addNavigationState(state);
        this.getSelectionProviderAdapter().handleSelectionChanged(selectedElements);
        WorkbenchView connectedView = this.getConnectedView();
        if (connectedView != null && connectedView instanceof TreeMapView) {
            TreeMapView treeMapView = (TreeMapView)connectedView;
            treeMapView.selectNodes(this.m_infoView.getSelected());
        }
        this.addListeners();
    }

    protected void performRestoreNavigationState(NavigationState state, boolean viewCreated) {
        assert (state != null) : "Parameter 'state' of method 'restoreState' must not be null";
        this.getContentArea().setRedraw(false);
        WorkbenchView connectedView = this.getConnectedView();
        if (connectedView != null) {
            TreeMapRepresentation treeMapRepresentation = ((TreeMapView)connectedView).getTreeMapRepresentation();
        }
        this.getContentArea().setRedraw(true);
    }

    private void addStateInfo(NavigationState state) {
        assert (state != null) : "Parameter 'state' of method 'addStateInfo' must not be null";
        List tableSelection = this.getSelectedElements().stream().filter(e -> e instanceof NamedElement).map(e -> (NamedElement)e).collect(Collectors.toList());
        state.addElementsInformation((IElementGroup)ElementGroups.TABLE_SELECTION, NavigationState.getDescriptors(tableSelection, (IElementResolver)this.getElementResolver()));
    }

    public void completeViewNavigationState(NavigationState state) {
        assert (state != null) : "Parameter 'state' of method 'createNavigationStateForFocusGained' must not be null";
        this.addStateInfo(state);
    }

    public boolean supportsCopy() {
        return !this.getSelectedElements().isEmpty();
    }

    public String copy() {
        return this.m_infoView != null ? this.m_infoView.getCopyToClipboardData() : null;
    }

    public boolean supportsExcelExport() {
        return this.m_treeMap != null && this.m_infoView != null && !this.m_infoView.isDisposed() && !this.m_infoView.getFilteredInputData().isEmpty();
    }

    public String getExcelExportContentName() {
        return this.m_treeMap.getParent().getPresentationName(true);
    }

    public List<ExportData> getExportData(IWorkerContext workerContext) {
        return ((IExportProvider)this.getSoftwareSystemProvider().getInstallation().getExtension(IExportProvider.class)).getLeafElementData(this.m_treeMap, this.m_infoView.getFilteredInputData());
    }

    private static enum ElementGroups implements IElementGroup
    {
        TABLE_SELECTION;

    }
}

