/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.treemap;

import com.hello2morrow.sonargraph.core.foundation.common.treemap.TreeMapNode;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.treemap.TreeMapNodeData;
import com.hello2morrow.sonargraph.ui.standalone.treemap.CanvasImageData;
import com.hello2morrow.sonargraph.ui.standalone.treemap.ChunkWorkerThread;
import com.hello2morrow.sonargraph.ui.standalone.treemap.Draw3DWorkerThread;
import com.hello2morrow.sonargraph.ui.standalone.treemap.Matrix;
import com.hello2morrow.sonargraph.ui.standalone.treemap.PixelInfo;
import com.hello2morrow.sonargraph.ui.standalone.treemap.PixelInfo3D;
import com.hello2morrow.sonargraph.ui.standalone.treemap.TreeMapCuboid;
import com.hello2morrow.sonargraph.ui.standalone.treemap.TreeMapNodeView;
import com.hello2morrow.sonargraph.ui.standalone.treemap.Triangle;
import com.hello2morrow.sonargraph.ui.standalone.treemap.Vertex;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CanvasImageData3D
extends CanvasImageData {
    private static final Logger LOGGER = LoggerFactory.getLogger(CanvasImageData3D.class);
    private static final int INITIALIZE_CHUNKS = 16;
    private static final int DOWNSCALE_CHUNKS = 10;
    private static final int UPDATE_COLORS_CHUNKS = 10;
    private static final int CUBOIDS_CHUNK_SIZE = 1000;
    private static final int FACTOR = 3;
    private static final int SAMPLE_LENGTH = 9;
    private final IInfoProvider3D m_provider;
    private final Point m_bufferSize;
    private final PixelInfo3D[] m_pixelInfo;
    private final ImageData m_imageData;
    private final RGB[][] m_sample = new RGB[10][9];

    CanvasImageData3D(IInfoProvider3D provider, Point size) {
        assert (provider != null) : "Parameter 'provider' of method 'CanvasImageData3D' must not be null";
        assert (size != null) : "Parameter 'size' of method 'CanvasImageData' must not be null";
        long start = System.currentTimeMillis();
        LOGGER.debug("Initialize 3D data");
        this.m_provider = provider;
        this.m_pixelInfo = new PixelInfo3D[size.x * 3 * size.y * 3];
        this.m_bufferSize = new Point(size.x * 3, size.y * 3);
        this.m_imageData = new ImageData(size.x, size.y, 24, PixelInfo.PALETTE_DATA);
        ArrayList<ChunkWorkerThread> workers = new ArrayList<ChunkWorkerThread>(16);
        int chunks = 8;
        int chunkSize = (int)Math.ceil((double)this.m_pixelInfo.length / 8.0);
        int from = 0;
        int to = Math.min(this.m_pixelInfo.length, chunkSize);
        int c = 0;
        while (c < 8) {
            workers.add(new ChunkWorkerThread(c, from, to, (chunkIndex, i) -> {
                this.m_pixelInfo[i] = new PixelInfo3D();
            }));
            from += chunkSize;
            to = Math.min(to + chunkSize, this.m_pixelInfo.length);
            ++c;
        }
        chunkSize = (int)Math.ceil((double)this.m_imageData.width / 8.0);
        from = 0;
        to = Math.min(this.m_imageData.width, chunkSize);
        c = 0;
        while (c < 8) {
            workers.add(new ChunkWorkerThread(c, from, to, (chunkIndex, x) -> {
                int y = 0;
                while (y < this.m_imageData.height) {
                    this.m_imageData.setPixel(x, y, PixelInfo.BACKGROUND_PIXEL_VALUE);
                    ++y;
                }
            }));
            from += chunkSize;
            to = Math.min(to + chunkSize, this.m_imageData.width);
            ++c;
        }
        ExecutorService executorService = Executors.newCachedThreadPool();
        workers.forEach(w -> executorService.execute((Runnable)w));
        executorService.shutdown();
        try {
            executorService.awaitTermination(1L, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            LOGGER.error("Exception in 'awaitTermination'", (Throwable)e);
        }
        LOGGER.debug("Initialize 3D data - done [" + (System.currentTimeMillis() - start) + " ms]");
    }

    @Override
    void reInitialize() {
        long start = System.currentTimeMillis();
        LOGGER.debug("Re-initialize 3D data");
        ArrayList<ChunkWorkerThread> workers = new ArrayList<ChunkWorkerThread>(16);
        int chunks = 8;
        int chunkSize = (int)Math.ceil((double)this.m_pixelInfo.length / 8.0);
        int from = 0;
        int to = Math.min(this.m_pixelInfo.length, chunkSize);
        int c = 0;
        while (c < 8) {
            workers.add(new ChunkWorkerThread(c, from, to, (chunkIndex, i) -> this.m_pixelInfo[i].reset()));
            from += chunkSize;
            to = Math.min(to + chunkSize, this.m_pixelInfo.length);
            ++c;
        }
        chunkSize = (int)Math.ceil((double)this.m_imageData.width / 8.0);
        from = 0;
        to = Math.min(this.m_imageData.width, chunkSize);
        c = 0;
        while (c < 8) {
            workers.add(new ChunkWorkerThread(c, from, to, (chunkIndex, x) -> {
                int y = 0;
                while (y < this.m_imageData.height) {
                    this.m_imageData.setPixel(x, y, PixelInfo.BACKGROUND_PIXEL_VALUE);
                    ++y;
                }
            }));
            from += chunkSize;
            to = Math.min(to + chunkSize, this.m_imageData.width);
            ++c;
        }
        ExecutorService executorService = Executors.newCachedThreadPool();
        workers.forEach(w -> executorService.execute((Runnable)w));
        executorService.shutdown();
        try {
            executorService.awaitTermination(1L, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            LOGGER.error("Exception in 'awaitTermination'", (Throwable)e);
        }
        LOGGER.debug("Re-initialize 3D data - done [" + (System.currentTimeMillis() - start) + " ms]");
    }

    @Override
    Point getTreeMapNodeViewLocation(Point location) {
        assert (location != null) : "Parameter 'location' of method 'getPixelInfoIndex' must not be null";
        int y = location.y * 3;
        int x = location.x * 3;
        int index = y * this.m_bufferSize.x + x;
        return index >= 0 && index < this.m_pixelInfo.length ? new Point(x, y) : null;
    }

    @Override
    public TreeMapNodeView getTreeMapNodeView(int x, int y) {
        return this.m_pixelInfo[y * this.m_bufferSize.x + x].getView();
    }

    @Override
    ImageData getImageData() {
        return this.m_imageData;
    }

    @Override
    boolean needsReCreation(Point size, boolean requires3D) {
        assert (size != null) : "Parameter 'size' of method 'needsReCreation' must not be null";
        return this.m_imageData.width != size.x || this.m_imageData.height != size.y || !requires3D;
    }

    private double calculateFoV(Matrix transform, int modelWidth, int modelHeight, int targetWidth, int targetHeight, double aspectRatio, double zNear, double zFar, double scaleX, double scaleY, double halfWidth, double halfHeight) {
        Vertex v = new Vertex(0.0, 0.0, 0.0);
        Vertex x = new Vertex(modelWidth, 0.0, 0.0);
        Vertex y = new Vertex(0.0, modelHeight, 0.0);
        double currentDiffX = Double.POSITIVE_INFINITY;
        double currentAngleX = 0.0;
        double currentDiffY = Double.POSITIVE_INFINITY;
        double currentAngleY = 0.0;
        boolean finishedX = false;
        boolean finishedY = false;
        int i = 900;
        while (i > 19) {
            double nextAngle = (double)i * 0.1;
            Matrix p = Matrix.createPerspectiveMatrix(aspectRatio, Math.toRadians(nextAngle), zNear, zFar);
            Vertex vt = transform.createTransformed(v);
            Vertex xt = transform.createTransformed(x);
            Vertex yt = transform.createTransformed(y);
            CanvasImageData3D.applyProjection(vt, p, scaleX, scaleY, halfWidth, halfHeight);
            CanvasImageData3D.applyProjection(xt, p, scaleX, scaleY, halfWidth, halfHeight);
            CanvasImageData3D.applyProjection(yt, p, scaleX, scaleY, halfWidth, halfHeight);
            double lengthX = Math.sqrt(Math.pow(Math.abs(xt.x - vt.x), 2.0));
            double nextDiffX = Math.abs((double)targetWidth - lengthX);
            if (nextDiffX < currentDiffX) {
                currentDiffX = nextDiffX;
                currentAngleX = nextAngle;
            } else {
                finishedX = true;
            }
            double lengthY = Math.sqrt(Math.pow(Math.abs(yt.y - vt.y), 2.0));
            double nextDiffY = Math.abs((double)targetHeight - lengthY);
            if (nextDiffY < currentDiffY) {
                currentDiffY = nextDiffY;
                currentAngleY = nextAngle;
            } else {
                finishedY = true;
            }
            if (finishedX && finishedY) break;
            --i;
        }
        double angle = Math.max(currentAngleX, currentAngleY);
        return Math.toRadians(angle);
    }

    private void downscale() {
        long start = System.currentTimeMillis();
        LOGGER.debug("Downscale");
        ArrayList<ChunkWorkerThread> workers = new ArrayList<ChunkWorkerThread>(10);
        int chunkSize = (int)Math.ceil((double)this.m_imageData.height / 10.0);
        int from = 0;
        int to = Math.min(this.m_imageData.height, chunkSize);
        int c = 0;
        while (c < 10) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("[" + c + "] 'from' ... 'to': " + from + " ... " + to + " (chunkSize=" + chunkSize + ", imageData.height=" + this.m_imageData.height + ")");
            }
            workers.add(new ChunkWorkerThread(c, from, to, (chunkIndex, y) -> {
                int x = 0;
                while (x < this.m_imageData.width) {
                    boolean needsAverage = false;
                    RGB rgb = null;
                    int rgbIndex = 0;
                    int sampleOffsetY = 0;
                    while (sampleOffsetY < 3) {
                        int rgbBufferY = y * 3 + sampleOffsetY;
                        int sampleOffsetX = 0;
                        while (sampleOffsetX < 3) {
                            RGB nextRGB;
                            this.m_sample[chunkIndex][rgbIndex] = nextRGB = this.m_pixelInfo[rgbBufferY * this.m_bufferSize.x + (x * 3 + sampleOffsetX)].getRGB();
                            ++rgbIndex;
                            if (rgb != null) {
                                needsAverage = rgb != nextRGB;
                            } else {
                                rgb = nextRGB;
                            }
                            ++sampleOffsetX;
                        }
                        ++sampleOffsetY;
                    }
                    if (needsAverage) {
                        int red = 0;
                        int green = 0;
                        int blue = 0;
                        int i = 0;
                        while (i < 9) {
                            RGB next = this.m_sample[chunkIndex][i];
                            red += next.red * next.red;
                            green += next.green * next.green;
                            blue += next.blue * next.blue;
                            ++i;
                        }
                        int redAverage = (int)Math.round(Math.sqrt((double)red / 9.0));
                        int greenAverage = (int)Math.round(Math.sqrt((double)green / 9.0));
                        int blueAverage = (int)Math.round(Math.sqrt((double)blue / 9.0));
                        RGB average = new RGB(redAverage, greenAverage, blueAverage);
                        this.m_imageData.setPixel(x, y, PixelInfo.PALETTE_DATA.getPixel(average));
                    } else if (rgb != PixelInfo.BACKGROUND_RGB) {
                        this.m_imageData.setPixel(x, y, PixelInfo.PALETTE_DATA.getPixel(rgb));
                    }
                    ++x;
                }
            }));
            if (to >= this.m_imageData.height) break;
            from += chunkSize;
            to = Math.min(to + chunkSize, this.m_imageData.height);
            ++c;
        }
        ExecutorService executorService = Executors.newCachedThreadPool();
        workers.forEach(w -> executorService.execute((Runnable)w));
        executorService.shutdown();
        try {
            executorService.awaitTermination(1L, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            LOGGER.error("Exception in 'awaitTermination'", (Throwable)e);
        }
        LOGGER.debug("Downscale - done [" + (System.currentTimeMillis() - start) + " ms]");
    }

    private static void applyProjection(Vertex vertex, Matrix matrix, double scaleX, double scaleY, double halfWidth, double halfHeight) {
        assert (vertex != null) : "Parameter 'vertex' of method 'applyProjection' must not be null";
        assert (matrix != null) : "Parameter 'matrix' of method 'applyProjection' must not be null";
        matrix.transform(vertex);
        if (vertex.w != 0.0) {
            vertex.x /= vertex.w;
            vertex.y /= vertex.w;
            vertex.z /= vertex.w;
        }
        vertex.x *= scaleX;
        vertex.y *= scaleY;
        vertex.x += halfWidth;
        vertex.y = halfHeight - vertex.y;
    }

    @Override
    void createImageData(Rectangle monitorBounds, TreeMapNode<NamedElement, TreeMapNodeData> root, List<? extends TreeMapNodeView> nodeViews, Point translation, boolean isAutoResizeEnabled, boolean greyNonSelected) {
        assert (monitorBounds != null) : "Parameter 'monitorBounds' of method 'createImageData' must not be null";
        assert (root != null) : "Parameter 'root' of method 'createImageData' must not be null";
        assert (nodeViews != null && !nodeViews.isEmpty()) : "Parameter 'nodeViews' of method 'createImageData' must not be empty";
        assert (translation != null) : "Parameter 'translation' of method 'createImageData' must not be null";
        long start = System.currentTimeMillis();
        LOGGER.debug("Create image data");
        double scaleX = (double)monitorBounds.width / 2.0;
        double scaleY = (double)monitorBounds.height / 2.0;
        double aspectRatio = (double)monitorBounds.height / (double)monitorBounds.width;
        double zNear = this.m_provider.getModelWorldOffsetZ3D();
        double zFar = zNear + (double)this.m_provider.getModelWorldDepth3d();
        Matrix matrix = this.m_provider.getMoveModelMatrix3d();
        matrix = matrix.createdMultiplied(Matrix.createAxisXRotationMatrix(Math.toRadians(this.m_provider.getRotateUpDown3d())));
        matrix = matrix.createdMultiplied(Matrix.createAxisYRotationMatrix(Math.toRadians(this.m_provider.getRotateLeftRight3d())));
        Matrix transform = matrix = matrix.createdMultiplied(this.m_provider.getCenterModelMatrix3d());
        double fovRadians3d = this.m_provider.getFovRadians3d();
        if (isAutoResizeEnabled) {
            fovRadians3d = this.calculateFoV(transform, root.getWidth(), this.m_provider.getModelHeight3D(), this.m_bufferSize.x - 6, this.m_bufferSize.y - 6, aspectRatio, zNear, zFar, scaleX, scaleY, (double)this.m_bufferSize.x / 2.0, (double)this.m_bufferSize.y / 2.0);
            this.m_provider.setFovRadians3d(fovRadians3d);
        }
        Matrix project = Matrix.createPerspectiveMatrix(aspectRatio, fovRadians3d, zNear, zFar);
        double halfWidth = (double)this.m_bufferSize.x / 2.0;
        double halfHeight = (double)this.m_bufferSize.y / 2.0;
        int from = 0;
        int to = 1000;
        ArrayList<Draw3DWorkerThread> workers = new ArrayList<Draw3DWorkerThread>();
        do {
            List<? extends TreeMapNodeView> nextNodeViews = nodeViews.subList(from, Math.min(to, nodeViews.size() - 1));
            workers.add(new Draw3DWorkerThread(nextNodeViews, views -> {
                for (TreeMapNodeView nextView : views) {
                    assert (nextView instanceof TreeMapCuboid) : "Unexpected class in method 'createImage': " + String.valueOf(nextView);
                    RGB nextRGB = nextView.getRGB(greyNonSelected);
                    Triangle[] triangleArray = ((TreeMapCuboid)nextView).getTriangles();
                    int n = triangleArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Triangle nextTriangle = triangleArray[n2];
                        Vertex v1 = transform.createTransformed(nextTriangle.v1);
                        Vertex v2 = transform.createTransformed(nextTriangle.v2);
                        Vertex v3 = transform.createTransformed(nextTriangle.v3);
                        Vertex edge1 = new Vertex(v2.x - v1.x, v2.y - v1.y, v2.z - v1.z);
                        Vertex edge2 = new Vertex(v3.x - v2.x, v3.y - v2.y, v3.z - v2.z);
                        Vertex norm = new Vertex(edge1.y * edge2.z - edge1.z * edge2.y, edge1.z * edge2.x - edge1.x * edge2.z, edge1.x * edge2.y - edge1.y * edge2.x);
                        double normalLength = Math.sqrt(norm.x * norm.x + norm.y * norm.y + norm.z * norm.z);
                        norm.x /= normalLength;
                        norm.y /= normalLength;
                        norm.z /= normalLength;
                        nextTriangle.angle = Math.abs(norm.z);
                        CanvasImageData3D.applyProjection(v1, project, scaleX, scaleY, halfWidth, halfHeight);
                        CanvasImageData3D.applyProjection(v2, project, scaleX, scaleY, halfWidth, halfHeight);
                        CanvasImageData3D.applyProjection(v3, project, scaleX, scaleY, halfWidth, halfHeight);
                        v1.x += (double)point.x;
                        v1.y += (double)point.y;
                        v2.x += (double)point.x;
                        v2.y += (double)point.y;
                        v3.x += (double)point.x;
                        v3.y += (double)point.y;
                        int minX = (int)Math.max(0.0, Math.ceil(Math.min(v1.x, Math.min(v2.x, v3.x))));
                        int maxX = (int)Math.min((double)(this.m_bufferSize.x - 1), Math.floor(Math.max(v1.x, Math.max(v2.x, v3.x))));
                        int minY = (int)Math.max(0.0, Math.ceil(Math.min(v1.y, Math.min(v2.y, v3.y))));
                        int maxY = (int)Math.min((double)(this.m_bufferSize.y - 1), Math.floor(Math.max(v1.y, Math.max(v2.y, v3.y))));
                        RGB nextPixelRGB = null;
                        double triangleArea = (v1.y - v3.y) * (v2.x - v3.x) + (v2.y - v3.y) * (v3.x - v1.x);
                        int y = minY;
                        while (y <= maxY) {
                            int x = minX;
                            while (x <= maxX) {
                                double b3;
                                double b2;
                                double b1 = (((double)y - v3.y) * (v2.x - v3.x) + (v2.y - v3.y) * (v3.x - (double)x)) / triangleArea;
                                if (b1 >= 0.0 && b1 <= 1.0 && (b2 = (((double)y - v1.y) * (v3.x - v1.x) + (v3.y - v1.y) * (v1.x - (double)x)) / triangleArea) >= 0.0 && b2 <= 1.0 && (b3 = (((double)y - v2.y) * (v1.x - v2.x) + (v1.y - v2.y) * (v2.x - (double)x)) / triangleArea) >= 0.0 && b3 <= 1.0) {
                                    double depth = b1 * v1.z + b2 * v2.z + b3 * v3.z;
                                    PixelInfo3D nextInfo = this.m_pixelInfo[y * this.m_bufferSize.x + x];
                                    if (nextInfo.getDepth() > depth) {
                                        if (nextPixelRGB == null) {
                                            nextPixelRGB = Triangle.createShadedRGB(nextRGB, nextTriangle.angle);
                                        }
                                        this.m_pixelInfo[y * this.m_bufferSize.x + x].setRGB(nextPixelRGB);
                                        nextInfo.setData(nextView, depth, nextTriangle);
                                    }
                                }
                                ++x;
                            }
                            ++y;
                        }
                        ++n2;
                    }
                }
            }));
            to += 1000;
        } while ((from += 1000) < nodeViews.size() - 1);
        ExecutorService executorService = Executors.newCachedThreadPool();
        workers.forEach(w -> executorService.execute((Runnable)w));
        executorService.shutdown();
        try {
            executorService.awaitTermination(1L, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            LOGGER.error("Exception in 'awaitTermination'", (Throwable)e);
        }
        LOGGER.debug("Create image data - done [" + (System.currentTimeMillis() - start) + " ms]");
        this.downscale();
    }

    @Override
    void updateColors(boolean greyNonSelected) {
        long start = System.currentTimeMillis();
        LOGGER.debug("Update colors");
        ArrayList<ChunkWorkerThread> workers = new ArrayList<ChunkWorkerThread>(10);
        int chunkSize = (int)Math.ceil((double)this.m_bufferSize.y / 10.0);
        int from = 0;
        int to = Math.min(this.m_bufferSize.y, chunkSize);
        int c = 0;
        while (c < 10) {
            workers.add(new ChunkWorkerThread(c, from, to, (chunkIndex, y) -> {
                int x = 0;
                while (x < this.m_bufferSize.x) {
                    PixelInfo3D nextInfo = this.m_pixelInfo[y * this.m_bufferSize.x + x];
                    TreeMapNodeView nextView = nextInfo.getView();
                    if (nextView != null) {
                        Triangle nextTriangle = nextInfo.getTriangle();
                        assert (nextTriangle != null) : "'nextTriangle' of method 'createImage' must not be null";
                        assert (nextTriangle.angle != Double.NEGATIVE_INFINITY) : "'nextEntry.triangle.angle' of method 'createImage' not set";
                        this.m_pixelInfo[y * this.m_bufferSize.x + x].setRGB(Triangle.createShadedRGB(nextView.getRGB(greyNonSelected), nextTriangle.angle));
                    }
                    ++x;
                }
            }));
            from += chunkSize;
            to = Math.min(to + chunkSize, this.m_bufferSize.y);
            ++c;
        }
        ExecutorService executorService = Executors.newCachedThreadPool();
        workers.forEach(w -> executorService.execute((Runnable)w));
        executorService.shutdown();
        try {
            executorService.awaitTermination(1L, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            LOGGER.error("Exception in 'awaitTermination'", (Throwable)e);
        }
        LOGGER.debug("Update colors - done [" + (System.currentTimeMillis() - start) + " ms]");
        this.downscale();
    }

    static interface IInfoProvider3D {
        public int getModelWorldOffsetZ3D();

        public int getModelWorldDepth3d();

        public int getModelHeight3D();

        public Matrix getMoveModelMatrix3d();

        public int getRotateUpDown3d();

        public int getRotateLeftRight3d();

        public Matrix getCenterModelMatrix3d();

        public double getFovRadians3d();

        public void setFovRadians3d(double var1);
    }
}

