/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.sonargraphenterprise;

import com.hello2morrow.sonargraph.core.model.enterprise.IConnectionValidator;
import com.hello2morrow.sonargraph.core.model.enterprise.ISonargraphEnterpriseProvider;
import com.hello2morrow.sonargraph.core.model.enterprise.SonargraphEnterpriseConnection;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.settings.ISettingsDelta;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.ui.standalone.base.preferencepage.StandardPreferencePage;
import com.hello2morrow.sonargraph.ui.standalone.base.workbench.CoreDialogId;
import com.hello2morrow.sonargraph.ui.standalone.sonargraphenterprise.SonargraphEnterpriseConnectionWidget;
import com.hello2morrow.sonargraph.ui.standalone.sonargraphenterprise.SonargraphEnterprisePreferenceProvider;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public final class SonargraphEnterpriseConnectionPreferencePage
extends StandardPreferencePage
implements ISettingsDelta {
    private final SonargraphEnterprisePreferenceProvider m_prefProvider;
    private final IConnectionValidator m_connectionValidator;
    private SonargraphEnterpriseConnectionWidget m_connectionWidget;

    public SonargraphEnterpriseConnectionPreferencePage() {
        super("Sonargraph-Enterprise Connection Preferences");
        this.noDefaultAndApplyButton();
        this.m_prefProvider = new SonargraphEnterprisePreferenceProvider();
        Installation installation = WorkbenchRegistry.getInstance().getProvider().getInstallation();
        ISonargraphEnterpriseProvider enterpriseExtension = (ISonargraphEnterpriseProvider)installation.getExtension(ISonargraphEnterpriseProvider.class);
        this.m_connectionValidator = enterpriseExtension.getConnectionValidator();
    }

    @Override
    public IDialogId getDialogId() {
        return CoreDialogId.SONARGRAPH_ENTERPRISE_CONNECTION_PAGE;
    }

    @Override
    protected Composite createPageContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)SwtUtility.createSingleRootWidgetGridLayoutWithoutMargin());
        this.m_connectionWidget = new SonargraphEnterpriseConnectionWidget(container, this.m_connectionValidator, new SonargraphEnterpriseConnectionWidget.ICallback(){

            @Override
            public void hasChanged(boolean isValid, boolean isModified) {
                SonargraphEnterpriseConnectionPreferencePage.this.handleButtons(isValid, isModified);
            }
        });
        this.m_connectionWidget.setLayoutData(new GridData(4, 4, true, true));
        this.createButtonsPart(container, false);
        this.m_connectionWidget.init(this.m_prefProvider.loadConnectionData());
        return container;
    }

    private void handleButtons(boolean isValid, boolean isModified) {
        this.getApplyButton().setEnabled(isModified && isValid);
        this.getCancelButton().setEnabled(this.isModified());
    }

    public boolean hasValidData() {
        return this.m_connectionWidget.isValid();
    }

    @Override
    protected ISettingsDelta getDelta() {
        return this;
    }

    @Override
    protected OperationResult getOperationResult() {
        return null;
    }

    @Override
    protected boolean okToLeavePageWithErrors() {
        return true;
    }

    @Override
    protected void cancel() {
        this.handleButtons(this.m_connectionWidget.isValid(), this.m_connectionWidget.isModified());
        this.m_connectionWidget.reset();
    }

    @Override
    protected void internPerformOk() {
        SonargraphEnterpriseConnection connection = this.m_connectionWidget.getSonargraphConnection();
        this.m_prefProvider.saveConnectionData(connection.getServer(), connection.getPort(), connection.getClientKey(), connection.useProxy());
        this.m_connectionWidget.init(connection);
    }

    public void setVisible(boolean visible) {
        if (!this.m_connectionWidget.isDisposed()) {
            this.m_connectionWidget.getParent().layout(true, true);
            if (visible) {
                this.m_connectionWidget.updateProxySettings();
            }
        }
        super.setVisible(visible);
    }

    public boolean isModified() {
        return this.m_connectionWidget.isModified();
    }

    public void reset() {
        this.m_connectionWidget.reset();
    }
}

