/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.softwaresystemview;

import com.hello2morrow.sonargraph.foundation.utilities.NumberUtility;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;

public class StackedBarWidget
extends Composite
implements PaintListener,
DisposeListener {
    private static final int PART_SEPARATOR_WIDTH = 1;
    private static final int MINIMUM_PART_WIDTH = 2;
    private final List<BarPartInfo> m_parts = new ArrayList<BarPartInfo>();
    private final ValueType m_valueType;
    private final String m_name;

    public StackedBarWidget(Composite parent, int style, ValueType type, String name) {
        super(parent, style);
        assert (type != null) : "Parameter 'type' of method 'StackedBarWidget' must not be null";
        assert (name != null) : "Parameter 'name' of method 'StackedBarWidget' must not be null";
        this.m_valueType = type;
        this.m_name = name;
        this.addPaintListener(this);
        this.addDisposeListener(this);
    }

    public void paintControl(PaintEvent event) {
        Rectangle clientArea = this.getClientArea();
        if (this.m_parts.isEmpty()) {
            this.drawPart(event, clientArea.x, clientArea.y, clientArea.width, clientArea.height, this.getBackground());
            return;
        }
        int nonEmptyParts = 0;
        for (BarPartInfo next : this.m_parts) {
            if (Float.compare(next.getValue().floatValue(), 0.0f) == 0) continue;
            ++nonEmptyParts;
        }
        if (nonEmptyParts == 0) {
            this.drawPart(event, clientArea.x, clientArea.y, clientArea.width, clientArea.height, this.getBackground());
            return;
        }
        int pixelsForBorder = (nonEmptyParts - 1) * 1;
        ArrayList<StrictPair> widths = new ArrayList<StrictPair>(this.m_parts.size());
        int biggest = 0;
        int indexOfBiggest = 0;
        int availableWidth = clientArea.width;
        int totalWidth = pixelsForBorder;
        float sumOfValues = this.m_parts.stream().map(p -> Float.valueOf(p.getValue().floatValue())).reduce(Float.valueOf(0.0f), Float::sum).floatValue();
        int i = 0;
        while (i < this.m_parts.size()) {
            BarPartInfo barPartInfo = this.m_parts.get(i);
            float value = barPartInfo.getValue().floatValue();
            int partWidth = (int)(value * (float)availableWidth / sumOfValues);
            if (partWidth == 0 && Float.compare(value, 0.005f) > 0) {
                partWidth = 2;
            }
            if (partWidth > biggest) {
                biggest = partWidth;
                indexOfBiggest = i;
            }
            totalWidth += partWidth;
            widths.add(new StrictPair((Object)partWidth, (Object)barPartInfo));
            ++i;
        }
        int x = 0;
        int i2 = 0;
        while (i2 < widths.size()) {
            StrictPair pair = (StrictPair)widths.get(i2);
            int width = (Integer)pair.getFirst();
            if (width != 0) {
                if (i2 == indexOfBiggest) {
                    int diff = totalWidth - availableWidth;
                    width -= diff;
                }
                this.drawPart(event, x, clientArea.y, width, clientArea.height, ((BarPartInfo)pair.getSecond()).getColor());
                x += width + 1;
            }
            ++i2;
        }
    }

    protected void setPartInfos(List<BarPartInfo> parts, boolean update) {
        assert (parts != null && !parts.isEmpty()) : "Parameter 'parts' of method 'setPercentages' must not be empty";
        if (Objects.equals(parts, this.m_parts)) {
            return;
        }
        this.m_parts.clear();
        this.m_parts.addAll(parts);
        this.setToolTipText(this.createTooltipText(parts));
        if (update) {
            this.redraw();
        }
    }

    public void setPartInfos(List<BarPartInfo> parts) {
        this.setPartInfos(parts, true);
    }

    private String createTooltipText(List<BarPartInfo> parts) {
        String toolTip = parts.stream().filter(p -> p.isContributesToTooltip()).map(p -> p.toToolTip(this.m_valueType)).collect(Collectors.joining("\n"));
        return toolTip;
    }

    private void drawPart(PaintEvent event, int x, int y, int width, int height, Color color) {
        assert (event != null) : "Parameter 'event' of method 'drawPart' must not be null";
        assert (color != null) : "Parameter 'color' of method 'drawPart' must not be null";
        if (width == 0) {
            return;
        }
        event.gc.setBackground(color);
        event.gc.fillRectangle(x, y, width, height);
    }

    public void layout() {
        super.layout();
    }

    public void layout(boolean changed) {
        super.layout(changed);
    }

    public void reset() {
        if (!this.m_parts.isEmpty()) {
            this.m_parts.clear();
            this.update();
        }
    }

    public void widgetDisposed(DisposeEvent event) {
        this.m_parts.clear();
        this.removeDisposeListener(this);
        this.removePaintListener(this);
    }

    public String toString() {
        return this.m_name + " parts: " + this.m_parts.stream().map(p -> p.toString()).collect(Collectors.joining(", "));
    }

    public static class BarPartInfo {
        private final String m_name;
        private final Number m_value;
        private final Color m_color;
        private final String m_colorText;
        private final boolean m_contributesToTooltip;
        private Number m_asPercent;

        public BarPartInfo(String name, Number value, Color color, String colorText, boolean contributesToTooltip) {
            assert (name != null && name.length() > 0) : "Parameter 'name' of method 'BarPartInfo' must not be empty";
            assert (color != null) : "Parameter 'color' of method 'BarPartInfo' must not be null";
            assert (colorText != null && colorText.length() > 0) : "Parameter 'colorText' of method 'BarPartInfo' must not be empty";
            this.m_name = name;
            this.m_value = value;
            this.m_color = color;
            this.m_colorText = colorText;
            this.m_contributesToTooltip = contributesToTooltip;
        }

        public BarPartInfo(String name, Number value, Number asPercent, Color color, String colorText, boolean contributesToTooltip) {
            this(name, value, color, colorText, contributesToTooltip);
            assert (asPercent != null) : "Parameter 'asPercent' of method 'BarPartInfo' must not be null";
            this.m_asPercent = asPercent;
        }

        public String getName() {
            return this.m_name;
        }

        public Color getColor() {
            return this.m_color;
        }

        public Number getValue() {
            return this.m_value;
        }

        public String toToolTip(ValueType type) {
            StringBuilder text = new StringBuilder();
            text.append(NumberUtility.format((Number)this.m_value));
            if (type == ValueType.PERCENT) {
                text.append("%");
            } else if (type == ValueType.NUMERIC_AND_PERCENT) {
                assert (this.m_asPercent != null) : "Parameter 'm_percent' of method 'toToolTip' must not be null";
                text.append(" (").append(NumberUtility.format((Number)this.m_asPercent)).append("%) ").append(this.m_name);
            } else {
                text.append(" ").append(this.m_name);
            }
            text.append(" (").append(this.m_colorText).append(")");
            return text.toString();
        }

        public boolean isContributesToTooltip() {
            return this.m_contributesToTooltip;
        }

        public int hashCode() {
            return Objects.hash(this.m_asPercent, this.m_name, this.m_value);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BarPartInfo other = (BarPartInfo)obj;
            return Objects.equals(this.m_asPercent, other.m_asPercent) && Objects.equals(this.m_name, other.m_name) && Objects.equals(this.m_value, other.m_value);
        }

        public String toString() {
            return this.m_name + ": " + this.m_value;
        }
    }

    public static enum ValueType {
        NUMERIC,
        PERCENT,
        NUMERIC_AND_PERCENT;

    }
}

