/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.softwaresystemview;

import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import java.util.Collections;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RecentlyUsedMenuItem {
    private static final Logger LOGGER = LoggerFactory.getLogger(RecentlyUsedMenuItem.class);

    @Execute
    public void execute(ECommandService commandService, EHandlerService handlerService, MMenuItem menuItem) {
        String path;
        assert (commandService != null) : "Parameter 'commandService' of method 'execute' must not be null";
        assert (handlerService != null) : "Parameter 'handlerService' of method 'execute' must not be null";
        assert (menuItem != null) : "Parameter 'menuItem' of method 'execute' must not be null";
        ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
        ISoftwareSystemProvider.PathType pathType = provider.getPathType(path = menuItem.getLabel());
        if (pathType != null) {
            ParameterizedCommand command = null;
            switch (pathType) {
                case SNAPSHOT: {
                    command = commandService.createCommand("com.hello2morrow.sonargraph.standalone.command.recentlyUsedOpenSoftwareSystemFromSnapshot", Collections.singletonMap("com.hello2morrow.sonargraph.standalone.command.recentlyUsedOpenSoftwareSystemFromSnapshot.fileParam", menuItem.getLabel()));
                    break;
                }
                case SOFTWARE_SYSTEM: {
                    command = commandService.createCommand("com.hello2morrow.sonargraph.standalone.command.recentlyUsedOpenSoftwareSystem", Collections.singletonMap("com.hello2morrow.sonargraph.standalone.command.recentlyUsedOpenSoftwareSystem.fileParam", menuItem.getLabel()));
                    break;
                }
                default: {
                    assert (false) : "Unhandled path type: " + String.valueOf(pathType);
                    break;
                }
            }
            if (command != null) {
                handlerService.executeHandler(command);
            }
        } else {
            LOGGER.warn("Unhandled path (neither software system nor snapshot): " + path);
        }
    }
}

