/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.softwaresystemview;

import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewOnDemand;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewStructureMode;
import com.hello2morrow.sonargraph.core.model.explorationview.IArchitecturalViewProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.OpenExplorationViewMenuItem;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.StandaloneActions;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchState;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.menu.MToolItem;

public final class OpenExplorationViewMenuProvider {
    @CanExecute
    public boolean canExecute(MToolItem toolItem) {
        SoftwareSystem softwareSystem;
        assert (toolItem != null) : "Parameter 'toolItem' of method 'canExecute' must not be null";
        if (WorkbenchRegistry.getInstance().hasState(new WorkbenchState[]{WorkbenchState.SOFTWARE_SYSTEM_OPENED}) && (softwareSystem = WorkbenchRegistry.getInstance().getSoftwareSystem()) != null) {
            ExplorationViewStructureMode structureMode = OpenExplorationViewMenuItem.getStructureMode();
            ExplorationViewOnDemand onDemand = ((IArchitecturalViewProvider)softwareSystem.getExtension(IArchitecturalViewProvider.class)).isLoadable(structureMode);
            if (onDemand != null) {
                toolItem.setTooltip("Open Exploration view '" + structureMode.getPresentationName() + "'");
                return true;
            }
        }
        toolItem.setTooltip("Open an Exploration view with the selected structure mode");
        return false;
    }

    @Execute
    public void execute() {
        SoftwareSystem softwareSystem;
        if (WorkbenchRegistry.getInstance().hasState(new WorkbenchState[]{WorkbenchState.SOFTWARE_SYSTEM_OPENED}) && (softwareSystem = WorkbenchRegistry.getInstance().getSoftwareSystem()) != null) {
            ExplorationViewStructureMode structureMode = OpenExplorationViewMenuItem.getStructureMode();
            StandaloneActions.getInstance().openExplorationView(softwareSystem, structureMode);
        }
    }
}

