/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.softwaresystemview;

import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewStructureMode;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.StandaloneActions;
import com.hello2morrow.sonargraph.ui.swt.base.PreferencesUtility;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchState;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;

public final class OpenExplorationViewMenuItem {
    private static final String OPEN_EXPLORATION_VIEW = "OpenExplorationView";

    static ExplorationViewStructureMode getStructureMode() {
        IEclipsePreferences eclipsePreferences = PreferencesUtility.getPreferences((String)"com.hello2morrow.sonargraph.standalone");
        String structureModeStandardName = eclipsePreferences.get(OPEN_EXPLORATION_VIEW, ExplorationViewStructureMode.PHYSICAL_WITH_ROOT_DIRECTORIES.getStandardName());
        try {
            return ExplorationViewStructureMode.fromStandardName((String)structureModeStandardName);
        }
        catch (IllegalArgumentException ex) {
            return ExplorationViewStructureMode.PHYSICAL_WITH_ROOT_DIRECTORIES;
        }
    }

    @CanExecute
    public boolean canExecute(MMenuItem menuItem) {
        assert (menuItem != null) : "Parameter 'menuItem' of method 'canExecute' must not be null";
        return WorkbenchRegistry.getInstance().hasState(new WorkbenchState[]{WorkbenchState.SOFTWARE_SYSTEM_OPENED}) && menuItem.getTransientData().get(ExplorationViewStructureMode.class.getName()) instanceof ExplorationViewStructureMode;
    }

    @Execute
    public void execute(MMenuItem menuItem) {
        assert (menuItem != null) : "Parameter 'menuItem' of method 'execute' must not be null";
        Object object = menuItem.getTransientData().get(ExplorationViewStructureMode.class.getName());
        if (object instanceof ExplorationViewStructureMode) {
            ExplorationViewStructureMode structureMode = (ExplorationViewStructureMode)object;
            IEclipsePreferences eclipsePreferences = PreferencesUtility.getPreferences((String)"com.hello2morrow.sonargraph.standalone");
            eclipsePreferences.put(OPEN_EXPLORATION_VIEW, structureMode.getStandardName());
            PreferencesUtility.save((IEclipsePreferences)eclipsePreferences);
            WorkbenchRegistry.getInstance().refreshUIElements();
            SoftwareSystem softwareSystem = WorkbenchRegistry.getInstance().getSoftwareSystem();
            assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'execute' must not be null";
            StandaloneActions.getInstance().openExplorationView(softwareSystem, structureMode);
        }
    }
}

