/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.softwaresystemview;

import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerState;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricId;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricValue;
import com.hello2morrow.sonargraph.core.model.common.IMetricLevel;
import com.hello2morrow.sonargraph.core.model.dashboard.AdditionalDetailsSeparator;
import com.hello2morrow.sonargraph.core.model.dashboard.Box;
import com.hello2morrow.sonargraph.core.model.dashboard.BoxElement;
import com.hello2morrow.sonargraph.core.model.dashboard.IssueCounter;
import com.hello2morrow.sonargraph.core.model.dashboard.Metric;
import com.hello2morrow.sonargraph.core.model.dashboard.QualityGateStatusElement;
import com.hello2morrow.sonargraph.core.model.dashboard.RedYellowGreenElement;
import com.hello2morrow.sonargraph.core.model.dashboard.ResolutionCounter;
import com.hello2morrow.sonargraph.core.model.dashboard.Separator;
import com.hello2morrow.sonargraph.core.model.dashboard.SimpleMetricChartType;
import com.hello2morrow.sonargraph.core.model.dashboard.SourceFileDiscriminationElement;
import com.hello2morrow.sonargraph.core.model.dashboard.SystemInfo;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.event.MetricValuesAvailableEvent;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricId;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricLevel;
import com.hello2morrow.sonargraph.core.model.resolution.IgnoreDefinition;
import com.hello2morrow.sonargraph.core.model.resolution.Resolution;
import com.hello2morrow.sonargraph.core.model.resolution.ResolutionApplicability;
import com.hello2morrow.sonargraph.core.model.resolution.ResolutionFilter;
import com.hello2morrow.sonargraph.core.model.resolution.ResolutionMode;
import com.hello2morrow.sonargraph.core.model.resolution.TaskDefinition;
import com.hello2morrow.sonargraph.core.model.system.IMetricAccessor;
import com.hello2morrow.sonargraph.core.model.system.IMetricsProvider;
import com.hello2morrow.sonargraph.core.model.system.IQualityGateProvider;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.diff.ISystemDiffProvider;
import com.hello2morrow.sonargraph.core.model.system.diff.MetricValueDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.SoftwareSystemDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.IIssueDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.IssuesDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.resolution.ResolutionDefinitionDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.resolution.ResolutionsDiff;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGate;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGateResult;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGateResultStatus;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;
import com.hello2morrow.sonargraph.integration.access.model.IIssue;
import com.hello2morrow.sonargraph.integration.access.model.IResolution;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.AnalyzerStateUpdater;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.IBoxCompositeContribution;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.MetricTrend;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.MetricTrendWithStackedBar;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.QualityGatesStatus;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.RedYellowGreenWithMetricTrend;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.SourceFileDiscrimination;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.StandardTrend;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.ValueTrend;
import com.hello2morrow.sonargraph.ui.swt.base.DetailsSeparatorWidget;
import com.hello2morrow.sonargraph.ui.swt.base.HorizontalSeparator;
import com.hello2morrow.sonargraph.ui.swt.base.PreferencesUtility;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchState;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

final class BoxComposite
extends Composite
implements DisposeListener,
DetailsSeparatorWidget.IExpansionStateListener {
    private final Map<SystemInfo.Kind, StrictPair<Label, Label>> m_systemInfoKindToLabels = new THashMap();
    private final Map<IssueCounter, StandardTrend> m_issueCounterToTrends = new THashMap();
    private final Map<ResolutionCounter, StandardTrend> m_resolutionCounterToTrends = new THashMap();
    private final Map<Metric, MetricTrend> m_metricToTrends = new THashMap();
    private final Map<RedYellowGreenElement, RedYellowGreenWithMetricTrend> m_entangledCodeMap = new THashMap();
    private Label m_systemAnalyzersState;
    private Timer m_timer;
    private boolean m_showTrend;
    private QualityGatesStatus m_qualityGateStatus;
    private SourceFileDiscrimination m_sourceFileDiscrimination;
    private IContentChangedListener m_contentChangeListener;

    BoxComposite(Composite parent, Box box, SoftwareSystem system, Collection<Issue> issues, IMetricsProvider metricsProvider, Set<IMetricDescriptor> metricDescriptors, boolean showTrend, int firstColumnWidth) {
        super(parent, 0);
        assert (box != null) : "Parameter 'box' of method 'BoxView' must not be null";
        assert (system != null) : "Parameter 'system' of method 'BoxComposite' must not be null";
        assert (issues != null) : "Parameter 'issues' of method 'BoxComposite' must not be null";
        assert (metricsProvider != null) : "Parameter 'metricsProvider' of method 'BoxComposite' must not be null";
        assert (metricDescriptors != null) : "Parameter 'metricDescriptors' of method 'BoxComposite' must not be null";
        this.m_showTrend = showTrend;
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.marginHeight = 2;
        gridLayout.horizontalSpacing = 3;
        gridLayout.verticalSpacing = 3;
        gridLayout.marginWidth = 2;
        this.setLayout((Layout)gridLayout);
        CLabel header = new CLabel((Composite)this, 0x1000000);
        header.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 4, 1));
        header.setBackground(new Color[]{UiResourceManager.getInstance().getHeaderColor(), UiResourceManager.getInstance().getBackgroundColor()}, new int[]{80}, true);
        header.setText(box.getName());
        String imageName = box.getImageResourceName();
        if (imageName != null && imageName.trim().length() > 0) {
            header.setImage(UiResourceManager.getInstance().getImage(imageName));
        }
        Predicate<Object> isSeparator = o -> o != null && (o instanceof Separator || o instanceof AdditionalDetailsSeparator);
        BoxElement previouslyAddedElement = null;
        DetailsSeparatorWidget detailsSeparator = null;
        for (BoxElement nextBoxElement : box.getChildren(BoxElement.class)) {
            if (isSeparator.test(previouslyAddedElement) && isSeparator.test(nextBoxElement)) continue;
            Object added = this.addBoxElement(system, this, nextBoxElement, metricsProvider, metricDescriptors, detailsSeparator, firstColumnWidth);
            if (added != null) {
                previouslyAddedElement = nextBoxElement;
            }
            if (!(added instanceof DetailsSeparatorWidget)) continue;
            assert (detailsSeparator == null) : "Unexpected second details separator for box: " + box.getName();
            detailsSeparator = (DetailsSeparatorWidget)added;
        }
        if (detailsSeparator != null) {
            detailsSeparator.addVisibilityChangeListener((DetailsSeparatorWidget.IExpansionStateListener)this);
        }
        this.softwareSystemModified(system, issues, EnumSet.noneOf(Modification.class), firstColumnWidth);
        this.addDisposeListener(this);
    }

    void setContentChangedListener(IContentChangedListener listener) {
        assert (listener != null) : "Parameter 'listener' of method 'addContentChangeListener' must not be null";
        this.m_contentChangeListener = listener;
    }

    private Object addBoxElement(SoftwareSystem system, Composite parent, BoxElement boxElement, IMetricsProvider metricsProvider, Set<IMetricDescriptor> metricDescriptors, DetailsSeparatorWidget detailsSeparator, int firstColumnWidth) {
        assert (parent != null) : "Parameter 'parent' of method 'addBoxElement' must not be null";
        assert (boxElement != null) : "Parameter 'boxElement' of method 'addBoxElement' must not be null";
        assert (metricsProvider != null) : "Parameter 'metricsProvider' of method 'addBoxElement' must not be null";
        assert (metricDescriptors != null) : "Parameter 'metricDescriptors' of method 'addBoxElement' must not be null";
        if (boxElement instanceof Separator) {
            Separator separatorElement = (Separator)boxElement;
            if (separatorElement.getLanguage() == null || separatorElement.getLanguage() != null && system.getUsedLanguages().contains(separatorElement.getLanguage())) {
                if (separatorElement.getLabel() == null) {
                    Control separator = SwtUtility.placeHorizontalSeparator((Composite)parent, (int)4);
                    this.registerWithDetailsSeparator(detailsSeparator, separator);
                    return separator;
                }
                HorizontalSeparator separator = new HorizontalSeparator(parent, separatorElement.getLabel(), UiResourceManager.getInstance().getColor(DetailsSeparatorWidget.SEPARATOR_COLOR));
                separator.setLayoutData((Object)new GridData(4, 4, true, false, 4, 1));
                separator.set(separatorElement.getLabel(), UiResourceManager.getInstance().getImage(separatorElement.getImageResourceName()));
                this.registerWithDetailsSeparator(detailsSeparator, separator);
                return separator;
            }
            return null;
        }
        if (boxElement instanceof AdditionalDetailsSeparator) {
            String id = boxElement.getFullyQualifiedName();
            DetailsSeparatorWidget separator = new DetailsSeparatorWidget(parent, this.getExpansionState(id), id);
            separator.setLayoutData((Object)new GridData(4, 4, true, false, 4, 1));
            return separator;
        }
        if (boxElement instanceof SystemInfo) {
            SystemInfo nextSystemInfo = (SystemInfo)boxElement;
            SystemInfo.Kind nextKind = nextSystemInfo.getKind();
            Label name = new Label(parent, 0);
            name.setText(nextSystemInfo.getName() + ":");
            GridData gridData = new GridData(0, 0, false, false, 3, 1);
            name.setLayoutData((Object)gridData);
            name.setForeground(UiResourceManager.getInstance().getColor(IBoxCompositeContribution.LABEL_COLOR));
            Label value = new Label(parent, 16384);
            value.setLayoutData((Object)new GridData(4, 64, true, false));
            StrictPair<Label, Label> previousLabels = this.m_systemInfoKindToLabels.put(nextKind, (StrictPair<Label, Label>)new StrictPair((Object)name, (Object)value));
            assert (previousLabels == null) : "'previousLabels' of method 'BoxView' must be null";
            if (nextKind == SystemInfo.Kind.ANALYZER_ACTIVITY) {
                this.m_systemAnalyzersState = value;
                this.checkCalculating(WorkbenchRegistry.getInstance().hasState(new WorkbenchState[]{WorkbenchState.CALCULATING}));
            }
            this.registerWithDetailsSeparator(detailsSeparator, name, value);
            return name;
        }
        if (boxElement instanceof QualityGateStatusElement) {
            this.m_qualityGateStatus = new QualityGatesStatus(parent, firstColumnWidth);
            this.registerWithDetailsSeparator(detailsSeparator, this.m_qualityGateStatus);
            return this.m_qualityGateStatus;
        }
        if (boxElement instanceof SourceFileDiscriminationElement) {
            this.m_sourceFileDiscrimination = new SourceFileDiscrimination(parent, firstColumnWidth);
            this.registerWithDetailsSeparator(detailsSeparator, this.m_sourceFileDiscrimination);
            return this.m_sourceFileDiscrimination;
        }
        if (boxElement instanceof RedYellowGreenElement) {
            RedYellowGreenElement ryg = (RedYellowGreenElement)boxElement;
            RedYellowGreenWithMetricTrend entangledCodeElement = new RedYellowGreenWithMetricTrend(parent, ryg.getName(), ryg.getDescription(), this.m_showTrend, ryg.getRedDescription(), ryg.getYellowDescription(), ryg.getGreenDescription(), firstColumnWidth);
            this.registerWithDetailsSeparator(detailsSeparator, entangledCodeElement);
            this.m_entangledCodeMap.put(ryg, entangledCodeElement);
            return entangledCodeElement;
        }
        if (boxElement instanceof IssueCounter) {
            IssueCounter issueCounter = (IssueCounter)boxElement;
            StandardTrend trend = new StandardTrend(parent, issueCounter.getName(), this.m_showTrend, firstColumnWidth);
            this.m_issueCounterToTrends.put(issueCounter, trend);
            this.registerWithDetailsSeparator(detailsSeparator, trend);
            return trend;
        }
        if (boxElement instanceof ResolutionCounter) {
            ResolutionCounter resolutionCounter = (ResolutionCounter)boxElement;
            StandardTrend trend = new StandardTrend(parent, resolutionCounter.getName(), this.m_showTrend, firstColumnWidth);
            this.m_resolutionCounterToTrends.put(resolutionCounter, trend);
            this.registerWithDetailsSeparator(detailsSeparator, trend);
            return trend;
        }
        if (boxElement instanceof Metric) {
            Metric metric = (Metric)boxElement;
            IMetricDescriptor metricDescriptor = metric.getMetricDescriptor();
            if (metricDescriptor == null) {
                metricDescriptor = metricsProvider.findMetricByIdAndLevel(metric.getIdStandardName(), metric.getLevelStandardName());
            }
            if (metricDescriptor != null || metric.isScriptBased()) {
                String description = metricDescriptor != null ? metricDescriptor.getMetricId().getDescription() : null;
                MetricTrend valueTrend = metric.getChartType() == SimpleMetricChartType.NONE ? new MetricTrend(parent, metric.getName(), this.m_showTrend, description, firstColumnWidth) : new MetricTrendWithStackedBar(parent, metric.getName(), this.m_showTrend, description, firstColumnWidth);
                this.registerWithDetailsSeparator(detailsSeparator, valueTrend);
                this.m_metricToTrends.put(metric, valueTrend);
                if (metricDescriptor != null) {
                    metricDescriptors.add(metricDescriptor);
                }
                return valueTrend;
            }
            this.m_metricToTrends.put(metric, null);
            return null;
        }
        assert (false) : "Unhandled box element: " + boxElement.getClass().getName();
        return null;
    }

    private void registerWithDetailsSeparator(DetailsSeparatorWidget detailsSeparator, Object ... objects) {
        assert (objects != null) : "Parameter 'objects' of method 'registerWithDetailsSeparator' must not be null";
        if (detailsSeparator == null) {
            return;
        }
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object next = objectArray[n2];
            if (next instanceof DetailsSeparatorWidget.IExpansionStateListener) {
                listener = (DetailsSeparatorWidget.IExpansionStateListener)next;
                detailsSeparator.addVisibilityChangeListener(listener);
                listener.changeExpansionState(detailsSeparator.getState(), detailsSeparator.getIdentifier());
            } else if (next instanceof Control) {
                listener = new DetailsSeparatorWidget.DefaultExpansionStateListener((Control)next);
                detailsSeparator.addVisibilityChangeListener(listener);
                listener.changeExpansionState(detailsSeparator.getState(), detailsSeparator.getIdentifier());
            } else assert (false) : "Unsupported class for details section: " + next.getClass().getCanonicalName();
            ++n2;
        }
    }

    private void checkCalculating(boolean calculating) {
        assert (this.m_systemAnalyzersState != null) : "Parameter 'm_systemAnalyzersState' of method 'checkCalculating' must not be null";
        if (!calculating) {
            if (this.m_timer != null) {
                this.m_timer.cancel();
                this.m_timer = null;
            }
            if (!this.m_systemAnalyzersState.isDisposed()) {
                AnalyzerStateUpdater.updateSystemAnalyzerState(this.m_systemAnalyzersState, false);
                this.m_systemAnalyzersState.setForeground(UiResourceManager.getInstance().getForegroundColor());
                this.m_systemAnalyzersState.setVisible(true);
            }
        } else if (!this.m_systemAnalyzersState.isDisposed() && this.m_timer == null) {
            AnalyzerStateUpdater.updateSystemAnalyzerState(this.m_systemAnalyzersState, true);
            this.m_systemAnalyzersState.setForeground(UiResourceManager.getInstance().getColor(UiResourceManager.DARK_GREEN));
            TimerTask timerTask = new TimerTask(){

                @Override
                public void run() {
                    UserInterfaceAdapter.getInstance().displayUiElement(new Runnable(){

                        @Override
                        public void run() {
                            if ((this).BoxComposite.this.m_systemAnalyzersState != null && !(this).BoxComposite.this.m_systemAnalyzersState.isDisposed()) {
                                boolean setVisible;
                                boolean bl = setVisible = !(this).BoxComposite.this.m_systemAnalyzersState.getVisible();
                                if (setVisible) {
                                    (this).BoxComposite.this.m_systemAnalyzersState.setVisible(true);
                                } else if ((this).BoxComposite.this.m_systemAnalyzersState.getText().startsWith(AnalyzerState.RUNNING.getPresentationName())) {
                                    (this).BoxComposite.this.m_systemAnalyzersState.setVisible(false);
                                }
                            }
                        }
                    });
                }
            };
            this.m_timer = new Timer(false);
            this.m_timer.scheduleAtFixedRate(timerTask, 1000L, 750L);
        }
        this.layout();
    }

    void calculationStateChanged(SoftwareSystem system, boolean calculating) {
        boolean resetTrend;
        assert (system != null) : "Parameter 'system' of method 'calculationStateChanged' must not be null";
        ISystemDiffProvider systemDiffProvider = (ISystemDiffProvider)system.getExtension(ISystemDiffProvider.class);
        this.m_showTrend = systemDiffProvider.getActiveBaselineFile() != null;
        boolean bl = resetTrend = this.m_showTrend && calculating;
        if (calculating) {
            for (Map.Entry<Metric, MetricTrend> nextEntry : this.m_metricToTrends.entrySet()) {
                MetricTrend nextMetricTrend = nextEntry.getValue();
                if (nextMetricTrend == null) continue;
                nextMetricTrend.setValue(null, this.m_showTrend, resetTrend);
            }
            this.layout();
        }
        if (this.m_systemAnalyzersState != null) {
            this.checkCalculating(calculating);
        }
        this.processSystemInfo(system);
    }

    private void handleLanguageSpecificMetrics(SoftwareSystem system, int firstColumnWidth) {
        assert (system != null) : "Parameter 'system' of method 'handleLanguageSpecificMetrics' must not be null";
        ArrayList<Metric> removed = new ArrayList<Metric>();
        Set usedLanguages = system.getUsedLanguages();
        for (Map.Entry<Metric, MetricTrend> nextEntry : this.m_metricToTrends.entrySet()) {
            Metric nextMetric = nextEntry.getKey();
            Language nextLanguage = nextMetric.getLanguage();
            if (nextLanguage == null) continue;
            if (usedLanguages.contains(nextLanguage)) {
                if (nextEntry.getValue() != null) continue;
                IMetricDescriptor descriptor = nextMetric.getMetricDescriptor();
                MetricTrend valueTrend = new MetricTrend(this, nextMetric.getName(), this.m_showTrend, descriptor != null ? descriptor.getDescription() : "", firstColumnWidth);
                this.m_metricToTrends.put(nextMetric, valueTrend);
                continue;
            }
            MetricTrend valueTrend = nextEntry.getValue();
            if (valueTrend == null) continue;
            removed.add(nextMetric);
        }
        for (Metric nextRemovedMetric : removed) {
            this.m_metricToTrends.put(nextRemovedMetric, null);
        }
        this.layout();
    }

    private ResolutionMode getResolutionMode(Issue issue) {
        assert (issue != null) : "Parameter 'issue' of method 'getResolutionMode' must not be null";
        com.hello2morrow.sonargraph.core.model.element.IResolution resolution = issue.getResolution();
        if (resolution == null) {
            return ResolutionMode.NONE;
        }
        if (resolution instanceof IgnoreDefinition) {
            return ResolutionMode.IGNORE;
        }
        assert (resolution instanceof TaskDefinition) : "Unexpected class: " + String.valueOf(resolution);
        return ResolutionMode.TASK;
    }

    private void processIssueCounter(SoftwareSystem softwareSystem, Collection<Issue> allIssues, boolean resetTrend) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'processIssueCounter' must not be null";
        assert (allIssues != null) : "Parameter 'allIssues' of method 'processIssueCounter' must not be null";
        if (!this.m_issueCounterToTrends.isEmpty()) {
            for (Map.Entry<IssueCounter, StandardTrend> nextEntry : this.m_issueCounterToTrends.entrySet()) {
                IssueCounter nextIssueCounter = nextEntry.getKey();
                int numberOfIssues = 0;
                for (Issue nextIssue : allIssues) {
                    if (!nextIssueCounter.match(nextIssue.getSeverity().getStandardName(), nextIssue.getId().getCategory().getStandardName(), this.getResolutionMode(nextIssue).getStandardName())) continue;
                    ++numberOfIssues;
                }
                nextEntry.getValue().setValue(numberOfIssues, this.m_showTrend, resetTrend);
            }
        }
    }

    private void processResolutionCounter(SoftwareSystem system, boolean resetTrend) {
        assert (system != null) : "Parameter 'system' of method 'processResolutionCounter' must not be null";
        for (Map.Entry<ResolutionCounter, StandardTrend> nextEntry : this.m_resolutionCounterToTrends.entrySet()) {
            ResolutionCounter nextResolutionCounter = nextEntry.getKey();
            ResolutionFilter resolutionFilter = nextResolutionCounter.createResolutionFilter();
            int resolutionCount = system.getCurrentModel().getResolutions(Resolution.class, resolutionFilter).size();
            StandardTrend trend = nextEntry.getValue();
            trend.setValue(resolutionCount, this.m_showTrend, resetTrend);
        }
    }

    private void processSystemInfo(SoftwareSystem system) {
        assert (system != null) : "Parameter 'system' of method 'processSystemInfo' must not be null";
        block7: for (Map.Entry<SystemInfo.Kind, StrictPair<Label, Label>> nextEntry : this.m_systemInfoKindToLabels.entrySet()) {
            SystemInfo.Kind nextKind = nextEntry.getKey();
            Label nextValue = (Label)nextEntry.getValue().getSecond();
            switch (nextKind) {
                case ANALYZER_ACTIVITY: {
                    break;
                }
                case LANGUAGES: {
                    Set usedLanguages = system.getUsedLanguages();
                    if (!usedLanguages.isEmpty()) {
                        StringBuilder usedLanguagesText = new StringBuilder();
                        for (Language nextLanguage : system.getUsedLanguages()) {
                            usedLanguagesText.append(nextLanguage.getPresentationName());
                            usedLanguagesText.append(", ");
                        }
                        usedLanguagesText.delete(usedLanguagesText.length() - 2, usedLanguagesText.length());
                        nextValue.setText(usedLanguagesText.toString());
                        break;
                    }
                    nextValue.setText("None");
                    break;
                }
                case NAME: {
                    nextValue.setText(system.getName());
                    break;
                }
                case STATE: {
                    nextValue.setText(system.state());
                    break;
                }
                case BASELINE: {
                    ISystemDiffProvider systemDiffProvider = (ISystemDiffProvider)system.getExtension(ISystemDiffProvider.class);
                    Pair activeBaselineInfo = systemDiffProvider.getBaselineInfo();
                    nextValue.setText((String)activeBaselineInfo.getFirst());
                    nextValue.setToolTipText(activeBaselineInfo.getSecond() != null ? (String)activeBaselineInfo.getSecond() : "");
                    break;
                }
                default: {
                    assert (false) : "Unhandled system info kind: " + String.valueOf(nextKind);
                    continue block7;
                }
            }
        }
    }

    void softwareSystemModified(SoftwareSystem system, Collection<Issue> issues, EnumSet<Modification> modification, int firstColumnWidth) {
        assert (system != null) : "Parameter 'system' of method 'softwareSystemModified' must not be null";
        assert (issues != null) : "Parameter 'issues' of method 'softwareSystemModified' must not be null";
        assert (modification != null) : "Parameter 'modification' of method 'softwareSystemModified' must not be null";
        if (modification.contains(Modification.AVAILABLE_LANGUAGES_MODIFIED)) {
            this.handleLanguageSpecificMetrics(system, firstColumnWidth);
        }
        this.processSystemInfo(system);
        boolean resetTrend = this.checkSystemDiff(system);
        this.processIssueCounter(system, issues, resetTrend);
        this.processResolutionCounter(system, resetTrend);
        this.processSizeInfo(system);
        this.processEntangledCodeInfo(system, resetTrend);
        if (modification.contains(Modification.WORKSPACE_CLEARED) && this.m_systemAnalyzersState != null && !this.m_systemAnalyzersState.isDisposed()) {
            AnalyzerStateUpdater.updateSystemAnalyzerState(this.m_systemAnalyzersState, false);
        }
        if (modification.contains(Modification.WORKSPACE_CLEARED) || modification.contains(Modification.WORKSPACE_MODIFIED) || modification.contains(Modification.AVAILABLE_LANGUAGES_MODIFIED) || modification.contains(Modification.VIRTUAL_MODEL_CHANGED)) {
            for (Map.Entry<Metric, MetricTrend> nextEntry : this.m_metricToTrends.entrySet()) {
                MetricTrend nextMetricWidget = nextEntry.getValue();
                if (nextMetricWidget == null) continue;
                nextMetricWidget.setValue(null, this.m_showTrend, resetTrend);
            }
        }
    }

    private void processSizeInfo(SoftwareSystem system) {
        assert (system != null) : "Parameter 'system' of method 'processSizeInfo' must not be null";
        if (this.m_sourceFileDiscrimination == null) {
            return;
        }
        IMetricAccessor metricAccessor = (IMetricAccessor)((ISoftwareSystemProvider)system.getExtension(ISoftwareSystemProvider.class)).getInstallation().getExtension(IMetricAccessor.class);
        Function<IMetricId, Number> retriever = id -> metricAccessor.getMetricValue(system, (NamedElement)system, (IMetricLevel)CoreMetricLevel.SYSTEM, id, false);
        Number fullAnalysis = retriever.apply((IMetricId)CoreMetricId.CORE_SOURCEFILES_FULLY_ANALYZED);
        Number test = retriever.apply((IMetricId)CoreMetricId.CORE_SOURCEFILES_TEST);
        Number issueIgnore = retriever.apply((IMetricId)CoreMetricId.CORE_SOURCEFILES_ISSUE_IGNORE);
        Number excluded = retriever.apply((IMetricId)CoreMetricId.CORE_SOURCEFILES_EXCLUDED);
        if (fullAnalysis == null || test == null || issueIgnore == null || excluded == null) {
            this.m_sourceFileDiscrimination.setDiscriminationValues(0, 0, 0, 0);
            return;
        }
        this.m_sourceFileDiscrimination.setDiscriminationValues(fullAnalysis.intValue(), issueIgnore.intValue(), test.intValue(), excluded.intValue());
    }

    void analyzerModification(SoftwareSystem system, Collection<Issue> issues) {
        assert (system != null) : "Parameter 'system' of method 'analyzerModification' must not be null";
        assert (issues != null) : "Parameter 'issues' of method 'analyzerModification' must not be null";
        boolean resetTrend = this.checkSystemDiff(system);
        this.processIssueCounter(system, issues, resetTrend);
        this.processResolutionCounter(system, resetTrend);
        this.processEntangledCodeInfo(system, resetTrend);
    }

    private void processEntangledCodeInfo(SoftwareSystem softwareSystem, boolean resetTrend) {
        if (this.m_entangledCodeMap.isEmpty()) {
            return;
        }
        IMetricAccessor metricAccessor = (IMetricAccessor)((ISoftwareSystemProvider)softwareSystem.getExtension(ISoftwareSystemProvider.class)).getInstallation().getExtension(IMetricAccessor.class);
        Function<IMetricDescriptor, Number> retriever = desc -> metricAccessor.getMetricValue(softwareSystem, (NamedElement)softwareSystem, (IMetricLevel)CoreMetricLevel.SYSTEM, desc.getMetricId(), false);
        for (Map.Entry<RedYellowGreenElement, RedYellowGreenWithMetricTrend> entry : this.m_entangledCodeMap.entrySet()) {
            RedYellowGreenElement element = entry.getKey();
            RedYellowGreenWithMetricTrend trendUi = entry.getValue();
            if (trendUi == null) continue;
            Number redValue = retriever.apply(element.getRedMetric());
            Number redAndYellowValue = retriever.apply(element.getRedAndYellowMetric());
            Number allValue = retriever.apply(element.getAllMetric());
            if (redValue == null || redAndYellowValue == null || allValue == null) {
                trendUi.setDiscriminationValues(0, 0, 0);
                trendUi.setValue(null, this.m_showTrend, resetTrend);
                continue;
            }
            trendUi.setDiscriminationValues(redValue.intValue(), redAndYellowValue.intValue(), allValue.intValue());
            if (element.getMetricDescriptor() == null) continue;
            trendUi.setValue(retriever.apply(element.getMetricDescriptor()), this.m_showTrend, resetTrend);
        }
    }

    private void processEntangledCodeInfoTrends(SoftwareSystem softwareSystem, ISystemDiffProvider systemDiffProvider, SoftwareSystemDiff systemDiff, boolean resetTrend) {
        if (this.m_entangledCodeMap.isEmpty()) {
            return;
        }
        IMetricAccessor metricAccessor = (IMetricAccessor)((ISoftwareSystemProvider)softwareSystem.getExtension(ISoftwareSystemProvider.class)).getInstallation().getExtension(IMetricAccessor.class);
        Function<IMetricDescriptor, Number> retriever = desc -> metricAccessor.getMetricValue(softwareSystem, (NamedElement)softwareSystem, (IMetricLevel)CoreMetricLevel.SYSTEM, desc.getMetricId(), false);
        for (Map.Entry<RedYellowGreenElement, RedYellowGreenWithMetricTrend> entry : this.m_entangledCodeMap.entrySet()) {
            RedYellowGreenElement element = entry.getKey();
            RedYellowGreenWithMetricTrend uiTrend = entry.getValue();
            if (uiTrend == null) continue;
            Number redValue = retriever.apply(element.getRedMetric());
            Number redAndYellowValue = retriever.apply(element.getRedAndYellowMetric());
            Number allValue = retriever.apply(element.getAllMetric());
            if (redValue == null || redAndYellowValue == null || allValue == null) {
                uiTrend.setDiscriminationValues(0, 0, 0);
                uiTrend.setValue(null, this.m_showTrend, resetTrend);
                return;
            }
            uiTrend.setDiscriminationValues(redValue.intValue(), redAndYellowValue.intValue(), allValue.intValue());
            if (element.getMetricDescriptor() == null) continue;
            Number value = retriever.apply(element.getMetricDescriptor());
            uiTrend.setValue(value, this.m_showTrend, true);
            MetricValueDiff diff = systemDiffProvider.getMetricDiff(systemDiff, element.getMetricDescriptor());
            if (diff == null) continue;
            if (diff.getBaseline() != null) {
                uiTrend.setTrend(diff.getValueDiffAbsolute(), diff.getChange());
                continue;
            }
            uiTrend.resetTrend();
        }
    }

    private boolean checkSystemDiff(SoftwareSystem system) {
        assert (system != null) : "Parameter 'system' of method 'checkSystemDiff' must not be null";
        ISystemDiffProvider systemDiffProvider = (ISystemDiffProvider)system.getExtension(ISystemDiffProvider.class);
        this.m_showTrend = systemDiffProvider.getActiveBaselineFile() != null;
        boolean resetTrend = this.m_showTrend && systemDiffProvider.getSoftwareSystemDiff() == null;
        return resetTrend;
    }

    void collectNeededMetricDescriptors(IMetricsProvider metricsProvider, Set<IMetricDescriptor> metricDescriptors) {
        assert (metricsProvider != null) : "Parameter 'metricsProvider' of method 'collectNeededMetrics' must not be null";
        assert (metricDescriptors != null) : "Parameter 'metricDescriptors' of method 'collectNeededMetrics' must not be null";
        for (Map.Entry<Metric, MetricTrend> nextEntry : this.m_metricToTrends.entrySet()) {
            if (nextEntry.getValue() == null) continue;
            Metric nextMetric = nextEntry.getKey();
            IMetricDescriptor metricDescriptor = nextMetric.getMetricDescriptor();
            if (metricDescriptor == null) {
                metricDescriptor = metricsProvider.findMetricByIdAndLevel(nextMetric.getIdStandardName(), nextMetric.getLevelStandardName());
            }
            if (metricDescriptor == null) continue;
            metricDescriptors.add(metricDescriptor);
        }
    }

    void processAvailableMetricValues(SoftwareSystem softwareSystem, IMetricsProvider metricsProvider, MetricValuesAvailableEvent event, boolean isSystemDiffActive, boolean resetTrend) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'processAvailableMetricValues' must not be null";
        assert (metricsProvider != null) : "Parameter 'metricsProvider' of method 'processAvailableMetricValues' must not be null";
        assert (event != null) : "Parameter 'event' of method 'processAvailableMetricValues' must not be null";
        int fullyAnalyzedFiles = -1;
        int issueIgnoringFiles = -1;
        int testFiles = -1;
        int excludedFiles = -1;
        this.m_showTrend = isSystemDiffActive;
        for (Map.Entry<Metric, MetricTrend> nextEntry : this.m_metricToTrends.entrySet()) {
            List values;
            if (nextEntry.getValue() == null) continue;
            Metric nextMetric = nextEntry.getKey();
            IMetricDescriptor metricDescriptor = nextMetric.getMetricDescriptor();
            if (metricDescriptor == null) {
                metricDescriptor = metricsProvider.findMetricByIdAndLevel(nextMetric.getIdStandardName(), nextMetric.getLevelStandardName());
            }
            if (metricDescriptor == null || (values = event.getMetricValues(metricDescriptor)) == null || values.isEmpty()) continue;
            MetricTrend nextMetricWidget = nextEntry.getValue();
            Number oldValue = nextMetricWidget.getValue();
            Number value = ((IMetricValue)values.get(0)).getValue();
            if (oldValue != null && value == null || oldValue == null && value != null || oldValue != null && value != null && Float.compare(oldValue.floatValue(), value.floatValue()) != 0) {
                nextMetricWidget.setValue(value, this.m_showTrend, resetTrend);
            }
            if (value == null) continue;
            if (metricDescriptor.getMetricId() == CoreMetricId.CORE_SOURCEFILES_FULLY_ANALYZED) {
                fullyAnalyzedFiles = value.intValue();
                continue;
            }
            if (metricDescriptor.getMetricId() == CoreMetricId.CORE_SOURCEFILES_ISSUE_IGNORE) {
                issueIgnoringFiles = value.intValue();
                continue;
            }
            if (metricDescriptor.getMetricId() == CoreMetricId.CORE_SOURCEFILES_TEST) {
                testFiles = value.intValue();
                continue;
            }
            if (metricDescriptor.getMetricId() != CoreMetricId.CORE_SOURCEFILES_EXCLUDED) continue;
            excludedFiles = value.intValue();
        }
        if (fullyAnalyzedFiles != -1 && issueIgnoringFiles != -1 && testFiles != -1 && excludedFiles != -1) {
            this.m_sourceFileDiscrimination.setDiscriminationValues(fullyAnalyzedFiles, issueIgnoringFiles, testFiles, excludedFiles);
        }
        this.processEntangledCodeInfo(softwareSystem, resetTrend);
    }

    public void widgetDisposed(DisposeEvent event) {
        if (this.m_timer != null) {
            this.m_timer.cancel();
            this.m_timer = null;
        }
    }

    void handleAnalyzerExecutionLevelChanged() {
        if (this.m_systemAnalyzersState != null && !this.m_systemAnalyzersState.isDisposed()) {
            AnalyzerStateUpdater.updateSystemAnalyzerState(this.m_systemAnalyzersState, false);
        }
    }

    void processQualityGateStatus(List<QualityGateResult> qualityGateResults, SoftwareSystem softwareSystem) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'processQualityGateStatus' must not be null";
        if (this.m_qualityGateStatus == null) {
            return;
        }
        if (qualityGateResults == null) {
            this.m_qualityGateStatus.resetStatusInfo();
            return;
        }
        int failed = 0;
        int passed = 0;
        int inactive = 0;
        for (QualityGate nextQualityGate : ((IQualityGateProvider)softwareSystem.getExtension(IQualityGateProvider.class)).getAvailableQualityGates()) {
            if (nextQualityGate.isChecked()) {
                QualityGateResultStatus nextStatus = nextQualityGate.getStatus();
                if (nextStatus == null) continue;
                if (nextStatus == QualityGateResultStatus.FAILED) {
                    ++failed;
                    continue;
                }
                if (nextStatus != QualityGateResultStatus.PASSED) continue;
                ++passed;
                continue;
            }
            ++inactive;
        }
        this.m_qualityGateStatus.setStatusInfo(failed, passed, inactive);
    }

    void processSystemDiff(SoftwareSystem system, ISystemDiffProvider systemDiffProvider, SoftwareSystemDiff systemDiff, IMetricsProvider metricsProvider) {
        assert (system != null) : "Parameter 'system' of method 'handleTrendInfo' must not be null";
        assert (systemDiffProvider != null) : "Parameter 'systemDiffProvider' of method 'handleSystemDiff' must not be null";
        assert (systemDiff != null) : "Parameter 'systemDiff' of method 'handleSystemDiff' must not be null";
        assert (metricsProvider != null) : "Parameter 'metricsProvider' of method 'handleTrendInfo' must not be null";
        this.processMetricTrends(systemDiffProvider, systemDiff, metricsProvider);
        if (!this.m_issueCounterToTrends.isEmpty()) {
            this.processIssueTrends(systemDiff);
        }
        if (!this.m_resolutionCounterToTrends.isEmpty()) {
            this.processResolutionTrends(systemDiff);
        }
        this.processEntangledCodeInfoTrends(system, systemDiffProvider, systemDiff, this.m_showTrend);
        this.layout(true);
    }

    private void processResolutionTrends(SoftwareSystemDiff softwareSystemDiff) {
        ResolutionsDiff resolutionsDiff = (ResolutionsDiff)softwareSystemDiff.getUniqueExistingChild(ResolutionsDiff.class);
        List diffResolutions = resolutionsDiff.getChildren(ResolutionDefinitionDiff.class).stream().filter(r -> r.getBaseline() != null).collect(Collectors.toList());
        for (Map.Entry<ResolutionCounter, StandardTrend> nextEntry : this.m_resolutionCounterToTrends.entrySet()) {
            ResolutionCounter nextResolutionCounter = nextEntry.getKey();
            Integer baselineResolutionCount = null;
            if (diffResolutions != null) {
                int numberOfBaselineResolutions = 0;
                for (ResolutionDefinitionDiff next : diffResolutions) {
                    ResolutionApplicability applicability;
                    IResolution resolution = (IResolution)next.getBaseline();
                    ResolutionApplicability resolutionApplicability = applicability = resolution.getMatchingElementsCount() == 0 ? ResolutionApplicability.NOT_APPLICABLE : ResolutionApplicability.APPLICABLE;
                    if (!nextResolutionCounter.match(resolution.getKind(), applicability.getStandardName())) continue;
                    ++numberOfBaselineResolutions;
                }
                baselineResolutionCount = numberOfBaselineResolutions;
            }
            StandardTrend standardTrend = nextEntry.getValue();
            standardTrend.setBaselineValue(baselineResolutionCount);
        }
    }

    private void processIssueTrends(SoftwareSystemDiff softwareSystemDiff) {
        IssuesDiff issuesDiff = (IssuesDiff)softwareSystemDiff.getUniqueExistingChild(IssuesDiff.class);
        List diffIssues = issuesDiff.getChildren(i -> i instanceof IIssueDiff && ((IIssueDiff)i).getBaseline() != null, IIssueDiff.class);
        for (Map.Entry<IssueCounter, StandardTrend> nextEntry : this.m_issueCounterToTrends.entrySet()) {
            IssueCounter nextIssueCounter = nextEntry.getKey();
            Integer baselineIssueCount = null;
            if (diffIssues != null) {
                int numberOfBaselineIssues = 0;
                for (IIssueDiff next : diffIssues) {
                    IIssue issue = next.getBaseline();
                    if (!nextIssueCounter.match(issue.getSeverity().getStandardName(), issue.getIssueType().getCategory().getName(), issue.getResolutionType().getStandardName())) continue;
                    ++numberOfBaselineIssues;
                }
                baselineIssueCount = numberOfBaselineIssues;
            }
            StandardTrend standardTrend = nextEntry.getValue();
            standardTrend.setBaselineValue(baselineIssueCount);
        }
    }

    private void processMetricTrends(ISystemDiffProvider systemDiffProvider, SoftwareSystemDiff systemDiff, IMetricsProvider metricsProvider) {
        for (Map.Entry<Metric, MetricTrend> nextEntry : this.m_metricToTrends.entrySet()) {
            MetricValueDiff diff;
            MetricTrend valueTrend = nextEntry.getValue();
            if (valueTrend == null) continue;
            Metric nextMetric = nextEntry.getKey();
            IMetricDescriptor metricDescriptor = nextMetric.getMetricDescriptor();
            if (metricDescriptor == null) {
                metricDescriptor = metricsProvider.findMetricByIdAndLevel(nextMetric.getIdStandardName(), nextMetric.getLevelStandardName());
            }
            if (metricDescriptor != null && (diff = systemDiffProvider.getMetricDiff(systemDiff, metricDescriptor)) != null) {
                if (diff.getBaseline() != null) {
                    valueTrend.setTrend(diff.getValueDiffAbsolute(), diff.getChange());
                    continue;
                }
                valueTrend.resetTrend();
                continue;
            }
            valueTrend.resetTrend();
        }
    }

    void clearTrendInfo(SoftwareSystem system, boolean isSystemDiffEnabled) {
        StandardTrend standardTrend;
        assert (system != null) : "Parameter 'system' of method 'clearTrendInfo' must not be null";
        for (Map.Entry<Metric, MetricTrend> entry : this.m_metricToTrends.entrySet()) {
            MetricTrend trendInfo = entry.getValue();
            if (trendInfo == null) continue;
            if (isSystemDiffEnabled) {
                trendInfo.resetTrend();
                continue;
            }
            trendInfo.showTrend(false);
        }
        for (Map.Entry<Object, ValueTrend> entry : this.m_issueCounterToTrends.entrySet()) {
            standardTrend = (StandardTrend)entry.getValue();
            if (isSystemDiffEnabled) {
                standardTrend.resetTrend();
                continue;
            }
            standardTrend.showTrend(false);
        }
        for (Map.Entry<Object, ValueTrend> entry : this.m_resolutionCounterToTrends.entrySet()) {
            standardTrend = (StandardTrend)entry.getValue();
            if (isSystemDiffEnabled) {
                standardTrend.resetTrend();
                continue;
            }
            standardTrend.showTrend(false);
        }
        for (Map.Entry<Object, ValueTrend> entry : this.m_systemInfoKindToLabels.entrySet()) {
            if (entry.getKey() != SystemInfo.Kind.BASELINE) continue;
            Label baseline = (Label)((StrictPair)entry.getValue()).getSecond();
            ISystemDiffProvider systemDiffProvider = (ISystemDiffProvider)system.getExtension(ISystemDiffProvider.class);
            Pair activeBaselineInfo = systemDiffProvider.getBaselineInfo();
            baseline.setText((String)activeBaselineInfo.getFirst());
            baseline.setToolTipText(activeBaselineInfo.getSecond() != null ? (String)activeBaselineInfo.getSecond() : "");
        }
        for (Map.Entry<Object, ValueTrend> entry : this.m_entangledCodeMap.entrySet()) {
            if (entry.getValue() == null) continue;
            if (isSystemDiffEnabled) {
                ((RedYellowGreenWithMetricTrend)entry.getValue()).resetTrend();
                continue;
            }
            ((RedYellowGreenWithMetricTrend)entry.getValue()).showTrend(false);
        }
    }

    public void changeExpansionState(DetailsSeparatorWidget.ExpansionState expansionState, String identifier) {
        assert (expansionState != null) : "Parameter 'expansionState' of method 'changeExpansionState' must not be null";
        assert (identifier != null) : "Parameter 'identifier' of method 'changeExpansionState' must not be null";
        PreferencesUtility.getPreferences((String)"com.hello2morrow.sonargraph.standalone").putBoolean(identifier + ".expanded", expansionState == DetailsSeparatorWidget.ExpansionState.EXPANDED);
        if (this.m_contentChangeListener != null) {
            this.m_contentChangeListener.contentChanged();
        }
    }

    private DetailsSeparatorWidget.ExpansionState getExpansionState(String identifier) {
        boolean expanded = PreferencesUtility.getPreferences((String)"com.hello2morrow.sonargraph.standalone").getBoolean(identifier + ".expanded", false);
        return expanded ? DetailsSeparatorWidget.ExpansionState.EXPANDED : DetailsSeparatorWidget.ExpansionState.COLLAPSED;
    }

    public static interface IContentChangedListener {
        public void contentChanged();
    }
}

