/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.settings;

import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.PortValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.system.settings.ISettingsDelta;
import com.hello2morrow.sonargraph.foundation.common.StandaloneResourceProviderAdapter;
import com.hello2morrow.sonargraph.foundation.utilities.ExceptionUtility;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.ProxySettings;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.foundation.utilities.URLUtility;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.HttpConnectionCheckComposite;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.StandaloneProxySettingsProvider;
import com.hello2morrow.sonargraph.ui.standalone.base.preferencepage.StandardPreferencePage;
import com.hello2morrow.sonargraph.ui.standalone.update.UpdateSupport;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextOrComboWidget;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextWidget;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public final class UpdateSitePreferencePage
extends StandardPreferencePage
implements ISettingsDelta {
    private static final String PROPERTY_LABEL_UPDATESITE_URL = "standalone.label.update.site.url";
    private static final String PROPERTY_UPDATE_SITE_TEST_CONNECTION = "standalone.label.update.site.test.connection";
    private static final String TEST_CONNECTION = StandaloneResourceProviderAdapter.getInstance().getString("standalone.label.update.site.test.connection", new Object[0]);
    private ValidatingTextWidget m_updateSiteURLWidget;
    private ValidatingTextWidget m_updateSitePortWidget;
    private HttpConnectionCheckComposite m_connectionCheckComposite;
    private String m_updateSiteURL;
    private String m_initialUpdateSiteURL;
    private int m_updateSitePort;
    private int m_initialUpdateSitePort;
    private boolean m_portIsValid = true;
    private boolean m_urlIsValid = true;

    public UpdateSitePreferencePage() {
        this.noDefaultAndApplyButton();
        StrictPair<String, Integer> updateSiteUrlAndPort = UpdateSupport.getUpdateSiteUrlAndPort();
        this.m_updateSiteURL = this.m_initialUpdateSiteURL = (String)updateSiteUrlAndPort.getFirst();
        this.m_updateSitePort = this.m_initialUpdateSitePort = ((Integer)updateSiteUrlAndPort.getSecond()).intValue();
    }

    public boolean isModified() {
        return !this.m_updateSiteURL.equals(this.m_initialUpdateSiteURL) || this.m_updateSitePort != this.m_initialUpdateSitePort;
    }

    public boolean hasValidData() {
        return this.m_portIsValid && this.m_urlIsValid;
    }

    public void reset() {
        if (this.isModified()) {
            this.m_updateSiteURLWidget.setText(this.m_initialUpdateSiteURL);
            this.m_updateSitePortWidget.setText(String.valueOf(this.m_initialUpdateSitePort));
        }
        this.handleButtons();
    }

    @Override
    protected Composite createPageContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)SwtUtility.createMultipleRootWidgetGridLayout((int)2, (boolean)false));
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        ITextValidator validator = new ITextValidator(){

            public ValidationResult isValid(String currentInput, String newInput) {
                UpdateSitePreferencePage.this.m_urlIsValid = false;
                ValidationResult result = new ValidationResult(!StringUtility.areEqual((String)currentInput, (String)newInput));
                if (newInput != null) {
                    if ((newInput = newInput.trim()).isEmpty()) {
                        result.addError("Empty URL");
                    } else {
                        try {
                            new URI(newInput).toURL();
                            UpdateSitePreferencePage.this.m_urlIsValid = true;
                        }
                        catch (MalformedURLException | URISyntaxException mue) {
                            result.addError(mue.getMessage());
                        }
                    }
                }
                return result;
            }
        };
        ValidatingTextOrComboWidget.IConsumer consumer = new ValidatingTextOrComboWidget.IConsumer(){

            public void setText(ValidatingTextOrComboWidget source, String input, boolean inputModified) {
                if (input != null) {
                    UpdateSitePreferencePage.this.m_updateSiteURL = input;
                }
                UpdateSitePreferencePage.this.handleButtons();
            }
        };
        Label textLabel = new Label(container, 131072);
        textLabel.setText(StandaloneResourceProviderAdapter.getInstance().getString(PROPERTY_LABEL_UPDATESITE_URL, new Object[0]));
        this.m_updateSiteURLWidget = new ValidatingTextWidget(container, validator, consumer, this.m_initialUpdateSiteURL, false, false, 0);
        this.m_updateSiteURLWidget.setLayoutData((Object)new GridData(4, 0, true, false));
        Label portFieldLabel = new Label(container, 131072);
        portFieldLabel.setText("Port: ");
        this.m_updateSitePortWidget = new ValidatingTextWidget(container, (ITextValidator)new PortValidator(), new ValidatingTextOrComboWidget.IConsumer(){

            public void setText(ValidatingTextOrComboWidget source, String text, boolean inputModified) {
                if (text != null) {
                    try {
                        UpdateSitePreferencePage.this.m_updateSitePort = Integer.parseInt(text);
                        UpdateSitePreferencePage.this.m_portIsValid = true;
                    }
                    catch (NumberFormatException nfe) {
                        if (!$assertionsDisabled) {
                            throw new AssertionError((Object)ExceptionUtility.collectFirstAndLast((Throwable)nfe));
                        }
                    }
                } else {
                    UpdateSitePreferencePage.this.m_portIsValid = false;
                }
                UpdateSitePreferencePage.this.handleButtons();
            }
        }, String.valueOf(this.m_initialUpdateSitePort), false, false, 0);
        this.m_updateSitePortWidget.setLayoutData((Object)new GridData(4, 0, true, false));
        HttpConnectionCheckComposite.IInfoProvider infoProvider = new HttpConnectionCheckComposite.IInfoProvider(){

            @Override
            public List<String> getUrls() {
                URL updateInfoUrl = null;
                try {
                    URL updateSiteUrlBase = URLUtility.toURL((String)UpdateSitePreferencePage.this.m_updateSiteURL, (int)UpdateSitePreferencePage.this.m_updateSitePort);
                    updateInfoUrl = URLUtility.appendPath((URL)updateSiteUrlBase, (String)"updateinfo.txt");
                    return Arrays.asList(updateInfoUrl.toString());
                }
                catch (MalformedURLException e1) {
                    return Collections.emptyList();
                }
            }

            @Override
            public String getExpectedResonse() {
                return null;
            }

            @Override
            public ProxySettings getProxy() {
                return new StandaloneProxySettingsProvider().getProxySettings(false);
            }

            @Override
            public boolean isActive() {
                return WorkbenchRegistry.isRunning();
            }

            @Override
            public void setChecking(boolean isChecking) {
                UpdateSitePreferencePage.this.m_updateSiteURLWidget.setEnabled(!isChecking);
                UpdateSitePreferencePage.this.m_updateSitePortWidget.setEnabled(!isChecking);
            }

            @Override
            public String getTestConnectionButtonLabel() {
                return TEST_CONNECTION;
            }
        };
        this.m_connectionCheckComposite = new HttpConnectionCheckComposite(container, infoProvider);
        this.m_connectionCheckComposite.setLayoutData(new GridData(4, 4, true, true, 2, 1));
        this.createButtonsPart(container, true);
        this.handleButtons();
        return parent;
    }

    private void handleButtons() {
        this.getApplyButton().setEnabled(this.isModified() && this.hasValidData());
        this.getCancelButton().setEnabled(this.isModified());
        this.getRestoreDefaultsButton().setEnabled(!"https://eclipse.hello2morrow.com/Sonargraph.site".equals(this.m_updateSiteURL) || 443 != this.m_updateSitePort);
        this.m_connectionCheckComposite.enableTestConnectionButton(this.hasValidData());
    }

    @Override
    protected ISettingsDelta getDelta() {
        return this;
    }

    @Override
    protected OperationResult getOperationResult() {
        return null;
    }

    @Override
    protected void cancel() {
        this.reset();
    }

    @Override
    protected void internPerformOk() {
        UpdateSupport.saveUpdateSiteUrlAndPort((StrictPair<String, Integer>)new StrictPair((Object)this.m_updateSiteURL, (Object)this.m_updateSitePort));
        this.m_initialUpdateSiteURL = this.m_updateSiteURL;
        this.m_initialUpdateSitePort = this.m_updateSitePort;
        this.handleButtons();
    }

    protected void performDefaults() {
        this.m_updateSiteURLWidget.setText("https://eclipse.hello2morrow.com/Sonargraph.site");
        this.m_updateSitePortWidget.setText(String.valueOf(443));
        this.handleButtons();
    }
}

