/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.settings;

import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.ScriptRunnerConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.ScriptRunnerData;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.script.GroovyScript;
import com.hello2morrow.sonargraph.core.model.script.IGroovyProvider;
import com.hello2morrow.sonargraph.core.model.script.IRunConfiguration;
import com.hello2morrow.sonargraph.foundation.propertyreader.BeanPropertyReader;
import com.hello2morrow.sonargraph.ui.standalone.base.workbench.CoreDialogId;
import com.hello2morrow.sonargraph.ui.standalone.settings.AnalyzerPropertyPage;
import com.hello2morrow.sonargraph.ui.standalone.settings.ScriptRunnerDataBeanAdapter;
import com.hello2morrow.sonargraph.ui.standalone.settings.ScriptRunnerEntryDialog;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableViewer;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public final class ScriptRunnerPropertyPage
extends AnalyzerPropertyPage<ScriptRunnerConfiguration>
implements ISelectionChangedListener,
SelectionListener,
ScriptRunnerEntryDialog.IDataProvider {
    private final Map<GroovyScript, List<IRunConfiguration>> m_availableScripts = new LinkedHashMap<GroovyScript, List<IRunConfiguration>>();
    private final List<GroovyScript> m_allScripts = new ArrayList<GroovyScript>();
    private List<ScriptRunnerData> m_original;
    private List<ScriptRunnerData> m_current;
    private PropertyTableViewer<ScriptRunnerData> m_scriptRunnerDataTable;
    private Button m_add;
    private Button m_delete;
    private Button m_up;
    private Button m_down;

    public ScriptRunnerPropertyPage() {
        super((IAnalyzerId)CoreAnalyzerId.SCRIPT_RUNNER);
    }

    @Override
    public IDialogId getDialogId() {
        return CoreDialogId.SCRIPTRUNNER_ANALYZER_PROPERTY_PAGE;
    }

    @Override
    protected int getNumberOfColumns() {
        return 2;
    }

    private boolean isDefinedAsAutomated(GroovyScript script, IRunConfiguration runConfiguration) {
        assert (script != null) : "Parameter 'script' of method 'isDefinedAsAutomated' must not be null";
        assert (runConfiguration != null) : "Parameter 'runConfiguration' of method 'isDefinedAsAutomated' must not be null";
        for (ScriptRunnerData next : this.m_current) {
            if (!next.getIdentifyingScriptPath().equals(script.getIdentifyingPath()) || !next.getRunConfigurationName().equals(runConfiguration.getRunConfigurationName())) continue;
            return true;
        }
        return false;
    }

    private void updateAvailable() {
        this.m_availableScripts.clear();
        for (GroovyScript nextScript : this.m_allScripts) {
            ArrayList<IRunConfiguration> availableRunConfigurations = new ArrayList<IRunConfiguration>();
            for (IRunConfiguration nextRunConfiguration : nextScript.getRunConfigurations()) {
                if (this.isDefinedAsAutomated(nextScript, nextRunConfiguration)) continue;
                availableRunConfigurations.add(nextRunConfiguration);
            }
            if (availableRunConfigurations.isEmpty()) continue;
            this.m_availableScripts.put(nextScript, availableRunConfigurations);
        }
    }

    @Override
    protected void fillDialogArea(Composite composite, ScriptRunnerConfiguration configuration, boolean readOnly) {
        assert (composite != null) : "Parameter 'composite' of method 'fillDialogArea' must not be null";
        this.m_original = configuration.getScriptRunnerData();
        this.m_current = configuration.getScriptRunnerData();
        this.m_allScripts.addAll(((IGroovyProvider)this.getSoftwareSystem().getExtension(IGroovyProvider.class)).getAvailableScripts());
        this.updateAvailable();
        this.m_scriptRunnerDataTable = new PropertyTableViewer(composite, (BeanPropertyReader.BeanAdapter)new ScriptRunnerDataBeanAdapter(configuration), PropertyTableViewer.SelectionType.MULTI_FULL_LINE);
        this.m_scriptRunnerDataTable.addColumn("Script", "script", "script", "scriptImage", 60, PropertyTableViewer.ColumnType.TEXT);
        this.m_scriptRunnerDataTable.addColumn("Run Configuration", "runConfiguration", "runConfiguration", "runConfigurationImage", 40, PropertyTableViewer.ColumnType.TEXT);
        this.m_scriptRunnerDataTable.setLayoutData((Object)new GridData(4, 4, true, true));
        if (!readOnly) {
            this.m_scriptRunnerDataTable.getTableViewer().addSelectionChangedListener((ISelectionChangedListener)this);
        }
        Composite buttonRow = new Composite(composite, 0);
        buttonRow.setLayoutData((Object)new GridData(1, 4, false, true));
        buttonRow.setLayout((Layout)SwtUtility.createMultipleRootWidgetGridLayout((int)1));
        this.m_add = new Button(buttonRow, 8);
        this.m_add.setImage(UiResourceManager.getInstance().getImage("New"));
        if (!readOnly) {
            this.m_add.addSelectionListener((SelectionListener)this);
        }
        this.m_delete = new Button(buttonRow, 8);
        this.m_delete.setImage(UiResourceManager.getInstance().getImage("Delete"));
        if (!readOnly) {
            this.m_delete.addSelectionListener((SelectionListener)this);
        }
        this.m_up = new Button(buttonRow, 8);
        this.m_up.setImage(UiResourceManager.getInstance().getImage("ArrowUp"));
        if (!readOnly) {
            this.m_up.addSelectionListener((SelectionListener)this);
        }
        this.m_down = new Button(buttonRow, 8);
        this.m_down.setImage(UiResourceManager.getInstance().getImage("ArrowDown"));
        if (!readOnly) {
            this.m_down.addSelectionListener((SelectionListener)this);
        }
        this.m_scriptRunnerDataTable.showData(this.m_current);
        this.m_add.setEnabled(!readOnly && !this.m_availableScripts.isEmpty());
        this.m_delete.setEnabled(false);
        this.m_up.setEnabled(false);
        this.m_down.setEnabled(false);
    }

    private void applyModification(ScriptRunnerData select) {
        this.updateAvailable();
        this.m_scriptRunnerDataTable.showData(this.m_current);
        this.m_scriptRunnerDataTable.getTableViewer().setSelection((ISelection)(select == null ? new StructuredSelection() : new StructuredSelection((Object)select)));
    }

    @Override
    protected boolean applyChanges(ScriptRunnerConfiguration configuration) {
        assert (configuration != null) : "Parameter 'configuration' of method 'applyChanges' must not be null";
        if (!this.m_original.equals(this.m_current)) {
            configuration.setScriptRunnerData(this.m_current);
            return true;
        }
        return false;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        assert (event != null) : "Parameter 'event' of method 'selectionChanged' must not be null";
        assert (event.getSource() == this.m_scriptRunnerDataTable.getTableViewer()) : "Unexpected source: " + String.valueOf(event.getSelectionProvider());
        List selected = this.m_scriptRunnerDataTable.getSelected();
        if (selected.size() == 0) {
            this.m_add.setEnabled(!this.m_availableScripts.isEmpty());
            this.m_delete.setEnabled(false);
            this.m_up.setEnabled(false);
            this.m_down.setEnabled(false);
        } else if (selected.size() == 1) {
            this.m_add.setEnabled(!this.m_availableScripts.isEmpty());
            this.m_delete.setEnabled(true);
            int pos = this.m_current.indexOf(selected.get(0));
            this.m_up.setEnabled(pos > 0);
            this.m_down.setEnabled(pos < this.m_current.size() - 1);
        } else {
            this.m_add.setEnabled(!this.m_availableScripts.isEmpty());
            this.m_delete.setEnabled(true);
            this.m_up.setEnabled(false);
            this.m_down.setEnabled(false);
        }
    }

    public void widgetSelected(SelectionEvent event) {
        assert (event != null) : "Parameter 'event' of method 'widgetSelected' must not be null";
        List selected = this.m_scriptRunnerDataTable.getSelected();
        Object source = event.getSource();
        if (source == this.m_add) {
            ScriptRunnerEntryDialog dialog = new ScriptRunnerEntryDialog(this.getShell(), this);
            if (dialog.open() == 0) {
                this.m_current.add(new ScriptRunnerData(dialog.getGroovyScript().getIdentifyingPath(), dialog.getRunConfiguration().getRunConfigurationName()));
                this.applyModification(null);
            }
        } else if (source == this.m_delete) {
            this.m_current.removeAll(selected);
            this.applyModification(null);
        } else if (source == this.m_up) {
            assert (selected.size() == 1) : "Only one selected element expected";
            ScriptRunnerData move = (ScriptRunnerData)selected.get(0);
            int pos = this.m_current.indexOf(move);
            ScriptRunnerData replaced = this.m_current.set(pos - 1, move);
            this.m_current.set(pos, replaced);
            this.applyModification(move);
        } else if (source == this.m_down) {
            assert (selected.size() == 1) : "Only one selected element expected";
            ScriptRunnerData move = (ScriptRunnerData)selected.get(0);
            int pos = this.m_current.indexOf(move);
            ScriptRunnerData replaced = this.m_current.set(pos + 1, move);
            this.m_current.set(pos, replaced);
            this.applyModification(move);
        } else assert (false) : "Unhandled source: " + String.valueOf(source);
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    @Override
    public List<GroovyScript> getAvailableScripts() {
        return new ArrayList<GroovyScript>(this.m_availableScripts.keySet());
    }

    @Override
    public List<IRunConfiguration> getAvailableRunConfigurations(GroovyScript script) {
        assert (script != null) : "Parameter 'script' of method 'getAvailableRunConfigurations' must not be null";
        List<IRunConfiguration> runConfigurations = this.m_availableScripts.get(script);
        assert (runConfigurations != null && !runConfigurations.isEmpty()) : "Parameter 'runConfigurations' of method 'getAvailableRunConfigurations' must not be empty";
        return runConfigurations;
    }
}

