/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.settings;

import com.hello2morrow.sonargraph.core.model.analysis.AbstractCheckedFilesConfiguration;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFile;
import com.hello2morrow.sonargraph.ui.standalone.settings.AbstractFileEntryDialog;
import com.hello2morrow.sonargraph.ui.standalone.settings.AnalyzerPropertyPage;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableViewer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class CheckedFilesAnalyzerPropertyPage<T extends AbstractCheckedFilesConfiguration, F extends ModifiableFile>
extends AnalyzerPropertyPage<T>
implements ISelectionChangedListener,
SelectionListener,
AbstractFileEntryDialog.IDataProvider<F> {
    private final List<F> m_available = new ArrayList<F>();
    private final List<F> m_all = new ArrayList<F>();
    private List<String> m_original;
    private List<String> m_current;
    private PropertyTableViewer<String> m_filesTable;
    private Button m_add;
    private Button m_delete;
    private Button m_up;
    private Button m_down;

    public CheckedFilesAnalyzerPropertyPage(IAnalyzerId analyzerId, boolean supportsDefaultValues) {
        super(analyzerId, supportsDefaultValues);
    }

    public CheckedFilesAnalyzerPropertyPage(IAnalyzerId analyzerId) {
        super(analyzerId);
    }

    @Override
    protected int getNumberOfColumns() {
        return 2;
    }

    private void updateAvailable(boolean readOnly) {
        this.m_available.clear();
        for (ModifiableFile next : this.m_all) {
            if (this.m_current.contains(next.getIdentifyingPath())) continue;
            this.m_available.add(next);
        }
        this.m_add.setEnabled(!readOnly && !this.m_available.isEmpty());
    }

    @Override
    public List<F> getAvailableFiles() {
        return this.m_available;
    }

    @Override
    protected void fillDialogArea(Composite composite, T configuration, boolean readOnly) {
        assert (composite != null) : "Parameter 'composite' of method 'fillDialogArea' must not be null";
        assert (configuration != null) : "Parameter 'configuration' of method 'fillDialogArea' must not be null";
        this.m_original = configuration.getIdentifyingPaths();
        this.m_current = configuration.getIdentifyingPaths();
        this.m_all.addAll(this.getAvailableFilesFromProvider());
        this.m_filesTable = this.createPropertyTableViewer(composite, configuration);
        if (!readOnly) {
            this.m_filesTable.getTableViewer().addSelectionChangedListener((ISelectionChangedListener)this);
        }
        Composite buttonRow = new Composite(composite, 0);
        buttonRow.setLayoutData((Object)new GridData(1, 4, false, true));
        buttonRow.setLayout((Layout)SwtUtility.createMultipleRootWidgetGridLayout((int)1));
        this.m_add = new Button(buttonRow, 8);
        this.m_add.setImage(UiResourceManager.getInstance().getImage("New"));
        if (!readOnly) {
            this.m_add.addSelectionListener((SelectionListener)this);
        }
        this.m_delete = new Button(buttonRow, 8);
        this.m_delete.setImage(UiResourceManager.getInstance().getImage("Delete"));
        if (!readOnly) {
            this.m_delete.addSelectionListener((SelectionListener)this);
        }
        this.m_up = new Button(buttonRow, 8);
        this.m_up.setImage(UiResourceManager.getInstance().getImage("ArrowUp"));
        if (!readOnly) {
            this.m_up.addSelectionListener((SelectionListener)this);
        }
        this.m_down = new Button(buttonRow, 8);
        this.m_down.setImage(UiResourceManager.getInstance().getImage("ArrowDown"));
        if (!readOnly) {
            this.m_down.addSelectionListener((SelectionListener)this);
        }
        this.m_filesTable.showData(this.m_current);
        this.m_delete.setEnabled(false);
        this.m_up.setEnabled(false);
        this.m_down.setEnabled(false);
        this.updateAvailable(readOnly);
    }

    protected abstract List<F> getAvailableFilesFromProvider();

    protected abstract PropertyTableViewer<String> createPropertyTableViewer(Composite var1, T var2);

    protected abstract AbstractFileEntryDialog<F> createFileEntryDialog(Shell var1, AbstractFileEntryDialog.IDataProvider<F> var2);

    private void applyModification(String select) {
        this.updateAvailable(this.isReadOnly());
        this.m_filesTable.showData(this.m_current);
        this.m_filesTable.getTableViewer().setSelection((ISelection)(select == null ? new StructuredSelection() : new StructuredSelection((Object)select)));
    }

    @Override
    protected boolean applyChanges(T configuration) {
        assert (configuration != null) : "Parameter 'configuration' of method 'applyChanges' must not be null";
        if (!this.m_original.equals(this.m_current)) {
            configuration.setIdentifyingPaths(this.m_current);
            return true;
        }
        return false;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        assert (event != null) : "Parameter 'event' of method 'selectionChanged' must not be null";
        assert (event.getSource() == this.m_filesTable.getTableViewer()) : "Unexpected source: " + String.valueOf(event.getSelectionProvider());
        List selected = this.m_filesTable.getSelected();
        if (selected.size() == 0) {
            this.m_add.setEnabled(!this.m_available.isEmpty());
            this.m_delete.setEnabled(false);
            this.m_up.setEnabled(false);
            this.m_down.setEnabled(false);
        } else if (selected.size() == 1) {
            this.m_add.setEnabled(!this.m_available.isEmpty());
            this.m_delete.setEnabled(true);
            int pos = this.m_current.indexOf(selected.get(0));
            this.m_up.setEnabled(pos > 0);
            this.m_down.setEnabled(pos < this.m_current.size() - 1);
        } else {
            this.m_add.setEnabled(!this.m_available.isEmpty());
            this.m_delete.setEnabled(true);
            this.m_up.setEnabled(false);
            this.m_down.setEnabled(false);
        }
    }

    public void widgetSelected(SelectionEvent event) {
        assert (event != null) : "Parameter 'event' of method 'widgetSelected' must not be null";
        List selected = this.m_filesTable.getSelected();
        Object source = event.getSource();
        if (source == this.m_add) {
            AbstractFileEntryDialog<F> dialog = this.createFileEntryDialog(this.getShell(), this);
            if (dialog.open() == 0) {
                this.m_current.add(dialog.getFile().getIdentifyingPath());
                this.applyModification(null);
            }
        } else if (source == this.m_delete) {
            this.m_current.removeAll(selected);
            this.applyModification(null);
        } else if (source == this.m_up) {
            assert (selected.size() == 1) : "Only one selected element expected";
            String move = (String)selected.get(0);
            int pos = this.m_current.indexOf(move);
            String replaced = this.m_current.set(pos - 1, move);
            this.m_current.set(pos, replaced);
            this.applyModification(move);
        } else if (source == this.m_down) {
            assert (selected.size() == 1) : "Only one selected element expected";
            String move = (String)selected.get(0);
            int pos = this.m_current.indexOf(move);
            String replaced = this.m_current.set(pos + 1, move);
            this.m_current.set(pos, replaced);
            this.applyModification(move);
        } else assert (false) : "Unhandled source: " + String.valueOf(source);
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }
}

