/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.scriptview;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.script.GroovyScript;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.ui.standalone.scriptview.RunConfigurationWizard;
import com.hello2morrow.sonargraph.ui.standalone.scriptview.ScriptBasedWizardAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.CommandHandlerWithCorrespondingCommand;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.SonargraphWizard;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchState;
import java.util.List;

public final class RunConfigurationWizardAdapter
extends ScriptBasedWizardAdapter {
    public String getName() {
        return "New Script Run Configuration";
    }

    public String getImageResource() {
        return "NewRunConfiguration";
    }

    public boolean isAvailable() {
        return CommandHandlerWithCorrespondingCommand.isAvailable((ICommandId)CoreCommandId.CREATE_GROOVY_SCRIPT_RUN_CONFIGURATION);
    }

    public SonargraphWizard create(ISoftwareSystemProvider provider, List<Element> selected) {
        GroovyScript groovyScript = this.getGroovyScript(provider, selected);
        return new RunConfigurationWizard(groovyScript);
    }

    private GroovyScript getGroovyScript(ISoftwareSystemProvider provider, List<Element> selected) {
        Element element;
        assert (provider != null) : "Parameter 'provider' of method 'getGroovyScript' must not be null";
        assert (selected != null) : "Parameter 'selected' of method 'getGroovyScript' must not be null";
        if (selected.size() == 1 && (element = selected.get(0)) instanceof GroovyScript) {
            return (GroovyScript)element;
        }
        return null;
    }

    public boolean isEnabled(ISoftwareSystemProvider provider, List<Element> selected) {
        assert (provider != null) : "Parameter 'provider' of method 'isEnabled' must not be null";
        assert (selected != null) : "Parameter 'selected' of method 'isEnabled' must not be null";
        if (this.isAvailable() && WorkbenchRegistry.getInstance().hasState(new WorkbenchState[]{WorkbenchState.SOFTWARE_SYSTEM_OPENED})) {
            return this.getGroovyScript(provider, selected) != null;
        }
        return false;
    }

    public boolean showInContextMenu(ISoftwareSystemProvider provider, IWorkbenchView workbenchView, List<Element> selected) {
        assert (provider != null) : "Parameter 'provider' of method 'showInContextMenu' must not be null";
        assert (workbenchView != null) : "Parameter 'workbenchView' of method 'showInContextMenu' must not be null";
        assert (selected != null) : "Parameter 'selected' of method 'showInContextMenu' must not be null";
        return workbenchView.getViewId() == ViewId.FILES_VIEW;
    }
}

