/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.scriptview;

import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.model.script.IGroovyProvider;
import com.hello2morrow.sonargraph.core.model.script.ParameterDefinition;
import com.hello2morrow.sonargraph.core.model.script.ParameterDefinitionFactory;
import com.hello2morrow.sonargraph.core.model.script.ParameterType;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextOrComboWidget;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextWidget;
import com.hello2morrow.sonargraph.ui.swt.dialog.StandardDialog;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public final class ParameterDefinitionDialog
extends StandardDialog
implements IGroovyProvider.IParameterDefinitionInfoProvider {
    private final ParameterDefinition<?> m_toBeEdited;
    private final ITextValidator m_nameValidator;
    private final ITextValidator m_defaultValueValidator;
    private final ITextValidator m_possibleValueValidator;
    private ValidatingTextWidget m_widgetName;
    private Text m_widgetDescription;
    private Group m_widgetParameterType;
    private Composite m_widgetDefaultValuePlaceHolder;
    private ValidatingTextWidget m_widgetPossibleValues;
    private ParameterDefinition.Builder m_parameterDefinitionBuilder;
    private final String m_initialName;
    private final String m_initialDescription;
    private final ParameterType m_initialParameterType;
    private final String m_initialDefaultValue;
    private final String m_initialPossibleValuesAsString;
    private Set<?> m_initialPossibleValues;
    private String m_currentName;
    private String m_currentDescription;
    private ParameterType m_currentParameterType;
    private String m_currentDefaultValue;
    private String m_currentPossibleValuesAsString;
    private Set<?> m_currentPossibleValues;

    private static String getTitle(ParameterDefinition.Builder<?> parameterDefinition) {
        StringBuilder sb = new StringBuilder(parameterDefinition != null ? "Edit " : "Add ");
        if (parameterDefinition != null && parameterDefinition.isPredefined()) {
            sb.append("Predefined ");
        }
        sb.append("Parameter Definition");
        return sb.toString();
    }

    public ParameterDefinitionDialog(Shell parentShell, IGroovyProvider groovyProvider, List<ParameterDefinition.Builder> parameters, ParameterDefinition.Builder parameterToBeEdited) {
        super(parentShell, ParameterDefinitionDialog.getTitle(parameterToBeEdited));
        assert (groovyProvider != null) : "Parameter 'groovyProvider' of method 'ParameterDefinitionDialog' must not be null";
        assert (parameters != null) : "Parameter 'parameters' of method 'ParameterDefinitionDialog' must not be null";
        this.m_nameValidator = groovyProvider.getParameterNameValidator(parameters, parameterToBeEdited);
        this.m_defaultValueValidator = groovyProvider.getParameterValueValidator((IGroovyProvider.IParameterDefinitionInfoProvider)this);
        this.m_possibleValueValidator = groovyProvider.getParameterPossibleValuesValidator((IGroovyProvider.IParameterDefinitionInfoProvider)this);
        ParameterDefinition parameterDefinition = this.m_toBeEdited = parameterToBeEdited != null ? parameterToBeEdited.build() : null;
        if (this.m_toBeEdited != null) {
            this.m_initialName = this.m_toBeEdited.getName();
            this.m_initialDescription = this.m_toBeEdited.getDescription();
            this.m_initialParameterType = this.m_toBeEdited.getType();
            this.m_initialDefaultValue = this.m_toBeEdited.getDefaultValueAsString();
            this.m_initialPossibleValuesAsString = this.m_toBeEdited.getPossibleValuesAsString();
            this.m_initialPossibleValues = this.m_toBeEdited.getPossibleValues();
        } else {
            this.m_initialName = "";
            this.m_initialDescription = "";
            this.m_initialParameterType = ParameterType.STRING;
            this.m_initialDefaultValue = this.m_initialParameterType.getDefaultValue().toString();
            this.m_initialPossibleValuesAsString = this.m_initialParameterType.getPossibleValuesAsString();
            this.m_initialPossibleValues = this.m_initialParameterType.getPossibleValues();
        }
        this.m_currentName = this.m_initialName;
        this.m_currentDescription = this.m_initialDescription;
        this.m_currentParameterType = this.m_initialParameterType;
        this.m_currentDefaultValue = this.m_initialDefaultValue;
        this.m_currentPossibleValuesAsString = this.m_initialPossibleValuesAsString;
        this.m_currentPossibleValues = new LinkedHashSet(this.m_initialPossibleValues);
    }

    protected int getNumberOfColumns() {
        return 2;
    }

    protected Point getMaximumSize() {
        return new Point(500, 400);
    }

    protected Point getPreferredSize() {
        return new Point(450, 280);
    }

    public ParameterDefinition.Builder getParameterDefinition() {
        return this.m_parameterDefinitionBuilder;
    }

    private void setParameterType(ParameterType type) {
        assert (type != null) : "Parameter 'type' of method 'setParameterType' must not be null";
        this.m_currentParameterType = type;
        this.m_currentDefaultValue = type.getDefaultValue().toString();
        this.m_currentPossibleValuesAsString = type.getPossibleValuesAsString();
        this.m_currentPossibleValues = type.getPossibleValues();
        this.m_widgetPossibleValues.setText(this.m_currentPossibleValuesAsString);
        this.m_widgetPossibleValues.setEnabled(type.getPossibleValues().isEmpty());
        if (this.m_currentPossibleValues.isEmpty()) {
            this.createWidgetDefaultValueText();
        } else {
            this.createWidgetDefaultValueCombo();
        }
    }

    private void addParameterTypeRadioButton(final ParameterType type) {
        assert (this.m_widgetParameterType != null) : "'m_widgetParameterType' of method 'addParameterTypeRadioButton' must not be null";
        assert (this.m_initialParameterType != null) : "'m_initialParameterType' of method 'addParameterTypeRadioButton' must not be null";
        assert (type != null) : "Parameter 'type' of method 'createParameterTypeRadioButton' must not be null";
        Button radioButton = new Button((Composite)this.m_widgetParameterType, 16);
        radioButton.setText(type.getPresentationName());
        radioButton.setSelection(this.m_initialParameterType == type);
        radioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ParameterDefinitionDialog.this.setParameterType(type);
            }
        });
    }

    private void createWidgetDefaultValueText() {
        Control[] controlArray = this.m_widgetDefaultValuePlaceHolder.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control nextControl = controlArray[n2];
            nextControl.dispose();
            ++n2;
        }
        new ValidatingTextWidget(this.m_widgetDefaultValuePlaceHolder, this.m_defaultValueValidator, new ValidatingTextOrComboWidget.IConsumer(){

            public void setText(ValidatingTextOrComboWidget source, String input, boolean inputModified) {
                ParameterDefinitionDialog.this.m_currentDefaultValue = input;
                ParameterDefinitionDialog.this.applyData();
            }
        }, this.m_currentDefaultValue, true, false, 2048);
        this.m_widgetDefaultValuePlaceHolder.layout(true);
    }

    private void createWidgetDefaultValueCombo() {
        Control[] controlArray = this.m_widgetDefaultValuePlaceHolder.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control nextControl = controlArray[n2];
            nextControl.dispose();
            ++n2;
        }
        final Combo combo = new Combo(this.m_widgetDefaultValuePlaceHolder, 12);
        String[] items = new String[this.m_currentPossibleValues.size()];
        int index = 0;
        int toBeSelected = -1;
        for (Object next : this.m_currentPossibleValues) {
            items[index] = next.toString();
            if (next.equals(this.m_currentDefaultValue)) {
                toBeSelected = index;
            }
            ++index;
        }
        combo.setItems(items);
        if (toBeSelected != -1) {
            combo.select(toBeSelected);
        } else {
            combo.select(0);
            this.m_currentDefaultValue = combo.getItem(0);
        }
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParameterDefinitionDialog.this.m_currentDefaultValue = combo.getItem(combo.getSelectionIndex());
                ParameterDefinitionDialog.this.applyData();
            }
        });
        this.m_widgetDefaultValuePlaceHolder.layout(true);
    }

    protected void fillDialogArea(Composite composite) {
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText("Name: ");
        nameLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.m_widgetName = new ValidatingTextWidget(composite, this.m_nameValidator, new ValidatingTextOrComboWidget.IConsumer(){

            public void setText(ValidatingTextOrComboWidget source, String input, boolean inputModified) {
                ParameterDefinitionDialog.this.m_currentName = input;
                ParameterDefinitionDialog.this.applyData();
            }
        }, this.m_initialName, true, false, 2048);
        this.m_widgetName.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label descriptionLabel = new Label(composite, 0);
        descriptionLabel.setText("Description:");
        descriptionLabel.setLayoutData((Object)new GridData(1, 1, false, false));
        this.m_widgetDescription = new Text(composite, 834);
        int preferredHeight = SwtUtility.calculatePreferredHeight((Text)this.m_widgetDescription, (int)3);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.heightHint = preferredHeight;
        this.m_widgetDescription.setText(this.m_initialDescription);
        this.m_widgetDescription.setLayoutData((Object)gridData);
        this.m_widgetDescription.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ParameterDefinitionDialog.this.m_currentDescription = ParameterDefinitionDialog.this.m_widgetDescription.getText();
                ParameterDefinitionDialog.this.applyData();
            }
        });
        Label parameterType = new Label(composite, 0);
        parameterType.setText("Type:");
        this.m_widgetParameterType = new Group(composite, 0);
        RowLayout rowLayout = new RowLayout(256);
        rowLayout.center = true;
        rowLayout.fill = true;
        rowLayout.justify = true;
        this.m_widgetParameterType.setLayout((Layout)rowLayout);
        this.addParameterTypeRadioButton(ParameterType.STRING);
        this.addParameterTypeRadioButton(ParameterType.INTEGER);
        this.addParameterTypeRadioButton(ParameterType.BOOLEAN);
        this.m_widgetParameterType.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label defaultLabel = new Label(composite, 0);
        defaultLabel.setText("Default Value:");
        defaultLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.m_widgetDefaultValuePlaceHolder = new Composite(composite, 0);
        this.m_widgetDefaultValuePlaceHolder.setLayout((Layout)new FillLayout());
        this.m_widgetDefaultValuePlaceHolder.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label possibleValuesLabel = new Label(composite, 0);
        possibleValuesLabel.setText("Possible Values:");
        possibleValuesLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.m_widgetPossibleValues = new ValidatingTextWidget(composite, this.m_possibleValueValidator, new ValidatingTextOrComboWidget.IConsumer(){

            public void setText(ValidatingTextOrComboWidget source, String input, boolean inputModified) {
                ParameterDefinitionDialog.this.m_currentPossibleValuesAsString = input;
                if (input != null) {
                    List split = ParameterDefinitionDialog.this.m_currentParameterType.splitPossibleValues(ParameterDefinitionDialog.this.m_currentPossibleValuesAsString);
                    ParameterDefinitionDialog.this.m_currentPossibleValues = new LinkedHashSet(split);
                    if (ParameterDefinitionDialog.this.m_currentPossibleValues.isEmpty()) {
                        ParameterDefinitionDialog.this.createWidgetDefaultValueText();
                    } else {
                        ParameterDefinitionDialog.this.createWidgetDefaultValueCombo();
                    }
                }
                ParameterDefinitionDialog.this.applyData();
            }
        }, this.m_initialPossibleValuesAsString, true, false, 2048);
        this.m_widgetPossibleValues.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        if (this.m_toBeEdited != null && this.m_toBeEdited.isPredefined()) {
            this.m_widgetName.setEnabled(false);
            this.m_widgetDescription.setEnabled(false);
            this.m_widgetPossibleValues.setEnabled(false);
            this.m_widgetParameterType.setEnabled(false);
        } else {
            this.m_widgetPossibleValues.setEnabled(this.m_initialParameterType.getPossibleValues().isEmpty());
        }
        if (this.m_initialPossibleValues.isEmpty()) {
            this.createWidgetDefaultValueText();
        } else {
            this.createWidgetDefaultValueCombo();
        }
    }

    private ParameterDefinition.Builder createParameterDefinition() {
        ParameterDefinition.Builder result = ParameterDefinitionFactory.create((ParameterType)this.m_currentParameterType, (String)this.m_currentName);
        result.parseDefaultValue(this.m_currentDefaultValue);
        if (!this.m_currentPossibleValuesAsString.isEmpty()) {
            result.candidates(this.m_currentPossibleValuesAsString);
        }
        result.description(this.m_currentDescription);
        return result;
    }

    public boolean hasValidData() {
        return this.m_currentParameterType != null && this.m_currentName != null && this.m_currentDescription != null && this.m_currentDefaultValue != null && this.m_currentPossibleValuesAsString != null;
    }

    private boolean isModified() {
        return !this.m_initialParameterType.equals((Object)this.m_currentParameterType) || !this.m_initialName.equals(this.m_currentName) || !this.m_initialDescription.equals(this.m_currentDescription) || !this.m_initialDefaultValue.equals(this.m_currentDefaultValue) || !this.m_initialPossibleValuesAsString.equals(this.m_currentPossibleValuesAsString);
    }

    protected void okPressed() {
        assert (this.hasValidData()) : "Ok Button active, but invalid data";
        this.m_parameterDefinitionBuilder = this.createParameterDefinition();
        super.okPressed();
    }

    protected void applyData() {
        this.getButton(0).setEnabled(this.hasValidData() && this.isModified());
    }

    public ParameterType getCurrentParameterType() {
        return this.m_currentParameterType;
    }

    public String getCurrentParameterName() {
        return this.m_currentName;
    }

    public String getCurrentPossibleValuesAsString() {
        return this.m_currentPossibleValuesAsString;
    }
}

