/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.scriptview;

import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public final class LanguageControl
extends Composite {
    private final Map<Language, Button> m_buttons = new HashMap<Language, Button>();
    private final IConsumer m_consumer;

    public LanguageControl(Composite parent, IConsumer consumer, Set<Language> languages, Set<Language> selected, Set<Language> enabled) {
        super(parent, 0);
        assert (languages != null && languages.size() > 0) : "Parameter 'languages' of method 'LanguageControl' must not be empty";
        assert (selected != null) : "Parameter 'selected' of method 'LanguageControl' must not be null";
        assert (enabled != null) : "Parameter 'enabled' of method 'LanguageControl' must not be null";
        this.m_consumer = consumer;
        this.initSelected(languages, selected, enabled);
    }

    private void initSelected(Set<Language> languages, Set<Language> selected, Set<Language> enabled) {
        RowLayout rowLayout = new RowLayout();
        rowLayout.marginTop = 0;
        rowLayout.center = true;
        rowLayout.fill = true;
        this.setLayout((Layout)rowLayout);
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LanguageControl.this.selectionChanged();
            }
        };
        this.addCore();
        for (Language next : languages) {
            Button nextOption = new Button((Composite)this, 32);
            nextOption.setText(next.getPresentationName());
            nextOption.setSelection(selected.contains(next));
            nextOption.setEnabled(enabled.contains(next));
            nextOption.addSelectionListener((SelectionListener)selectionListener);
            this.m_buttons.put(next, nextOption);
        }
    }

    private void addCore() {
        Button coreLanguage = new Button((Composite)this, 32);
        coreLanguage.setText("Core");
        coreLanguage.setSelection(true);
        coreLanguage.setEnabled(false);
    }

    private void selectionChanged() {
        HashSet<Language> selectedLanguages = new HashSet<Language>();
        for (Language language : this.m_buttons.keySet()) {
            Button b = this.m_buttons.get(language);
            if (!b.getSelection()) continue;
            selectedLanguages.add(language);
        }
        this.m_consumer.setValue(selectedLanguages);
    }

    public static interface IConsumer {
        public void setValue(Set<Language> var1);
    }
}

