/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.resolutionsview;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.resolution.CreateFixIssueCommand;
import com.hello2morrow.sonargraph.core.model.context.IContext;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.Priority;
import com.hello2morrow.sonargraph.core.model.system.IIssueProvider;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.ui.standalone.resolutionsview.CreateIssueResolutionHandler;
import com.hello2morrow.sonargraph.ui.standalone.resolutionsview.ResolutionDialog;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import java.util.List;

public final class CreateFixIssueHandler
extends CreateIssueResolutionHandler {
    @Override
    protected String getKind() {
        return "Fix";
    }

    public ICommandId getCorrespondingCommandId() {
        return CoreCommandId.CREATE_FIX_ISSUE_RESOLUTION;
    }

    @Override
    protected void apply(ISoftwareSystemProvider provider, IIssueProvider issueProvider, IContext context, List<Element> elements) {
        assert (provider != null) : "Parameter 'provider' of method 'apply' must not be null";
        assert (issueProvider != null) : "Parameter 'issueProvider' of method 'apply' must not be null";
        assert (context != null) : "Parameter 'context' of method 'apply' must not be null";
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'apply' must not be empty";
        final List resolvableIssues = issueProvider.getAssociatedResolvableIssues(context, elements);
        assert (resolvableIssues != null && !resolvableIssues.isEmpty()) : "'resolvableIssues' of method 'apply' must not be empty";
        final ResolutionDialog dialog = new ResolutionDialog(WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), resolvableIssues.size() == 1 ? "Fix Issue" : "Fix Issues", null, null, "", Priority.MEDIUM, "", ResolutionDialog.Mode.CREATE, ResolutionDialog.AssigneeMode.SHOW, resolvableIssues);
        if (dialog.open() == 0) {
            CreateFixIssueCommand cmd = new CreateFixIssueCommand(provider, new CreateFixIssueCommand.ICreateFixIssueInteraction(){

                public boolean collect(CreateFixIssueCommand.CreateFixIssueData data) {
                    if (!$assertionsDisabled && data == null) {
                        throw new AssertionError((Object)"Parameter 'data' of method 'collect' must not be null");
                    }
                    data.setIssues(dialog.getSelectedIssues());
                    data.setComment(dialog.getDescription());
                    data.setAssignee(dialog.getAssignee());
                    data.setPriority(dialog.getPriority());
                    return true;
                }

                public void consumeMatchedIssuesInfo(List<Issue> matched) {
                    if (!$assertionsDisabled && matched == null) {
                        throw new AssertionError((Object)"Parameter 'matched' of method 'consumeMatchedIssuesInfo' must not be null");
                    }
                    CreateFixIssueHandler.this.handleMatchedIssuesInfo(resolvableIssues.size(), matched);
                }

                public void processCreateFixIssueResult(OperationResult result) {
                    if (!$assertionsDisabled && result == null) {
                        throw new AssertionError((Object)"Parameter 'result' of method 'processCreateFixIssueResult' must not be null");
                    }
                    UserInterfaceAdapter.getInstance().process(result);
                }
            });
            UserInterfaceAdapter.getInstance().run((Command)cmd);
        }
    }
}

