/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.qualitygateview;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.CommandException;
import com.hello2morrow.sonargraph.core.command.common.CommandResultConsumer;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.qualitygate.CreateQualityGateExcludeFilterCommand;
import com.hello2morrow.sonargraph.core.command.system.qualitygate.RequestAvailableIssueIdsAndMetricDescriptorsCommand;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.system.IQualityGateProvider;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.CurrentSystemConditions;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.DiffAgainstBaselineConditions;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGate;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGateExcludeFilter;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.ui.standalone.qualitygateview.QualityGateExcludeFilterWizard;
import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.SelectionBasedCommandHandler;
import com.hello2morrow.sonargraph.ui.swt.base.view.IContextMenuContributor;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.view.WorkbenchViewSelection;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.SonargraphWizard;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.SonargraphWizardAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchState;
import jakarta.inject.Named;
import java.util.List;
import java.util.Set;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;

public final class CreateExcludeFilterCommandHandler
extends SelectionBasedCommandHandler {
    public ICommandId getCorrespondingCommandId() {
        return CoreCommandId.CREATE_QUALITY_GATE_EXCLUDE_FILTER;
    }

    protected boolean internalCanExecute(IEclipseContext eclipseContext, MMenuItem menuItem, WorkbenchViewSelection selection) {
        assert (selection != null) : "Parameter 'selection' of method 'internalCanExecute' must not be null";
        if (selection.size() != 1 || !WorkbenchRegistry.getInstance().hasState(new WorkbenchState[]{WorkbenchState.SOFTWARE_SYSTEM_OPENED})) {
            return false;
        }
        Element selected = (Element)selection.getElements().get(0);
        return selected instanceof CurrentSystemConditions || selected instanceof DiffAgainstBaselineConditions;
    }

    public IContextMenuContributor createContextMenuContributor() {
        return new IContextMenuContributor(){

            public boolean showInContextMenu(IWorkbenchView workbenchView, List<Element> currentSelection) {
                return true;
            }
        };
    }

    @Execute
    public void execute(@Named(value="org.eclipse.ui.selection") WorkbenchViewSelection selection) {
        assert (selection.getElements().size() == 1) : "Unexpected number of seelcted elements: " + selection.getElements().size();
        Element selectedElement = (Element)selection.getElements().get(0);
        assert (selectedElement instanceof CurrentSystemConditions || selectedElement instanceof DiffAgainstBaselineConditions);
        final NamedElement conditions = (NamedElement)selectedElement;
        final QualityGate qualityGate = (QualityGate)conditions.getParent(QualityGate.class, new Class[0]);
        assert (qualityGate != null) : "Quality Gate must not be null";
        final RequestAvailableIssueIdsAndMetricDescriptorsCommand requestCommand = new RequestAvailableIssueIdsAndMetricDescriptorsCommand(WorkbenchRegistry.getInstance().getProvider());
        UserInterfaceAdapter.getInstance().run((Command)requestCommand, new CommandResultConsumer(){

            public void consume(CommandException exception) {
                if (exception != null) {
                    super.consume(exception);
                } else if (requestCommand.getResult() != null) {
                    UserInterfaceAdapter.getInstance().displayUiElement(() -> CreateExcludeFilterCommandHandler.this.openWizard(conditions, qualityGate, (Set)requestCommand.getResult().getFirst(), (Set)requestCommand.getResult().getSecond()));
                }
            }
        });
    }

    private void openWizard(final NamedElement conditions, final QualityGate qualityGate, Set<IIssueId> issueIds, Set<IMetricDescriptor> metricDescriptors) {
        final QualityGateExcludeFilterWizard wizard = new QualityGateExcludeFilterWizard((IQualityGateProvider)WorkbenchRegistry.getInstance().getSoftwareSystem().getExtension(IQualityGateProvider.class), issueIds, metricDescriptors);
        WizardDialog wizardDialog = SonargraphWizardAdapter.createWizardDialog((Shell)WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), (SonargraphWizard)wizard);
        if (wizardDialog.open() == 0) {
            CreateQualityGateExcludeFilterCommand command = new CreateQualityGateExcludeFilterCommand(WorkbenchRegistry.getInstance().getProvider(), new CreateQualityGateExcludeFilterCommand.ICreateFilterInteraction(){

                public boolean collect(CreateQualityGateExcludeFilterCommand.InteractionData data) {
                    data.setQualityGate(qualityGate);
                    data.setParent(conditions);
                    data.setFilterInfo(wizard.getFilterInfo());
                    return true;
                }

                public void processResult(OperationResultWithOutcome<QualityGateExcludeFilter> result) {
                    UserInterfaceAdapter.getInstance().process(result);
                }
            });
            UserInterfaceAdapter.getInstance().run((Command)command);
        }
    }
}

