/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.metricsview;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.system.RequestMetricValuesCommand;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerConfigurationFile;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricValue;
import com.hello2morrow.sonargraph.core.model.analysis.MetricScope;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.common.IMetricLevel;
import com.hello2morrow.sonargraph.core.model.common.IOriginator;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IElementGroup;
import com.hello2morrow.sonargraph.core.model.element.IElementResolver;
import com.hello2morrow.sonargraph.core.model.element.IResolution;
import com.hello2morrow.sonargraph.core.model.element.IStateData;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementIssue;
import com.hello2morrow.sonargraph.core.model.event.AnalyzerModificationEvent;
import com.hello2morrow.sonargraph.core.model.event.AnalyzerResultAvailableEvent;
import com.hello2morrow.sonargraph.core.model.event.MetricValuesAvailableEvent;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.event.MultipleModifiableFileModifiedEvent;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemProviderEvent;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.system.IMetricsProvider;
import com.hello2morrow.sonargraph.core.model.system.IThresholdProvider;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.export.IExportProvider;
import com.hello2morrow.sonargraph.core.model.system.export.MetricAccessKey;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.event.EventHandler;
import com.hello2morrow.sonargraph.foundation.event.EventManager;
import com.hello2morrow.sonargraph.foundation.export.ExportData;
import com.hello2morrow.sonargraph.foundation.file.IFileType;
import com.hello2morrow.sonargraph.foundation.file.IPathType;
import com.hello2morrow.sonargraph.foundation.propertyreader.BeanPropertyReader;
import com.hello2morrow.sonargraph.foundation.propertyreader.IPropertyReader;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.foundation.utilities.NumberUtility;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.ui.standalone.metricsview.Chart;
import com.hello2morrow.sonargraph.ui.standalone.metricsview.Histogram;
import com.hello2morrow.sonargraph.ui.standalone.metricsview.MetricDescriptorBeanAdapter;
import com.hello2morrow.sonargraph.ui.standalone.metricsview.MetricValueBeanAdapter;
import com.hello2morrow.sonargraph.ui.standalone.metricsview.MetricsInfo;
import com.hello2morrow.sonargraph.ui.standalone.metricsview.PieChart;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.textsearch.ITextSearchHandler;
import com.hello2morrow.sonargraph.ui.swt.base.view.RcpUtility;
import com.hello2morrow.sonargraph.ui.swt.base.view.Search;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableViewer;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableViewerBasedTextSearchHandler;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchSlaveView;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import com.hello2morrow.sonargraph.ui.swt.common.NavigationState;
import com.hello2morrow.sonargraph.ui.swt.common.ViewNavigationManager;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MetricsView
extends WorkbenchSlaveView
implements ISelectionChangedListener,
IOriginator {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetricsView.class);
    private static final String FILTER_HANDLED_ITEM_ID = "com.hello2morrow.sonargraph.standalone.handledmenuitem.hideissueignoring";
    private final MetricDescriptorBeanAdapter m_metricDescriptorBeanAdapter = new MetricDescriptorBeanAdapter(null);
    private final Set<IMetricDescriptor> m_availableMetricDescriptors = new THashSet();
    private final Map<IMetricDescriptor, TableViewerColumn> m_columnMap = new THashMap();
    private final Set<IMetricLevel> m_metricLevels = new TreeSet<IMetricLevel>((Comparator<IMetricLevel>)new IMetricLevel.MetricLevelComparator());
    private final List<NamedElement> m_scopeList = new ArrayList<NamedElement>();
    private final Map<IMetricDescriptor, List<IMetricValue>> m_allMetricValuesMap = new LinkedHashMap<IMetricDescriptor, List<IMetricValue>>();
    private final Map<IMetricDescriptor, List<IMetricValue>> m_filteredMetricValuesMap = new LinkedHashMap<IMetricDescriptor, List<IMetricValue>>();
    private final Map<MetricAccessKey, IMetricValue> m_valueMap = new THashMap();
    private IMetricsProvider m_metricsProvider;
    private IExportProvider m_exportProvider;
    private IThresholdProvider m_thresholdProvider;
    private PropertyTableViewerBasedTextSearchHandler m_metricValuesTableTextSearchHandler;
    private PropertyTableViewerBasedTextSearchHandler m_metricsTableTextSearchHandler;
    private Set<IMetricDescriptor> m_selectedMetricDescriptors = new LinkedHashSet<IMetricDescriptor>();
    private ViewComponent m_selectedViewComponent;
    private NamedElement m_currentScope;
    private boolean m_hideIssueIgnoringElements;
    private ComboViewer m_metricLevelCombo;
    private PropertyTableViewer<IMetricDescriptor> m_metricDescriptorTable;
    private ComboViewer m_scopeCombo;
    private CTabFolder m_metricValuesTabFolder;
    private CTabItem m_metricValueTableTab;
    private PropertyTableViewer<NamedElement> m_metricValueTable;
    private boolean m_metricValueTableNeedsRedraw;
    private CTabItem m_histogramTab;
    private Histogram m_histogram;
    private CTabItem m_pieChartTab;
    private PieChart m_pieChart;
    private MetricsInfo m_metricsInfo;

    public IViewId getViewId() {
        return ViewId.METRICS_VIEW;
    }

    protected final EnumSet<WorkbenchView.EventCategory> getDisabledEventCategories() {
        return EnumSet.of(WorkbenchView.EventCategory.INSTALLATION);
    }

    protected void createViewContent(Composite viewContentArea) {
        assert (viewContentArea != null) : "Parameter 'viewContentArea' of method 'createViewContent' must not be null";
        SashForm sashForm = new SashForm(viewContentArea, 256);
        SwtUtility.applySashSeparatorStyle((SashForm)sashForm);
        Composite metricsComposite = new Composite((Composite)sashForm, 0);
        metricsComposite.setLayout((Layout)SwtUtility.createMultipleRootWidgetGridLayoutWithoutMargin((int)2));
        metricsComposite.setBackground(UiResourceManager.getInstance().getBackgroundColor());
        Label levelLabel = new Label(metricsComposite, 0);
        levelLabel.setText("Level: ");
        this.m_metricLevelCombo = new ComboViewer(metricsComposite);
        this.m_metricLevelCombo.getCombo().setLayoutData((Object)new GridData(4, 0, true, false));
        this.m_metricLevelCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.m_metricLevelCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (!$assertionsDisabled && !(element instanceof IMetricLevel)) {
                    throw new AssertionError((Object)("Unexpected class: " + element.getClass().getName()));
                }
                return ((IMetricLevel)element).getPresentationName();
            }
        });
        this.m_metricDescriptorTable = new PropertyTableViewer(metricsComposite, (BeanPropertyReader.BeanAdapter)this.m_metricDescriptorBeanAdapter, "categoriesSort", true, PropertyTableViewer.SelectionType.MULTI_FULL_LINE);
        this.m_metricDescriptorTable.addColumn("Metric", "name", "name", "metricImage", 40, PropertyTableViewer.ColumnType.TEXT);
        this.m_metricDescriptorTable.addColumn("Categories", "categories", "categoriesSort", null, 25, PropertyTableViewer.ColumnType.TEXT);
        this.m_metricDescriptorTable.addColumn("Provider", "provider", "provider", null, 17, PropertyTableViewer.ColumnType.TEXT);
        this.m_metricDescriptorTable.addColumn("Min", "lowerThreshold", "lowerThreshold", null, 9, PropertyTableViewer.ColumnType.NUMBER);
        this.m_metricDescriptorTable.addColumn("Max", "upperThreshold", "upperThreshold", null, 9, PropertyTableViewer.ColumnType.NUMBER);
        this.m_metricDescriptorTable.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.m_metricDescriptorTable.addSortProperty("mainCategory", true, false);
        this.m_metricDescriptorTable.addSortProperty("name", true, false);
        Composite metricValuesComposite = new Composite((Composite)sashForm, 0);
        metricValuesComposite.setLayout((Layout)SwtUtility.createMultipleRootWidgetGridLayoutWithoutMargin((int)2));
        metricValuesComposite.setBackground(UiResourceManager.getInstance().getBackgroundColor());
        Label scopeLabel = new Label(metricValuesComposite, 0);
        scopeLabel.setText("Scope: ");
        this.m_scopeCombo = new ComboViewer(metricValuesComposite);
        this.m_scopeCombo.getCombo().setLayoutData((Object)new GridData(4, 0, true, false));
        this.m_scopeCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.m_scopeCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof NamedElement) {
                    StringBuilder postfix = new StringBuilder();
                    if (element instanceof SoftwareSystem) {
                        postfix.append(" (System)");
                    } else if (element instanceof Module) {
                        postfix.append(" (Module)");
                    }
                    return ((NamedElement)element).getName() + postfix.toString();
                }
                if (element instanceof String) {
                    return (String)element;
                }
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)("Unexpected class in scope combo: " + element.getClass().getName()));
                }
                return "";
            }

            public Image getImage(Object element) {
                if (element instanceof Element) {
                    return UiResourceManager.getInstance().getImage((Element)element);
                }
                return null;
            }
        });
        this.m_metricValuesTabFolder = SwtUtility.createTabFolder((Composite)metricValuesComposite);
        this.m_metricValuesTabFolder.setBackground(metricValuesComposite.getBackground());
        this.m_metricValuesTabFolder.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.m_metricValueTableTab = new CTabItem(this.m_metricValuesTabFolder, 0);
        this.m_metricValueTableTab.setText("Values");
        this.m_metricValueTableTab.setImage(UiResourceManager.getInstance().getImage("ListView"));
        MetricValueAccessor accessor = new MetricValueAccessor(new MetricValueBeanAdapter());
        this.m_metricValueTable = new PropertyTableViewer((Composite)this.m_metricValuesTabFolder, (IPropertyReader)accessor, PropertyTableViewer.SelectionType.SINGLE_COLUMN, null);
        this.m_metricValueTable.addColumn("Element", "element", "element", "elementImage", 350, PropertyTableViewer.ColumnType.TEXT);
        this.m_metricValueTable.setCellImageProvider((PropertyTableViewer.ICellImageProvider)accessor);
        this.m_metricValueTableTab.setControl(this.m_metricValueTable);
        this.m_metricValueTable.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_metricValueTable.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent arg0) {
                if (MetricsView.this.m_metricValueTableNeedsRedraw) {
                    MetricsView.this.m_metricValueTable.layout(true);
                    MetricsView.this.m_metricValueTableNeedsRedraw = false;
                }
            }
        });
        this.m_histogramTab = new CTabItem(this.m_metricValuesTabFolder, 0);
        this.m_histogramTab.setText("Histogram");
        this.m_histogramTab.setImage(UiResourceManager.getInstance().getImage("BarChartView"));
        this.m_histogram = new Histogram((Composite)this.m_metricValuesTabFolder);
        this.m_histogramTab.setControl((Control)this.m_histogram);
        this.m_pieChartTab = new CTabItem(this.m_metricValuesTabFolder, 0);
        this.m_pieChartTab.setText("Pie Chart");
        this.m_pieChartTab.setImage(UiResourceManager.getInstance().getImage("PieChart"));
        this.m_pieChart = new PieChart((Composite)this.m_metricValuesTabFolder);
        this.m_pieChartTab.setControl((Control)this.m_pieChart);
        this.m_metricsInfo = new MetricsInfo(metricValuesComposite);
        this.m_metricsInfo.setLayoutData(new GridData(4, 4, true, false, 2, 1));
        this.m_metricValuesTabFolder.setSelection(this.m_metricValueTableTab);
        this.m_selectedViewComponent = ViewComponent.METRICS;
        this.m_metricsTableTextSearchHandler = new PropertyTableViewerBasedTextSearchHandler(this.m_metricDescriptorTable, this.getViewId().getPresentationName());
        this.m_metricValuesTableTextSearchHandler = new PropertyTableViewerBasedTextSearchHandler(this.m_metricValueTable, this.getViewId().getPresentationName());
        this.addListeners();
        EventManager.getInstance().attach((EventHandler)new EventHandler<AnalyzerResultAvailableEvent>(AnalyzerResultAvailableEvent.class, (Object)this){

            public void handleEvent(AnalyzerResultAvailableEvent event) {
                if (MetricsView.this.canHandleEvent((SoftwareSystemProviderEvent)event) && event.getOriginator() == null) {
                    MetricsView.this.removeListeners();
                    MetricsView.this.setRedraw(false);
                    MetricsView.this.refreshViews();
                    MetricsView.this.setRedraw(true);
                    MetricsView.this.addListeners();
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<MetricValuesAvailableEvent>(MetricValuesAvailableEvent.class, (Object)this){

            public void handleEvent(MetricValuesAvailableEvent event) {
                if (MetricsView.this.canHandleEvent((SoftwareSystemProviderEvent)event) && event.getOriginator() == MetricsView.this) {
                    MetricsView.this.handleMetricValuesAvailableEvent(event);
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<MultipleModifiableFileModifiedEvent>(MultipleModifiableFileModifiedEvent.class, (Object)this){

            public void handleEvent(MultipleModifiableFileModifiedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"'event' must not be null");
                }
                if (MetricsView.this.canHandleEvent((SoftwareSystemProviderEvent)event) && event.containsPathOfType(new IPathType[]{CoreFileType.ANALYZER_CONFIGURATION})) {
                    for (IModifiableFile next : event.getModifiableFiles()) {
                        IFileType nextFileType = next.getFileType();
                        if (nextFileType != CoreFileType.ANALYZER_CONFIGURATION || !CoreAnalyzerId.METRIC_THRESHOLDS.equals((Object)((AnalyzerConfigurationFile)next).getAnalyzerId())) continue;
                        MetricsView.this.refreshViews();
                    }
                }
            }
        });
        Installation installation = this.getInstallation();
        this.m_metricsProvider = (IMetricsProvider)installation.getExtension(IMetricsProvider.class);
        this.m_exportProvider = (IExportProvider)installation.getExtension(IExportProvider.class);
    }

    public List<Control> getControlsForInteraction() {
        return Arrays.asList(this.m_metricValueTable.getTable(), this.m_metricDescriptorTable.getTable(), this.m_histogram.getCanvas(), this.m_pieChart.getCanvas());
    }

    protected boolean supportsSleep() {
        return false;
    }

    public boolean supportsImageExport() {
        if (this.getSoftwareSystemProvider().hasSoftwareSystem()) {
            if (this.m_selectedViewComponent == ViewComponent.HISTOGRAM) {
                return !this.m_histogram.isEmpty();
            }
            if (this.m_selectedViewComponent == ViewComponent.PIECHART) {
                return !this.m_pieChart.isEmpty();
            }
        }
        return false;
    }

    public OperationResult exportToImage(TFile targetFile) {
        assert (targetFile != null) : "Parameter 'targetFile' of method 'exportToImage' must not be null";
        assert (this.supportsImageExport()) : "Image export not supported. Selected component: " + this.m_selectedViewComponent.getStandardName();
        Chart chart = null;
        if (this.m_selectedViewComponent == ViewComponent.HISTOGRAM) {
            chart = this.m_histogram;
        } else if (this.m_selectedViewComponent == ViewComponent.PIECHART) {
            chart = this.m_pieChart;
        } else assert (false) : "Unsupported view component: " + this.m_selectedViewComponent.getStandardName();
        assert (chart != null) : "Chart must not be null";
        assert (this.m_selectedMetricDescriptors.size() == 1) : "Image export must not be enabled for multi-metric selection";
        OperationResult result = new OperationResult("Saving " + chart.getType() + " of '" + this.m_selectedMetricDescriptors.iterator().next().getPresentationName() + "'");
        try {
            chart.exportToImage(targetFile);
        }
        catch (IOException ex) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.IO_EXCEPTION, (Throwable)ex);
        }
        return result;
    }

    private void handleMetricLevelChanged(IMetricLevel metricLevel, boolean requestMetricValuesIfPossible) {
        assert (metricLevel != null) : "Parameter 'metricLevel' of method 'handleMetricLevelChanged' must not be null";
        assert (this.m_metricsProvider != null) : "'m_metricsProvider' of method 'handleMetricLevelChanged' must not be null";
        if (!this.m_metricDescriptorTable.isDisposed()) {
            List metrics = this.m_metricsProvider.getAvailableMetricDescriptorsForLevel(metricLevel, true);
            this.m_metricDescriptorTable.showData((Collection)metrics);
            this.clearMetricSelection();
            this.m_metricDescriptorTable.getTableViewer().setSelection(null);
            this.updateMetricValues(this.m_filteredMetricValuesMap);
        }
    }

    private void handleMetricChanged(Set<IMetricDescriptor> newMetricDescriptors, boolean requestMetricValuesIfPossible) {
        assert (newMetricDescriptors != null) : "Parameter 'newMetricDescriptors' of method 'handleMetricChanged' must not be null";
        if (this.m_selectedMetricDescriptors.equals(newMetricDescriptors)) {
            return;
        }
        LinkedHashSet<IMetricDescriptor> descriptorsToRequest = new LinkedHashSet<IMetricDescriptor>();
        for (IMetricDescriptor newDescriptor : newMetricDescriptors) {
            if (!this.m_selectedMetricDescriptors.add(newDescriptor)) continue;
            String metricName = newDescriptor.getShortName();
            this.m_columnMap.put(newDescriptor, this.m_metricValueTable.addColumn(metricName, metricName, metricName, null, 100, PropertyTableViewer.ColumnType.NUMBER));
            descriptorsToRequest.add(newDescriptor);
        }
        for (IMetricDescriptor oldDescr : this.m_selectedMetricDescriptors) {
            if (newMetricDescriptors.contains(oldDescr)) continue;
            this.removeColumnFor(oldDescr);
            this.m_allMetricValuesMap.remove(oldDescr);
            this.m_filteredMetricValuesMap.remove(oldDescr);
        }
        this.m_selectedMetricDescriptors = newMetricDescriptors;
        if (this.m_selectedMetricDescriptors.size() == 1) {
            this.m_metricValueTable.addSortProperty(this.m_selectedMetricDescriptors.iterator().next().getShortName(), false, true);
        }
        this.m_metricValueTable.adaptColumnSizes();
        if (!newMetricDescriptors.isEmpty()) {
            IMetricDescriptor firstDescriptor = newMetricDescriptors.iterator().next();
            MetricScope metricScope = firstDescriptor.getMetricId().getMetricScope();
            switch (metricScope) {
                case SYSTEM: {
                    if (this.m_currentScope == this.getSoftwareSystem()) break;
                    this.m_currentScope = this.getSoftwareSystem();
                    this.filterAndUpdateMetricValues();
                    break;
                }
                case MODULE: {
                    if (this.m_currentScope != this.getSoftwareSystem()) break;
                    this.m_currentScope = this.m_scopeList.get(1);
                    this.filterAndUpdateMetricValues();
                    break;
                }
                default: {
                    assert (false) : "Unhandled scope: " + String.valueOf(metricScope);
                    break;
                }
            }
            this.updateScopeCombo(metricScope);
        } else {
            this.updateScopeCombo(null);
        }
        if (!descriptorsToRequest.isEmpty() && requestMetricValuesIfPossible) {
            SoftwareSystem softwareSystem = this.getSoftwareSystem();
            assert (softwareSystem != null) : "'softwareSystem' of method 'handleElementMetricChanged' must not be null";
            UserInterfaceAdapter.getInstance().run((Command)new RequestMetricValuesCommand(this.getSoftwareSystemProvider(), descriptorsToRequest, (NamedElement)softwareSystem, false, (IOriginator)this));
        }
        this.filterAndUpdateMetricValues();
    }

    private IMetricLevel getSelectedMetricLevel() {
        IMetricLevel level = (IMetricLevel)((IStructuredSelection)this.m_metricLevelCombo.getSelection()).getFirstElement();
        assert (level != null) : "Parameter 'level' of method 'getSelectedMetricLevel' must not be null";
        return level;
    }

    private void refreshViews() {
        NavigationState state;
        THashSet currentMetricDescriptorsAsSet;
        assert (this.m_metricsProvider != null) : "'m_metricsProvider' of method 'refreshViews' must not be null";
        boolean metricDescriptorTableNeedsRefresh = true;
        IMetricLevel metricLevel = this.getSelectedMetricLevel();
        List newlyAvailableMetricDescriptors = this.m_metricsProvider.getAvailableMetricDescriptorsForLevel(metricLevel, true);
        THashSet newlyAvailableMetricDescriptorsAsSet = new THashSet((Collection)newlyAvailableMetricDescriptors);
        Collection currentMetricDescriptors = this.m_metricDescriptorTable.getInputData();
        THashSet tHashSet = currentMetricDescriptorsAsSet = currentMetricDescriptors != null ? new THashSet(currentMetricDescriptors) : Collections.emptySet();
        if (!newlyAvailableMetricDescriptorsAsSet.equals(currentMetricDescriptorsAsSet)) {
            this.m_metricDescriptorTable.showData((Collection)newlyAvailableMetricDescriptors);
            metricDescriptorTableNeedsRefresh = false;
        }
        if ((state = ViewNavigationManager.getInstance().getCurrentViewNavigationState(this.getViewId(), this.getSecondaryId())) != null) {
            this.applyNavigationState(state);
        } else {
            this.handleMetricChanged(Collections.emptySet(), true);
        }
        if (metricDescriptorTableNeedsRefresh) {
            this.m_metricDescriptorTable.refresh();
        }
        IMetricDescriptor firstDescriptor = this.m_selectedMetricDescriptors.isEmpty() ? null : this.m_selectedMetricDescriptors.iterator().next();
        List<IMetricValue> metricValues = firstDescriptor != null ? this.m_filteredMetricValuesMap.get(firstDescriptor) : null;
        this.m_metricsInfo.update(firstDescriptor, metricValues == null ? Collections.emptyList() : metricValues, this.m_thresholdProvider);
        this.m_metricValueTable.refresh();
    }

    private void updateScopeCombo(MetricScope metricScope) {
        block6: {
            block5: {
                if (metricScope == null) break block5;
                switch (metricScope) {
                    case SYSTEM: {
                        List<NamedElement> system = this.m_scopeList.subList(0, 1);
                        this.m_scopeCombo.setInput(system);
                        this.m_scopeCombo.setSelection((ISelection)new StructuredSelection(system));
                        this.m_scopeCombo.getControl().setEnabled(false);
                        break block6;
                    }
                    case MODULE: {
                        List<NamedElement> modules = this.m_scopeList.subList(1, this.m_scopeList.size());
                        this.m_scopeCombo.setInput(modules);
                        this.m_scopeCombo.setSelection((ISelection)new StructuredSelection((Object)this.m_currentScope));
                        this.m_scopeCombo.getControl().setEnabled(true);
                        break block6;
                    }
                    default: {
                        assert (false) : "Unhandled scope: " + String.valueOf(metricScope);
                        break block6;
                    }
                }
            }
            this.m_currentScope = this.getSoftwareSystem();
            this.m_scopeCombo.setInput(Arrays.asList("n/a"));
            this.m_scopeCombo.setSelection((ISelection)new StructuredSelection((Object)"n/a"));
            this.m_scopeCombo.getControl().setEnabled(false);
        }
    }

    private Map<IMetricDescriptor, List<IMetricValue>> filterMetricValues(Map<IMetricDescriptor, List<IMetricValue>> allMetricValues, NamedElement currentScope) {
        assert (this.m_metricsProvider != null) : "'m_metricsProvider' of method 'filterMetricValues' must not be null";
        assert (allMetricValues != null) : "Parameter 'allMetricValues' of method 'filterMetricValues' must not be null";
        assert (currentScope != null) : "Parameter 'currentScope' of method 'filterMetricValues' must not be null";
        if (currentScope == this.getSoftwareSystem() && !this.m_hideIssueIgnoringElements) {
            return allMetricValues;
        }
        LinkedHashMap<IMetricDescriptor, List<IMetricValue>> filtered = new LinkedHashMap<IMetricDescriptor, List<IMetricValue>>();
        for (Map.Entry<IMetricDescriptor, List<IMetricValue>> nextEntry : allMetricValues.entrySet()) {
            List<IMetricValue> filteredValues = currentScope == this.getSoftwareSystem() ? nextEntry.getValue() : this.filterValuesByScope(nextEntry.getValue(), currentScope, this.m_metricsProvider);
            filteredValues = this.filterIssueIgnoringElementsIfNeeded(filteredValues);
            filtered.put(nextEntry.getKey(), filteredValues);
        }
        return filtered;
    }

    private List<IMetricValue> filterIssueIgnoringElementsIfNeeded(List<IMetricValue> filteredValues) {
        assert (filteredValues != null) : "Parameter 'filteredValues' of method 'filterIssueIgnoringElementsIfNeeded' must not be null";
        if (this.m_hideIssueIgnoringElements) {
            filteredValues = filteredValues.parallelStream().filter(v -> !v.getAssociatedElement().ignoreIssues()).collect(Collectors.toList());
        }
        return filteredValues;
    }

    private List<IMetricValue> filterValuesByScope(List<IMetricValue> values, NamedElement scope, IMetricsProvider metricsProvider) {
        assert (values != null) : "Parameter 'values' of method 'filterValuesByScope' must not be null";
        assert (scope != null) : "Parameter 'scope' of method 'filterValuesByScope' must not be null";
        assert (metricsProvider != null) : "Parameter 'metricsProvider' of method 'filterValuesByScope' must not be null";
        if (scope == this.getSoftwareSystem()) {
            return values;
        }
        return values.stream().filter(mv -> scope == metricsProvider.getModuleScopeOf(mv.getAssociatedElement())).collect(Collectors.toList());
    }

    private void handleMetricValuesAvailableEvent(MetricValuesAvailableEvent event) {
        assert (event != null) : "Parameter 'event' of method 'handleMetricValuesAvailableEvent' must not be null";
        assert (this.m_metricsProvider != null) : "'m_metricsProvider' of method 'handleMetricValuesAvailableEvent' must not be null";
        LOGGER.debug("Handle metrics available");
        boolean elementMetricsChanged = false;
        for (IMetricDescriptor nextMetricDescriptor : event.getMetricDescriptors()) {
            if (!this.m_selectedMetricDescriptors.contains(nextMetricDescriptor)) continue;
            List<IMetricValue> allValues = this.m_allMetricValuesMap.get(nextMetricDescriptor);
            if (allValues != null) {
                allValues.clear();
            } else {
                allValues = new ArrayList<IMetricValue>();
                this.m_allMetricValuesMap.put(nextMetricDescriptor, allValues);
            }
            allValues.addAll(event.getMetricValues(nextMetricDescriptor));
            List<IMetricValue> filteredPreviousValues = this.m_filteredMetricValuesMap.get(nextMetricDescriptor);
            List<IMetricValue> filtered = this.filterValuesByScope(allValues, this.m_currentScope, this.m_metricsProvider);
            filtered = this.filterIssueIgnoringElementsIfNeeded(filtered);
            if (filteredPreviousValues == null) {
                this.m_filteredMetricValuesMap.put(nextMetricDescriptor, filtered);
            } else if (filtered != allValues) {
                filteredPreviousValues.clear();
                filteredPreviousValues.addAll(filtered);
            }
            elementMetricsChanged = true;
        }
        if (elementMetricsChanged) {
            this.removeListeners();
            this.setRedraw(false);
            this.updateMetricValues(this.m_filteredMetricValuesMap);
            this.setRedraw(true);
            this.addListeners();
        }
    }

    protected void destroyViewContent() {
        EventManager.getInstance().detach(AnalyzerResultAvailableEvent.class, (Object)this);
        EventManager.getInstance().detach(MetricValuesAvailableEvent.class, (Object)this);
        EventManager.getInstance().detach(MultipleModifiableFileModifiedEvent.class, (Object)this);
        super.destroyViewContent();
    }

    private void resetViews() {
        this.m_metricLevelCombo.setInput(this.m_metricLevels);
        this.updateMetricValues(this.m_filteredMetricValuesMap);
        boolean forceLevelSelection = true;
        if (!this.m_selectedMetricDescriptors.isEmpty()) {
            THashSet invalidDescriptors = new THashSet();
            boolean scopeComboIsUpdated = false;
            for (IMetricDescriptor next : this.m_selectedMetricDescriptors) {
                if (!next.isValid()) {
                    invalidDescriptors.add(next);
                    continue;
                }
                this.m_metricLevelCombo.setSelection((ISelection)new StructuredSelection((Object)next.getLevel()));
                this.updateScopeCombo(next.getMetricId().getMetricScope());
                forceLevelSelection = false;
            }
            invalidDescriptors.forEach(d -> this.removeColumnFor((IMetricDescriptor)d));
            this.m_selectedMetricDescriptors.removeAll((Collection<?>)invalidDescriptors);
            if (this.m_selectedMetricDescriptors.isEmpty()) {
                this.m_valueMap.clear();
                this.m_filteredMetricValuesMap.clear();
                this.m_allMetricValuesMap.clear();
            }
        }
        if (forceLevelSelection && !this.m_metricLevels.isEmpty()) {
            this.m_metricLevelCombo.getCombo().select(0);
            this.handleMetricLevelChanged(this.getSelectedMetricLevel(), false);
        }
    }

    protected void softwareSystemShow(WorkbenchView.ShowMode mode) {
        assert (mode != null) : "Parameter 'mode' of method 'softwareSystemShow' must not be null";
        assert (this.m_metricsProvider != null) : "'m_metricsProvider' of method 'softwareSystemShow' must not be null";
        this.checkShowIssueIgnoringElements();
        SoftwareSystem softwareSystem = this.getSoftwareSystem();
        this.m_thresholdProvider = (IThresholdProvider)softwareSystem.getExtension(IThresholdProvider.class);
        this.m_metricDescriptorBeanAdapter.setThresholdProvider(this.m_thresholdProvider);
        this.m_histogram.setThresholdProvider(this.m_thresholdProvider);
        this.m_pieChart.setThresholdProvider(this.m_thresholdProvider);
        this.m_availableMetricDescriptors.addAll(this.m_metricsProvider.getAvailableMetricDescriptors());
        this.m_metricLevels.addAll(this.m_metricsProvider.getAvailableElementMetricLevels(true, true));
        this.m_scopeList.addAll(this.m_metricsProvider.getAvailableMetricScopes(softwareSystem));
        this.m_currentScope = softwareSystem;
        this.removeListeners();
        this.setRedraw(false);
        this.resetViews();
        this.setRedraw(true);
        this.addListeners();
        this.requestMetricValues();
        super.softwareSystemShow(mode);
    }

    private void removeInvalidValues(Map<IMetricDescriptor, List<IMetricValue>> metricValues, Map<IMetricDescriptor, List<IMetricValue>> allMetricValues) {
        IMetricValue nextMetricValue;
        Iterator<IMetricValue> iter;
        assert (metricValues != null) : "Parameter 'metricValues' of method 'removeInvalidValues' must not be null";
        assert (allMetricValues != null) : "Parameter 'allMetricValues' of method 'removeInvalidValues' must not be null";
        boolean modified = false;
        for (Map.Entry<IMetricDescriptor, List<IMetricValue>> nextEntry : metricValues.entrySet()) {
            iter = nextEntry.getValue().iterator();
            while (iter.hasNext()) {
                nextMetricValue = iter.next();
                if (nextMetricValue.isValid()) continue;
                iter.remove();
                modified = true;
            }
        }
        if (modified) {
            this.updateMetricValues(metricValues);
        }
        for (Map.Entry<IMetricDescriptor, List<IMetricValue>> nextEntry : allMetricValues.entrySet()) {
            iter = nextEntry.getValue().iterator();
            while (iter.hasNext()) {
                nextMetricValue = iter.next();
                if (nextMetricValue.isValid()) continue;
                iter.remove();
            }
        }
    }

    protected void softwareSystemModified(EnumSet<Modification> modification, boolean restoredFromHistory) {
        List scopeList;
        assert (this.m_metricsProvider != null) : "'m_metricsProvider' of method 'softwareSystemModified' must not be null";
        super.softwareSystemModified(modification, restoredFromHistory);
        this.removeListeners();
        this.setRedraw(false);
        boolean reset = false;
        Set availableMetricDescriptors = this.m_metricsProvider.getAvailableMetricDescriptors();
        if (!availableMetricDescriptors.equals(this.m_availableMetricDescriptors)) {
            this.m_availableMetricDescriptors.clear();
            this.m_availableMetricDescriptors.addAll(availableMetricDescriptors);
            reset = true;
        }
        if (!(scopeList = this.m_metricsProvider.getAvailableMetricScopes(this.getSoftwareSystem())).equals(this.m_scopeList)) {
            this.m_scopeList.clear();
            this.m_scopeList.addAll(scopeList);
            if (!this.m_scopeList.contains(this.m_currentScope)) {
                this.m_currentScope = this.m_currentScope != null && !(this.m_currentScope instanceof SoftwareSystem) && this.m_scopeList.size() > 1 ? this.m_scopeList.get(1) : this.getSoftwareSystem();
            }
        }
        if (reset) {
            this.m_metricLevels.clear();
            this.m_allMetricValuesMap.clear();
            this.m_filteredMetricValuesMap.clear();
            this.m_metricLevels.addAll(this.m_metricsProvider.getAvailableElementMetricLevels(true, true));
            this.resetViews();
        } else {
            this.removeInvalidValues(this.m_filteredMetricValuesMap, this.m_allMetricValuesMap);
            this.refreshViews();
        }
        this.m_metricsTableTextSearchHandler.requestNewFindInfo();
        this.m_metricValuesTableTextSearchHandler.requestNewFindInfo();
        this.setRedraw(true);
        this.addListeners();
        this.requestMetricValues();
    }

    protected void analyzerModification(EnumSet<AnalyzerModificationEvent.AnalyzerModification> modification, IAnalyzerId analyzerId) {
        assert (modification != null) : "Parameter 'modification' of method 'analyzerModification' must not be null";
        if (modification.contains(AnalyzerModificationEvent.AnalyzerModification.METRIC_DESCRIPTOR_ADDED)) {
            this.refreshViews();
        } else if (modification.contains(AnalyzerModificationEvent.AnalyzerModification.METRIC_VALUE_ADDED)) {
            this.requestMetricValues();
        }
        super.analyzerModification(modification, analyzerId);
    }

    private void removeColumnFor(IMetricDescriptor descriptor) {
        assert (descriptor != null) : "Parameter 'descriptor' of method 'removeColumnFor' must not be null";
        TableViewerColumn column = this.m_columnMap.remove(descriptor);
        if (column != null) {
            this.m_metricValueTable.removeColumn(column, 100);
        }
    }

    private void clearMetricSelection() {
        this.m_selectedMetricDescriptors.forEach(d -> this.removeColumnFor((IMetricDescriptor)d));
        this.m_selectedMetricDescriptors.clear();
        this.m_valueMap.clear();
        this.m_allMetricValuesMap.clear();
        this.m_filteredMetricValuesMap.clear();
        this.updateScopeCombo(null);
    }

    protected void softwareSystemHide(WorkbenchView.HideMode mode) {
        super.softwareSystemHide(mode);
        this.removeListeners();
        this.setRedraw(false);
        this.m_metricLevelCombo.setInput(null);
        this.m_metricDescriptorTable.showData(null);
        this.m_scopeCombo.setInput(null);
        this.m_metricValueTable.showData(null);
        this.m_histogram.clear();
        this.m_histogram.setThresholdProvider(null);
        this.m_pieChart.clear();
        this.m_pieChart.setThresholdProvider(null);
        this.m_allMetricValuesMap.clear();
        this.m_filteredMetricValuesMap.clear();
        this.m_availableMetricDescriptors.clear();
        this.m_metricLevels.clear();
        this.m_selectedMetricDescriptors.forEach(d -> this.removeColumnFor((IMetricDescriptor)d));
        this.m_selectedMetricDescriptors.clear();
        this.m_valueMap.clear();
        this.m_thresholdProvider = null;
        this.m_metricDescriptorBeanAdapter.setThresholdProvider(null);
        this.m_scopeList.clear();
        this.m_currentScope = null;
        this.m_metricsInfo.reset();
        this.setRedraw(true);
        this.addListeners();
    }

    public NamedElement getLinkNamedElement(Element element) {
        assert (element != null) : "Parameter 'element' of method 'getLinkNamedElement' must not be null";
        if (element instanceof IMetricValue) {
            IMetricValue metricValue = (IMetricValue)element;
            return metricValue.getAssociatedElement();
        }
        if (element instanceof NamedElement) {
            return (NamedElement)element;
        }
        return null;
    }

    private void removeListeners() {
        this.m_metricDescriptorTable.getTableViewer().removeSelectionChangedListener((ISelectionChangedListener)this);
        this.m_metricLevelCombo.removeSelectionChangedListener((ISelectionChangedListener)this);
        this.m_scopeCombo.removeSelectionChangedListener((ISelectionChangedListener)this);
        this.m_metricValueTable.getTableViewer().removeSelectionChangedListener((ISelectionChangedListener)this);
    }

    private void addListeners() {
        this.m_metricDescriptorTable.getTableViewer().addSelectionChangedListener((ISelectionChangedListener)this);
        this.m_metricLevelCombo.addSelectionChangedListener((ISelectionChangedListener)this);
        this.m_scopeCombo.addSelectionChangedListener((ISelectionChangedListener)this);
        this.m_metricValueTable.getTableViewer().addSelectionChangedListener((ISelectionChangedListener)this);
    }

    private void requestMetricValues() {
        if (!this.m_selectedMetricDescriptors.isEmpty()) {
            LOGGER.debug("Request metric values");
            SoftwareSystem softwareSystem = this.getSoftwareSystem();
            assert (softwareSystem != null) : "'softwareSystem' of method 'requestMetricValues' must not be null";
            UserInterfaceAdapter.getInstance().run((Command)new RequestMetricValuesCommand(this.getSoftwareSystemProvider(), this.m_selectedMetricDescriptors, (NamedElement)softwareSystem, false, (IOriginator)this));
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        assert (event != null) : "Parameter 'event' of method 'selectionChanged' must not be null";
        if (!this.isActive()) {
            return;
        }
        this.removeListeners();
        if (event.getSource() == this.m_metricDescriptorTable.getTableViewer()) {
            this.m_selectedViewComponent = ViewComponent.METRICS;
            LinkedHashSet<IMetricDescriptor> selectedMetrics = new LinkedHashSet<IMetricDescriptor>();
            if (!event.getSelection().isEmpty()) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                selection.toList().stream().filter(s -> s instanceof IMetricDescriptor).forEach(s -> {
                    boolean bl = selectedMetrics.add((IMetricDescriptor)s);
                });
            }
            this.handleMetricChanged(selectedMetrics, true);
        } else if (event.getSource() == this.m_metricLevelCombo) {
            IMetricLevel selected = null;
            if (!event.getSelection().isEmpty()) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                assert (selection.getFirstElement() instanceof IMetricLevel) : "Unexpected class: " + selection.getFirstElement().getClass().getName();
                selected = (IMetricLevel)selection.getFirstElement();
            }
            this.clearMetricSelection();
            this.handleMetricLevelChanged(selected, true);
        } else if (event.getSource() == this.m_scopeCombo && !event.getSelection().isEmpty()) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            Object firstElement = selection.getFirstElement();
            assert (firstElement instanceof NamedElement || firstElement instanceof String) : "Unexpected class: " + firstElement.getClass().getName();
            Object newScope = firstElement instanceof NamedElement ? (NamedElement)firstElement : this.getSoftwareSystem();
            if (newScope != this.m_currentScope) {
                this.m_currentScope = newScope;
                this.filterAndUpdateMetricValues();
            }
        }
        this.addListeners();
        NavigationState state = ViewNavigationManager.getInstance().createNavigationState(this.getViewId(), this.getSecondaryId(), NavigationState.Type.CONTENT_SELECTED);
        this.createNavigationState(state);
        ViewNavigationManager.getInstance().addNavigationState(state);
        this.getSelectionProviderAdapter().handleSelectionChanged(this.getSelectedElements());
    }

    private void filterAndUpdateMetricValues() {
        this.m_filteredMetricValuesMap.clear();
        this.m_filteredMetricValuesMap.putAll(this.filterMetricValues(this.m_allMetricValuesMap, this.m_currentScope));
        this.updateMetricValues(this.m_filteredMetricValuesMap);
    }

    public void clearSelection(Control control) {
        assert (control != null) : "Parameter 'control' of method 'clearSelection' must not be null";
        if (this.m_metricDescriptorTable.getTable() == control) {
            this.m_metricDescriptorTable.getTableViewer().setSelection((ISelection)StructuredSelection.EMPTY);
        } else if (this.m_metricValueTable.getTable() == control) {
            this.m_metricValueTable.getTableViewer().setSelection((ISelection)StructuredSelection.EMPTY);
        }
    }

    public List<Control> getViewComponents() {
        return Arrays.asList(new Control[]{this.m_metricDescriptorTable.getTable(), this.m_metricValueTable.getTable(), this.m_histogram, this.m_histogram.getCanvas(), this.m_pieChart, this.m_pieChart.getCanvas()});
    }

    public Control getSelectedViewComponent() {
        switch (this.m_selectedViewComponent) {
            case METRICS: {
                return this.m_metricDescriptorTable.getTable();
            }
            case METRIC_VALUES: {
                return this.m_metricValueTable.getTable();
            }
            case HISTOGRAM: {
                return this.m_histogram.getCanvas();
            }
            case PIECHART: {
                return this.m_pieChart.getCanvas();
            }
        }
        assert (false) : "Unhandled component: " + String.valueOf((Object)this.m_selectedViewComponent);
        return null;
    }

    protected void componentSelected(Control component) {
        assert (component != null) : "Parameter 'component' of method 'componentSelected' must not be null";
        this.removeListeners();
        if (this.m_metricDescriptorTable.getTable() == component) {
            this.m_selectedViewComponent = ViewComponent.METRICS;
        } else if (this.m_metricValueTable.getTable() == component) {
            this.m_selectedViewComponent = ViewComponent.METRIC_VALUES;
            this.m_metricValuesTabFolder.setSelection(this.m_metricValueTableTab);
        } else if (this.m_histogram == component || this.m_histogram.getCanvas() == component) {
            this.m_selectedViewComponent = ViewComponent.HISTOGRAM;
            this.m_metricValuesTabFolder.setSelection(this.m_histogramTab);
        } else if (this.m_pieChart == component || this.m_pieChart.getCanvas() == component) {
            this.m_selectedViewComponent = ViewComponent.PIECHART;
            this.m_metricValuesTabFolder.setSelection(this.m_pieChartTab);
        }
        this.addListeners();
    }

    private void createNavigationState(NavigationState state) {
        assert (state != null) : "Parameter 'state' of method 'createNavigationState' must not be null";
        String comboValue = "";
        switch (this.m_selectedViewComponent) {
            case METRICS: 
            case METRIC_VALUES: 
            case HISTOGRAM: 
            case PIECHART: {
                List selectedComboValues = ((StructuredSelection)this.m_metricLevelCombo.getSelection()).toList();
                if (!selectedComboValues.isEmpty()) {
                    comboValue = ((IMetricLevel)selectedComboValues.get(0)).getStandardName();
                }
                LinkedHashSet<NamedElement> names = new LinkedHashSet<NamedElement>();
                Object[] objectArray = this.m_metricDescriptorTable.getSelection().toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object next = objectArray[n2];
                    if (next instanceof NamedElement) {
                        names.add((NamedElement)next);
                    }
                    ++n2;
                }
                state.addElementsInformation((IElementGroup)ElementGroup.METRIC_NAMES, NavigationState.getDescriptors(names, (IElementResolver)this.getElementResolver()));
                break;
            }
            default: {
                assert (false) : "Unhandled view component: " + String.valueOf((Object)this.m_selectedViewComponent);
                break;
            }
        }
        state.addConstant((IStateData)ViewData.VIEW_COMPONENT, (Enum)this.m_selectedViewComponent);
        state.addString((IStateData)ViewData.COMBO_VALUE, comboValue);
        String scopeName = this.m_currentScope == null ? "" : this.m_currentScope.getName();
        state.addString((IStateData)ViewData.SCOPE_VALUE, scopeName);
    }

    public List<Element> getSelectedElements() {
        assert (this.m_metricValueTable != null) : "'m_elementMetricsViewer' of method 'getSelected' must not be null";
        IStructuredSelection selection = null;
        switch (this.m_selectedViewComponent) {
            case METRICS: {
                selection = this.m_metricDescriptorTable.getSelection();
                break;
            }
            case METRIC_VALUES: {
                selection = this.m_metricValueTable.getSelection();
                break;
            }
            case HISTOGRAM: {
                break;
            }
            case PIECHART: {
                break;
            }
            default: {
                assert (false) : "Unhandled view component: " + String.valueOf((Object)this.m_selectedViewComponent);
                break;
            }
        }
        if (selection == null || selection.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Element> selected = new ArrayList<Element>();
        if (this.m_selectedViewComponent == ViewComponent.METRIC_VALUES && this.m_selectedMetricDescriptors.size() == 1) {
            IMetricDescriptor descr = this.m_selectedMetricDescriptors.iterator().next();
            IMetricValue val = this.m_valueMap.get(new MetricAccessKey((NamedElement)selection.getFirstElement(), descr.getShortName()));
            if (val != null) {
                selected.add((Element)val.getElement());
            }
        }
        if (selected.isEmpty()) {
            for (Object next : selection.toList()) {
                selected.add((Element)next);
            }
        }
        return selected;
    }

    private void applyNavigationState(NavigationState state) {
        NamedElement newSelection;
        String selectedScopeName;
        String scopeName;
        assert (state != null) : "Parameter 'state' of method 'applyNavigationState' must not be null";
        ViewComponent viewComponent = (ViewComponent)state.getConstant((IStateData)ViewData.VIEW_COMPONENT);
        assert (viewComponent != null) : "'viewComponent' of method 'applyNavigationState' must not be null";
        this.m_selectedViewComponent = ViewComponent.METRICS;
        List selectedComboValues = ((StructuredSelection)this.m_metricLevelCombo.getSelection()).toList();
        if (!selectedComboValues.isEmpty() && selectedComboValues.size() == 1) {
            String presentComboValue = ((IMetricLevel)selectedComboValues.get(0)).getStandardName();
            if (!state.getString((IStateData)ViewData.COMBO_VALUE).equals(presentComboValue)) {
                IMetricLevel foundLevel = null;
                String comboValue = state.getString((IStateData)ViewData.COMBO_VALUE);
                for (IMetricLevel nextLevel : this.m_metricLevels) {
                    if (!nextLevel.getStandardName().equals(comboValue)) continue;
                    foundLevel = nextLevel;
                    break;
                }
                if (foundLevel != null) {
                    this.m_metricLevelCombo.setSelection((ISelection)new StructuredSelection(foundLevel));
                    this.handleMetricLevelChanged(foundLevel, true);
                }
            }
        }
        if (!(scopeName = state.getString((IStateData)ViewData.SCOPE_VALUE)).equals(selectedScopeName = this.getSelectedScopeName()) && scopeName.length() > 0 && (newSelection = (NamedElement)this.m_scopeList.stream().filter(ne -> ne.getName().equals(scopeName)).findFirst().orElse(null)) != null) {
            this.m_scopeCombo.setSelection((ISelection)new StructuredSelection((Object)newSelection));
            this.m_currentScope = newSelection;
            this.filterAndUpdateMetricValues();
        }
        StructuredSelection namesSelection = new StructuredSelection(state.getElements((IElementGroup)ElementGroup.METRIC_NAMES, NamedElement.class, this.getElementResolver()).toArray());
        this.m_metricDescriptorTable.getTableViewer().setSelection((ISelection)namesSelection);
        this.getSelectionProviderAdapter().handleSelectionChanged((IStructuredSelection)namesSelection);
        if (!namesSelection.isEmpty()) {
            LinkedHashSet<IMetricDescriptor> selectedMetrics = new LinkedHashSet<IMetricDescriptor>();
            namesSelection.toList().forEach(s -> {
                boolean bl = selectedMetrics.add((IMetricDescriptor)s);
            });
            this.handleMetricChanged(selectedMetrics, true);
        }
    }

    private String getSelectedScopeName() {
        StructuredSelection scopeSelection = (StructuredSelection)this.m_scopeCombo.getSelection();
        if (scopeSelection.isEmpty()) {
            return this.getSoftwareSystem().getName();
        }
        Object selectedScope = scopeSelection.getFirstElement();
        if (selectedScope instanceof NamedElement) {
            return ((NamedElement)selectedScope).getName();
        }
        return this.getSoftwareSystem().getName();
    }

    protected void performRestoreNavigationState(NavigationState state, boolean viewCreated) {
        assert (state != null) : "Parameter 'state' of method 'restoreState' must not be null";
        this.removeListeners();
        this.setRedraw(false);
        this.applyNavigationState(state);
        this.setRedraw(true);
        this.addListeners();
    }

    private void setRedraw(boolean redraw) {
        this.m_metricLevelCombo.getCombo().setRedraw(redraw);
        this.m_metricDescriptorTable.setRedraw(redraw);
        this.m_metricValueTable.setRedraw(redraw);
    }

    public void completeViewNavigationState(NavigationState state) {
        this.createNavigationState(state);
    }

    public boolean supportsExcelExport() {
        return this.getSoftwareSystemProvider().hasSoftwareSystem() && !this.m_selectedMetricDescriptors.isEmpty() && !this.m_valueMap.isEmpty() && this.m_metricValueTable != null && !this.m_metricValueTable.isDisposed() && !this.m_metricValueTable.getFilteredInputData().isEmpty() && this.m_selectedViewComponent != ViewComponent.HISTOGRAM && this.m_selectedViewComponent != ViewComponent.PIECHART;
    }

    public List<ExportData> getExportData(IWorkerContext workerContext) {
        assert (this.m_exportProvider != null) : "'m_exportProvider' of method 'getExportData' must not be null";
        return this.m_exportProvider.getMetrics(this.m_metricValueTable.getFilteredInputData(), this.m_selectedMetricDescriptors, this.m_valueMap, this.m_currentScope.getName());
    }

    public boolean supportsAllExcelExport() {
        return this.getSoftwareSystemProvider().hasSoftwareSystem() && this.m_selectedViewComponent != ViewComponent.HISTOGRAM && this.m_selectedViewComponent != ViewComponent.PIECHART;
    }

    public List<ExportData> getAllExportData(IWorkerContext workerContext) {
        assert (this.m_exportProvider != null) : "'m_exportProvider' of method 'getAllExportData' must not be null";
        return this.m_exportProvider.getAllMetrics(workerContext);
    }

    public boolean supportsCopy() {
        return !this.getSelectedElements().isEmpty();
    }

    public String copy() {
        switch (this.m_selectedViewComponent) {
            case METRIC_VALUES: {
                return this.m_metricValueTable.getCopyToClipboardData();
            }
            case METRICS: {
                return this.m_metricDescriptorTable.getCopyToClipboardData();
            }
        }
        assert (false) : "Unhandled view component: " + String.valueOf((Object)this.m_selectedViewComponent);
        return null;
    }

    public Search supportsSearch() {
        return Search.FIND_TEXT;
    }

    protected ITextSearchHandler getTextSearchHandler() {
        return this.geSelectedTextSearchHandler();
    }

    private PropertyTableViewerBasedTextSearchHandler geSelectedTextSearchHandler() {
        switch (this.m_selectedViewComponent) {
            case METRICS: {
                return this.m_metricsTableTextSearchHandler;
            }
            case METRIC_VALUES: {
                return this.m_metricValuesTableTextSearchHandler;
            }
            case HISTOGRAM: 
            case PIECHART: {
                return this.m_metricsTableTextSearchHandler;
            }
        }
        assert (false) : "Unhandled view component: " + String.valueOf((Object)this.m_selectedViewComponent);
        return null;
    }

    private void updateMetricValues(Map<IMetricDescriptor, List<IMetricValue>> metricDescriptorToValues) {
        assert (metricDescriptorToValues != null) : "Parameter 'metricDescriptorToValues' of method 'updateMetricValues' must not be null";
        IMetricDescriptor firstDescriptor = this.m_selectedMetricDescriptors.isEmpty() ? null : this.m_selectedMetricDescriptors.iterator().next();
        List<IMetricValue> metricValues = firstDescriptor != null ? metricDescriptorToValues.get(firstDescriptor) : null;
        this.m_metricsInfo.update(firstDescriptor, metricValues == null ? Collections.emptyList() : metricValues, this.m_thresholdProvider);
        List<IMetricValue> currentValues = metricDescriptorToValues.isEmpty() ? Collections.emptyList() : metricDescriptorToValues.get(metricDescriptorToValues.keySet().iterator().next());
        ArrayList<NamedElement> currentElements = new ArrayList<NamedElement>(currentValues.size());
        boolean firstElementProcessed = false;
        this.m_valueMap.clear();
        for (List<IMetricValue> list : metricDescriptorToValues.values()) {
            for (IMetricValue val : list) {
                this.m_valueMap.put(new MetricAccessKey(val.getAssociatedElement(), val.getMetricDescriptor().getShortName()), val);
                if (firstElementProcessed) continue;
                currentElements.add(val.getAssociatedElement());
            }
            firstElementProcessed = true;
        }
        this.m_metricValueTable.setAdditionalFirstColumnInfo(this.calculateAdditionalInfo(currentElements));
        LOGGER.debug("Metric values: showData");
        this.m_metricValueTable.showData(currentElements);
        if (!this.m_metricValueTable.isVisible()) {
            this.m_metricValueTableNeedsRedraw = true;
        }
        if (this.m_selectedMetricDescriptors.size() == 1 && currentValues.size() >= 5) {
            this.m_histogram.setValues(this.m_selectedMetricDescriptors.iterator().next(), currentValues);
            PieChart.ValuesContainer valuesContainer = PieChart.computeValuesContainer(this.m_thresholdProvider, this.m_selectedMetricDescriptors.iterator().next(), currentValues);
            this.m_pieChart.setValues(this.m_selectedMetricDescriptors.iterator().next(), valuesContainer);
        } else {
            this.m_histogram.clear();
            this.m_pieChart.clear();
        }
    }

    private String calculateAdditionalInfo(List<NamedElement> input) {
        if (this.m_thresholdProvider == null || input == null || input.isEmpty() || this.m_selectedMetricDescriptors.size() != 1) {
            return null;
        }
        int size = input.size();
        int violations = 0;
        if (size > 0) {
            IMetricDescriptor metricDescriptor = this.m_selectedMetricDescriptors.iterator().next();
            if (this.m_thresholdProvider.getThreshold(metricDescriptor) == null) {
                return null;
            }
            for (NamedElement next : input) {
                assert (next instanceof NamedElement) : "Unexpected class in method 'getFirstColumnHeader': " + String.valueOf(next);
                NamedElement element = next;
                if (!this.m_thresholdProvider.hasThresholdViolations(metricDescriptor, element)) continue;
                ++violations;
            }
        }
        float percentage = NumberUtility.getPercentage((int)violations, (int)size);
        return NumberUtility.format((Number)violations) + " " + StringUtility.pluralize((String)"violation", (int)violations) + ", " + NumberUtility.format((Number)Float.valueOf(percentage)) + "%";
    }

    public void finishShowInView(IViewId sourceViewId, List<Element> elements, List<IStandardEnumeration> options) {
        assert (sourceViewId != null) : "Parameter 'sourceViewId' of method 'finishShowInView' must not be null";
        assert (elements != null) : "Parameter 'elements' of method 'finishShowInView' must not be null";
        if (elements.size() == 1 && elements.get(0) instanceof IMetricDescriptor) {
            this.removeListeners();
            this.setRedraw(false);
            IMetricDescriptor descriptor = (IMetricDescriptor)elements.get(0);
            List selectedComboValues = ((StructuredSelection)this.m_metricLevelCombo.getSelection()).toList();
            boolean levelChanged = selectedComboValues.size() == 1 ? (IMetricLevel)selectedComboValues.get(0) != descriptor.getLevel() : true;
            if (levelChanged) {
                this.m_metricLevelCombo.setSelection((ISelection)new StructuredSelection((Object)descriptor.getLevel()));
                this.handleMetricLevelChanged(descriptor.getLevel(), true);
            }
            StructuredSelection namesSelection = new StructuredSelection((Object)descriptor);
            this.m_metricDescriptorTable.getTableViewer().setSelection((ISelection)namesSelection, true);
            this.setRedraw(true);
            this.addListeners();
        }
        super.finishShowInView(sourceViewId, elements, options);
    }

    public void viewOptionsChanged() {
        this.checkShowIssueIgnoringElements();
        this.filterAndUpdateMetricValues();
    }

    private void checkShowIssueIgnoringElements() {
        MHandledMenuItem filterMenuItem = (MHandledMenuItem)RcpUtility.findUniqueModelElement((IEclipseContext)this.getEclipseContext(), (MUIElement)((MUIElement)this.getPart().getMenus().get(0)), (String)FILTER_HANDLED_ITEM_ID, MHandledMenuItem.class);
        this.m_hideIssueIgnoringElements = filterMenuItem != null && filterMenuItem.isSelected();
    }

    private static enum ElementGroup implements IElementGroup
    {
        METRIC_NAMES,
        METRIC_VALUES;

    }

    private class MetricValueAccessor
    extends BeanPropertyReader<NamedElement>
    implements PropertyTableViewer.ICellImageProvider<NamedElement> {
        private MetricValueAccessor(BeanPropertyReader.BeanAdapter<NamedElement> adapter) {
            super(adapter);
        }

        private IMetricDescriptor findMatchingDescriptor(String propertyName) {
            return MetricsView.this.m_selectedMetricDescriptors.stream().filter(d -> d.getShortName().equals(propertyName)).findFirst().orElse(null);
        }

        public Object readProperty(NamedElement obj, String propertyName) {
            IMetricValue val;
            Object result = super.readProperty((Object)obj, propertyName);
            if (result == null && (val = MetricsView.this.m_valueMap.get(new MetricAccessKey(obj, propertyName))) != null) {
                result = val.getValue();
            }
            return result;
        }

        public boolean hasProperty(String propertyName) {
            return super.hasProperty(propertyName) || this.findMatchingDescriptor(propertyName) != null;
        }

        public Image getCellImage(PropertyTableViewer<NamedElement> viewer, NamedElement element, String propertyName, Image columnImage) {
            NamedElementIssue thresholdViolation;
            assert (element != null) : "Parameter 'element' of method 'getCellImage' must not be null";
            IMetricDescriptor descriptor = this.findMatchingDescriptor(propertyName);
            if (descriptor != null && (thresholdViolation = MetricsView.this.m_thresholdProvider.getThresholdViolationIssue(descriptor, element)) != null) {
                IResolution resolution = thresholdViolation.getResolution();
                return resolution == null ? UiResourceManager.getInstance().getImage(thresholdViolation.getImageResourceName()) : UiResourceManager.getInstance().getImage(resolution.getImageResourceName());
            }
            return null;
        }
    }

    private static enum ViewComponent implements IStandardEnumeration
    {
        METRICS,
        METRIC_VALUES,
        HISTOGRAM,
        PIECHART;


        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            return StringUtility.convertConstantNameToPresentationName((String)this.name());
        }
    }

    private static enum ViewData implements IStateData
    {
        VIEW_COMPONENT,
        COMBO_VALUE,
        SCOPE_VALUE;

    }
}

