/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.metricsview;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.SimpleSoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.command.system.UpdateThresholdsCommand;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IHasMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricThreshold;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.INavigationState;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.IThresholdProvider;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.ui.standalone.settings.ThresholdDialog;
import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.CommandHandlerWithCorrespondingCommand;
import com.hello2morrow.sonargraph.ui.swt.base.view.IContextMenuContributor;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.view.WorkbenchViewSelection;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchState;
import com.hello2morrow.sonargraph.ui.swt.common.ViewNavigationManager;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;

public final class CreateThresholdHandler
extends CommandHandlerWithCorrespondingCommand {
    public IContextMenuContributor createContextMenuContributor() {
        return new IContextMenuContributor(){

            public boolean showInContextMenu(IWorkbenchView workbenchView, List<Element> currentSelection) {
                return true;
            }
        };
    }

    public ICommandId getCorrespondingCommandId() {
        return UpdateThresholdsCommand.ID;
    }

    @CanExecute
    public final boolean canExecute(@Optional @Named(value="org.eclipse.ui.selection") WorkbenchViewSelection selection, @Optional MMenuItem menuItem) {
        if (this.isAvailable(menuItem) && WorkbenchRegistry.getInstance().hasState(new WorkbenchState[]{WorkbenchState.SOFTWARE_SYSTEM_OPENED}) && selection != null && selection.size() == 1 && selection.getElements().get(0) instanceof IHasMetricDescriptor) {
            ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
            IMetricThreshold threshold = ((IThresholdProvider)provider.getSoftwareSystem().getExtension(IThresholdProvider.class)).getThreshold(((IHasMetricDescriptor)selection.getElements().get(0)).getMetricDescriptor());
            return threshold == null;
        }
        return false;
    }

    @Execute
    public final void execute(@Optional @Named(value="org.eclipse.ui.selection") WorkbenchViewSelection selection) {
        assert (selection != null) : "Parameter 'selection' of method 'execute' must not be null";
        IHasMetricDescriptor hasMetricDescriptor = (IHasMetricDescriptor)CreateThresholdHandler.getSingleSelection(IHasMetricDescriptor.class, (List)selection.getElements(), (boolean)true);
        IMetricDescriptor metric = hasMetricDescriptor.getMetricDescriptor();
        if (metric.getProvidingAnalyzerId() == CoreAnalyzerId.SCRIPT_RUNNER) {
            UserInterfaceAdapter.getInstance().error("Cannot define threshold on script based metric", "Script metric thresholds can only be defined in the script itself");
            return;
        }
        assert (WorkbenchRegistry.getInstance().getProvider().hasSoftwareSystem()) : "Not software system available";
        ThresholdDialog dialog = new ThresholdDialog(WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), "New Threshold", WorkbenchRegistry.getInstance().getProvider().getSoftwareSystem(), metric);
        if (dialog.open() == 0) {
            ArrayList<IMetricThreshold> added = new ArrayList<IMetricThreshold>();
            added.add(dialog.getThreshold());
            UpdateThresholdsCommand cmd = new UpdateThresholdsCommand(WorkbenchRegistry.getInstance().getProvider(), new SimpleSoftwareSystemBasedCommand.ISimpleCommandInteraction(){

                public void process(OperationResult result) {
                    if (!$assertionsDisabled && result == null) {
                        throw new AssertionError((Object)"Parameter 'result' of method 'process' must not be null");
                    }
                    UserInterfaceAdapter.getInstance().process(result);
                }

                public INavigationState getNavigationState() {
                    return ViewNavigationManager.getInstance().getCurrentNavigationState();
                }
            }, added, null, null);
            UserInterfaceAdapter.getInstance().run((Command)cmd);
        }
    }
}

