/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.issuesview;

import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.issuehierarchy.IssueNamedElement;
import com.hello2morrow.sonargraph.core.model.system.Root;
import com.hello2morrow.sonargraph.ui.standalone.base.view.PresentationModeBasedViewContentAndLabelProvider;
import com.hello2morrow.sonargraph.ui.swt.common.IViewContentExclusionFilter;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

final class HierarchicalIssueContentProvider
extends PresentationModeBasedViewContentAndLabelProvider {
    private final List<IViewContentExclusionFilter> m_viewContentExclusionFilters = Arrays.asList(new IssueContentExclusionFilter());

    HierarchicalIssueContentProvider() {
    }

    @Override
    protected boolean accept(NamedElement namedElement) {
        assert (namedElement != null) : "Parameter 'namedElement' of method 'accept' must not be null";
        if (!this.m_viewContentExclusionFilters.isEmpty()) {
            for (IViewContentExclusionFilter nextFilter : this.m_viewContentExclusionFilters) {
                if (!nextFilter.match((Element)namedElement)) continue;
                return false;
            }
        }
        return true;
    }

    private static final class IssueContentExclusionFilter
    implements IViewContentExclusionFilter {
        private static final List<Class<? extends NamedElement>> CLASSES_OF_ALWAYS_SHOWN_NODES = Arrays.asList(Root.class);
        private static final Predicate<IssueNamedElement> NO_ISSUES = node -> node.getIssueInfo().isEmpty();
        private static final Predicate<IssueNamedElement> MATCHES_ALWAYS_SHOWN_CLASSES = n -> CLASSES_OF_ALWAYS_SHOWN_NODES.stream().anyMatch(c -> c.isAssignableFrom(n.getElement().getClass()));

        private IssueContentExclusionFilter() {
        }

        public boolean match(Element element) {
            if (element instanceof IssueNamedElement) {
                IssueNamedElement issueElement = (IssueNamedElement)element;
                if (MATCHES_ALWAYS_SHOWN_CLASSES.test(issueElement)) {
                    return false;
                }
                return NO_ISSUES.test(issueElement);
            }
            return true;
        }
    }
}

