/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.filesview;

import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.plugin.PluginConfigurationFile;
import com.hello2morrow.sonargraph.core.model.script.IElementWithScriptRunnerStatus;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;

final class FilesViewLabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    FilesViewLabelProvider() {
    }

    private String getState(NamedElement namedElement) {
        assert (namedElement != null) : "Parameter 'namedElement' of method 'getState' must not be null";
        if (namedElement instanceof IModifiableFile && ((IModifiableFile)namedElement).needsSave()) {
            return " (*)";
        }
        return "";
    }

    public StyledString getStyledText(Object obj) {
        assert (obj != null && obj instanceof NamedElement) : "Unexpected class in method 'getStyledText': " + String.valueOf(obj);
        NamedElement namedElement = (NamedElement)obj;
        String presentationName = namedElement.getPresentationName(true) + this.getState(namedElement);
        StringBuilder info = new StringBuilder();
        if (namedElement instanceof IElementWithScriptRunnerStatus) {
            IElementWithScriptRunnerStatus statusElement = (IElementWithScriptRunnerStatus)namedElement;
            if (statusElement.isAutomated()) {
                info.append("Automated");
            }
        } else if (namedElement instanceof IModifiableFile) {
            String elementInformation = namedElement.getInformation();
            if (elementInformation != null && !elementInformation.isEmpty()) {
                info.append(elementInformation);
            }
            if (!((IModifiableFile)obj).existsOnDisk()) {
                if (info.length() > 0) {
                    info.append(", ");
                }
                info.append("Not On Disk");
            }
            if (namedElement instanceof PluginConfigurationFile) {
                if (info.length() > 0) {
                    info.append(", ");
                }
                info.append(((PluginConfigurationFile)namedElement).isEnabled() ? "Enabled" : "Disabled");
            }
        }
        StyledString styledString = new StyledString(presentationName);
        if (info.length() > 0) {
            styledString.append("  [" + info.toString() + "]", new StyledString.Styler(){

                public void applyStyles(TextStyle textStyle) {
                    if (!$assertionsDisabled && textStyle == null) {
                        throw new AssertionError((Object)"Parameter 'textStyle' of method 'applyStyles' must not be null");
                    }
                    textStyle.foreground = UiResourceManager.getInstance().getColor(UiResourceManager.LIGHT_BLUE);
                }
            });
        }
        return styledString;
    }

    public Image getImage(Object obj) {
        assert (obj != null && obj instanceof NamedElement) : "Unexpected class in method 'getImage': " + String.valueOf(obj);
        return UiResourceManager.getInstance().getImage((Element)((NamedElement)obj));
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

