/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.duplicateview;

import com.hello2morrow.sonargraph.core.model.path.ISourceFileRegionVisitor;
import com.hello2morrow.sonargraph.core.model.system.ILanguageProvider;
import com.hello2morrow.sonargraph.foundation.file.IFileType;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.ui.standalone.base.sourceview.LanguageBasedSourceViewWidget;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;

final class DuplicateSourceViewWidget
extends LanguageBasedSourceViewWidget {
    DuplicateSourceViewWidget(Composite parent, IWorkbenchView workbenchView) {
        super(parent, workbenchView);
    }

    void clearDuplicateBlock() {
        StyledText sourceWidget = this.getSourceWidget();
        int numberOfLines = sourceWidget.getLineCount();
        int i = 0;
        while (i < numberOfLines) {
            sourceWidget.setLineBackground(i, 1, UiResourceManager.getInstance().getBackgroundColor());
            ++i;
        }
    }

    List<String> getLinesSubsetWithEndTrim(int startLine, int endLine) {
        StyledText source = this.getSourceWidget();
        if (!this.isSourceAvailable()) {
            return Collections.emptyList();
        }
        int start = this.getOffsetAtLine(startLine - 1);
        int end = this.getOffsetAtLine(endLine - 2);
        if (start == -1 || end == -1 || source.getLineCount() < endLine - 2 || start < 0 || end > source.getCharCount()) {
            return Collections.emptyList();
        }
        List chunk = StringUtility.toList((String)source.getText(start, end));
        assert (chunk != null && !chunk.isEmpty()) : "'chunk' of method 'getLinesSubsetWithEndTrim' must not be empty";
        ArrayList<String> subList = new ArrayList<String>(chunk.size());
        for (String next : chunk) {
            subList.add(next.trim());
        }
        return subList;
    }

    void highlightDuplicateBlock(int base, int length, Set<Integer> matchingLines) {
        if (matchingLines != null && !matchingLines.isEmpty()) {
            StyledText sourceWidget = this.getSourceWidget();
            --length;
            int i = --base;
            while (i < length) {
                sourceWidget.setLineBackground(i, 1, UiResourceManager.getInstance().getTextHighlightSecondaryColor());
                ++i;
            }
            for (Integer i2 : matchingLines) {
                sourceWidget.setLineBackground(base + i2, 1, UiResourceManager.getInstance().getTextHighlightPrimaryColor());
            }
        }
    }

    @Override
    protected void calculateStyleRangesForSyntaxHighlighting(String content, IFileType fileType) {
        assert (content != null) : "Parameter 'content' of method 'performSyntaxHighlighting' must not be null";
        ILanguageProvider languageProvider = this.getLanguageProvider();
        languageProvider.accept((ISourceFileRegionVisitor)this, content, fileType);
    }
}

