/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.duplicateview;

import com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlock;
import com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlockOccurrence;
import com.hello2morrow.sonargraph.core.model.element.ISingleIssueProvider;
import com.hello2morrow.sonargraph.ui.swt.base.view.SingleIssueProviderComparator;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

final class CodeBlockBasedViewerComparator
extends ViewerComparator {
    CodeBlockBasedViewerComparator() {
    }

    public int compare(Viewer viewer, Object o1, Object o2) {
        assert (viewer != null) : "Parameter 'viewer' of method 'compare' must not be null";
        assert (o1 != null) : "Parameter 'o1' of method 'compare' must not be null";
        assert (o2 != null) : "Parameter 'o2' of method 'compare' must not be null";
        int result = 0;
        Tree tree = ((TreeViewer)viewer).getTree();
        TreeColumn currentSortIndicator = tree.getSortColumn();
        if (o1 instanceof DuplicateCodeBlock && o2 instanceof DuplicateCodeBlock) {
            DuplicateCodeBlock block1 = (DuplicateCodeBlock)o1;
            DuplicateCodeBlock block2 = (DuplicateCodeBlock)o2;
            if (currentSortIndicator != null) {
                int columnIndex = tree.indexOf(currentSortIndicator);
                switch (columnIndex) {
                    case 0: {
                        result = Integer.compare(block1.getTotalNumberOfOccurrences(), block2.getTotalNumberOfOccurrences());
                        break;
                    }
                    case 2: {
                        result = Integer.compare(block1.getBlockSize(), block2.getBlockSize());
                        break;
                    }
                    case 3: {
                        result = SingleIssueProviderComparator.compareByResolutionPriority((ISingleIssueProvider)block1, (ISingleIssueProvider)block2);
                        break;
                    }
                    default: {
                        assert (columnIndex != 0 || columnIndex != 2) : "Unexpected column index: " + columnIndex;
                        break;
                    }
                }
                if (tree.getSortDirection() == 1024) {
                    return -result;
                }
                return result;
            }
            return Integer.compare(block2.getBlockSize(), block1.getBlockSize());
        }
        if (o1 instanceof DuplicateCodeBlockOccurrence && o2 instanceof DuplicateCodeBlockOccurrence) {
            DuplicateCodeBlockOccurrence occurrence1 = (DuplicateCodeBlockOccurrence)o1;
            DuplicateCodeBlockOccurrence occurrence2 = (DuplicateCodeBlockOccurrence)o2;
            if (currentSortIndicator != null) {
                int columnIndex = tree.indexOf(currentSortIndicator);
                switch (columnIndex) {
                    case 1: {
                        result = occurrence1.getBlockBegin() - occurrence2.getBlockBegin();
                        break;
                    }
                    default: {
                        assert (columnIndex != 1) : "Unexpected column index: " + columnIndex;
                        break;
                    }
                }
                if (tree.getSortDirection() == 1024) {
                    return -result;
                }
                return result;
            }
            return occurrence1.getBlockBegin() - occurrence2.getBlockBegin();
        }
        return 0;
    }
}

