/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.diffview;

import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.system.diff.BaselineInfo;
import com.hello2morrow.sonargraph.core.model.system.diff.BaselineType;
import com.hello2morrow.sonargraph.core.model.system.diff.ISystemDiffProvider;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.Iso8601DateFormat;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.ui.standalone.base.workbench.CoreDialogId;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingPathWidget;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.StandardWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import de.schlichtherle.truezip.file.TFile;
import java.util.Date;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

final class OpenBaselineWizardPage
extends StandardWizardPage {
    private static final CoreDialogId ID = CoreDialogId.OPEN_BASELINE;
    private final ISystemDiffProvider m_systemDiffProvider;
    private final List<BaselineInfo> m_recentlyUsedList;
    private final BaselineType m_baselineType;
    private TFile m_baselineReport;
    private TFile m_defaultDirectory;
    private TableViewer m_tableViewer;
    private ValidatingPathWidget m_pathWidget;
    private StyledText m_descriptionText;

    OpenBaselineWizardPage(BaselineType type, ISystemDiffProvider systemDiffProvider) {
        super(ID.getStandardName(), "Select " + (String)(type != null ? type.getPresentationName() + " " : "") + "Baseline");
        assert (type != null) : "Parameter 'type' of method 'OpenBaselineWizardPage' must not be null";
        assert (systemDiffProvider != null) : "Parameter 'systemDiffProvider' of method 'OpenBaselineWizardPage' must not be null";
        this.m_baselineType = type;
        this.m_systemDiffProvider = systemDiffProvider;
        this.m_recentlyUsedList = systemDiffProvider.getRecentlyUsedBaselineReports(type);
        TFile tFile = this.m_baselineReport = this.m_recentlyUsedList.isEmpty() ? null : this.m_recentlyUsedList.get(0).getFile();
        this.m_defaultDirectory = this.m_baselineReport != null ? this.m_baselineReport.getParentFile() : (type == BaselineType.SYSTEM ? systemDiffProvider.getBaselinesDirectory().getDirectoryFile() : systemDiffProvider.getHiddenBaselinesDirectory());
    }

    protected IDialogId getDialogId() {
        return ID;
    }

    public boolean isPageComplete() {
        return this.m_baselineReport != null;
    }

    protected int getNumberOfColumns() {
        return 1;
    }

    public TFile getBaseline() {
        return this.m_baselineReport;
    }

    protected void createContent(Composite composite) {
        assert (composite != null) : "Parameter 'composite' of method 'fillDialogArea' must not be null";
        this.m_baselineReport = this.m_recentlyUsedList.isEmpty() ? null : this.m_recentlyUsedList.get(0).getFile();
        ValidatingPathWidget.IConsumer consumer = new ValidatingPathWidget.IConsumer(){

            public void setPath(TFile input, boolean inputModified) {
                if (inputModified) {
                    OpenBaselineWizardPage.this.m_tableViewer.setSelection(null);
                    OpenBaselineWizardPage.this.m_baselineReport = input;
                    if (input != null) {
                        String description;
                        OperationResultWithOutcome baselineInfoResult = ((ISystemDiffProvider)WorkbenchRegistry.getInstance().getSoftwareSystem().getExtension(ISystemDiffProvider.class)).getBaselineInfo(OpenBaselineWizardPage.this.m_baselineReport);
                        if (baselineInfoResult.isSuccess()) {
                            description = ((BaselineInfo)baselineInfoResult.getOutcome()).getDescription();
                        } else {
                            description = "";
                            OpenBaselineWizardPage.this.m_baselineReport = null;
                        }
                        OpenBaselineWizardPage.this.m_descriptionText.setText(description);
                    }
                    OpenBaselineWizardPage.this.setPageComplete(OpenBaselineWizardPage.this.isPageComplete());
                }
            }
        };
        TFile baseDirectory = WorkbenchRegistry.getInstance().getSoftwareSystem().getSystemDirectoryFile();
        this.m_pathWidget = this.m_baselineType == BaselineType.SYSTEM ? new ValidatingPathWidget(composite, consumer, this.m_systemDiffProvider.getBaselineValidator(), 1, this.m_baselineReport, false, baseDirectory, true, this.m_defaultDirectory) : new ValidatingPathWidget(composite, consumer, this.m_systemDiffProvider.getBaselineValidator(), 1, this.m_baselineReport, false, null, false, this.m_defaultDirectory);
        GridData pathGridData = new GridData(4, 4, true, false);
        pathGridData.widthHint = 500;
        this.m_pathWidget.setLayoutData((Object)pathGridData);
        this.m_pathWidget.setFilterExtensions(new String[]{"*" + CoreFileType.REPORT_XML.getDefaultExtension()});
        SwtUtility.placeHorizontalSeparator((Composite)composite, (int)1);
        Group group = new Group(composite, 0);
        group.setText("Recently used Baselines");
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setLayout((Layout)new FillLayout());
        SashForm sashForm = new SashForm((Composite)group, 512);
        this.m_tableViewer = new TableViewer((Composite)sashForm, 68356);
        this.m_tableViewer.getTable().setHeaderVisible(true);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.m_tableViewer, (int)2);
        TableViewerColumn fileColumn = new TableViewerColumn(this.m_tableViewer, 0);
        fileColumn.getColumn().setText("Path");
        fileColumn.getColumn().setWidth(350);
        fileColumn.getColumn().setResizable(true);
        fileColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (!($assertionsDisabled || element != null && element instanceof BaselineInfo)) {
                    throw new AssertionError((Object)("Unexpected class in method 'getText': " + String.valueOf(element)));
                }
                return OpenBaselineWizardPage.this.getPathFromBaselineInfo((BaselineInfo)element);
            }

            public Image getImage(Object element) {
                return UiResourceManager.getInstance().getImage("File");
            }
        });
        TableViewerColumn timestampColumn = new TableViewerColumn(this.m_tableViewer, 0);
        timestampColumn.getColumn().setText("Timestamp");
        timestampColumn.getColumn().setWidth(130);
        timestampColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (!($assertionsDisabled || element != null && element instanceof BaselineInfo)) {
                    throw new AssertionError((Object)("Unexpected class in method 'getText': " + String.valueOf(element)));
                }
                return Iso8601DateFormat.formatDateAndTime((Date)((BaselineInfo)element).getCreationTime());
            }
        });
        this.m_tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.m_descriptionText = new StyledText((Composite)sashForm, 2122);
        this.m_descriptionText.setEditable(false);
        this.m_descriptionText.setCaret(null);
        this.m_descriptionText.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        sashForm.setWeights(new int[]{80, 20});
        this.m_tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.isEmpty()) {
                    OpenBaselineWizardPage.this.m_baselineReport = null;
                    OpenBaselineWizardPage.this.m_descriptionText.setText("");
                } else {
                    Object firstElement = selection.getFirstElement();
                    if (!($assertionsDisabled || firstElement != null && firstElement instanceof BaselineInfo)) {
                        throw new AssertionError((Object)("Unexpected class in method 'selectionChanged': " + String.valueOf(firstElement)));
                    }
                    BaselineInfo baselineInfo = (BaselineInfo)firstElement;
                    OpenBaselineWizardPage.this.m_baselineReport = baselineInfo.getFile();
                    OpenBaselineWizardPage.this.m_pathWidget.setPath(OpenBaselineWizardPage.this.m_baselineReport.getAbsolutePath());
                    OpenBaselineWizardPage.this.m_descriptionText.setText(baselineInfo.getDescription());
                }
                OpenBaselineWizardPage.this.setPageComplete(OpenBaselineWizardPage.this.isPageComplete());
            }
        });
        this.m_tableViewer.setInput(this.m_recentlyUsedList);
    }

    private String getPathFromBaselineInfo(BaselineInfo baselineInfo) {
        assert (baselineInfo != null) : "Parameter 'baselineInfo' of method 'getPathFromBaselineInfo' must not be null";
        if (this.m_baselineType == BaselineType.SYSTEM) {
            TFile baseDirectory = WorkbenchRegistry.getInstance().getSoftwareSystem().getSystemDirectoryFile();
            return FileUtility.calculateRelativePath((TFile)baselineInfo.getFile(), (TFile)baseDirectory);
        }
        return baselineInfo.getFile().getNormalizedAbsolutePath();
    }
}

