/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.diffview;

import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.diff.BaselineInfo;
import com.hello2morrow.sonargraph.core.model.system.diff.BaselineType;
import com.hello2morrow.sonargraph.core.model.system.diff.ISystemDiffProvider;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.ui.standalone.diffview.OpenBaselineWizardPage;
import com.hello2morrow.sonargraph.ui.standalone.diffview.SelectBaselineTypePage;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.LazySonargraphWizard;
import de.schlichtherle.truezip.file.TFile;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;

final class OpenBaselineWizard
extends LazySonargraphWizard {
    private final SelectBaselineTypePage m_selectBaselineTypePage;
    private final ISoftwareSystemProvider m_softwareSystemProvider;
    private final TFile m_baseline;
    private OpenBaselineWizardPage m_baselineWizardPage;

    OpenBaselineWizard(ISoftwareSystemProvider provider) {
        super("Set Baseline");
        assert (provider != null) : "Parameter 'provider' of method 'OpenBaselineWizard' must not be null";
        this.m_softwareSystemProvider = provider;
        this.m_selectBaselineTypePage = new SelectBaselineTypePage(SelectBaselineTypePage.Mode.OPEN);
        this.m_selectBaselineTypePage.setWizard((IWizard)this);
        this.m_baseline = null;
    }

    OpenBaselineWizard(ISoftwareSystemProvider provider, TFile baseline) {
        super("Set Baseline");
        assert (provider != null) : "Parameter 'provider' of method 'OpenBaselineWizard' must not be null";
        assert (baseline != null) : "Parameter 'baseline' of method 'OpenBaselineWizard' must not be null";
        this.m_softwareSystemProvider = provider;
        this.m_baseline = baseline;
        ISystemDiffProvider systemDiffProvider = (ISystemDiffProvider)provider.getSoftwareSystem().getExtension(ISystemDiffProvider.class);
        String path = FileUtility.calculateRelativePath((TFile)baseline, (TFile)systemDiffProvider.getBaselinesDirectory().getFile().getParentFile().getParentFile());
        OperationResultWithOutcome result = systemDiffProvider.getBaselineInfo(baseline);
        BaselineInfo baselineInfo = result.isSuccess() ? (BaselineInfo)result.getOutcome() : null;
        this.m_selectBaselineTypePage = new SelectBaselineTypePage(SelectBaselineTypePage.Mode.OPEN, path, baselineInfo);
        this.m_selectBaselineTypePage.setWizard((IWizard)this);
    }

    public IWizardPage getStartingPage() {
        return this.m_selectBaselineTypePage;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (this.m_baseline == null && page == this.m_selectBaselineTypePage) {
            BaselineType type = this.m_selectBaselineTypePage.getBaselineType();
            this.m_baselineWizardPage = new OpenBaselineWizardPage(type, (ISystemDiffProvider)this.m_softwareSystemProvider.getSoftwareSystem().getExtension(ISystemDiffProvider.class));
            this.m_baselineWizardPage.setWizard((IWizard)this);
            return this.m_baselineWizardPage;
        }
        return null;
    }

    public IWizardPage getPage(String name) {
        assert (name != null) : "Parameter 'name' of method 'getPage' must not be null";
        if (name.equals(this.m_selectBaselineTypePage.getName())) {
            return this.m_selectBaselineTypePage;
        }
        if (this.m_baselineWizardPage != null && name.equals(this.m_baselineWizardPage.getName())) {
            return this.m_baselineWizardPage;
        }
        return null;
    }

    public int getPageCount() {
        return this.m_baseline != null ? 1 : 2;
    }

    public boolean canFinish() {
        return this.m_baseline != null ? true : this.m_baselineWizardPage != null && this.m_baselineWizardPage.isPageComplete();
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        if (this.m_selectBaselineTypePage == page) {
            return this.m_selectBaselineTypePage;
        }
        return null;
    }

    public boolean performFinish() {
        return true;
    }

    public TFile getBaseline() {
        return this.m_baseline != null ? this.m_baseline : this.m_baselineWizardPage.getBaseline();
    }

    public BaselineType getBaselineType() {
        return this.m_selectBaselineTypePage.getBaselineType();
    }
}

