/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.diffview;

import com.hello2morrow.sonargraph.core.model.element.Dependency;
import com.hello2morrow.sonargraph.core.model.element.DependencyIssue;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElementIssue;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.IIssueDiff;
import com.hello2morrow.sonargraph.integration.access.model.ICycleGroupIssue;
import com.hello2morrow.sonargraph.integration.access.model.IDependencyIssue;
import com.hello2morrow.sonargraph.integration.access.model.IIssue;
import com.hello2morrow.sonargraph.integration.access.model.INamedElementIssue;
import com.hello2morrow.sonargraph.ui.swt.base.CompositeImageDescriptor;
import com.hello2morrow.sonargraph.ui.swt.base.DecoratingImageDescriptor;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import org.eclipse.swt.graphics.Image;

final class IssueDiffResourceProvider {
    private static IssueDiffResourceProvider s_instance;

    private IssueDiffResourceProvider() {
    }

    public static synchronized IssueDiffResourceProvider getInstance() {
        if (s_instance == null) {
            s_instance = new IssueDiffResourceProvider();
        }
        return s_instance;
    }

    Image getImage(IIssueDiff diff) {
        CompositeImageDescriptor imageDescriptor;
        assert (diff != null) : "Parameter 'diff' of method 'getImage' must not be null";
        Issue current = diff.getCurrent();
        if (current != null) {
            if (!current.isValid()) {
                return null;
            }
            if (current instanceof NamedElementIssue) {
                return UiResourceManager.getInstance().getImage(current.getAffectedElement());
            }
            if (current instanceof DependencyIssue) {
                Dependency dependency = (Dependency)current.getAffectedElement();
                return UiResourceManager.getInstance().getImage((Element)dependency.getUnderlyingFrom());
            }
            assert (false) : "Unexpected class: " + current.getClass().getName();
            return null;
        }
        IIssue baseline = diff.getBaseline();
        if (baseline instanceof ICycleGroupIssue) {
            imageDescriptor = new CompositeImageDescriptor("CycleGroup");
        } else if (baseline instanceof INamedElementIssue) {
            imageDescriptor = new CompositeImageDescriptor("ElementIssue");
        } else if (baseline instanceof IDependencyIssue) {
            imageDescriptor = new CompositeImageDescriptor("DependencyIssue");
        } else {
            assert (false) : "Unexpected class: " + baseline.getClass().getName();
            return null;
        }
        imageDescriptor.addMarker(DecoratingImageDescriptor.Corner.UPPER_LEFT, "DeletionMarker");
        return UiResourceManager.getInstance().getImage(imageDescriptor);
    }

    public Image getChangeImage(IDiffElement.Change change) {
        assert (change != null) : "Parameter 'change' of method 'getChangeImage' must not be null";
        IDiffElement.Change actualChange = change == IDiffElement.Change.RESOLUTION_ADDED ? IDiffElement.Change.REMOVED : (change == IDiffElement.Change.RESOLUTION_REMOVED ? IDiffElement.Change.ADDED : change);
        String imageResourceName = "IssueDiff" + actualChange.getPresentationName();
        return UiResourceManager.getInstance().getImage(imageResourceName);
    }
}

