/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.diffview;

import com.hello2morrow.sonargraph.core.model.resolution.ResolutionKind;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.IIssueDiff;
import com.hello2morrow.sonargraph.ui.swt.base.PreferencesUtility;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.view.AggregatingViewerFilter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

class DiffTabFolderViewOptions
implements Listener {
    private final String m_preferencesPrefix;
    private final String m_hideIgnoredPrefKey;
    private final String m_hideFixedPrefKey;
    private final String m_hideWithoutResolutionPrefKey;
    private static final boolean HIDE_IGNORED_DEFAULT = true;
    private static final boolean HIDE_FIXED_DEFAULT = false;
    private static final boolean HIDE_WITHOUT_RESOLUTION_DEFAULT = false;
    private boolean m_hideIgnored;
    private boolean m_hideFixed;
    private boolean m_hideWithoutResolution;
    private final IEclipsePreferences m_preferences;
    private final IViewerFilterProvider m_filterProvider;
    private ToolItem m_toolItem;
    private Menu m_menu;
    private ToolBar m_toolbar;
    private final boolean m_showCollapseExpandAll;
    private ToolItem m_collapseAll;
    private ToolItem m_expandAll;
    private final Class<?> m_rootElementClass;

    public DiffTabFolderViewOptions(IViewerFilterProvider filterProvider, String preferencesPrefix, IEclipsePreferences preferences, boolean showCollapsExpandAll, Class<?> parentElementClass) {
        assert (filterProvider != null) : "Parameter 'filterProvider' of method 'TabFolderViewOptions' must not be null";
        assert (preferencesPrefix != null) : "Parameter 'preferencesPrefix' of method 'TabFolderViewOptions' must not be null";
        assert (preferences != null) : "Parameter 'preferences' of method 'TabFolderViewOptions' must not be null";
        this.m_filterProvider = filterProvider;
        this.m_preferences = preferences;
        this.m_preferencesPrefix = preferencesPrefix;
        this.m_hideIgnoredPrefKey = this.m_preferencesPrefix + "hideIgnored";
        this.m_hideFixedPrefKey = this.m_preferencesPrefix + "hideFixed";
        this.m_hideWithoutResolutionPrefKey = this.m_preferencesPrefix + "hideWithoutResolution";
        this.m_hideIgnored = preferences.getBoolean(this.m_hideIgnoredPrefKey, true);
        this.m_hideFixed = preferences.getBoolean(this.m_hideFixedPrefKey, false);
        this.m_hideWithoutResolution = preferences.getBoolean(this.m_hideWithoutResolutionPrefKey, false);
        this.m_showCollapseExpandAll = showCollapsExpandAll;
        this.m_rootElementClass = parentElementClass;
    }

    public Control createControl(Composite parent, String elementName) {
        this.m_toolbar = new ToolBar(parent, 0x800000);
        if (this.m_showCollapseExpandAll) {
            this.m_collapseAll = new ToolItem(this.m_toolbar, 8);
            this.m_collapseAll.setImage(UiResourceManager.getInstance().getImage("CollapseAll"));
            this.m_collapseAll.setToolTipText("Collapse All");
            this.m_collapseAll.addListener(13, (Listener)this);
            this.m_expandAll = new ToolItem(this.m_toolbar, 8);
            this.m_expandAll.setImage(UiResourceManager.getInstance().getImage("ExpandAll"));
            this.m_expandAll.setToolTipText("Expand All");
            this.m_expandAll.addListener(13, (Listener)this);
        }
        this.m_toolItem = new ToolItem(this.m_toolbar, 8);
        this.m_toolItem.setImage(UiResourceManager.getInstance().getImage("ViewOptions"));
        this.m_toolItem.setToolTipText("Filter Options");
        this.m_menu = new Menu((Decorations)parent.getShell(), 8);
        this.m_toolItem.addListener(13, (Listener)this);
        this.createMenuItems(this.m_menu, elementName);
        return this.m_toolbar;
    }

    public void handleEvent(Event event) {
        if (event.type == 13) {
            if (event.widget == this.m_toolItem) {
                Rectangle bounds = this.m_toolItem.getBounds();
                Point point = this.m_toolbar.toDisplay(bounds.x, bounds.y + bounds.height);
                this.m_menu.setLocation(point);
                this.m_menu.setVisible(true);
            } else if (event.widget == this.m_collapseAll) {
                this.m_filterProvider.collapseAll();
            } else if (event.widget == this.m_expandAll) {
                this.m_filterProvider.expandAll();
            }
        }
    }

    public void dispose() {
        this.m_toolItem.removeListener(13, (Listener)this);
        if (this.m_showCollapseExpandAll) {
            this.m_collapseAll.removeListener(13, (Listener)this);
            this.m_expandAll.removeListener(13, (Listener)this);
        }
        this.m_toolbar.dispose();
    }

    final void updateFilters() {
        ArrayList<ViewerFilter> filters = new ArrayList<ViewerFilter>();
        for (ViewerFilter nextPrevious : this.m_filterProvider.getFilters()) {
            if (nextPrevious instanceof ViewOptionsViewerFilter) continue;
            filters.add(nextPrevious);
        }
        if (this.m_hideIgnored) {
            filters.add(new HideResolution(ResolutionKind.IGNORE));
        }
        this.m_preferences.putBoolean(this.m_hideIgnoredPrefKey, this.m_hideIgnored);
        if (this.m_hideFixed) {
            filters.add(new HideResolution(ResolutionKind.FIX));
        }
        this.m_preferences.putBoolean(this.m_hideFixedPrefKey, this.m_hideFixed);
        if (this.m_hideWithoutResolution) {
            filters.add(new HideNoResolution());
            this.m_preferences.putBoolean(this.m_hideWithoutResolutionPrefKey, this.m_hideWithoutResolution);
        }
        this.updateCustomFilters(filters, this.m_preferences);
        PreferencesUtility.save((IEclipsePreferences)this.m_preferences);
        AggregatingViewerFilter filter = new AggregatingViewerFilter(filters, this.m_rootElementClass);
        this.m_filterProvider.setFilters(filter);
    }

    protected void updateCustomFilters(List<ViewerFilter> filters, IEclipsePreferences preferences) {
    }

    protected final void createMenuItems(Menu menu, String elementName) {
        assert (menu != null) : "Parameter 'menu' of method 'createMenuItems' must not be null";
        assert (elementName != null) : "Parameter 'elementName' of method 'createMenuItems' must not be null";
        final MenuItem hideIgnoreMenu = new MenuItem(menu, 32);
        hideIgnoreMenu.setText("Hide " + elementName + " With 'Ignore' Resolution");
        hideIgnoreMenu.setSelection(this.m_hideIgnored);
        hideIgnoreMenu.setImage(UiResourceManager.getInstance().getImage("Ignore"));
        hideIgnoreMenu.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (hideIgnoreMenu.getSelection() != DiffTabFolderViewOptions.this.m_hideIgnored) {
                    DiffTabFolderViewOptions.this.m_hideIgnored = hideIgnoreMenu.getSelection();
                    DiffTabFolderViewOptions.this.updateFilters();
                }
            }
        });
        final MenuItem hideFixMenu = new MenuItem(menu, 32);
        hideFixMenu.setText("Hide " + elementName + " With 'Fix' Resolution");
        hideFixMenu.setImage(UiResourceManager.getInstance().getImage("Fix"));
        hideFixMenu.setSelection(this.m_hideFixed);
        hideFixMenu.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (hideFixMenu.getSelection() != DiffTabFolderViewOptions.this.m_hideFixed) {
                    DiffTabFolderViewOptions.this.m_hideFixed = hideFixMenu.getSelection();
                    DiffTabFolderViewOptions.this.updateFilters();
                }
            }
        });
        final MenuItem hideWithoutResolutionMenu = new MenuItem(menu, 32);
        hideWithoutResolutionMenu.setText("Hide " + elementName + " Without Resolution");
        hideWithoutResolutionMenu.setImage(UiResourceManager.getInstance().getImage("None"));
        hideWithoutResolutionMenu.setSelection(this.m_hideWithoutResolution);
        hideWithoutResolutionMenu.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (hideWithoutResolutionMenu.getSelection() != DiffTabFolderViewOptions.this.m_hideWithoutResolution) {
                    DiffTabFolderViewOptions.this.m_hideWithoutResolution = hideWithoutResolutionMenu.getSelection();
                    DiffTabFolderViewOptions.this.updateFilters();
                }
            }
        });
        this.createAdditionalMenuItems(menu);
        new MenuItem(menu, 2);
        this.createDefaultMenuItem(menu, hideIgnoreMenu, hideFixMenu, hideWithoutResolutionMenu);
    }

    protected void createAdditionalMenuItems(Menu menu) {
        assert (menu != null) : "Parameter 'menu' of method 'createAdditionalMenuItems' must not be null";
    }

    protected void createDefaultMenuItem(Menu menu, final MenuItem hideIgnoreMenu, final MenuItem hideFixMenu, final MenuItem hideWithoutResolutionMenu) {
        MenuItem resetToDefault = new MenuItem(menu, 8);
        resetToDefault.setText("Reset To Default (Hide with 'Ignore' Resolution)");
        resetToDefault.setImage(UiResourceManager.getInstance().getImage("HideIgnored"));
        resetToDefault.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DiffTabFolderViewOptions.this.m_hideIgnored = true;
                hideIgnoreMenu.setSelection(DiffTabFolderViewOptions.this.m_hideIgnored);
                DiffTabFolderViewOptions.this.m_hideFixed = false;
                hideFixMenu.setSelection(DiffTabFolderViewOptions.this.m_hideFixed);
                DiffTabFolderViewOptions.this.m_hideWithoutResolution = false;
                hideWithoutResolutionMenu.setSelection(DiffTabFolderViewOptions.this.m_hideWithoutResolution);
                DiffTabFolderViewOptions.this.handleDefaultMenuItemSelection();
                DiffTabFolderViewOptions.this.updateFilters();
            }
        });
    }

    protected void handleDefaultMenuItemSelection() {
    }

    private static final class HideNoResolution
    extends HideResolution {
    }

    private static class HideResolution
    extends ViewerFilter
    implements ViewOptionsViewerFilter {
        private final ResolutionKind m_kindToIgnore;

        public HideResolution(ResolutionKind kindToIgnore) {
            assert (kindToIgnore != null) : "Parameter 'kindToIgnore' of method 'ResolutionFilter' must not be null";
            this.m_kindToIgnore = kindToIgnore;
        }

        protected HideResolution() {
            this.m_kindToIgnore = null;
        }

        public final boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IIssueDiff) {
                IIssueDiff issueDiff = (IIssueDiff)element;
                if (issueDiff.getCurrent() != null) {
                    return issueDiff.getCurrentResolutionKind() != this.m_kindToIgnore;
                }
                return issueDiff.getBaselineResolutionKind() != this.m_kindToIgnore;
            }
            return true;
        }
    }

    public static interface IViewerFilterProvider {
        public List<ViewerFilter> getFilters();

        public void setFilters(AggregatingViewerFilter var1);

        default public void expandAll() {
        }

        default public void collapseAll() {
        }
    }

    public static interface ViewOptionsViewerFilter {
    }
}

